/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.LDAPExpr;

public class AutoManifest
extends Manifest {
    FrameworkContext fwCtx;
    Manifest mf;
    String location;
    AutoInfo autoInfo;
    Attributes mainAttrs;
    Set packages = new TreeSet();
    static String configSource = null;
    static Map configs = null;
    private Hashtable fileProps = new Hashtable();
    static /* synthetic */ Class class$org$knopflerfish$framework$AutoManifest;

    public AutoManifest(FrameworkContext fwCtx, Manifest mf, String location) {
        if (mf == null) {
            throw new NullPointerException("Manifest cannot be null");
        }
        if (location == null) {
            throw new NullPointerException("location cannot be null");
        }
        this.fwCtx = fwCtx;
        this.mf = mf;
        this.location = location;
        if (configs == null) {
            if (fwCtx.props.getBooleanProperty("org.knopflerfish.framework.automanifest")) {
                configSource = fwCtx.props.getProperty("org.knopflerfish.framework.automanifest.config");
                configs = this.loadConfig(configSource);
                if (fwCtx.debug.automanifest) {
                    fwCtx.debug.println("Loaded auto manifest config from " + configSource);
                }
            } else {
                configs = new TreeMap();
            }
        }
        this.autoInfo = this.findConfig();
        if (this.isAuto() && fwCtx.debug.automanifest) {
            fwCtx.debug.println("Using auto manifest for bundlelocation " + location);
        }
    }

    public boolean isAuto() {
        return this.autoInfo != null;
    }

    public void clear() {
        this.mf.clear();
        this.mainAttrs = null;
    }

    public Attributes getAttributes(String name) {
        return this.mf.getAttributes(name);
    }

    public Map getEntries() {
        return this.mf.getEntries();
    }

    public void read(InputStream is) throws IOException {
        this.mf.read(is);
        this.mainAttrs = null;
    }

    public void write(OutputStream out) throws IOException {
        this.mf.write(out);
    }

    public Manifest getManifest() {
        return this.mf;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AutoManifest)) {
            return false;
        }
        AutoManifest af = (AutoManifest)obj;
        return this.mf.equals(af.mf) && this.location.equals(af.location);
    }

    public int hashCode() {
        return this.mf.hashCode() + 17 * this.location.hashCode();
    }

    public Attributes getMainAttributes() {
        if (this.mainAttrs == null) {
            this.mainAttrs = this.mf.getMainAttributes();
            if (this.autoInfo != null) {
                this.mainAttrs.putValue("Bundle-AutoManifest-config", configSource);
                Iterator it = this.autoInfo.headers.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    String val = (String)this.autoInfo.headers.get(key);
                    if ("[remove]".equals(val)) {
                        this.mainAttrs.remove(new Attributes.Name(key));
                        continue;
                    }
                    if ("[autoexport]".equals(val)) {
                        String exports = this.getExports();
                        if (this.fwCtx.debug.automanifest) {
                            this.fwCtx.debug.println("Auto exports for " + this.location + ": " + exports);
                        }
                        if (exports.length() > 0) {
                            this.mainAttrs.putValue("Export-Package", exports);
                            continue;
                        }
                        this.mainAttrs.remove(new Attributes.Name("Export-Package"));
                        continue;
                    }
                    this.mainAttrs.putValue(key, val);
                }
            }
        }
        return this.mainAttrs;
    }

    public void addFile(File file) throws IOException {
        this.addFile(file.getAbsolutePath(), file);
    }

    public void addFile(String prefix, File file) throws IOException {
        String f;
        String string = f = prefix.length() < file.getAbsolutePath().length() ? file.getAbsolutePath().substring(prefix.length() + 1) : file.getAbsolutePath();
        if (f.endsWith(".jar")) {
            this.addZipFile(new ZipFile(file));
        } else if (this.isValidFileName(f)) {
            this.addFileName(f);
        } else if (file.isDirectory()) {
            String[] files = file.list();
            for (int i = 0; i < files.length; ++i) {
                this.addFile(prefix, new File(file.getAbsolutePath(), files[i]));
            }
        }
    }

    private boolean isValidFileName(String f) {
        if (this.autoInfo != null && this.autoInfo.fileNameFilter != null) {
            this.fileProps.put("file", f);
            return this.autoInfo.fileNameFilter.evaluate(this.fileProps, true);
        }
        return f.endsWith(".class");
    }

    public void addZipFile(ZipFile jar) {
        Enumeration<? extends ZipEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String f = ze.getName();
            if (!this.isValidFileName(f)) continue;
            this.addFileName(f);
        }
    }

    public void addFileName(String f) {
        int ix = (f = f.replace('\\', '/')).lastIndexOf("/");
        if (ix != -1) {
            f = f.substring(0, ix);
        }
        f = f.replace('/', '.');
        if (this.autoInfo != null) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("pkg", f);
            if (this.autoInfo.exportFilter.evaluate(props, true) && !this.packages.contains(f)) {
                this.packages.add(f);
            }
        }
        this.mainAttrs = null;
    }

    String getExports() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.packages.iterator();
        while (it.hasNext()) {
            String pkg = (String)it.next();
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(pkg);
            if (this.autoInfo.version == null) continue;
            sb.append(";");
            sb.append(this.autoInfo.version);
        }
        return sb.toString();
    }

    private AutoInfo findConfig() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("location", this.location);
        Attributes attrs = this.mf.getMainAttributes();
        Iterator<Object> it = attrs.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            String val = attrs.getValue(key.toString());
            props.put(key.toString(), val.toString());
        }
        it = configs.keySet().iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            AutoInfo ai = (AutoInfo)configs.get(id);
            if (!ai.filter.evaluate(props, true)) continue;
            return ai;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map loadConfig(String urlS) {
        if (urlS != null && !"".equals(urlS)) {
            URL url = null;
            InputStream is = null;
            try {
                url = urlS.startsWith("!!") ? (class$org$knopflerfish$framework$AutoManifest == null ? (class$org$knopflerfish$framework$AutoManifest = AutoManifest.class$("org.knopflerfish.framework.AutoManifest")) : class$org$knopflerfish$framework$AutoManifest).getResource(urlS.substring(2)) : new URL(urlS);
                is = url.openStream();
                Map map = this.loadConfigFromInputStream(is);
                return map;
            }
            catch (Exception e) {
                this.fwCtx.debug.printStackTrace("Failed to load autoimportexport conf from " + url, e);
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception ignored) {}
            }
        }
        return new HashMap();
    }

    private Map loadConfigFromInputStream(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        TreeMap<String, AutoInfo> configMap = new TreeMap<String, AutoInfo>();
        Iterator it = ((Hashtable)props).keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            int ix = key.indexOf(".");
            if (ix == -1) continue;
            String id = key.substring(0, ix);
            String pattern = (String)((Hashtable)props).get(id + ".match.filter");
            String export = (String)((Hashtable)props).get(id + ".export.filter");
            String fileFilter = (String)((Hashtable)props).get(id + ".export.file.filter");
            HashMap<String, String> headers = new HashMap<String, String>();
            if (fileFilter == null) {
                fileFilter = "(file=*.class)";
            }
            String headerPre = id + ".header.";
            Iterator it2 = ((Hashtable)props).keySet().iterator();
            while (it2.hasNext()) {
                String key2 = (String)it2.next();
                String val2 = (String)((Hashtable)props).get(key2);
                if (!key2.startsWith(headerPre)) continue;
                headers.put(key2.substring(headerPre.length()), val2);
            }
            AutoInfo ai = new AutoInfo(pattern, export, fileFilter, headers);
            ai.version = (String)((Hashtable)props).get(id + ".export.version");
            configMap.put(id, ai);
        }
        return configMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class AutoInfo {
        LDAPExpr filter;
        LDAPExpr exportFilter;
        LDAPExpr fileNameFilter;
        Map headers;
        String version;

        AutoInfo(String filter, String export, String nameFilter, Map headers) {
            try {
                this.filter = new LDAPExpr(filter);
            }
            catch (Exception e) {
                throw new RuntimeException("Bad filter '" + filter + "': " + e);
            }
            try {
                this.fileNameFilter = new LDAPExpr(nameFilter);
            }
            catch (Exception e) {
                throw new RuntimeException("Bad file name filter '" + nameFilter + "': " + e);
            }
            try {
                this.exportFilter = new LDAPExpr(export);
            }
            catch (Exception e) {
                throw new RuntimeException("Bad export filter '" + export + "': " + e);
            }
            this.headers = headers;
        }

        public String toString() {
            return "AutoInfo[filter=" + this.filter + ", exportFilter=" + this.exportFilter + ", version=" + this.version + ", headers=" + this.headers + "]";
        }
    }
}

