/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.validator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidator;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.Validator;

public class JKSValidator
implements Validator {
    private static final String CA_CERTS_PROP = "org.knopflerfish.framework.validator.jks.ca_certs";
    private static final String CA_CERTS_PASSWORD_PROP = "org.knopflerfish.framework.validator.jks.ca_certs_password";
    private static final String CERT_PROVIDER_PROP = "org.knopflerfish.framework.validator.jks.cert_provider";
    private String certProvider;
    private CertificateFactory certFactory = null;
    private CertPathValidator certValidator = null;
    private final KeyStore keystore;
    private boolean trustKeys = true;
    private final Debug debug;

    public JKSValidator(FrameworkContext fw) throws KeyStoreException {
        this.debug = fw.debug;
        this.keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        fw.props.setPropertyDefault(CERT_PROVIDER_PROP, "");
        this.certProvider = fw.props.getProperty(CERT_PROVIDER_PROP);
        String repos = fw.props.getProperty("org.osgi.framework.trust.repositories");
        if (repos.length() > 0) {
            String[] l = Util.splitwords(repos, File.pathSeparator);
            for (int i = 0; i < l.length; ++i) {
                String certRepo = l[i].trim();
                if (certRepo.length() <= 0) continue;
                this.loadKeyStore(certRepo, null);
            }
        } else {
            fw.props.setPropertyDefault(CA_CERTS_PROP, System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar));
            fw.props.setPropertyDefault(CA_CERTS_PASSWORD_PROP, "changeit");
            String caCertsFileName = fw.props.getProperty(CA_CERTS_PROP);
            if (caCertsFileName != null) {
                this.loadKeyStore(caCertsFileName, fw.props.getProperty(CA_CERTS_PASSWORD_PROP));
            }
        }
    }

    public boolean validateCertificateChain(List chain) {
        if (this.keystore == null) {
            return false;
        }
        try {
            CertPath c = this.getCertificateFactory().generateCertPath(chain);
            CertPathValidator cpv = this.getCertPathValidator();
            CertPathParameters params = this.getCertPathParameters(this.keystore);
            cpv.validate(c, params);
        }
        catch (GeneralSecurityException gse) {
            return false;
        }
        return true;
    }

    private CertificateFactory getCertificateFactory() throws GeneralSecurityException {
        if (this.certFactory == null) {
            this.certFactory = this.certProvider.length() > 0 ? CertificateFactory.getInstance("X.509", this.certProvider) : CertificateFactory.getInstance("X.509");
        }
        return this.certFactory;
    }

    private CertPathParameters getCertPathParameters(KeyStore keystore) throws GeneralSecurityException {
        HashSet<TrustAnchor> tas = new HashSet<TrustAnchor>();
        Enumeration<String> e = keystore.aliases();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            Certificate c = keystore.getCertificate(name);
            if (c == null || !this.trustKeys && !keystore.isCertificateEntry(name)) continue;
            tas.add(new TrustAnchor((X509Certificate)c, null));
        }
        PKIXParameters p = new PKIXParameters(tas);
        p.setRevocationEnabled(false);
        return p;
    }

    private CertPathValidator getCertPathValidator() throws GeneralSecurityException {
        if (this.certValidator == null) {
            this.certValidator = this.certProvider.length() > 0 ? CertPathValidator.getInstance("PKIX", this.certProvider) : CertPathValidator.getInstance("PKIX");
        }
        return this.certValidator;
    }

    private void loadKeyStore(String file, String password) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            this.keystore.load(is, password != null ? password.toCharArray() : null);
            if (this.debug.certificates) {
                this.debug.println("Loaded keystore, " + file);
            }
        }
        catch (Exception e) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            this.debug.printStackTrace("Failed to load keystore, " + file, e);
        }
    }
}

