/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.security.AccessControlContext;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.permissions.ConditionalPermission;

class PostponementCheck
implements PrivilegedAction {
    private AccessControlContext acc;
    private Permission perm;
    private ArrayList checkedClasses;
    private ArrayList ppList = null;
    private Debug debug = null;

    PostponementCheck(AccessControlContext acc, Permission perm, PostponementCheck previous) {
        this.acc = acc;
        this.perm = perm;
        this.checkedClasses = previous != null ? previous.getCheckedClasses() : null;
    }

    ArrayList getCheckedClasses() {
        if (this.checkedClasses != null) {
            return (ArrayList)this.checkedClasses.clone();
        }
        return null;
    }

    public void savePostponement(List postponement, Object debug) {
        if (this.ppList == null) {
            this.ppList = new ArrayList(2);
            this.debug = (Debug)debug;
        }
        this.ppList.add(postponement);
    }

    public Object run() {
        this.acc.checkPermission(this.perm);
        this.checkPostponements();
        return null;
    }

    private void checkPostponements() {
        if (this.ppList != null) {
            HashMap condDict = new HashMap();
            if (this.checkedClasses == null) {
                this.checkedClasses = new ArrayList();
            }
            Iterator ppi = ((AbstractList)this.ppList).iterator();
            while (ppi.hasNext()) {
                boolean deny = true;
                Iterator pi = ((List)ppi.next()).iterator();
                while (pi.hasNext()) {
                    ConditionalPermission cp = (ConditionalPermission)pi.next();
                    if (!cp.checkPostponedOk(condDict, this.checkedClasses)) continue;
                    if (cp.access != "allow") break;
                    deny = false;
                    break;
                }
                if (!deny) continue;
                if (this.debug.permissions) {
                    this.debug.println("CHECK_POSTPONE: postponement failed");
                }
                throw new SecurityException("Postponed conditions failed");
            }
            if (this.debug.permissions) {
                this.debug.println("CHECK_POSTPONE: postponement ok");
            }
        }
    }
}

