/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.io.File;
import java.io.FilePermission;
import java.io.InputStream;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PropertyPermission;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.permissions.ConditionalPermission;
import org.knopflerfish.framework.permissions.ConditionalPermissionInfoImpl;
import org.knopflerfish.framework.permissions.ConditionalPermissionInfoStorage;
import org.knopflerfish.framework.permissions.ConditionalPermissionSecurityManager;
import org.knopflerfish.framework.permissions.PermissionInfoPermissions;
import org.knopflerfish.framework.permissions.PermissionInfoStorage;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.service.permissionadmin.PermissionInfo;

public class PermissionsWrapper
extends PermissionCollection {
    private static final long serialVersionUID = 1L;
    String location;
    private Bundle bundle;
    private PermissionInfoStorage pinfos;
    private ConditionalPermissionInfoStorage cpinfos;
    private PermissionCollection implicitPermissions;
    private PermissionCollection localPermissions;
    private volatile PermissionCollection systemPermissions;
    private File dataRoot;
    private boolean readOnly = false;
    private ArrayList condPermList = null;
    private ConditionalPermissionSecurityManager cpsm;
    private final FrameworkContext framework;
    private final Debug debug;

    PermissionsWrapper(FrameworkContext fw, PermissionInfoStorage pis, ConditionalPermissionInfoStorage cpis, String loc, Bundle b, InputStream localPerms) {
        this.framework = fw;
        this.debug = fw.debug;
        this.pinfos = pis;
        this.cpinfos = cpis;
        this.location = loc;
        this.bundle = b;
        if (loc != null) {
            SecurityManager sm = System.getSecurityManager();
            if (sm instanceof ConditionalPermissionSecurityManager) {
                this.cpsm = (ConditionalPermissionSecurityManager)((Object)sm);
            }
            this.dataRoot = fw.getDataStorage(b.getBundleId());
            if (localPerms != null) {
                this.localPermissions = new PermissionInfoPermissions(fw, this.dataRoot, localPerms);
            }
            this.implicitPermissions = this.makeImplicitPermissionCollection(fw, b);
        }
        this.initCondPermList();
        this.systemPermissions = this.makePermissionCollection();
    }

    public void add(Permission permission) {
        PermissionCollection p = this.getPerms();
        if (p == null) {
            throw new RuntimeException("NYI! Using Conditional Permissions");
        }
        p.add(permission);
    }

    public Enumeration elements() {
        final PermissionCollection p = this.getPerms();
        if (p == null) {
            throw new RuntimeException("NYI! Using Conditional Permissions 2");
        }
        return new Enumeration(){
            private Enumeration implicitElements;
            private Enumeration systemElements;
            {
                this.implicitElements = PermissionsWrapper.this.implicitPermissions.elements();
                this.systemElements = p.elements();
            }

            public boolean hasMoreElements() {
                if (this.implicitElements != null) {
                    if (this.implicitElements.hasMoreElements()) {
                        return true;
                    }
                    this.implicitElements = null;
                }
                return this.systemElements.hasMoreElements();
            }

            public Object nextElement() {
                if (this.implicitElements != null) {
                    try {
                        return this.implicitElements.nextElement();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        this.implicitElements = null;
                    }
                }
                return this.systemElements.nextElement();
            }
        };
    }

    public boolean implies(Permission permission) {
        boolean res;
        String me = "PermissionWrapper.implies: ";
        if (this.implicitPermissions != null && this.implicitPermissions.implies(permission)) {
            if (this.debug.permissions) {
                this.debug.println(me + "Implicitly OK for, " + permission);
            }
            return true;
        }
        if (this.localPermissions != null && !this.localPermissions.implies(permission)) {
            if (this.debug.permissions) {
                this.debug.println(me + "No localpermissions for, " + permission);
            }
            return false;
        }
        PermissionCollection p = this.getPerms();
        if (p != null) {
            res = p.implies(permission);
            if (this.debug.permissions) {
                this.debug.println(me + (res ? "OK" : "No") + " framework permission for," + permission);
            }
        } else {
            res = this.conditionalPermissionImplies(permission);
            if (this.debug.permissions) {
                this.debug.println(me + (res ? "OK" : "No") + " conditional permission for," + permission);
            }
        }
        return res;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        if (!this.readOnly) {
            this.readOnly = true;
            PermissionCollection p = this.getPerms();
            if (p != null) {
                p.setReadOnly();
            }
        }
    }

    synchronized void invalidate() {
        this.systemPermissions = null;
    }

    private PermissionCollection getPerms0() {
        if (this.systemPermissions == null) {
            PermissionCollection p = this.makePermissionCollection();
            if (this.readOnly && p != null) {
                p.setReadOnly();
            }
            this.systemPermissions = p;
        }
        return this.systemPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection getPerms() {
        if (this.framework.props.isDoubleCheckedLockingSafe) {
            if (this.systemPermissions == null) {
                PermissionsWrapper permissionsWrapper = this;
                synchronized (permissionsWrapper) {
                    return this.getPerms0();
                }
            }
            return this.systemPermissions;
        }
        PermissionsWrapper permissionsWrapper = this;
        synchronized (permissionsWrapper) {
            return this.getPerms0();
        }
    }

    private PermissionCollection makeImplicitPermissionCollection(FrameworkContext fw, Bundle b) {
        Permissions pc = new Permissions();
        if (this.dataRoot != null) {
            pc.add(new FilePermission(this.dataRoot.getPath(), "read,write"));
            pc.add(new FilePermission(new File(this.dataRoot, "-").getPath(), "read,write,delete"));
        }
        StringBuffer sb = new StringBuffer("(id=");
        sb.append(b.getBundleId());
        sb.append(")");
        pc.add(new AdminPermission(sb.toString(), "resource,metadata,class"));
        pc.add(new PropertyPermission("org.osgi.framework.*", "read"));
        return pc;
    }

    private PermissionCollection makePermissionCollection() {
        boolean useDefault;
        PermissionInfo[] pi = this.pinfos.get(this.location, this);
        boolean bl = useDefault = pi == null;
        if (useDefault) {
            if (this.cpinfos != null && this.cpinfos.size() > 0) {
                return null;
            }
            pi = this.pinfos.getDefault(this);
        }
        return new PermissionInfoPermissions(this.framework, useDefault ? null : this.dataRoot, pi);
    }

    private boolean conditionalPermissionImplies(Permission permission) {
        ArrayList<ConditionalPermission> postponement = this.cpsm != null && this.cpsm.isPostponeAvailable() ? new ArrayList<ConditionalPermission>() : null;
        String immediateAccess = null;
        Iterator i = ((AbstractList)this.condPermList).iterator();
        while (i.hasNext()) {
            ConditionalPermission cp = (ConditionalPermission)i.next();
            if (cp == null) continue;
            if (this.debug.permissions) {
                this.debug.println("conditionalPermissionImplies: Check if " + cp + " implies " + permission + " for " + this.bundle);
            }
            if (cp.checkImmediateOk(permission, postponement == null)) {
                if (postponement != null) {
                    postponement.add(cp);
                }
                if (cp.hasPostponed()) {
                    if (!this.debug.permissions) continue;
                    this.debug.println("conditionalPermissionImplies: " + cp + " with postponement implies " + permission + " for " + this.bundle);
                    continue;
                }
                if (this.debug.permissions) {
                    this.debug.println("conditionalPermissionImplies: " + cp + " implies " + permission + " for " + this.bundle + ", end search");
                }
                immediateAccess = cp.access;
                break;
            }
            if (!this.debug.permissions) continue;
            this.debug.println("conditionalPermissionImplies: " + cp + " does NOT imply " + permission + " for " + this.bundle);
        }
        if (postponement != null) {
            int offset;
            if (immediateAccess == null) {
                immediateAccess = "deny";
                offset = 1;
            } else {
                offset = 2;
            }
            for (int pos = postponement.size() - offset; pos >= 0 && ((ConditionalPermission)postponement.get((int)pos)).access == immediateAccess; --pos) {
                Object pruned = postponement.remove(pos);
                if (!this.debug.permissions) continue;
                this.debug.println("conditionalPermissionImplies: pruned, " + pruned + " for " + this.bundle);
            }
            if (immediateAccess == "deny" && postponement.size() < offset) {
                return false;
            }
            if (this.debug.permissions) {
                this.debug.println("conditionalPermissionImplies: postpone check of " + permission + " for " + this.bundle);
            }
            this.cpsm.savePostponement(postponement, this.debug);
            return true;
        }
        return immediateAccess == "allow";
    }

    synchronized void updateChangedConditionalPermission(ConditionalPermissionInfoImpl cpi, int cpi_pos, int remove_pos, int expected_size) {
        ConditionalPermission new_cp;
        ConditionalPermission conditionalPermission = new_cp = cpi != null ? cpi.getConditionalPermission(this.bundle) : null;
        if (cpi_pos == remove_pos) {
            ConditionalPermission old_cp = this.condPermList.set(cpi_pos, new_cp);
        } else if (remove_pos == -1) {
            this.condPermList.add(cpi_pos, new_cp);
            Object old_cp = null;
        } else if (cpi_pos == -1) {
            Object old_cp = this.condPermList.remove(remove_pos);
        } else {
            throw new RuntimeException("NYI");
        }
        if (expected_size != this.condPermList.size()) {
            this.debug.printStackTrace("ASSERT, table size differ, " + expected_size + " != " + this.condPermList.size(), new Throwable());
            throw new RuntimeException("ASSERT ERROR");
        }
        this.invalidate();
    }

    private void initCondPermList() {
        ArrayList cpis = this.cpinfos.getAll();
        this.condPermList = new ArrayList(cpis.size());
        Iterator i = ((AbstractList)cpis).iterator();
        while (i.hasNext()) {
            ConditionalPermissionInfoImpl cpi = (ConditionalPermissionInfoImpl)i.next();
            if (this.debug.permissions) {
                this.debug.println("conditionalPermissionImplies: " + cpi + " Bundle#" + this.bundle.getBundleId());
            }
            this.condPermList.add(cpi.getConditionalPermission(this.bundle));
        }
        this.invalidate();
    }
}

