/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.util.List;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.permissions.ConditionalPermissionSecurityManager;
import org.knopflerfish.framework.permissions.PostponementCheck;

public class KFSecurityManager
extends SecurityManager
implements ConditionalPermissionSecurityManager {
    private final ThreadLocal postponementCheck = new ThreadLocal();
    private final Debug debug;

    public KFSecurityManager(Debug debug) {
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPermission(Permission perm, Object context) {
        if (!(context instanceof AccessControlContext)) {
            throw new SecurityException("Context not an AccessControlContext");
        }
        PostponementCheck old = (PostponementCheck)this.postponementCheck.get();
        PostponementCheck pc = new PostponementCheck((AccessControlContext)context, perm, old);
        this.postponementCheck.set(pc);
        try {
            AccessController.doPrivileged(pc);
        }
        finally {
            this.postponementCheck.set(old);
        }
    }

    public void checkPermission(Permission perm) {
        this.checkPermission(perm, this.getSecurityContext());
    }

    public boolean isPostponeAvailable() {
        return this.postponementCheck.get() != null;
    }

    public void savePostponement(List postponement, Object debug) {
        PostponementCheck pc = (PostponementCheck)this.postponementCheck.get();
        pc.savePostponement(postponement, debug);
    }
}

