/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.permissions.ConditionalPermissionInfoImpl;
import org.knopflerfish.framework.permissions.ConditionalPermissionUpdateImpl;
import org.knopflerfish.framework.permissions.PermUtil;
import org.knopflerfish.framework.permissions.PermissionsHandle;
import org.knopflerfish.framework.permissions.PermissionsWrapper;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionUpdate;
import org.osgi.service.permissionadmin.PermissionInfo;

class ConditionalPermissionInfoStorage {
    private File condPermDir;
    private long lastFile;
    private ArrayList cpiTable = new ArrayList();
    private PermissionsHandle ph;
    private int generation = -1;
    private final Debug debug;
    static final String END_MARKER = "END";

    ConditionalPermissionInfoStorage(PermissionsHandle ph) {
        this.ph = ph;
        this.debug = ph.framework.debug;
        this.condPermDir = Util.getFileStorage(ph.framework, "condperm");
        if (this.condPermDir == null) {
            System.err.println("Property org.osgi.framework.dir not set,conditional permission info will not be saved between sessions");
        } else {
            this.load();
        }
    }

    synchronized ConditionalPermissionInfo get(String name) {
        int i = this.find(name);
        if (i >= 0) {
            return (ConditionalPermissionInfo)this.cpiTable.get(i);
        }
        return null;
    }

    synchronized Enumeration getAllEnumeration() {
        return new Vector(this.cpiTable).elements();
    }

    ArrayList getAll() {
        return this.cpiTable;
    }

    synchronized ConditionalPermissionUpdate getUpdate() {
        return new ConditionalPermissionUpdateImpl(this, this.cpiTable, this.generation);
    }

    synchronized ConditionalPermissionInfo put(String name, ConditionInfo[] conds, PermissionInfo[] perms) {
        ConditionalPermissionInfoImpl old;
        int oldIx;
        if (name == null) {
            name = this.uniqueName();
            oldIx = -1;
        } else {
            if (name.equals("")) {
                throw new IllegalArgumentException("Name can not be an empty string");
            }
            oldIx = this.find(name);
        }
        ConditionalPermissionInfoImpl res = new ConditionalPermissionInfoImpl(this, name, conds, perms, "allow", this.ph.framework);
        if (oldIx >= 0) {
            old = this.cpiTable.set(oldIx, res);
            this.updateChangedConditionalPermission(res, oldIx, oldIx);
        } else {
            old = null;
            this.cpiTable.add(0, res);
            this.updateChangedConditionalPermission(res, 0, -1);
        }
        ++this.generation;
        this.save();
        if (this.debug.permissions) {
            this.debug.println("CondPermStorage set " + res);
            if (old != null) {
                this.debug.println("CondPermStorage replaced " + old);
            }
        }
        return res;
    }

    synchronized void remove(ConditionalPermissionInfoImpl obj) {
        int pos = this.cpiTable.indexOf(obj);
        if (this.debug.permissions) {
            this.debug.println("CondPermStorage remove " + obj + ", pos=" + pos);
        }
        if (pos >= 0) {
            this.cpiTable.remove(pos);
            this.updateChangedConditionalPermission(null, -1, pos);
            ++this.generation;
            this.save();
            if (this.debug.permissions) {
                this.debug.println("CondPermStorage removed " + obj);
            }
        }
    }

    synchronized boolean commitUpdate(List updatedTable, int parentGen) {
        int i;
        if (parentGen != this.generation) {
            return false;
        }
        ArrayList checkTable = new ArrayList(updatedTable);
        HashSet<String> names = new HashSet<String>();
        int oi = 0;
        ConditionalPermissionInfoImpl ocpi = oi < this.cpiTable.size() ? this.cpiTable.get(oi) : null;
        int[] update = new int[this.cpiTable.size() + checkTable.size()];
        int ui = 0;
        String uniqueNameBase = Integer.toString(this.generation, 36) + "_";
        for (i = 0; i < checkTable.size(); ++i) {
            ConditionalPermissionInfoImpl cpi;
            try {
                cpi = (ConditionalPermissionInfoImpl)checkTable.get(i);
            }
            catch (ClassCastException _) {
                throw new IllegalStateException("Illegal class of element in updated table, index=" + i);
            }
            if (cpi == null) {
                throw new IllegalStateException("Updated table contains null element, index=" + i);
            }
            String name = cpi.getName();
            if (name != null) {
                if (!names.add(name)) {
                    throw new IllegalStateException("Updated table contains elements with same name, name=" + name);
                }
                while (name.startsWith(uniqueNameBase)) {
                    uniqueNameBase = uniqueNameBase + "_";
                }
            }
            if (cpi == ocpi) {
                ocpi = ++oi < this.cpiTable.size() ? this.cpiTable.get(oi) : null;
                continue;
            }
            int removed = 0;
            for (int j = oi + 1; j < this.cpiTable.size(); ++j) {
                if (this.cpiTable.get(j) != cpi) continue;
                removed = j;
                break;
            }
            if (removed != 0) {
                while (oi++ < removed) {
                    update[ui++] = -i - 1;
                }
                ocpi = oi < this.cpiTable.size() ? this.cpiTable.get(oi) : null;
                continue;
            }
            update[ui++] = i;
        }
        while (oi++ < this.cpiTable.size()) {
            update[ui++] = -i - 1;
        }
        if (ui == 0) {
            return true;
        }
        int NOP = Integer.MIN_VALUE;
        int uniqueCounter = 0;
        int rememberLastInsert = 0;
        for (int pui = 0; pui < ui; ++pui) {
            int u = update[pui];
            if (u >= 0) {
                ConditionalPermissionInfoImpl cpi;
                int ipui;
                int rMatch;
                int remove = -1;
                if (pui < rememberLastInsert) {
                    rMatch = u + rememberLastInsert - pui;
                    ipui = rememberLastInsert;
                } else {
                    rMatch = u + rememberLastInsert - pui;
                    ipui = pui;
                }
                while (++ipui < ui) {
                    int iu = update[ipui];
                    if (iu == -rMatch) {
                        remove = u;
                        update[ipui] = Integer.MIN_VALUE;
                        break;
                    }
                    if (iu == rMatch) break;
                    rememberLastInsert = iu;
                    ++rMatch;
                }
                if ((cpi = (ConditionalPermissionInfoImpl)checkTable.get(u)).getName() == null) {
                    cpi.setName(uniqueNameBase + uniqueCounter++);
                }
                cpi.setPermissionInfoStorage(this);
                if (u == remove) {
                    this.cpiTable.set(u, cpi);
                } else if (remove == -1) {
                    this.cpiTable.add(u, cpi);
                } else {
                    throw new RuntimeException("NYI");
                }
                this.updateChangedConditionalPermission(cpi, u, remove);
                continue;
            }
            if (u == Integer.MIN_VALUE) continue;
            u = -1 - u;
            this.cpiTable.remove(u);
            this.updateChangedConditionalPermission(null, -1, u);
        }
        ++this.generation;
        this.save();
        if (this.debug.permissions) {
            this.debug.println("CondPermStorage commited update, " + ui + " changes");
        }
        return true;
    }

    synchronized int size() {
        return this.cpiTable.size();
    }

    private int find(String name) {
        for (int i = 0; i < this.cpiTable.size(); ++i) {
            if (!((ConditionalPermissionInfo)this.cpiTable.get(i)).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    private String uniqueName() {
        String uniqueNameBase = Integer.toString(this.generation, 36) + "_";
        Iterator i = ((AbstractList)this.cpiTable).iterator();
        while (i.hasNext()) {
            String name = ((ConditionalPermissionInfoImpl)i.next()).getName();
            while (name.startsWith(uniqueNameBase)) {
                uniqueNameBase = uniqueNameBase + "_";
            }
        }
        return uniqueNameBase + "0";
    }

    private void updateChangedConditionalPermission(ConditionalPermissionInfoImpl cpi, int pos, int removePos) {
        Iterator i = this.ph.getPermissionWrappers();
        while (i.hasNext()) {
            ((PermissionsWrapper)i.next()).updateChangedConditionalPermission(cpi, pos, removePos, this.cpiTable.size());
        }
    }

    private void save() {
        if (this.debug.permissions) {
            this.debug.println("CondPermStorage save " + this.size() + " cpis, gen=" + this.generation);
        }
        if (this.condPermDir != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ConditionalPermissionInfoStorage.this.purge();
                    File f = new File(ConditionalPermissionInfoStorage.this.condPermDir, Long.toString(++ConditionalPermissionInfoStorage.this.lastFile));
                    BufferedWriter out = null;
                    try {
                        out = new BufferedWriter(new FileWriter(f));
                        out.write("# Save generation " + ConditionalPermissionInfoStorage.this.generation + " at: " + System.currentTimeMillis());
                        out.newLine();
                        Iterator i = ((AbstractList)ConditionalPermissionInfoStorage.this.cpiTable).iterator();
                        while (i.hasNext()) {
                            out.write(((ConditionalPermissionInfoImpl)i.next()).toString());
                            out.newLine();
                        }
                        out.write(ConditionalPermissionInfoStorage.END_MARKER);
                        out.newLine();
                        out.close();
                    }
                    catch (IOException e) {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException ignore) {
                                // empty catch block
                            }
                            f.delete();
                        }
                        ConditionalPermissionInfoStorage.this.debug.printStackTrace("NYI! Report error", e);
                    }
                    return null;
                }
            });
        }
    }

    private void load() {
        File[] files = PermUtil.getSortedFiles(this.condPermDir);
        this.lastFile = -1L;
        for (int i = files.length - 1; i >= 0; --i) {
            block3: {
                try {
                    long l = Long.parseLong(files[i].getName());
                    if (l <= this.lastFile) break block3;
                    this.lastFile = l;
                }
                catch (Exception ignore) {
                    continue;
                }
            }
            if (this.load(files[i])) break;
            files[i].delete();
        }
    }

    private boolean load(File fh) {
        BufferedReader in = null;
        ArrayList<ConditionalPermissionInfoImpl> loadTable = new ArrayList<ConditionalPermissionInfoImpl>();
        try {
            in = new BufferedReader(new FileReader(fh));
            String l = in.readLine();
            while (l != null) {
                if (!(l = l.trim()).equals("") && !l.startsWith("#")) {
                    if (l.equals(END_MARKER)) {
                        in.close();
                        this.cpiTable = loadTable;
                        return true;
                    }
                    ConditionalPermissionInfoImpl res = new ConditionalPermissionInfoImpl(this, l, this.ph.framework);
                    loadTable.add(res);
                }
                l = in.readLine();
            }
            in.close();
        }
        catch (Exception e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            this.debug.printStackTrace("NYI! Report error", e);
        }
        return false;
    }

    private void purge() {
        File[] files = PermUtil.getSortedFiles(this.condPermDir);
        int okName = 0;
        for (int i = files.length - 1; i >= 0; --i) {
            try {
                Long.parseLong(files[i].getName());
                if (++okName <= 2) continue;
                files[i].delete();
                continue;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }
}

