/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.permissions.ConditionalPermissionInfoImpl;
import org.knopflerfish.framework.permissions.ConditionalPermissionInfoStorage;
import org.knopflerfish.framework.permissions.PermissionInfoStorage;
import org.knopflerfish.framework.permissions.PermissionsWrapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionUpdate;
import org.osgi.service.permissionadmin.PermissionInfo;

public class ConditionalPermissionAdminImpl
implements ConditionalPermissionAdmin {
    public static final String SPEC_VERSION = "1.1.0";
    private ConditionalPermissionInfoStorage cpis;
    private PermissionInfoStorage pis;
    private final FrameworkContext framework;

    public ConditionalPermissionAdminImpl(ConditionalPermissionInfoStorage cpis, PermissionInfoStorage pis, FrameworkContext framework) {
        this.cpis = cpis;
        this.pis = pis;
        this.framework = framework;
    }

    public ConditionalPermissionInfo addConditionalPermissionInfo(ConditionInfo[] conds, PermissionInfo[] perms) {
        return this.cpis.put(null, conds, perms);
    }

    public ConditionalPermissionInfo setConditionalPermissionInfo(String name, ConditionInfo[] conds, PermissionInfo[] perms) {
        return this.cpis.put(name, conds, perms);
    }

    public Enumeration getConditionalPermissionInfos() {
        return this.cpis.getAllEnumeration();
    }

    public ConditionalPermissionInfo getConditionalPermissionInfo(String name) {
        return this.cpis.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessControlContext getAccessControlContext(String[] signers) {
        PermissionsWrapper perms;
        ConditionalPermissionInfoStorage conditionalPermissionInfoStorage = this.cpis;
        synchronized (conditionalPermissionInfoStorage) {
            perms = new PermissionsWrapper(this.framework, this.pis, this.cpis, null, new DummyBundle(signers), null);
        }
        return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }

    public ConditionalPermissionUpdate newConditionalPermissionUpdate() {
        return this.cpis.getUpdate();
    }

    public ConditionalPermissionInfo newConditionalPermissionInfo(String name, ConditionInfo[] conditions, PermissionInfo[] permissions, String access) {
        if ("allow".equalsIgnoreCase(access)) {
            access = "allow";
        } else if ("deny".equalsIgnoreCase(access)) {
            access = "deny";
        } else {
            throw new IllegalArgumentException("access must be allow or deny");
        }
        if (permissions == null || permissions.length == 0) {
            throw new IllegalArgumentException("permissions must contain atleast one element");
        }
        return new ConditionalPermissionInfoImpl(this.cpis, name, conditions, permissions, access, this.framework);
    }

    public ConditionalPermissionInfo newConditionalPermissionInfo(String encoded) {
        return new ConditionalPermissionInfoImpl(this.cpis, encoded, this.framework);
    }

    static class PrincipalDummy
    implements Principal {
        private final String name;

        PrincipalDummy(String dn) {
            this.name = dn;
        }

        public String getName() {
            return this.name;
        }
    }

    static class X509Dummy
    extends X509Certificate {
        Principal subject;

        X509Dummy(String dn) {
            this.subject = new PrincipalDummy(dn);
        }

        public void checkValidity() {
        }

        public void checkValidity(Date date) {
        }

        public int getVersion() {
            return 1;
        }

        public BigInteger getSerialNumber() {
            return null;
        }

        public Principal getIssuerDN() {
            return null;
        }

        public Principal getSubjectDN() {
            return this.subject;
        }

        public Date getNotBefore() {
            return null;
        }

        public Date getNotAfter() {
            return null;
        }

        public byte[] getTBSCertificate() {
            return null;
        }

        public byte[] getSignature() {
            return null;
        }

        public String getSigAlgName() {
            return null;
        }

        public String getSigAlgOID() {
            return null;
        }

        public byte[] getSigAlgParams() {
            return null;
        }

        public boolean[] getIssuerUniqueID() {
            return null;
        }

        public boolean[] getSubjectUniqueID() {
            return null;
        }

        public boolean[] getKeyUsage() {
            return null;
        }

        public int getBasicConstraints() {
            return 0;
        }

        public byte[] getEncoded() {
            return null;
        }

        public PublicKey getPublicKey() {
            return null;
        }

        public String toString() {
            return "X509Dummy, " + this.subject.getName();
        }

        public void verify(PublicKey k) {
        }

        public void verify(PublicKey k, String p) {
        }

        public byte[] getExtensionValue(String oid) {
            return null;
        }

        public Set getCriticalExtensionOIDs() {
            return null;
        }

        public Set getNonCriticalExtensionOIDs() {
            return null;
        }

        public boolean hasUnsupportedCriticalExtension() {
            return false;
        }

        public boolean equals(Object o) {
            return ((Object)this.subject).equals(o);
        }

        public int hashCode() {
            return ((Object)this.subject).hashCode();
        }
    }

    static class DummyBundle
    implements Bundle {
        private HashMap signerMap = new HashMap();

        DummyBundle(String[] signers) {
            for (int i = 0; i < signers.length; ++i) {
                String[] chain = Util.splitwords(signers[i], ";");
                ArrayList<X509Dummy> tmp = new ArrayList<X509Dummy>(chain.length);
                for (int j = 0; j < chain.length; ++j) {
                    tmp.add(new X509Dummy(chain[j]));
                }
                this.signerMap.put(tmp.get(0), tmp);
            }
        }

        public int getState() {
            return 1;
        }

        public void start() {
            this.start(0);
        }

        public void start(int options) {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        public void stop() {
            this.stop(0);
        }

        public void stop(int options) {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        public void update() {
            this.update(null);
        }

        public void update(InputStream in) {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        public void uninstall() {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        public Dictionary getHeaders() {
            return this.getHeaders(null);
        }

        public long getBundleId() {
            return -1L;
        }

        public String getLocation() {
            return "";
        }

        public ServiceReference[] getRegisteredServices() {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        public ServiceReference[] getServicesInUse() {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        public boolean hasPermission(Object permission) {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        public BundleContext getBundleContext() {
            return null;
        }

        public URL getResource(String name) {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        public String getSymbolicName() {
            return null;
        }

        public long getLastModified() {
            return 0L;
        }

        public Map getSignerCertificates(int signersType) {
            return (Map)this.signerMap.clone();
        }

        public Version getVersion() {
            return Version.emptyVersion;
        }

        public Enumeration findEntries(String path, String filePattern, boolean recurse) {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        public URL getEntry(String name) {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        public Enumeration getEntryPaths(String path) {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        public Dictionary getHeaders(String locale) {
            return new Hashtable();
        }

        public Enumeration getResources(String name) {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        public Class loadClass(String name) {
            throw new IllegalStateException("Bundle is uninstalled");
        }
    }
}

