/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.bundlestorage.memory;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleResourceStream;
import org.knopflerfish.framework.FileArchive;
import org.knopflerfish.framework.HeaderDictionary;
import org.knopflerfish.framework.bundlestorage.memory.Archive;
import org.knopflerfish.framework.bundlestorage.memory.BundleStorageImpl;

class BundleArchiveImpl
implements BundleArchive {
    private Archive archive;
    private long id;
    private String location;
    private int autostartSetting = -1;
    private BundleStorageImpl storage;
    private Archive[] archives;
    private int startLevel = -1;
    private long lastModified;
    private ArrayList failedPath = null;

    BundleArchiveImpl(BundleStorageImpl bundleStorage, InputStream is, String bundleLocation, long bundleId) throws Exception {
        this.archive = new Archive(is);
        this.storage = bundleStorage;
        this.id = bundleId;
        this.location = bundleLocation;
        this.setClassPath();
    }

    BundleArchiveImpl(BundleArchiveImpl old, InputStream is) throws Exception {
        this.location = old.location;
        this.storage = old.storage;
        this.id = old.id;
        this.autostartSetting = old.autostartSetting;
        this.archive = new Archive(is);
        this.setClassPath();
    }

    public String getAttribute(String key) {
        return this.archive.getAttribute(key);
    }

    public FileArchive getFileArchive(String path) {
        return null;
    }

    public Hashtable getLocalizationEntries(String localeFile) {
        BundleResourceStream is = this.archive.getBundleResourceStream(localeFile);
        if (is != null) {
            Properties l = new Properties();
            try {
                l.load(is);
            }
            catch (IOException _ignore) {
                // empty catch block
            }
            try {
                is.close();
            }
            catch (IOException _ignore) {
                // empty catch block
            }
            return l;
        }
        return null;
    }

    public HeaderDictionary getUnlocalizedAttributes() {
        return new HeaderDictionary(this.archive.manifest.getMainAttributes());
    }

    public long getBundleId() {
        return this.id;
    }

    public String getBundleLocation() {
        return this.location;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(int level) {
        this.startLevel = level;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long timemillisecs) throws IOException {
        this.lastModified = timemillisecs;
    }

    public byte[] getClassBytes(Integer sub, String path) throws IOException {
        return this.archives[sub].getClassBytes(path);
    }

    public Vector componentExists(String component, boolean onlyFirst) {
        Vector<Integer> v = null;
        if (component.startsWith("/")) {
            component = component.substring(1);
        }
        if (0 == component.length()) {
            v = new Vector<Integer>();
            for (int i = 0; i < this.archives.length; ++i) {
                v.addElement(new Integer(i));
                if (!onlyFirst) {
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < this.archives.length; ++i) {
                BundleResourceStream is = this.archives[i].getBundleResourceStream(component);
                if (is == null) continue;
                if (v == null) {
                    v = new Vector();
                }
                v.addElement(new Integer(i));
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                if (!onlyFirst) {
                    continue;
                }
                break;
            }
        }
        return v;
    }

    public BundleResourceStream getBundleResourceStream(String component, int ix) {
        if (component.startsWith("/")) {
            component = component.substring(1);
        }
        if (ix == -1) {
            return this.archive.getBundleResourceStream(component);
        }
        return this.archives[ix].getBundleResourceStream(component);
    }

    public String getNativeLibrary(String libName) {
        return null;
    }

    public void setAutostartSetting(int setting) throws IOException {
        if (setting != this.autostartSetting) {
            this.autostartSetting = setting;
        }
    }

    public int getAutostartSetting() {
        return this.autostartSetting;
    }

    public void purge() {
        this.storage.removeArchive(this);
    }

    public void close() {
    }

    public List getFailedClassPathEntries() {
        return this.failedPath;
    }

    public String resolveNativeCode() {
        if (this.getAttribute("Bundle-NativeCode") != null) {
            return "Native code not allowed by memory storage";
        }
        return null;
    }

    private void setClassPath() throws IOException {
        String bcp = this.getAttribute("Bundle-ClassPath");
        if (bcp != null) {
            ArrayList<Archive> a = new ArrayList<Archive>();
            StringTokenizer st = new StringTokenizer(bcp, ",");
            while (st.hasMoreTokens()) {
                String path = st.nextToken().trim();
                if (".".equals(path)) {
                    a.add(this.archive);
                    continue;
                }
                if (path.endsWith(".jar")) {
                    try {
                        a.add(this.archive.getSubArchive(path));
                    }
                    catch (IOException ioe) {
                        if (this.failedPath == null) {
                            this.failedPath = new ArrayList(1);
                        }
                        this.failedPath.add(path);
                    }
                    continue;
                }
                if (this.archive.subDirs == null) {
                    this.archive.subDirs = new ArrayList(1);
                }
                this.archive.subDirs.add(path);
            }
            this.archives = a.toArray(new Archive[a.size()]);
        } else {
            this.archives = new Archive[]{this.archive};
        }
    }

    public Enumeration findResourcesPath(String path) {
        return this.archive.findResourcesPath(path);
    }

    public String getJarLocation() {
        return null;
    }

    public ArrayList getCertificateChains(boolean onlyTrusted) {
        throw new RuntimeException("NYI");
    }

    public void trustCertificateChain(List trustedChain) {
        throw new RuntimeException("NYI");
    }
}

