/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.bundlestorage.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.knopflerfish.framework.AutoManifest;
import org.knopflerfish.framework.BundleResourceStream;
import org.knopflerfish.framework.FileArchive;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.bundlestorage.file.BundleStorageImpl;

public class Archive
implements FileArchive {
    private static final String ARCHIVE = "jar";
    private static final String SUBDIR = "sub";
    private static final String CERTS_SUFFIX = ".crt";
    private static final String META_INF_DIR = "META-INF/";
    private static final String OSGI_OPT_DIR = "OSGI-OPT/";
    private FileTree file;
    private boolean fileIsReference = false;
    private ZipFile jar;
    private final String location;
    private Certificate[] certs = null;
    Manifest manifest;
    private ZipEntry subJar;
    private boolean bClosed = false;
    private Map nativeLibs;
    private Map renameLibs;
    BundleStorageImpl storage;
    private long bundleId;
    private int subId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Archive(BundleStorageImpl storage, File dir, int rev, InputStream is, URL source, String location, long id) throws IOException {
        FileTree sourceFile;
        this.location = location;
        this.storage = storage;
        this.bundleId = id;
        this.subId = -1;
        boolean isDirectory = false;
        FileTree bsFile = new FileTree(dir, ARCHIVE + rev);
        if (this.isReference(source)) {
            this.fileIsReference = true;
            this.file = sourceFile = new FileTree(this.getFile(source));
        } else {
            sourceFile = this.isFile(source) ? new FileTree(this.getFile(source)) : null;
            this.file = bsFile;
        }
        if (sourceFile != null && (isDirectory = sourceFile.isDirectory())) {
            File mfd = new File(sourceFile.getAbsolutePath(), META_INF_DIR);
            File mf = new File(mfd, "MANIFEST.MF");
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(mf));
            try {
                this.manifest = new Manifest(bis);
            }
            finally {
                bis.close();
            }
        }
        BufferedInputStream bis = null;
        JarInputStream ji = null;
        boolean doUnpack = false;
        if (this.manifest == null) {
            bis = new BufferedInputStream(is);
            if (storage.alwaysUnpack) {
                ji = new JarInputStream((InputStream)bis, storage.checkSigned);
                this.manifest = ji.getManifest();
                doUnpack = true;
            } else if (storage.unpack) {
                bis.mark(1000000);
                ji = new JarInputStream((InputStream)bis, storage.checkSigned);
                this.manifest = ji.getManifest();
                if (this.manifest == null || !this.needUnpack(this.manifest.getMainAttributes())) {
                    bis.reset();
                } else {
                    doUnpack = true;
                }
            }
            if (doUnpack) {
                if (this.fileIsReference) {
                    this.fileIsReference = false;
                    this.file = bsFile;
                }
                this.file.mkdirs();
                if (this.manifest == null) {
                    if (storage.checkSigned) {
                        throw new IOException("MANIFEST.MF must be first in archive when using signatures.");
                    }
                } else {
                    File f = new File(this.file, META_INF_DIR);
                    f.mkdir();
                    FileOutputStream fo = new FileOutputStream(new File(f, "MANIFEST.MF"));
                    BufferedOutputStream o = new BufferedOutputStream(fo);
                    try {
                        this.manifest.write(o);
                    }
                    finally {
                        o.close();
                    }
                }
                boolean verify = storage.checkSigned;
                int verifiedEntries = 0;
                while (this.processNextJarEntry(ji, verify, this.file)) {
                    if (!verify) continue;
                    if (this.isArchiveSigned()) {
                        ++verifiedEntries;
                        continue;
                    }
                    verify = false;
                }
                if (verify) {
                    this.checkCertificates(verifiedEntries, true);
                }
                this.jar = null;
            }
        }
        if (!doUnpack) {
            if (isDirectory) {
                if (!this.fileIsReference) {
                    sourceFile.copyTo(this.file);
                }
                if (storage.checkSigned) {
                    // empty if block
                }
                this.jar = null;
            } else {
                if (!this.fileIsReference) {
                    this.loadFile(this.file, bis);
                }
                if (storage.checkSigned) {
                    this.processSignedJar(this.file);
                }
                this.jar = new ZipFile(this.file);
            }
        }
        this.manifest = this.manifest != null ? new AutoManifest(storage.framework, this.manifest, location) : this.getManifest();
        this.checkManifest();
        this.handleAutoManifest();
        this.saveCertificates();
    }

    String getFile(URL source) {
        String sfile = source.getFile();
        if (sfile.startsWith("file:")) {
            return sfile.substring(5);
        }
        return sfile;
    }

    boolean isFile(URL source) {
        return source != null && "file".equals(source.getProtocol());
    }

    boolean isReference(URL source) {
        return source != null && ("reference".equals(source.getProtocol()) || this.storage.fileReference && this.isFile(source));
    }

    Archive(BundleStorageImpl storage, File dir, int rev, String location, long id) throws IOException {
        int i;
        this.location = location;
        this.storage = storage;
        this.bundleId = id;
        this.subId = -1;
        String[] f = dir.list();
        this.file = null;
        if (rev != -1) {
            this.file = new FileTree(dir, ARCHIVE + rev);
        } else {
            rev = Integer.MAX_VALUE;
            for (i = 0; i < f.length; ++i) {
                if (!f[i].startsWith(ARCHIVE)) continue;
                try {
                    int c = Integer.parseInt(f[i].substring(ARCHIVE.length()));
                    if (c >= rev) continue;
                    rev = c;
                    this.file = new FileTree(dir, f[i]);
                    continue;
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
        }
        for (i = 0; i < f.length; ++i) {
            if (f[i].startsWith(ARCHIVE)) {
                try {
                    int c = Integer.parseInt(f[i].substring(ARCHIVE.length()));
                    if (c != rev) {
                        new FileTree(dir, f[i]).delete();
                    }
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
            if (!f[i].startsWith(SUBDIR)) continue;
            try {
                int c = Integer.parseInt(f[i].substring(SUBDIR.length()));
                if (c == rev) continue;
                new FileTree(dir, f[i]).delete();
                continue;
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        if (this.file == null) {
            if (location != null) {
                try {
                    URL url = new URL(location);
                    if (this.isReference(url)) {
                        this.file = new FileTree(this.getFile(url));
                    }
                }
                catch (Exception e) {
                    throw new IOException("Bad file URL stored in referenced jar in: " + dir.getAbsolutePath() + ", location=" + location + ", e=" + e);
                }
            }
            if (this.file == null || !this.file.exists()) {
                throw new IOException("No saved jar file found in: " + dir.getAbsolutePath() + ", old location=" + location);
            }
            this.fileIsReference = true;
        }
        this.jar = this.file.isDirectory() ? null : new ZipFile(this.file);
        if (storage.checkSigned) {
            this.loadCertificates();
        }
        if (this.manifest == null) {
            this.manifest = this.getManifest();
        }
        this.handleAutoManifest();
    }

    Archive(Archive a, String path, int id) throws IOException {
        this.location = a.location;
        this.storage = a.storage;
        this.bundleId = a.bundleId;
        this.subId = id;
        if (a.jar != null) {
            this.jar = a.jar;
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            this.subJar = this.jar.getEntry(path);
            if (this.subJar == null) {
                this.subJar = this.jar.getEntry(path.substring(0, path.length() - 1));
            }
            if (this.subJar == null) {
                throw new IOException("No such JAR component: " + path);
            }
            this.file = a.file;
        } else {
            this.file = this.findFile(a.file, path);
            this.jar = this.file.isDirectory() ? null : new ZipFile(this.file);
        }
    }

    public String toString() {
        if (this.subJar != null) {
            return this.file.getAbsolutePath() + "(" + this.subJar.getName() + ")";
        }
        return this.file.getAbsolutePath();
    }

    int getRevision() {
        try {
            return Integer.parseInt(this.file.getName().substring(ARCHIVE.length()));
        }
        catch (NumberFormatException ignore) {
            return -1;
        }
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public int getSubId() {
        return this.subId;
    }

    String getAttribute(String key) {
        Attributes a = this.manifest.getMainAttributes();
        if (a != null) {
            return a.getValue(key);
        }
        return null;
    }

    public byte[] getClassBytes(String classFile) throws IOException {
        if (this.bClosed) {
            return null;
        }
        BundleResourceStream cif = this.getBundleResourceStream(classFile);
        if (cif != null) {
            byte[] bytes;
            long ilen = cif.getContentLength();
            if (ilen >= 0L) {
                bytes = new byte[(int)ilen];
                DataInputStream dis = new DataInputStream(cif);
                dis.readFully(bytes);
            } else {
                bytes = new byte[]{};
                byte[] tmp = new byte[8192];
                try {
                    int len;
                    while ((len = cif.read(tmp)) > 0) {
                        byte[] oldbytes = bytes;
                        bytes = new byte[oldbytes.length + len];
                        System.arraycopy(oldbytes, 0, bytes, 0, oldbytes.length);
                        System.arraycopy(tmp, 0, bytes, oldbytes.length, len);
                    }
                }
                catch (EOFException ignore) {
                    // empty catch block
                }
            }
            cif.close();
            return bytes;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BundleResourceStream getBundleResourceStream(String component) {
        if (this.bClosed) {
            return null;
        }
        if (component.startsWith("/")) {
            throw new RuntimeException("Assert! Path should never start with / here");
        }
        try {
            if (this.jar != null) {
                if (this.subJar != null) {
                    JarEntry ze;
                    if (this.subJar.isDirectory()) {
                        ZipEntry ze2 = this.jar.getEntry(this.subJar.getName() + component);
                        if (null == ze2) return null;
                        InputStream is = this.jar.getInputStream(ze2);
                        if (null != is) {
                            return new BundleResourceStream(is, ze2.getSize());
                        }
                        if (component.endsWith("/")) return new BundleResourceStream(is, ze2.getSize());
                        ZipEntry ze22 = this.jar.getEntry(this.subJar.getName() + component + "/");
                        is = this.jar.getInputStream(ze22);
                        return new BundleResourceStream(is, ze2.getSize());
                    }
                    if (component.equals("")) {
                        return new BundleResourceStream(this.jar.getInputStream(this.subJar), this.subJar.getSize());
                    }
                    JarInputStream ji = new JarInputStream(this.jar.getInputStream(this.subJar));
                    do {
                        if ((ze = ji.getNextJarEntry()) != null) continue;
                        ji.close();
                        return null;
                    } while (!component.equals(ze.getName()));
                    return new BundleResourceStream(ji, ze.getSize());
                }
                if (component.equals("")) {
                    File f = new File(this.jar.getName());
                    return new BundleResourceStream(new FileInputStream(f), f.length());
                }
                ZipEntry ze = this.jar.getEntry(component);
                if (null == ze) return null;
                InputStream is = this.jar.getInputStream(ze);
                if (null != is) {
                    return new BundleResourceStream(is, ze.getSize());
                }
                if (component.endsWith("/")) return new BundleResourceStream(is, ze.getSize());
                ZipEntry ze2 = this.jar.getEntry(component + "/");
                is = this.jar.getInputStream(ze2);
                return new BundleResourceStream(is, ze.getSize());
            }
            FileTree f = this.findFile(this.file, component);
            if (!f.exists()) return null;
            BundleResourceStream bundleResourceStream = new BundleResourceStream(new FileInputStream(f), f.length());
            return bundleResourceStream;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Enumeration findResourcesPath(String path) {
        Vector<String> answer = new Vector<String>();
        if (this.jar != null) {
            if ((path = path.replace('\\', '/')).startsWith("/")) {
                path = path.substring(1);
            }
            if (!path.endsWith("/") && path.length() > 1) {
                path = path + "/";
            }
            Enumeration<? extends ZipEntry> entries = this.jar.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(path)) continue;
                int idx = name.lastIndexOf(47);
                if (entry.isDirectory()) {
                    idx = name.substring(0, idx).lastIndexOf(47);
                }
                if (idx > 0) {
                    if (!name.substring(0, idx + 1).equals(path)) continue;
                    answer.add(name);
                    continue;
                }
                if (!path.equals("")) continue;
                answer.add(name);
            }
        } else {
            FileTree f = this.findFile(this.file, path);
            if (!f.exists()) {
                return null;
            }
            if (!f.isDirectory()) {
                return null;
            }
            File[] files = f.listFiles();
            int length = files.length;
            for (int i = 0; i < length; ++i) {
                String filePath = files[i].getPath();
                filePath = filePath.substring(this.file.getPath().length() + 1);
                filePath = filePath.replace(File.separatorChar, '/');
                if (files[i].isDirectory()) {
                    filePath = filePath + "/";
                }
                answer.add(filePath);
            }
        }
        if (answer.size() == 0) {
            return null;
        }
        return answer.elements();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String checkNativeLibrary(String path) {
        String key;
        File lib;
        if (this.bClosed) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (this.jar != null) {
            lib = this.getSubFile(this, path);
            if (!lib.exists()) {
                new File(lib.getParent()).mkdirs();
                ZipEntry ze = this.jar.getEntry(path);
                if (ze == null) return null;
                InputStream is = null;
                try {
                    is = this.jar.getInputStream(ze);
                    this.loadFile(lib, is);
                }
                catch (IOException _ignore) {
                    if (is == null) return null;
                    try {
                        is.close();
                        return null;
                    }
                    catch (IOException _ignore2) {
                        // empty catch block
                    }
                    return null;
                }
            }
        } else {
            lib = this.findFile(this.file, path);
            if (!lib.exists()) {
                if (lib.getParent() == null) return null;
                final String libname = lib.getName();
                File[] list = lib.getParentFile().listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        int pos = name.lastIndexOf(libname);
                        return pos > 1 && name.charAt(pos - 1) == '_';
                    }
                });
                if (list.length <= 0) return null;
                list[0].renameTo(lib);
            }
        }
        this.setPerm(lib);
        String libstr = lib.getAbsolutePath();
        int sp = libstr.lastIndexOf(File.separatorChar);
        String string = key = sp != -1 ? libstr.substring(sp + 1) : libstr;
        if (this.nativeLibs == null) {
            this.nativeLibs = new HashMap();
            this.renameLibs = new HashMap();
        }
        this.nativeLibs.put(key, libstr);
        return key;
    }

    public String getNativeLibrary(String libNameKey) {
        File f;
        String file = (String)this.nativeLibs.get(libNameKey);
        if (file != null && (f = new File(file)).isFile()) {
            return this.doRename(libNameKey, new File(file));
        }
        return null;
    }

    private String doRename(String key, File file1) {
        File file2;
        String val = file1.getAbsolutePath();
        if (this.renameLibs.containsKey(key) && file1.renameTo(file2 = new File((String)this.renameLibs.get(key)))) {
            val = file2.getAbsolutePath();
            this.nativeLibs.put(key, val);
        }
        StringBuffer rename = new StringBuffer(val);
        int index0 = val.lastIndexOf(File.separatorChar) + 1;
        int index1 = val.indexOf("_", index0);
        if (index1 > index0 && index1 == val.length() - key.length() - 1) {
            try {
                int prefix = Integer.parseInt(val.substring(index0, index1));
                rename.replace(index0, index1, Integer.toString(prefix + 1));
            }
            catch (Throwable t) {
                rename.insert(index0, "0_");
            }
        } else {
            rename.insert(index0, "0_");
        }
        this.renameLibs.put(key, rename.toString());
        return val;
    }

    private void setPerm(File f) {
        int start;
        String[] cmdarray;
        if (this.storage.execPermCmd.length() == 0) {
            return;
        }
        String abspath = f.getAbsolutePath();
        String[] execarray = Util.splitwords(this.storage.execPermCmd);
        if (this.storage.isWindows && !execarray[0].equalsIgnoreCase("cmd")) {
            cmdarray = new String[execarray.length + 2];
            cmdarray[0] = "cmd";
            cmdarray[1] = "/c";
            start = 2;
        } else {
            cmdarray = new String[execarray.length];
            start = 0;
        }
        for (int i = 0; i < execarray.length; ++i) {
            cmdarray[i + start] = Util.replace(execarray[i], "${abspath}", abspath);
        }
        try {
            Process p = Runtime.getRuntime().exec(cmdarray);
            InputGlobber ti = new InputGlobber(null, p.getInputStream());
            InputGlobber te = new InputGlobber(cmdarray, p.getErrorStream());
            ti.start();
            te.start();
            while (true) {
                try {
                    p.waitFor();
                }
                catch (InterruptedException _ie) {
                    _ie.printStackTrace();
                    continue;
                }
                break;
            }
            while (true) {
                try {
                    ti.join();
                }
                catch (InterruptedException _ie) {
                    _ie.printStackTrace();
                    continue;
                }
                break;
            }
            while (true) {
                try {
                    te.join();
                }
                catch (InterruptedException _ie) {
                    _ie.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (IOException _ioe) {
            _ioe.printStackTrace();
        }
    }

    void purge() {
        this.close();
        if (!this.fileIsReference) {
            this.file.delete();
        }
        this.getSubFileTree(this).delete();
        this.removeCertificates();
    }

    void close() {
        this.bClosed = true;
        if (this.subJar == null && this.jar != null) {
            try {
                this.jar.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    String getPath() {
        return this.file.getAbsolutePath();
    }

    Certificate[] getCertificates() {
        return this.certs;
    }

    private void checkManifest() {
        Attributes a = this.manifest.getMainAttributes();
        Util.parseEntries("Export-Package", a.getValue("Export-Package"), false, true, false);
        Util.parseEntries("Import-Package", a.getValue("Import-Package"), false, true, false);
    }

    private boolean needUnpack(Attributes a) {
        Iterator nc = Util.parseEntries("Bundle-NativeCode", a.getValue("Bundle-NativeCode"), false, false, false);
        String bc = a.getValue("Bundle-ClassPath");
        return bc != null && !bc.trim().equals(".") || nc.hasNext();
    }

    private void handleAutoManifest() throws IOException {
        AutoManifest mf;
        if (this.manifest instanceof AutoManifest && (mf = (AutoManifest)this.manifest).isAuto()) {
            if (this.jar != null) {
                mf.addZipFile(this.jar);
            } else if (this.file != null && this.file.isDirectory()) {
                mf.addFile(this.file.getAbsolutePath(), this.file);
            }
        }
    }

    private FileTree findFile(File root, String path) {
        return new FileTree(root, path.replace('/', File.separatorChar));
    }

    private AutoManifest getManifest() throws IOException {
        BundleResourceStream mi = this.getBundleResourceStream("META-INF/MANIFEST.MF");
        if (mi != null) {
            return new AutoManifest(this.storage.framework, new Manifest(mi), this.location);
        }
        throw new IOException("Manifest is missing");
    }

    private FileTree getSubFileTree(Archive archive) {
        return new FileTree(archive.file.getParent(), SUBDIR + archive.file.getName().substring(ARCHIVE.length()));
    }

    private File getSubFile(Archive archive, String path) {
        return new File(this.getSubFileTree(archive), path.replace('/', '-'));
    }

    private void loadFile(File output, InputStream is) throws IOException {
        OutputStream os = null;
        try {
            if (output != null) {
                os = new FileOutputStream(output);
            }
            byte[] buf = new byte[8192];
            try {
                int n;
                while ((n = is.read(buf)) >= 0) {
                    if (os == null) continue;
                    os.write(buf, 0, n);
                }
            }
            catch (EOFException ignore) {
                // empty catch block
            }
        }
        catch (IOException e) {
            if (os != null) {
                output.delete();
            }
            throw e;
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    private boolean isArchiveSigned() {
        return this.certs != null;
    }

    private boolean processNextJarEntry(JarInputStream ji, boolean verify, File saveDir) throws IOException {
        JarEntry je;
        while ((je = ji.getNextJarEntry()) != null) {
            if (je.isDirectory()) continue;
            String name = je.getName();
            if (saveDir != null && !name.startsWith(OSGI_OPT_DIR)) {
                StringTokenizer st = new StringTokenizer(name, "/");
                File f = new File(saveDir, st.nextToken());
                while (st.hasMoreTokens()) {
                    f.mkdir();
                    f = new File(f, st.nextToken());
                }
                this.loadFile(f, ji);
            } else {
                this.loadFile(null, ji);
            }
            ji.closeEntry();
            if (name.startsWith(META_INF_DIR)) continue;
            if (verify) {
                Object[] c = je.getCertificates();
                if (c != null) {
                    if (this.certs != null) {
                        if (!Arrays.equals(c, this.certs)) {
                            this.certs = null;
                        }
                    } else {
                        this.certs = c;
                    }
                } else {
                    this.certs = null;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSignedJar(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            BufferedInputStream bis = new BufferedInputStream(fis);
            JarInputStream ji = new JarInputStream(bis);
            int count = 0;
            this.manifest = ji.getManifest();
            while (this.processNextJarEntry(ji, true, null) && this.isArchiveSigned()) {
                ++count;
            }
            this.checkCertificates(count, true);
        }
        finally {
            fis.close();
        }
    }

    private void checkCertificates(int filesVerified, boolean complete) {
        if (filesVerified > 0) {
            int mentries;
            if (complete) {
                mentries = this.manifest.getEntries().size();
            } else {
                mentries = 0;
                Iterator<String> i = this.manifest.getEntries().keySet().iterator();
                while (i.hasNext()) {
                    String name = i.next();
                    if (name.startsWith(OSGI_OPT_DIR)) continue;
                    ++mentries;
                }
            }
            if (mentries != filesVerified) {
                this.certs = null;
                System.err.println("All entries in bundle not completly signed (" + mentries + " != " + filesVerified + ")");
            }
        }
    }

    public void saveCertificates() throws IOException {
        File f = new File(this.getPath() + CERTS_SUFFIX);
        if (this.certs != null) {
            try {
                FileOutputStream fos = new FileOutputStream(f);
                for (int i = 0; i < this.certs.length; ++i) {
                    fos.write(this.certs[i].getEncoded());
                }
                fos.close();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                // empty catch block
            }
        }
    }

    private void loadCertificates() throws IOException {
        File f = new File(this.getPath() + CERTS_SUFFIX);
        if (f.canRead()) {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                FileInputStream fis = new FileInputStream(f);
                Collection<? extends Certificate> c = cf.generateCertificates(fis);
                if (c.size() > 0) {
                    this.certs = new Certificate[c.size()];
                    this.certs = c.toArray(this.certs);
                }
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
    }

    public void removeCertificates() {
        File f = new File(this.getPath() + CERTS_SUFFIX);
        f.delete();
    }

    static class InputGlobber
    extends Thread {
        String[] cmd;
        final InputStream in;
        boolean copyToStdout;

        InputGlobber(String[] cmd, InputStream in) {
            this.cmd = cmd;
            this.in = in;
            this.copyToStdout = cmd != null;
        }

        public void run() {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.in));
            try {
                String line = br.readLine();
                while (null != line) {
                    if (null != this.cmd) {
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < this.cmd.length; ++i) {
                            if (sb.length() > 0) {
                                sb.append(" ");
                            }
                            sb.append(this.cmd[i]);
                        }
                        System.err.println("Failed to execute: '" + sb.toString() + "':");
                        this.cmd = null;
                    }
                    if (this.copyToStdout) {
                        System.out.println(line);
                    }
                    line = br.readLine();
                }
            }
            catch (IOException _ioe) {
                _ioe.printStackTrace();
            }
        }
    }
}

