/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Packages;
import org.knopflerfish.framework.Queue;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.startlevel.StartLevel;

public class StartLevelController
implements Runnable,
ServiceFactory {
    public static final String SPEC_VERSION = "1.1";
    static final int START_MIN = 0;
    static final int START_MAX = Integer.MAX_VALUE;
    static final String LEVEL_FILE = "currentlevel";
    static final String INITIAL_LEVEL_FILE = "initiallevel";
    Thread wc;
    long wcDelay = 2000L;
    boolean bRun = false;
    Queue jobQueue = new Queue(100);
    int currentLevel = 0;
    int initStartLevel = 1;
    int targetStartLevel = this.currentLevel;
    boolean acceptChanges = true;
    final FrameworkContext fwCtx;
    FileTree storage;
    boolean bCompat;
    Object lock = new Object();
    static final Util.Comparator BSComparator = new Util.Comparator(){

        public int compare(Object o1, Object o2) {
            BundleImpl b1 = (BundleImpl)o1;
            BundleImpl b2 = (BundleImpl)o2;
            int res = b1.getStartLevel() - b2.getStartLevel();
            if (res == 0) {
                res = (int)(b1.getBundleId() - b2.getBundleId());
            }
            return res;
        }
    };

    StartLevelController(FrameworkContext fwCtx) {
        this.fwCtx = fwCtx;
        this.bCompat = fwCtx.props.getBooleanProperty("org.knopflerfish.framework.startlevel.compat");
        this.storage = Util.getFileStorage(fwCtx, "startlevel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open() {
        if (this.fwCtx.debug.startlevel) {
            this.fwCtx.debug.println("startlevel: open");
        }
        if (this.jobQueue.isEmpty()) {
            int beginningLevel = 1;
            String sBeginningLevel = this.fwCtx.props.getProperty("org.osgi.framework.startlevel.beginning");
            try {
                beginningLevel = Integer.parseInt(sBeginningLevel);
            }
            catch (NumberFormatException nfe) {
                this.fwCtx.debug.printStackTrace("Invalid number '" + sBeginningLevel + "' in value of property named '" + "org.osgi.framework.startlevel.beginning" + "'.", nfe);
            }
            this.setStartLevel0(beginningLevel, false, false, true);
        }
        Runnable firstJob = (Runnable)this.jobQueue.firstElement();
        this.wc = new Thread(this.fwCtx.threadGroup, this, "startlevel job");
        Runnable runnable = firstJob;
        synchronized (runnable) {
            this.bRun = true;
            this.wc.start();
            if (!this.acceptChanges) {
                this.acceptChanges = true;
                this.restoreState();
            }
            try {
                firstJob.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void restoreState() {
        if (this.fwCtx.debug.startlevel) {
            this.fwCtx.debug.println("startlevel: restoreState");
        }
        if (this.storage != null) {
            String s;
            try {
                int oldStartLevel;
                s = Util.getContent(new File(this.storage, LEVEL_FILE));
                if (s != null && (oldStartLevel = Integer.parseInt(s)) != -1) {
                    this.setStartLevel0(oldStartLevel, false, false, true);
                }
            }
            catch (Exception _ignored) {
                // empty catch block
            }
            try {
                s = Util.getContent(new File(this.storage, INITIAL_LEVEL_FILE));
                if (s != null) {
                    this.setInitialBundleStartLevel0(Integer.parseInt(s), false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void close() {
        if (this.fwCtx.debug.startlevel) {
            this.fwCtx.debug.println("*** closing startlevel service");
        }
        this.bRun = false;
        if (this.wc != null) {
            try {
                this.wc.join(this.wcDelay * 2L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.wc = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.acceptChanges = false;
        Thread thread = this.wc;
        synchronized (thread) {
            this.setStartLevel0(0, false, true, false);
            while (this.currentLevel > 0) {
                try {
                    this.wc.wait();
                }
                catch (Exception exception) {}
            }
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.bRun) {
            try {
                Runnable job = (Runnable)this.jobQueue.removeWait((float)((double)this.wcDelay / 1000.0));
                if (job == null) continue;
                job.run();
                Runnable runnable = job;
                synchronized (runnable) {
                    job.notify();
                }
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
    }

    int getStartLevel() {
        return this.currentLevel;
    }

    void setStartLevel(int startLevel) {
        this.fwCtx.perm.checkStartLevelAdminPerm();
        if (startLevel <= 0) {
            throw new IllegalArgumentException("Initial start level must be > 0, is " + startLevel);
        }
        if (this.acceptChanges) {
            this.setStartLevel0(startLevel, true, false, true);
        }
    }

    private void setStartLevel0(final int startLevel, final boolean notifyFw, final boolean notifyWC, final boolean storeLevel) {
        if (this.fwCtx.debug.startlevel) {
            this.fwCtx.debug.println("startlevel: setStartLevel " + startLevel);
        }
        this.jobQueue.insert(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int sl;
                StartLevelController.this.targetStartLevel = sl = StartLevelController.this.bCompat ? 1 : startLevel;
                while (StartLevelController.this.targetStartLevel > StartLevelController.this.currentLevel) {
                    StartLevelController.this.increaseStartLevel();
                }
                while (StartLevelController.this.targetStartLevel < StartLevelController.this.currentLevel) {
                    StartLevelController.this.decreaseStartLevel();
                }
                if (storeLevel && StartLevelController.this.storage != null) {
                    try {
                        Util.putContent(new File(StartLevelController.this.storage, StartLevelController.LEVEL_FILE), Integer.toString(StartLevelController.this.currentLevel));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (notifyFw) {
                    StartLevelController.this.fwCtx.listeners.frameworkEvent(new FrameworkEvent(8, StartLevelController.this.fwCtx.systemBundle, null));
                }
                if (notifyWC && StartLevelController.this.wc != null) {
                    Thread thread = StartLevelController.this.wc;
                    synchronized (thread) {
                        StartLevelController.this.wc.notifyAll();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void increaseStartLevel() {
        Object object = this.lock;
        synchronized (object) {
            BundleImpl bs;
            ++this.currentLevel;
            if (this.fwCtx.debug.startlevel) {
                this.fwCtx.debug.println("startlevel: increaseStartLevel currentLevel=" + this.currentLevel);
            }
            Vector<BundleImpl> set = new Vector<BundleImpl>();
            List bundles = this.fwCtx.bundles.getBundles();
            Iterator i = bundles.iterator();
            while (i.hasNext()) {
                bs = (BundleImpl)i.next();
                if (!this.canStart(bs) || bs.getStartLevel() != this.currentLevel || bs.archive.getAutostartSetting() == -1) continue;
                set.addElement(bs);
            }
            Util.sort(set, BSComparator, false);
            for (int i2 = 0; i2 < set.size(); ++i2) {
                bs = (BundleImpl)set.elementAt(i2);
                try {
                    if (bs.archive.getAutostartSetting() == -1) continue;
                    if (this.fwCtx.debug.startlevel) {
                        this.fwCtx.debug.println("startlevel: start " + bs);
                    }
                    int startOptions = 1;
                    if (this.isBundleActivationPolicyUsed(bs.archive)) {
                        startOptions |= 2;
                    }
                    bs.start(startOptions);
                    continue;
                }
                catch (IllegalStateException ignore) {
                    continue;
                }
                catch (Exception e) {
                    this.fwCtx.listeners.frameworkError(bs, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decreaseStartLevel() {
        Object object = this.lock;
        synchronized (object) {
            --this.currentLevel;
            Vector<BundleImpl> set = new Vector<BundleImpl>();
            List bundles = this.fwCtx.bundles.getBundles();
            Iterator i = bundles.iterator();
            while (i.hasNext()) {
                BundleImpl bs = (BundleImpl)i.next();
                if (bs.getState() != 32 && (bs.getState() != 8 || !bs.lazyActivation) || bs.getStartLevel() != this.currentLevel + 1) continue;
                set.addElement(bs);
            }
            Util.sort(set, BSComparator, true);
            Packages packages = this.fwCtx.packages;
            synchronized (packages) {
                for (int i2 = 0; i2 < set.size(); ++i2) {
                    BundleImpl bs = (BundleImpl)set.elementAt(i2);
                    if (bs.getState() != 32 && (bs.getState() != 8 || !bs.lazyActivation)) continue;
                    if (this.fwCtx.debug.startlevel) {
                        this.fwCtx.debug.println("startlevel: stop " + bs);
                    }
                    try {
                        bs.stop(1);
                        continue;
                    }
                    catch (Throwable t) {
                        this.fwCtx.listeners.frameworkError(bs, t);
                    }
                }
            }
        }
    }

    boolean canStart(BundleImpl b) {
        return b.getState() != 1;
    }

    int getBundleStartLevel(BundleImpl bundle) {
        if (bundle.getBundleId() == 0L) {
            return 0;
        }
        return bundle.getStartLevel();
    }

    void setBundleStartLevel(final BundleImpl bundle, int startLevel) {
        this.fwCtx.perm.checkExecuteAdminPerm(bundle);
        if (startLevel <= 0) {
            throw new IllegalArgumentException("Initial start level must be > 0, is " + startLevel);
        }
        if (bundle.getBundleId() == 0L) {
            throw new IllegalArgumentException("System bundle start level cannot be changed");
        }
        this.fwCtx.perm.callSetStartLevel(bundle, this.bCompat ? 1 : startLevel);
        this.jobQueue.insert(new Runnable(){

            public void run() {
                StartLevelController.this.syncStartLevel(bundle);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncStartLevel(BundleImpl bs) {
        try {
            if (this.fwCtx.debug.startlevel) {
                this.fwCtx.debug.println("syncstartlevel: " + bs);
            }
            Object object = this.lock;
            synchronized (object) {
                Packages packages = this.fwCtx.packages;
                synchronized (packages) {
                    if (bs.getStartLevel() <= this.currentLevel) {
                        if ((bs.getState() & 0x16) != 0 && bs.archive.getAutostartSetting() != -1) {
                            if (this.fwCtx.debug.startlevel) {
                                this.fwCtx.debug.println("startlevel: start " + bs);
                            }
                            int startOptions = 1;
                            if (this.isBundleActivationPolicyUsed(bs.archive)) {
                                startOptions |= 2;
                            }
                            bs.start(startOptions);
                        }
                    } else if (bs.getStartLevel() > this.currentLevel && (bs.getState() & 0x28) != 0) {
                        if (this.fwCtx.debug.startlevel) {
                            this.fwCtx.debug.println("startlevel: stop " + bs);
                        }
                        bs.stop(1);
                    }
                }
            }
        }
        catch (Throwable t) {
            this.fwCtx.listeners.frameworkError(bs, t);
        }
    }

    int getInitialBundleStartLevel() {
        return this.initStartLevel;
    }

    void setInitialBundleStartLevel(int startLevel) {
        this.fwCtx.perm.checkStartLevelAdminPerm();
        this.setInitialBundleStartLevel0(startLevel, true);
    }

    private void setInitialBundleStartLevel0(int startLevel, boolean save) {
        if (startLevel <= 0) {
            throw new IllegalArgumentException("Initial start level must be > 0, is " + startLevel);
        }
        int n = this.initStartLevel = this.bCompat ? 1 : startLevel;
        if (this.storage != null && save) {
            try {
                Util.putContent(new File(this.storage, INITIAL_LEVEL_FILE), Integer.toString(this.initStartLevel));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    boolean isBundlePersistentlyStarted(BundleArchive archive) {
        return archive == null || archive.getAutostartSetting() != -1;
    }

    boolean isBundleActivationPolicyUsed(BundleArchive archive) {
        return archive != null && archive.getAutostartSetting() == 2;
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        return new StartLevelImpl(this);
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    static class StartLevelImpl
    implements StartLevel {
        private StartLevelController st;

        StartLevelImpl(StartLevelController st) {
            this.st = st;
        }

        public int getBundleStartLevel(Bundle bundle) {
            return this.st.getBundleStartLevel(this.checkBundle(bundle));
        }

        public int getInitialBundleStartLevel() {
            return this.st.getInitialBundleStartLevel();
        }

        public int getStartLevel() {
            return this.st.getStartLevel();
        }

        public boolean isBundleActivationPolicyUsed(Bundle bundle) {
            return this.st.isBundleActivationPolicyUsed(this.getBundleArchive(bundle));
        }

        public boolean isBundlePersistentlyStarted(Bundle bundle) {
            return this.st.isBundlePersistentlyStarted(this.getBundleArchive(bundle));
        }

        public void setBundleStartLevel(Bundle bundle, int startlevel) {
            this.st.setBundleStartLevel(this.checkBundle(bundle), startlevel);
        }

        public void setInitialBundleStartLevel(int startlevel) {
            this.st.setInitialBundleStartLevel(startlevel);
        }

        public void setStartLevel(int startlevel) {
            this.st.setStartLevel(startlevel);
        }

        private BundleImpl checkBundle(Bundle b) {
            if (b instanceof BundleImpl) {
                BundleImpl res = (BundleImpl)b;
                if (res.fwCtx == this.st.fwCtx) {
                    if (res.state != 1) {
                        return res;
                    }
                    throw new IllegalArgumentException("Bundle is in UNINSTALLED state");
                }
            }
            throw new IllegalArgumentException("Bundle doesn't belong to the same framework as the StartLevel service");
        }

        private BundleArchive getBundleArchive(Bundle b) {
            BundleImpl bi = this.checkBundle(b);
            BundleArchive res = bi.archive;
            if (res == null && bi.id != 0L) {
                throw new IllegalArgumentException("Bundle is in UNINSTALLED state");
            }
            return res;
        }
    }
}

