/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.knopflerfish.framework.BundleURLStreamHandler;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.ReferenceURLStreamHandler;
import org.knopflerfish.framework.URLStreamHandlerWrapper;
import org.knopflerfish.framework.Util;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ServiceURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    ArrayList framework = new ArrayList(2);
    Map handlers = new HashMap();
    String[] jvmPkgs = null;
    Map wrapMap = new HashMap();
    BundleURLStreamHandler bundleHandler;
    private final Debug debug;
    static /* synthetic */ Class class$org$osgi$service$url$URLStreamHandlerService;

    ServiceURLStreamHandlerFactory(FrameworkContext fw) {
        String s = fw.props.getProperty("java.protocol.handler.pkgs");
        this.debug = fw.debug;
        if (s != null) {
            this.jvmPkgs = Util.splitwords(s, "|");
            for (int i = 0; i < this.jvmPkgs.length; ++i) {
                this.jvmPkgs[i] = this.jvmPkgs[i].trim();
                if (!this.debug.url) continue;
                this.debug.println("JVMClassPath - URLHandler jvmPkgs[" + i + "]=" + this.jvmPkgs[i]);
            }
        }
        this.setURLStreamHandler("reference", new ReferenceURLStreamHandler());
        this.bundleHandler = new BundleURLStreamHandler();
        this.setURLStreamHandler("bundle", this.bundleHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (this.debug.url) {
            this.debug.println("createURLStreamHandler protocol=" + protocol);
        }
        Map map = this.handlers;
        synchronized (map) {
            URLStreamHandler handler = this.getJVMClassPathHandler(protocol);
            if (handler != null) {
                if (this.debug.url) {
                    this.debug.println("using JVMClassPath handler for " + protocol);
                }
                return handler;
            }
            handler = (URLStreamHandler)this.handlers.get(protocol);
            if (handler != null) {
                if (this.debug.url) {
                    this.debug.println("using predefined handler for " + protocol);
                }
                return handler;
            }
            handler = this.getServiceHandler(protocol);
            if (handler != null) {
                if (this.debug.url) {
                    this.debug.println("Using service URLHandler for " + protocol);
                }
                return handler;
            }
            if (this.debug.url) {
                this.debug.println("Using default URLHandler for " + protocol);
            }
            return null;
        }
    }

    void setURLStreamHandler(String protocol, URLStreamHandler handler) {
        this.handlers.put(protocol, handler);
    }

    void addFramework(FrameworkContext fw) {
        this.framework.add(fw);
        this.bundleHandler.addFramework(fw);
    }

    void removeFramework(FrameworkContext fw) {
        ((AbstractCollection)this.framework).remove(fw);
        this.bundleHandler.removeFramework(fw);
        Iterator i = this.wrapMap.values().iterator();
        while (i.hasNext()) {
            ((URLStreamHandlerWrapper)i.next()).removeFramework(fw);
        }
    }

    private URLStreamHandler getServiceHandler(String protocol) {
        try {
            String filter = "(url.handler.protocol=" + protocol + ")";
            Iterator i = ((AbstractList)this.framework).iterator();
            while (i.hasNext()) {
                FrameworkContext sfw = (FrameworkContext)i.next();
                ServiceReference[] srl = sfw.services.get((class$org$osgi$service$url$URLStreamHandlerService == null ? ServiceURLStreamHandlerFactory.class$("org.osgi.service.url.URLStreamHandlerService") : class$org$osgi$service$url$URLStreamHandlerService).getName(), filter, null);
                if (srl == null || srl.length <= 0) continue;
                URLStreamHandlerWrapper wrapper = (URLStreamHandlerWrapper)this.wrapMap.get(protocol);
                if (wrapper == null) {
                    wrapper = new URLStreamHandlerWrapper(sfw, protocol);
                    this.wrapMap.put(protocol, wrapper);
                } else {
                    wrapper.addFramework(sfw);
                }
                return wrapper;
            }
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("Failed to get service: " + e);
        }
        return null;
    }

    private URLStreamHandler getJVMClassPathHandler(String protocol) {
        if (this.jvmPkgs != null) {
            for (int i = 0; i < this.jvmPkgs.length; ++i) {
                String className = this.jvmPkgs[i] + "." + protocol + ".Handler";
                try {
                    if (this.debug.url) {
                        this.debug.println("JVMClassPath - trying URLHandler class=" + className);
                    }
                    Class<?> clazz = Class.forName(className);
                    URLStreamHandler handler = (URLStreamHandler)clazz.newInstance();
                    if (this.debug.url) {
                        this.debug.println("JVMClassPath - created URLHandler class=" + className);
                    }
                    return handler;
                }
                catch (Throwable t) {
                    if (!this.debug.url) continue;
                    this.debug.println("JVMClassPath - no URLHandler class " + className);
                    continue;
                }
            }
        }
        if (this.debug.url) {
            this.debug.println("JVMClassPath - no URLHandler for " + protocol);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

