/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.PropertiesDictionary;
import org.knopflerfish.framework.ServiceReferenceImpl;
import org.knopflerfish.framework.Services;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceRegistrationImpl
implements ServiceRegistration {
    BundleImpl bundle;
    Object service;
    ServiceReferenceImpl reference;
    PropertiesDictionary properties;
    HashMap dependents = new HashMap();
    HashMap serviceInstances = new HashMap();
    volatile boolean available;
    private Object eventLock = new Object();
    volatile boolean unregistering = false;

    ServiceRegistrationImpl(BundleImpl b, Object s, PropertiesDictionary props) {
        this.bundle = b;
        this.service = s;
        this.properties = props;
        this.reference = new ServiceReferenceImpl(this);
        this.available = true;
    }

    public ServiceReference getReference() {
        ServiceReferenceImpl res = this.reference;
        if (res != null) {
            return res;
        }
        throw new IllegalStateException("Service is unregistered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Dictionary props) {
        Object object = this.eventLock;
        synchronized (object) {
            Set before;
            Services services = this.bundle.fwCtx.services;
            synchronized (services) {
                PropertiesDictionary propertiesDictionary = this.properties;
                synchronized (propertiesDictionary) {
                    if (this.available) {
                        Object old_rank = this.properties.get("service.ranking");
                        before = this.bundle.fwCtx.listeners.getMatchingServiceListeners(this.reference);
                        String[] classes = (String[])this.properties.get("objectClass");
                        Long sid = (Long)this.properties.get("service.id");
                        this.properties = new PropertiesDictionary(props, classes, sid);
                        Object new_rank = this.properties.get("service.ranking");
                        if (old_rank != new_rank && new_rank instanceof Integer && !((Integer)new_rank).equals(old_rank)) {
                            this.bundle.fwCtx.services.updateServiceRegistrationOrder(this, classes);
                        }
                    } else {
                        throw new IllegalStateException("Service is unregistered");
                    }
                }
            }
            this.bundle.fwCtx.perm.callServiceChanged(this.bundle.fwCtx, this.bundle.fwCtx.listeners.getMatchingServiceListeners(this.reference), new ServiceEvent(2, this.reference), before);
            if (!before.isEmpty()) {
                this.bundle.fwCtx.perm.callServiceChanged(this.bundle.fwCtx, before, new ServiceEvent(8, this.reference), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        if (this.unregistering) {
            return;
        }
        Object object = this.eventLock;
        synchronized (object) {
            if (this.unregistering) {
                return;
            }
            this.unregistering = true;
            if (this.available) {
                if (null != this.bundle) {
                    this.bundle.fwCtx.services.removeServiceRegistration(this);
                }
            } else {
                throw new IllegalStateException("Service is unregistered");
            }
        }
        if (null != this.bundle) {
            this.bundle.fwCtx.perm.callServiceChanged(this.bundle.fwCtx, this.bundle.fwCtx.listeners.getMatchingServiceListeners(this.reference), new ServiceEvent(4, this.reference), null);
        }
        object = this.eventLock;
        synchronized (object) {
            PropertiesDictionary propertiesDictionary = this.properties;
            synchronized (propertiesDictionary) {
                this.available = false;
                if (null != this.bundle) {
                    this.bundle.fwCtx.perm.callUnregister0(this);
                }
                this.bundle = null;
                this.dependents = null;
                this.reference = null;
                this.service = null;
                this.serviceInstances = null;
                this.unregistering = false;
            }
        }
    }

    void unregister0() {
        Iterator i = this.serviceInstances.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            try {
                ((ServiceFactory)this.service).ungetService((Bundle)e.getKey(), this, e.getValue());
            }
            catch (Throwable ue) {
                this.bundle.fwCtx.listeners.frameworkError(this.bundle, ue);
            }
        }
    }

    boolean isUsedByBundle(Bundle b) {
        HashMap deps = this.dependents;
        if (deps != null) {
            return deps.containsKey(b);
        }
        return false;
    }
}

