/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.knopflerfish.framework.BundleContextImpl;
import org.knopflerfish.framework.Listeners;
import org.knopflerfish.framework.ServiceListenerEntry;
import org.knopflerfish.framework.ServiceReferenceImpl;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;

class ServiceListenerState {
    protected static final String[] hashedKeys = new String[]{"objectClass".toLowerCase(), "service.id".toLowerCase(), "service.pid".toLowerCase()};
    private static final int OBJECTCLASS_IX = 0;
    private static final int SERVICE_ID_IX = 1;
    private static final int SERVICE_PID_IX = 2;
    protected static List hashedKeysV;
    List complicatedListeners = new ArrayList();
    Map[] cache = new HashMap[hashedKeys.length];
    Set serviceSet = new HashSet();
    Listeners listeners;

    ServiceListenerState(Listeners listeners) {
        this.listeners = listeners;
        hashedKeysV = new ArrayList();
        for (int i = 0; i < hashedKeys.length; ++i) {
            hashedKeysV.add(hashedKeys[i]);
            this.cache[i] = new HashMap();
        }
    }

    void clear() {
        hashedKeysV.clear();
        this.complicatedListeners.clear();
        for (int i = 0; i < hashedKeys.length; ++i) {
            this.cache[i].clear();
        }
        this.serviceSet.clear();
        this.listeners = null;
    }

    synchronized void add(BundleContextImpl bc, ServiceListener listener, String filter) throws InvalidSyntaxException {
        ServiceListenerEntry sle = new ServiceListenerEntry(bc, listener, filter);
        if (this.serviceSet.contains(sle)) {
            this.remove(bc, listener);
        }
        this.serviceSet.add(sle);
        this.listeners.framework.hooks.handleServiceListenerReg(sle);
        this.checkSimple(sle);
    }

    synchronized void remove(BundleContextImpl bc, ServiceListener listener) {
        Iterator it = this.serviceSet.iterator();
        while (it.hasNext()) {
            ServiceListenerEntry sle = (ServiceListenerEntry)it.next();
            if (sle.bc != bc || sle.listener != listener) continue;
            sle.setRemoved(true);
            this.listeners.framework.hooks.handleServiceListenerUnreg(sle);
            this.removeFromCache(sle);
            it.remove();
            break;
        }
    }

    private void removeFromCache(ServiceListenerEntry sle) {
        if (sle.local_cache != null) {
            for (int i = 0; i < hashedKeys.length; ++i) {
                HashMap keymap = (HashMap)this.cache[i];
                List l = sle.local_cache[i];
                if (l == null) continue;
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    Object value = it.next();
                    List sles = (List)keymap.get(value);
                    sles.remove(sles.indexOf(sle));
                    if (!sles.isEmpty()) continue;
                    keymap.remove(value);
                }
            }
        } else {
            this.complicatedListeners.remove(sle);
        }
    }

    synchronized void removeAll(BundleContextImpl bc) {
        Iterator it = this.serviceSet.iterator();
        while (it.hasNext()) {
            ServiceListenerEntry sle = (ServiceListenerEntry)it.next();
            if (sle.bc != bc) continue;
            this.removeFromCache(sle);
            it.remove();
        }
    }

    synchronized void hooksBundleStopped(BundleContextImpl bc) {
        ArrayList<ServiceListenerEntry> entries = new ArrayList<ServiceListenerEntry>();
        Iterator it = this.serviceSet.iterator();
        while (it.hasNext()) {
            ServiceListenerEntry sle = (ServiceListenerEntry)it.next();
            if (sle.bc != bc) continue;
            entries.add(sle);
        }
        this.listeners.framework.hooks.handleServiceListenerUnreg(Collections.unmodifiableList(entries));
    }

    public void checkSimple(ServiceListenerEntry sle) {
        if (sle.ldap == null || this.listeners.nocacheldap) {
            this.complicatedListeners.add(sle);
        } else {
            List[] local_cache = new List[hashedKeys.length];
            if (sle.ldap.isSimple(hashedKeysV, local_cache, false)) {
                sle.local_cache = local_cache;
                for (int i = 0; i < hashedKeys.length; ++i) {
                    if (local_cache[i] == null) continue;
                    Iterator it = local_cache[i].iterator();
                    while (it.hasNext()) {
                        Object value = it.next();
                        ArrayList<ServiceListenerEntry> sles = (ArrayList<ServiceListenerEntry>)this.cache[i].get(value);
                        if (sles == null) {
                            sles = new ArrayList<ServiceListenerEntry>();
                            this.cache[i].put(value, sles);
                        }
                        sles.add(sle);
                    }
                }
            } else {
                if (this.listeners.framework.debug.ldap) {
                    this.listeners.framework.debug.println("Too complicated filter: " + sle.ldap);
                }
                this.complicatedListeners.add(sle);
            }
        }
    }

    synchronized Set getMatchingListeners(ServiceReferenceImpl sr) {
        HashSet<ServiceListenerEntry> set;
        block7: {
            Object service_pid;
            block9: {
                block8: {
                    set = new HashSet<ServiceListenerEntry>();
                    int n = 0;
                    Iterator it = this.complicatedListeners.iterator();
                    while (it.hasNext()) {
                        ServiceListenerEntry sle = (ServiceListenerEntry)it.next();
                        if (sle.ldap == null || sle.ldap.evaluate(sr.getProperties(), false)) {
                            set.add(sle);
                        }
                        ++n;
                    }
                    if (this.listeners.framework.debug.ldap) {
                        this.listeners.framework.debug.println("Added " + set.size() + " out of " + n + " listeners with complicated filters");
                    }
                    String[] c = (String[])sr.getProperty("objectClass");
                    for (int i = 0; i < c.length; ++i) {
                        this.addToSet(set, 0, c[i]);
                    }
                    Long service_id = (Long)sr.getProperty("service.id");
                    if (service_id != null) {
                        this.addToSet(set, 1, service_id.toString());
                    }
                    if ((service_pid = sr.getProperty("service.pid")) == null) break block7;
                    if (!(service_pid instanceof String)) break block8;
                    this.addToSet(set, 2, service_pid);
                    break block7;
                }
                if (!(service_pid instanceof String[])) break block9;
                String[] sa = (String[])service_pid;
                for (int i = 0; i < sa.length; ++i) {
                    this.addToSet(set, 2, sa[i]);
                }
                break block7;
            }
            if (!(service_pid instanceof Collection)) break block7;
            Iterator i = ((Collection)service_pid).iterator();
            while (i.hasNext()) {
                this.addToSet(set, 2, i.next());
            }
        }
        return set;
    }

    private void addToSet(Set set, int cache_ix, Object val) {
        List l = (List)this.cache[cache_ix].get(val);
        if (l != null) {
            if (this.listeners.framework.debug.ldap) {
                this.listeners.framework.debug.println(hashedKeys[cache_ix] + " matches " + l.size());
            }
            Iterator it = l.iterator();
            while (it.hasNext()) {
                set.add(it.next());
            }
        } else if (this.listeners.framework.debug.ldap) {
            this.listeners.framework.debug.println(hashedKeys[cache_ix] + " matches none");
        }
    }
}

