/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleClassLoader;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.BundleResourceStream;
import org.knopflerfish.framework.BundleThread;
import org.knopflerfish.framework.Bundles;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.HeaderDictionary;
import org.knopflerfish.framework.PackageAdminImpl;
import org.knopflerfish.framework.PermissionOps;
import org.knopflerfish.framework.ServiceRegistrationImpl;
import org.knopflerfish.framework.SystemBundle;
import org.knopflerfish.framework.permissions.ConditionalPermissionAdminImpl;
import org.knopflerfish.framework.permissions.PermissionsHandle;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundlePermission;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

class SecurePermissionOps
extends PermissionOps {
    private static final int AP_CLASS = 0;
    private static final int AP_EXECUTE = 1;
    private static final int AP_EXTENSIONLIFECYCLE = 2;
    private static final int AP_LIFECYCLE = 3;
    private static final int AP_LISTENER = 4;
    private static final int AP_METADATA = 5;
    private static final int AP_RESOURCE = 6;
    private static final int AP_CONTEXT = 7;
    private static final int AP_MAX = 8;
    private static String[] AP_TO_STRING = new String[]{"class", "execute", "extensionLifecycle", "lifecycle", "listener", "metadata", "resource", "context"};
    private final FrameworkContext framework;
    private PermissionsHandle ph;
    private AdminPermission ap_resolve = null;
    private AdminPermission ap_startlevel = null;
    private RuntimePermission rp_getprotectiondomain = null;
    Hashtable adminPerms = new Hashtable();
    static /* synthetic */ Class class$org$osgi$service$permissionadmin$PermissionAdmin;
    static /* synthetic */ Class class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin;

    SecurePermissionOps(FrameworkContext fw) {
        this.framework = fw;
    }

    void init() {
        this.ph = new PermissionsHandle(this.framework);
    }

    void registerService() {
        ConditionalPermissionAdminImpl cpa;
        if (this.framework.props.getBooleanProperty("org.knopflerfish.framework.service.permissionadmin")) {
            String[] classes = new String[]{(class$org$osgi$service$permissionadmin$PermissionAdmin == null ? (class$org$osgi$service$permissionadmin$PermissionAdmin = SecurePermissionOps.class$("org.osgi.service.permissionadmin.PermissionAdmin")) : class$org$osgi$service$permissionadmin$PermissionAdmin).getName()};
            this.framework.services.register(this.framework.systemBundle, classes, this.ph.getPermissionAdminService(), null);
        }
        if (this.framework.props.getBooleanProperty("org.knopflerfish.framework.service.conditionalpermissionadmin") && (cpa = this.ph.getConditionalPermissionAdminService()) != null) {
            String[] classes = new String[]{(class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin == null ? (class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin = SecurePermissionOps.class$("org.osgi.service.condpermadmin.ConditionalPermissionAdmin")) : class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin).getName()};
            this.framework.services.register(this.framework.systemBundle, classes, cpa, null);
        }
    }

    boolean checkPermissions() {
        return true;
    }

    boolean okClassAdminPerm(Bundle b) {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (null != sm) {
                sm.checkPermission(this.getAdminPermission(b, 0));
            }
            return true;
        }
        catch (SecurityException _ignore) {
            return false;
        }
    }

    void checkExecuteAdminPerm(Bundle b) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(this.getAdminPermission(b, 1));
        }
    }

    void checkExtensionLifecycleAdminPerm(Bundle b) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(this.getAdminPermission(b, 2));
        }
    }

    void checkExtensionLifecycleAdminPerm(Bundle b, Object checkContext) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm && checkContext != null) {
            sm.checkPermission(this.getAdminPermission(b, 2), checkContext);
        }
    }

    void checkLifecycleAdminPerm(Bundle b) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(this.getAdminPermission(b, 3));
        }
    }

    void checkLifecycleAdminPerm(Bundle b, Object checkContext) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm && checkContext != null) {
            sm.checkPermission(this.getAdminPermission(b, 3), checkContext);
        }
    }

    void checkListenerAdminPerm(Bundle b) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(this.getAdminPermission(b, 4));
        }
    }

    void checkMetadataAdminPerm(Bundle b) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(this.getAdminPermission(b, 5));
        }
    }

    void checkResolveAdminPerm() {
        SecurityManager sm;
        if (this.ap_resolve == null) {
            this.ap_resolve = new AdminPermission(this.framework.systemBundle, "resolve");
        }
        if (null != (sm = System.getSecurityManager())) {
            sm.checkPermission(this.ap_resolve);
        }
    }

    void checkResourceAdminPerm(Bundle b) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(this.getAdminPermission(b, 6));
        }
    }

    boolean okResourceAdminPerm(Bundle b) {
        try {
            this.checkResourceAdminPerm(b);
            return true;
        }
        catch (SecurityException ignore) {
            if (this.framework.debug.bundle_resource) {
                this.framework.debug.printStackTrace("No permission to access resources in bundle #" + b.getBundleId(), ignore);
            }
            return false;
        }
    }

    void checkContextAdminPerm(Bundle b) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(this.getAdminPermission(b, 7));
        }
    }

    void checkStartLevelAdminPerm() {
        SecurityManager sm;
        if (this.ap_startlevel == null) {
            this.ap_startlevel = new AdminPermission(this.framework.systemBundle, "startlevel");
        }
        if (null != (sm = System.getSecurityManager())) {
            sm.checkPermission(this.ap_startlevel);
        }
    }

    void checkGetProtectionDomain() {
        SecurityManager sm;
        if (this.rp_getprotectiondomain == null) {
            this.rp_getprotectiondomain = new RuntimePermission("getProtectionDomain");
        }
        if (null != (sm = System.getSecurityManager())) {
            sm.checkPermission(this.rp_getprotectiondomain);
        }
    }

    boolean okFragmentBundlePerm(BundleImpl b) {
        PermissionCollection pc = this.ph.getPermissionCollection(new Long(b.id));
        return pc.implies(new BundlePermission(b.symbolicName, "fragment"));
    }

    boolean okHostBundlePerm(BundleImpl b) {
        PermissionCollection pc = this.ph.getPermissionCollection(new Long(b.id));
        return pc.implies(new BundlePermission(b.symbolicName, "host"));
    }

    boolean okProvideBundlePerm(BundleImpl b) {
        PermissionCollection pc = this.ph.getPermissionCollection(new Long(b.id));
        return pc.implies(new BundlePermission(b.symbolicName, "provide"));
    }

    boolean okRequireBundlePerm(BundleImpl b) {
        PermissionCollection pc = this.ph.getPermissionCollection(new Long(b.id));
        return pc.implies(new BundlePermission(b.symbolicName, "require"));
    }

    boolean okAllPerm(BundleImpl b) {
        PermissionCollection pc = this.ph.getPermissionCollection(new Long(b.id));
        return pc.implies(new AllPermission());
    }

    boolean hasExportPackagePermission(ExportPkg ep) {
        BundleImpl b = ep.bpkgs.bundle;
        if (b.id != 0L) {
            PermissionCollection pc = this.ph.getPermissionCollection(new Long(b.id));
            return pc.implies(new PackagePermission(ep.name, "exportonly"));
        }
        return true;
    }

    boolean hasImportPackagePermission(BundleImpl b, ExportPkg ep) {
        if (b.id != 0L) {
            PermissionCollection pc = this.ph.getPermissionCollection(new Long(b.id));
            return pc.implies(new PackagePermission(ep.name, ep.bpkgs.bundle, "import"));
        }
        return true;
    }

    void checkRegisterServicePerm(String clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(new ServicePermission(clazz, "register"));
        }
    }

    void checkGetServicePerms(ServiceReference sr) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(new ServicePermission(sr, "get"));
        }
    }

    boolean okGetServicePerms(ServiceReference sr) {
        try {
            this.checkGetServicePerms(sr);
            return true;
        }
        catch (SecurityException ignore) {
            if (this.framework.debug.service_reference) {
                this.framework.debug.printStackTrace("No permission to get service ref: " + sr.getProperty("objectClass"), ignore);
            }
            return false;
        }
    }

    void filterGetServicePermission(Set srs) {
        Iterator i = srs.iterator();
        while (i.hasNext()) {
            ServiceRegistrationImpl sr = (ServiceRegistrationImpl)i.next();
            if (this.okGetServicePerms(sr.getReference())) continue;
            i.remove();
        }
    }

    BundleResourceStream callGetBundleResourceStream(final BundleArchive archive, final String name, final int ix) {
        return (BundleResourceStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return archive.getBundleResourceStream(name, ix);
            }
        });
    }

    Enumeration callFindResourcesPath(final BundleArchive archive, final String path) {
        return (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return archive.findResourcesPath(path);
            }
        });
    }

    Object callSearchFor(final BundleClassLoader cl, final String name, final String pkg, final String path, final BundleClassLoader.SearchAction action, final boolean onlyFirst, final BundleClassLoader requestor, final HashSet visited) {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cl.searchFor(name, pkg, path, action, onlyFirst, requestor, visited);
            }
        });
    }

    String callFindLibrary0(final BundleClassLoader cl, final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cl.findLibrary0(name);
            }
        });
    }

    void callFinalizeActivation(final BundleImpl b) throws BundleException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws BundleException {
                    b.finalizeActivation();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (BundleException)e.getException();
        }
    }

    BundleThread createBundleThread(final FrameworkContext fc) {
        return (BundleThread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new BundleThread(fc);
            }
        });
    }

    void callUpdate0(final BundleImpl b, final InputStream in, final boolean wasActive) throws BundleException {
        try {
            final AccessControlContext acc = AccessController.getContext();
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws BundleException {
                    b.update0(in, wasActive, acc);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (BundleException)e.getException();
        }
    }

    void callUninstall0(final BundleImpl b) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                b.uninstall0();
                return null;
            }
        });
    }

    void callSetAutostartSetting(final BundleImpl b, final int settings) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                b.setAutostartSetting0(settings);
                return null;
            }
        });
    }

    HeaderDictionary callGetHeaders0(final BundleImpl b, final String locale) {
        return (HeaderDictionary)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return b.getHeaders0(locale);
            }
        });
    }

    Enumeration callFindEntries0(final BundleImpl b, final String path, final String filePattern, final boolean recurse) {
        return (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return b.findEntries0(path, filePattern, recurse);
            }
        });
    }

    BundleClassLoader newBundleClassLoader(final BundlePackages bpkgs, final BundleArchive archive, final ArrayList fragments, final ProtectionDomain protectionDomain) throws BundleException {
        try {
            return (BundleClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new BundleClassLoader(bpkgs, archive, fragments, protectionDomain, SecurePermissionOps.this);
                }
            });
        }
        catch (PrivilegedActionException pe) {
            throw (BundleException)pe.getException();
        }
    }

    BundleImpl callInstall0(final Bundles bs, final String location, final InputStream in) throws BundleException {
        try {
            final AccessControlContext acc = AccessController.getContext();
            return (BundleImpl)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws BundleException {
                    return bs.install0(location, in, acc);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (BundleException)e.getException();
        }
    }

    void callBundleChanged(final FrameworkContext fwCtx, final BundleEvent evt) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                fwCtx.listeners.bundleChanged(evt);
                return null;
            }
        });
    }

    void callServiceChanged(final FrameworkContext fwCtx, final Collection receivers, final ServiceEvent evt, final Set matchBefore) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                fwCtx.listeners.serviceChanged(receivers, evt, matchBefore);
                return null;
            }
        });
    }

    void callRefreshPackages0(final PackageAdminImpl pa, final Bundle[] bundles) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                pa.refreshPackages0(bundles);
                return null;
            }
        });
    }

    Object callGetService(final ServiceFactory sf, final Bundle b, final ServiceRegistration sr) {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return sf.getService(b, sr);
            }
        });
    }

    void callUnregister0(final ServiceRegistrationImpl sr) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                sr.unregister0();
                return null;
            }
        });
    }

    void callSetStartLevel(final BundleImpl b, final int startlevel) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                b.setStartLevel(startlevel);
                return null;
            }
        });
    }

    void callShutdown(final SystemBundle sb, final boolean restart) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                sb.shutdown(restart);
                return null;
            }
        });
    }

    ProtectionDomain getProtectionDomain(BundleImpl b) {
        try {
            Certificate[] cca;
            URL bundleUrl = new URL("bundle", Long.toString(b.id) + "." + Long.toString(b.generation), -1, "", b.fwCtx.urlStreamHandlerFactory.createURLStreamHandler("bundle"));
            BundleResourceStream pis = b.archive.getBundleResourceStream("OSGI-INF/permissions.perm", 0);
            PermissionCollection pc = this.ph.createPermissionCollection(b.location, b, pis);
            ArrayList cc = b.archive.getCertificateChains(false);
            if (cc != null) {
                ArrayList tmp = new ArrayList();
                Iterator i = cc.iterator();
                while (i.hasNext()) {
                    tmp.addAll((List)i.next());
                }
                cca = tmp.toArray(new Certificate[tmp.size()]);
            } else {
                cca = null;
            }
            return new ProtectionDomain(new CodeSource(bundleUrl, cca), pc);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    URL getBundleURL(final FrameworkContext fwCtx, final String s) throws MalformedURLException {
        try {
            return (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MalformedURLException {
                    return new URL(null, s, fwCtx.urlStreamHandlerFactory.createURLStreamHandler("bundle"));
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (MalformedURLException)e.getException();
        }
    }

    ClassLoader getClassLoaderOf(final Class c) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return c.getClassLoader();
            }
        });
    }

    void purge(BundleImpl b, ProtectionDomain pd) {
        if (this.ph.purgePermissionCollection(new Long(b.id), pd.getPermissions())) {
            this.adminPerms.remove(b);
        }
    }

    AdminPermission getAdminPermission(Bundle b, int ti) {
        AdminPermission[] res = (AdminPermission[])this.adminPerms.get(b);
        if (res != null) {
            if (res[ti] != null) {
                return res[ti];
            }
        } else {
            res = new AdminPermission[8];
            this.adminPerms.put(b, res);
        }
        res[ti] = new AdminPermission(b, AP_TO_STRING[ti]);
        return res[ti];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

