/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Vector;

public class Queue
extends Vector {
    private int m_nMaxSize = -1;
    private boolean queueClosed = false;

    public Queue(int size) {
        this.m_nMaxSize = size;
    }

    public synchronized void insert(Object item) throws IndexOutOfBoundsException {
        if (this.m_nMaxSize > 0 && this.size() >= this.m_nMaxSize) {
            throw new IndexOutOfBoundsException("Queue full");
        }
        this.addElement(item);
        this.notify();
    }

    public synchronized void insertFirst(Object item) {
        this.insertElementAt(item, 0);
        this.notify();
    }

    public synchronized Object removeWait(float timeout) {
        Object obj = null;
        if (this.isEmpty() && !this.queueClosed) {
            try {
                if (timeout > 0.0f) {
                    this.wait(Math.round(timeout * 1000.0f));
                } else {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.queueClosed || this.isEmpty()) {
            return null;
        }
        obj = this.firstElement();
        this.removeElementAt(0);
        return obj;
    }

    public Object remove() {
        return this.removeWait(0.0f);
    }

    public synchronized void close() {
        this.queueClosed = true;
        this.notifyAll();
    }
}

