/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.ImportPkg;
import org.knopflerfish.framework.Util;

class Pkg {
    final String pkg;
    ArrayList exporters = new ArrayList(1);
    ArrayList importers = new ArrayList();
    ArrayList providers = new ArrayList(1);
    static final Util.Comparator epComp = new Util.Comparator(){

        public int compare(Object oa, Object ob) throws ClassCastException {
            ExportPkg a = (ExportPkg)oa;
            ExportPkg b = (ExportPkg)ob;
            int d = a.version.compareTo(b.version);
            if (d == 0) {
                long ld = b.bpkgs.bundle.id - a.bpkgs.bundle.id;
                if (ld < 0L) {
                    d = -1;
                } else if (ld > 0L) {
                    d = 1;
                }
            }
            return d;
        }
    };
    static final Util.Comparator ipComp = new Util.Comparator(){

        public int compare(Object oa, Object ob) throws ClassCastException {
            ImportPkg a = (ImportPkg)oa;
            ImportPkg b = (ImportPkg)ob;
            int d = a.packageRange.compareTo(b.packageRange);
            if (d == 0) {
                long ld = b.bpkgs.bundle.id - a.bpkgs.bundle.id;
                if (ld < 0L) {
                    d = -1;
                } else if (ld > 0L) {
                    d = 1;
                }
            }
            return d;
        }
    };

    Pkg(String pkg) {
        this.pkg = pkg;
    }

    synchronized void addExporter(ExportPkg ep) {
        int i = Math.abs(Util.binarySearch(this.exporters, epComp, ep) + 1);
        this.exporters.add(i, ep);
        ep.attachPkg(this);
    }

    synchronized boolean removeExporter(ExportPkg p) {
        ((AbstractCollection)this.providers).remove(p);
        ((AbstractCollection)this.exporters).remove(p);
        p.detachPkg();
        return true;
    }

    synchronized void addImporter(ImportPkg ip) {
        int i = Math.abs(Util.binarySearch(this.importers, ipComp, ip) + 1);
        this.importers.add(i, ip);
        ip.attachPkg(this);
    }

    synchronized void removeImporter(ImportPkg ip) {
        ((AbstractCollection)this.importers).remove(ip);
        ip.detachPkg();
    }

    synchronized void addProvider(ExportPkg ep) {
        int i = Util.binarySearch(this.providers, epComp, ep);
        if (i < 0) {
            this.providers.add(-i - 1, ep);
        }
    }

    synchronized ExportPkg getBestProvider() {
        if (!this.providers.isEmpty()) {
            return (ExportPkg)this.providers.get(0);
        }
        ExportPkg best = null;
        Iterator i = ((AbstractList)this.exporters).iterator();
        while (i.hasNext()) {
            ExportPkg ep = (ExportPkg)i.next();
            if ((ep.bpkgs.bundle.state & 0x3C) == 0 || best != null && best.version.compareTo(ep.version) >= 0) continue;
            best = ep;
        }
        return best;
    }

    synchronized boolean isEmpty() {
        return this.exporters.size() == 0 && this.importers.size() == 0;
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(int level) {
        StringBuffer sb = new StringBuffer();
        sb.append("Pkg[");
        if (level > 0) {
            sb.append("pkg=" + this.pkg);
        }
        if (level > 1) {
            sb.append(", providers=" + this.providers);
        }
        if (level > 2) {
            sb.append(", exporters=" + this.exporters);
        }
        sb.append("]");
        return sb.toString();
    }
}

