/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.knopflerfish.framework.BundleClassLoader;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.ExportedPackageImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Packages;
import org.knopflerfish.framework.Pkg;
import org.knopflerfish.framework.RequiredBundleImpl;
import org.knopflerfish.framework.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

public class PackageAdminImpl
implements PackageAdmin {
    static final String SPEC_VERSION = "1.2";
    private FrameworkContext fwCtx;
    private volatile Vector refreshSync = new Vector(1);

    PackageAdminImpl(FrameworkContext fw) {
        this.fwCtx = fw;
    }

    public ExportedPackage[] getExportedPackages(Bundle bundle) {
        int size;
        ArrayList<ExportedPackageImpl> pkgs = new ArrayList<ExportedPackageImpl>();
        if (bundle != null) {
            Iterator i = ((BundleImpl)bundle).getExports();
            while (i.hasNext()) {
                ExportPkg ep = (ExportPkg)i.next();
                if (!ep.isExported()) continue;
                pkgs.add(new ExportedPackageImpl(ep));
            }
        } else {
            Iterator bi = this.fwCtx.bundles.getBundles().iterator();
            while (bi.hasNext()) {
                Iterator i = ((BundleImpl)bi.next()).getExports();
                while (i.hasNext()) {
                    ExportPkg ep = (ExportPkg)i.next();
                    if (!ep.isExported()) continue;
                    pkgs.add(new ExportedPackageImpl(ep));
                }
            }
        }
        if ((size = pkgs.size()) > 0) {
            return pkgs.toArray(new ExportedPackage[size]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportedPackage[] getExportedPackages(String name) {
        Pkg pkg = this.fwCtx.packages.getPkg(name);
        ExportedPackage[] res = null;
        if (pkg != null) {
            Pkg pkg2 = pkg;
            synchronized (pkg2) {
                int size = pkg.exporters.size();
                if (size > 0) {
                    res = new ExportedPackage[size];
                    Iterator i = ((AbstractList)pkg.exporters).iterator();
                    int pos = 0;
                    while (pos < size) {
                        res[pos++] = new ExportedPackageImpl((ExportPkg)i.next());
                    }
                }
            }
        }
        return res;
    }

    public ExportedPackage getExportedPackage(String name) {
        ExportPkg ep;
        Pkg p = this.fwCtx.packages.getPkg(name);
        if (p != null && (ep = p.getBestProvider()) != null) {
            return new ExportedPackageImpl(ep);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshPackages(final Bundle[] bundles) {
        this.fwCtx.perm.checkResolveAdminPerm();
        boolean restart = false;
        if (bundles != null) {
            for (int i = 0; i < bundles.length; ++i) {
                if (bundles[i] == null) {
                    throw new NullPointerException("bundle[" + i + "] cannot be null");
                }
                this.fwCtx.checkOurBundle(bundles[i]);
                if (!((BundleImpl)bundles[i]).extensionNeedsRestart()) continue;
                restart = true;
                break;
            }
        } else {
            Iterator iter = this.fwCtx.bundles.getBundles().iterator();
            while (iter.hasNext()) {
                if (!((BundleImpl)iter.next()).extensionNeedsRestart()) continue;
                restart = true;
                break;
            }
        }
        if (restart) {
            try {
                this.fwCtx.systemBundle.update();
            }
            catch (BundleException ignored) {
                // empty catch block
            }
            return;
        }
        final PackageAdminImpl thisClass = this;
        Vector vector = this.refreshSync;
        synchronized (vector) {
            Thread t = new Thread(this.fwCtx.threadGroup, "RefreshPackages"){

                public void run() {
                    ((PackageAdminImpl)PackageAdminImpl.this).fwCtx.perm.callRefreshPackages0(thisClass, bundles);
                }
            };
            t.setDaemon(false);
            this.refreshSync.add(t);
            t.start();
            try {
                this.refreshSync.wait(500L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshPackages0(Bundle[] bundles) {
        if (this.fwCtx.debug.packages) {
            this.fwCtx.debug.println("PackageAdminImpl.refreshPackages() starting");
        }
        ArrayList<BundleImpl> startList = new ArrayList<BundleImpl>();
        Packages packages = this.fwCtx.packages;
        synchronized (packages) {
            TreeSet zombies = this.fwCtx.packages.getZombieAffected(bundles);
            BundleImpl[] bi = zombies.toArray(new BundleImpl[zombies.size()]);
            Vector vector = this.refreshSync;
            synchronized (vector) {
                this.refreshSync.notifyAll();
            }
            int bx = bi.length;
            while (bx-- > 0) {
                if (bi[bx].state != 32 && bi[bx].state != 8) continue;
                startList.add(0, bi[bx]);
                try {
                    bi[bx].waitOnOperation(this.fwCtx.packages, "PackageAdmin.refreshPackages", false);
                    Exception be = bi[bx].stop0();
                    if (be == null) continue;
                    this.fwCtx.listeners.frameworkError(bi[bx], (Throwable)be);
                }
                catch (BundleException ignore) {}
            }
            int startPos = startList.size() - 1;
            BundleImpl nextStart = startPos >= 0 ? (BundleImpl)startList.get(startPos) : null;
            int bx2 = bi.length;
            while (bx2-- > 0) {
                Exception be = null;
                switch (bi[bx2].state) {
                    case 8: 
                    case 32: {
                        while (true) {
                            try {
                                bi[bx2].waitOnOperation(this.fwCtx.packages, "PackageAdmin.refreshPackages", true);
                            }
                            catch (BundleException we) {
                                if (this.fwCtx.debug.packages) {
                                    this.fwCtx.debug.println("PackageAdminImpl.refreshPackages() timeout on bundle stop, retry...");
                                }
                                this.fwCtx.listeners.frameworkWarning(bi[bx2], we);
                                continue;
                            }
                            break;
                        }
                        be = bi[bx2].stop0();
                        if (be != null) {
                            this.fwCtx.listeners.frameworkError(bi[bx2], (Throwable)be);
                        }
                        if (nextStart != bi[bx2]) {
                            startList.add(startPos + 1, bi[bx2]);
                        }
                    }
                    case 4: 
                    case 16: {
                        bi[bx2].setStateInstalled(true);
                        if (bi[bx2] != nextStart) break;
                        nextStart = --startPos >= 0 ? (BundleImpl)startList.get(startPos) : null;
                    }
                }
                bi[bx2].purge();
            }
        }
        if (this.fwCtx.debug.packages) {
            this.fwCtx.debug.println("PackageAdminImpl.refreshPackages() all affected bundles now in state INSTALLED");
        }
        this.fwCtx.bundles.startBundles(startList);
        this.fwCtx.listeners.frameworkEvent(new FrameworkEvent(4, this.fwCtx.systemBundle, null));
        this.refreshSync.remove(Thread.currentThread());
        if (this.fwCtx.debug.packages) {
            this.fwCtx.debug.println("PackageAdminImpl.refreshPackages() done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resolveBundles(Bundle[] bundles) {
        this.fwCtx.perm.checkResolveAdminPerm();
        Packages packages = this.fwCtx.packages;
        synchronized (packages) {
            List<Bundle> bl;
            if (bundles != null) {
                bl = new ArrayList();
                for (int bx = 0; bx < bundles.length; ++bx) {
                    bl.add(bundles[bx]);
                }
            } else {
                bl = this.fwCtx.bundles.getBundles();
            }
            boolean res = true;
            Iterator i = bl.iterator();
            while (i.hasNext()) {
                BundleImpl b = (BundleImpl)i.next();
                if (b.getUpdatedState() != 2) continue;
                res = false;
            }
            return res;
        }
    }

    public RequiredBundle[] getRequiredBundles(String symbolicName) {
        ArrayList<RequiredBundleImpl> res = new ArrayList<RequiredBundleImpl>();
        List bs = symbolicName != null ? this.fwCtx.bundles.getBundles(symbolicName) : this.fwCtx.bundles.getBundles();
        Iterator i = bs.iterator();
        while (i.hasNext()) {
            BundleImpl b = (BundleImpl)i.next();
            if ((b.state & 0x3C) == 0 && b.getRequiredBy().size() <= 0 || b.isFragment()) continue;
            res.add(new RequiredBundleImpl(b.bpkgs));
        }
        int s = res.size();
        if (s > 0) {
            return res.toArray(new RequiredBundle[s]);
        }
        return null;
    }

    public Bundle[] getBundles(String symbolicName, String versionRange) {
        VersionRange vr = versionRange != null ? new VersionRange(versionRange.trim()) : VersionRange.defaultVersionRange;
        List bs = this.fwCtx.bundles.getBundles(symbolicName, vr);
        int size = bs.size();
        if (size > 0) {
            Bundle[] res = new Bundle[size];
            Iterator i = bs.iterator();
            int pos = 0;
            while (pos < size) {
                res[pos++] = (Bundle)i.next();
            }
            return res;
        }
        return null;
    }

    public Bundle[] getFragments(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        BundleImpl b = (BundleImpl)bundle;
        if (b.isFragment()) {
            return null;
        }
        if (b.isFragmentHost()) {
            return b.fragments.toArray(new Bundle[0]);
        }
        return null;
    }

    public Bundle[] getHosts(Bundle bundle) {
        BundleImpl b = (BundleImpl)bundle;
        if (b != null && b.isFragment() && b.isAttached()) {
            return b.fragment.hostsArray();
        }
        return null;
    }

    public Bundle getBundle(Class clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl instanceof BundleClassLoader) {
            return ((BundleClassLoader)cl).getBundle();
        }
        return null;
    }

    public int getBundleType(Bundle bundle) {
        BundleImpl b = (BundleImpl)bundle;
        if (b.isFragment() && !b.isExtension()) {
            return 1;
        }
        return 0;
    }
}

