/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.knopflerfish.framework.Alias;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.service.startlevel.StartLevel;

public class Main {
    static Main main;
    int verbosity;
    String version = "<unknown>";
    String topDir = "";
    boolean bZeroArgs;
    public String bootText;
    Map fwProps = new HashMap();
    Map sysProps = new HashMap();
    public static final String JARDIR_PROP = "org.knopflerfish.gosg.jars";
    public static final String JARDIR_DEFAULT = "file:";
    public static final String XARGS_INIT = "init.xargs";
    public static final String XARGS_RESTART = "restart.xargs";
    public static final String FWPROPS_XARGS = "fwprops.xargs";
    public static final String CMDIR_PROP = "org.knopflerfish.bundle.cm.store";
    public static final String CMDIR_DEFAULT = "cmdir";
    public static final String VERBOSITY_PROP = "org.knopflerfish.framework.main.verbosity";
    public static final String VERBOSITY_DEFAULT = "0";
    public static final String WRITE_FWPROPS_XARGS_PROP = "org.knopflerfish.framework.main.write.fwprops.xargs";
    public static final String XARGS_WRITESYSPROPS_PROP = "org.knopflerfish.framework.main.xargs.writesysprops";
    public static final String XARGS_DEFAULT = "default";
    public static final String PRODVERSION_PROP = "org.knopflerfish.prodver";
    Map defaultFwProps = new HashMap(){
        {
            this.put(Main.CMDIR_PROP, Main.CMDIR_DEFAULT);
        }
    };
    FrameworkFactory ff;
    Framework framework;
    static /* synthetic */ Class class$org$knopflerfish$framework$FrameworkFactoryImpl;
    static /* synthetic */ Class class$org$osgi$service$startlevel$StartLevel;

    public static void main(String[] args) {
        main = new Main();
        main.start(args);
        System.exit(0);
    }

    public Main() {
        try {
            String vpv = System.getProperty(VERBOSITY_PROP);
            this.verbosity = Integer.parseInt(null == vpv ? VERBOSITY_DEFAULT : vpv);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.populateSysProps();
    }

    protected void start(String[] args) {
        String xargsPath;
        this.version = Main.readVersion();
        this.bootText = "Knopflerfish OSGi framework, version " + this.version + "\n" + "Copyright 2003-2010 Knopflerfish. All Rights Reserved.\n\n" + "See http://www.knopflerfish.org for more information.";
        System.out.println(this.bootText);
        boolean bl = this.bZeroArgs = args.length == 0;
        if (!this.bZeroArgs) {
            this.bZeroArgs = true;
            for (int i = 0; this.bZeroArgs && i < args.length; ++i) {
                this.bZeroArgs = args[i].startsWith("-D") || args[i].startsWith("-F") || "-init".equals(args[i]);
            }
        }
        this.processProperties(args);
        if (this.bZeroArgs && (xargsPath = this.getDefaultXArgs()) != null) {
            if (0 == args.length) {
                args = new String[]{"-xargs", xargsPath};
            } else {
                String[] newArgs = new String[args.length + 2];
                newArgs[0] = "-xargs";
                newArgs[1] = xargsPath;
                System.arraycopy(args, 0, newArgs, 2, args.length);
                args = newArgs;
            }
        }
        args = this.expandArgs(args);
        this.handleArgs(args);
    }

    private boolean writeSysProps() {
        try {
            String val = (String)this.sysProps.get(XARGS_WRITESYSPROPS_PROP);
            return "true".equals(null != val ? val : "false");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public FrameworkFactory getFrameworkFactory() {
        try {
            String factoryS = new String(Util.readResource("/META-INF/services/org.osgi.framework.launch.FrameworkFactory"), "UTF-8");
            String factoryClassName = (class$org$knopflerfish$framework$FrameworkFactoryImpl == null ? (class$org$knopflerfish$framework$FrameworkFactoryImpl = Main.class$("org.knopflerfish.framework.FrameworkFactoryImpl")) : class$org$knopflerfish$framework$FrameworkFactoryImpl).getName();
            String[] w = Util.splitwords(factoryS, "\n\r");
            for (int i = 0; i < w.length; ++i) {
                if (w[i].length() <= 0 || w[i].startsWith("#")) continue;
                factoryClassName = w[i].trim();
                break;
            }
            return this.getFrameworkFactory(factoryClassName);
        }
        catch (Exception e) {
            this.error("failed to getFrameworkFactory", e);
            throw new RuntimeException("failed to getFrameworkFactory: " + e);
        }
    }

    public FrameworkFactory getFrameworkFactory(String factoryClassName) {
        try {
            this.println("getFrameworkFactory(" + factoryClassName + ")", 2);
            Class<?> clazz = Class.forName(factoryClassName);
            Constructor<?> cons = clazz.getConstructor(new Class[0]);
            FrameworkFactory ff = (FrameworkFactory)cons.newInstance(new Object[0]);
            return ff;
        }
        catch (Exception e) {
            this.error("failed to create " + factoryClassName, e);
            throw new RuntimeException("failed to create " + factoryClassName + ": " + e);
        }
    }

    String[] getJarBase() {
        this.assertFramework();
        String jars = this.framework.getBundleContext().getProperty(JARDIR_PROP);
        if (jars == null) {
            jars = JARDIR_DEFAULT;
        }
        String[] base = Util.splitwords(jars, ";");
        for (int i = 0; i < base.length; ++i) {
            try {
                base[i] = new URL(base[i]).toString();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            this.println("jar base[" + i + "]=" + base[i], 3);
        }
        return base;
    }

    void setProperty(String prefix, String arg, Map props) {
        int ix = arg.indexOf("=");
        if (ix != -1) {
            String key = arg.substring(2, ix);
            String value = arg.substring(ix + 1);
            this.println(prefix + key + "=" + value, 1);
            props.put(key, value);
            if (VERBOSITY_PROP.equals(key)) {
                try {
                    int old = this.verbosity;
                    this.verbosity = Integer.parseInt(value.length() == 0 ? VERBOSITY_DEFAULT : value);
                    if (old != this.verbosity) {
                        this.println("Verbosity changed to " + this.verbosity, 1);
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
    }

    void processProperties(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            try {
                if (args[i].startsWith("-D")) {
                    this.setProperty("-D", args[i], this.sysProps);
                    continue;
                }
                if (args[i].startsWith("-F")) {
                    this.setProperty("-F", args[i], this.fwProps);
                    continue;
                }
                if (!"-init".equals(args[i])) continue;
                this.fwProps.put("org.osgi.framework.storage.clean", "onFirstInit");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                this.error("Command \"" + args[i] + "\" failed, " + e.getMessage());
            }
        }
    }

    private void save_restart_props(Map props) {
        String xrwp = this.framework.getBundleContext().getProperty(WRITE_FWPROPS_XARGS_PROP);
        if ("false".equalsIgnoreCase(xrwp)) {
            return;
        }
        PrintWriter pr = null;
        try {
            String fwDirStr = Util.getFrameworkDir(props);
            File fwDir = new File(fwDirStr);
            fwDir.mkdirs();
            File propsFile = new File(fwDir, FWPROPS_XARGS);
            pr = new PrintWriter(new BufferedWriter(new FileWriter(propsFile)));
            Iterator it = props.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if ("org.osgi.framework.storage.clean".equals(key) && "onFirstInit".equals(value)) continue;
                pr.println("-F" + key + "=" + value);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalArgumentException("Failed to create fwprops.xargs: " + e);
        }
        finally {
            if (null != pr) {
                pr.close();
            }
        }
    }

    void assertFramework() {
        if (this.ff == null) {
            this.ff = this.getFrameworkFactory();
            this.println("Created FrameworkFactory " + this.ff.getClass().getName(), 1);
        }
        if (this.framework == null) {
            this.finalizeProperties();
            this.framework = this.ff.newFramework(this.fwProps);
            try {
                this.framework.init();
                this.save_restart_props(this.fwProps);
            }
            catch (BundleException be) {
                this.error("Failed to initialize the framework: " + be.getMessage(), be);
            }
            this.println("Created Framework " + this.framework.getClass().getName(), 1);
        }
    }

    private void handleArgs(String[] args) {
        File propsFile;
        boolean bLaunched = false;
        if (!"onFirstInit".equals((String)this.fwProps.get("org.osgi.framework.storage.clean")) && (propsFile = new File(Util.getFrameworkDir(this.fwProps), FWPROPS_XARGS)).exists()) {
            String[] newArgs = new String[args.length + 2];
            newArgs[0] = "-xargs";
            newArgs[1] = propsFile.getAbsolutePath();
            System.arraycopy(args, 0, newArgs, 2, args.length);
            args = this.expandArgs(newArgs);
        }
        this.processProperties(args);
        if (this.verbosity > 5) {
            for (int i = 0; i < args.length; ++i) {
                this.println("argv[" + i + "]=" + args[i], 5);
            }
        }
        for (int i = 0; i < args.length; ++i) {
            try {
                StartLevel ss;
                Bundle b;
                String bundle;
                if ("-exit".equals(args[i])) {
                    this.println("Exit.", 0);
                    System.exit(0);
                    continue;
                }
                if (args[i].startsWith("-F") || args[i].startsWith("-D") || "-init".equals(args[i])) continue;
                if ("-version".equals(args[i])) {
                    System.out.println("Knopflerfish version: " + Main.readRelease());
                    this.printResource("/tstamp");
                    this.printResource("/revision");
                    System.exit(0);
                    continue;
                }
                if ("-help".equals(args[i])) {
                    this.printResource("/help.txt");
                    System.exit(0);
                    continue;
                }
                if ("-jvminfo".equals(args[i])) {
                    this.assertFramework();
                    this.printJVMInfo(this.framework);
                    System.exit(0);
                    continue;
                }
                if ("-ff".equals(args[i])) {
                    if (null != this.framework) {
                        throw new IllegalArgumentException("a framework instance is already created.");
                    }
                    if (i + 1 < args.length) {
                        this.ff = this.getFrameworkFactory(args[++i]);
                        continue;
                    }
                    throw new IllegalArgumentException("No framework factory argument");
                }
                if ("-create".equals(args[i])) {
                    if (null != this.framework && (4 & this.framework.getState()) == 0) {
                        throw new IllegalArgumentException("a framework instance is already created. The '-create' command must either be the first command or come directly after a '-shutdown mSEC' command.");
                    }
                    this.framework = null;
                    continue;
                }
                if ("-install".equals(args[i])) {
                    this.assertFramework();
                    if (i + 1 < args.length) {
                        bundle = args[i + 1];
                        Bundle b2 = this.framework.getBundleContext().installBundle(this.completeLocation(bundle), null);
                        this.println("Installed: ", b2);
                        ++i;
                        continue;
                    }
                    this.error("No URL for install command");
                    continue;
                }
                if ("-istart".equals(args[i])) {
                    this.assertFramework();
                    if (i + 1 < args.length) {
                        bundle = args[i + 1];
                        Bundle b3 = this.framework.getBundleContext().installBundle(this.completeLocation(bundle), null);
                        b3.start(2);
                        this.println("Installed and started (policy): ", b3);
                        ++i;
                        continue;
                    }
                    this.error("No URL for install command");
                    continue;
                }
                if ("-launch".equals(args[i])) {
                    if (null != this.framework && (0x20 & this.framework.getState()) != 0) {
                        throw new IllegalArgumentException("a framework instance is already active.");
                    }
                    this.assertFramework();
                    this.framework.start();
                    bLaunched = true;
                    this.closeSplash();
                    this.println("Framework launched", 0);
                    continue;
                }
                if ("-shutdown".equals(args[i])) {
                    if (i + 1 < args.length) {
                        long timeout = Long.parseLong(args[++i]);
                        try {
                            if (this.framework != null) {
                                this.framework.stop();
                                FrameworkEvent stopEvent = this.framework.waitForStop(timeout);
                                switch (stopEvent.getType()) {
                                    case 64: {
                                        this.println("Framework terminated", 0);
                                        break;
                                    }
                                    case 128: {
                                        this.println("Framework stopped for update", 0);
                                        break;
                                    }
                                    case 256: {
                                        this.println("Framework stopped for bootclasspath update", 0);
                                        break;
                                    }
                                    case 2: {
                                        this.error("Fatal framework error, terminating.", stopEvent.getThrowable());
                                        break;
                                    }
                                    case 512: {
                                        this.error("Framework waitForStop(" + timeout + ") timed out!", stopEvent.getThrowable());
                                    }
                                }
                            } else {
                                throw new IllegalArgumentException("No framework to shutdown");
                            }
                            this.println("Framework shutdown", 0);
                        }
                        catch (Exception e) {
                            this.error("Failed to shutdown", e);
                        }
                        continue;
                    }
                    this.error("No timout for shutdown command");
                    continue;
                }
                if ("-sleep".equals(args[i])) {
                    if (i + 1 < args.length) {
                        long t = Long.parseLong(args[i + 1]);
                        try {
                            this.println("Sleeping " + t + " seconds...", 0);
                            Thread.sleep(t * 1000L);
                        }
                        catch (InterruptedException e) {
                            this.error("Sleep interrupted.");
                        }
                        ++i;
                        continue;
                    }
                    this.error("No time for sleep command");
                    continue;
                }
                if ("-start".equals(args[i])) {
                    this.assertFramework();
                    if (i + 1 < args.length) {
                        long id = this.getBundleID(this.framework, args[i + 1]);
                        b = this.framework.getBundleContext().getBundle(id);
                        b.start(2);
                        this.println("Started (policy): ", b);
                        ++i;
                        continue;
                    }
                    this.error("No ID for start command");
                    continue;
                }
                if ("-start_e".equals(args[i])) {
                    this.assertFramework();
                    if (i + 1 < args.length) {
                        long id = this.getBundleID(this.framework, args[i + 1]);
                        b = this.framework.getBundleContext().getBundle(id);
                        b.start(0);
                        this.println("Started (eager): ", b);
                        ++i;
                        continue;
                    }
                    this.error("No ID for start_e command");
                    continue;
                }
                if ("-start_et".equals(args[i])) {
                    this.assertFramework();
                    if (i + 1 < args.length) {
                        long id = this.getBundleID(this.framework, args[i + 1]);
                        b = this.framework.getBundleContext().getBundle(id);
                        b.start(1);
                        this.println("Started (eager,transient): ", b);
                        ++i;
                        continue;
                    }
                    this.error("No ID for start_et command");
                    continue;
                }
                if ("-start_pt".equals(args[i])) {
                    this.assertFramework();
                    if (i + 1 < args.length) {
                        long id = this.getBundleID(this.framework, args[i + 1]);
                        b = this.framework.getBundleContext().getBundle(id);
                        b.start(3);
                        this.println("Start (policy,transient): ", b);
                        ++i;
                        continue;
                    }
                    this.error("No ID for start_pt command");
                    continue;
                }
                if ("-stop".equals(args[i])) {
                    this.assertFramework();
                    if (i + 1 < args.length) {
                        long id = this.getBundleID(this.framework, args[i + 1]);
                        b = this.framework.getBundleContext().getBundle(id);
                        try {
                            b.stop(0);
                            this.println("Stopped: ", b);
                        }
                        catch (Exception e) {
                            this.error("Failed to stop", e);
                        }
                        ++i;
                        continue;
                    }
                    this.error("No ID for stop command");
                    continue;
                }
                if ("-stop_t".equals(args[i])) {
                    this.assertFramework();
                    if (i + 1 < args.length) {
                        long id = this.getBundleID(this.framework, args[i + 1]);
                        b = this.framework.getBundleContext().getBundle(id);
                        try {
                            b.stop(1);
                            this.println("Stopped (transient): ", b);
                        }
                        catch (Exception e) {
                            this.error("Failed to stop", e);
                        }
                        ++i;
                        continue;
                    }
                    this.error("No ID for stop_t command");
                    continue;
                }
                if ("-uninstall".equals(args[i])) {
                    this.assertFramework();
                    if (i + 1 < args.length) {
                        long id = this.getBundleID(this.framework, args[i + 1]);
                        b = this.framework.getBundleContext().getBundle(id);
                        b.uninstall();
                        this.println("Uninstalled: ", b);
                        ++i;
                        continue;
                    }
                    this.error("No id for uninstall command");
                    continue;
                }
                if ("-update".equals(args[i])) {
                    this.assertFramework();
                    if (i + 1 < args.length) {
                        Bundle[] bl = null;
                        bl = "ALL".equals(args[i + 1]) ? this.framework.getBundleContext().getBundles() : new Bundle[]{this.framework.getBundleContext().getBundle(this.getBundleID(this.framework, args[i + 1]))};
                        for (int n = 0; bl != null && n < bl.length; ++n) {
                            b = bl[i];
                            b.update();
                            this.println("Updated: ", b);
                        }
                        ++i;
                        continue;
                    }
                    this.error("No id for update command");
                    continue;
                }
                if ("-initlevel".equals(args[i])) {
                    this.assertFramework();
                    if (i + 1 < args.length) {
                        int n = Integer.parseInt(args[i + 1]);
                        ServiceReference sr = this.framework.getBundleContext().getServiceReference((class$org$osgi$service$startlevel$StartLevel == null ? Main.class$("org.osgi.service.startlevel.StartLevel") : class$org$osgi$service$startlevel$StartLevel).getName());
                        if (sr != null) {
                            ss = (StartLevel)this.framework.getBundleContext().getService(sr);
                            ss.setInitialBundleStartLevel(n);
                            this.framework.getBundleContext().ungetService(sr);
                        } else {
                            this.println("No start level service - ignoring init bundle level " + n, 0);
                        }
                        ++i;
                        continue;
                    }
                    this.error("No integer level for initlevel command");
                    continue;
                }
                if ("-startlevel".equals(args[i])) {
                    this.assertFramework();
                    if (i + 1 < args.length) {
                        int n = Integer.parseInt(args[i + 1]);
                        ServiceReference sr = this.framework.getBundleContext().getServiceReference((class$org$osgi$service$startlevel$StartLevel == null ? Main.class$("org.osgi.service.startlevel.StartLevel") : class$org$osgi$service$startlevel$StartLevel).getName());
                        if (sr != null) {
                            ss = (StartLevel)this.framework.getBundleContext().getService(sr);
                            ss.setStartLevel(n);
                            this.framework.getBundleContext().ungetService(sr);
                        } else {
                            this.println("No start level service - ignoring start level " + n, 0);
                        }
                        ++i;
                        continue;
                    }
                    this.error("No integer level for startlevel command");
                    continue;
                }
                this.error("Unknown option: " + args[i] + "\nUse option -help to see all options");
                continue;
            }
            catch (BundleException e) {
                Throwable ne = e.getNestedException();
                if (ne != null) {
                    e.getNestedException().printStackTrace(System.err);
                } else {
                    e.printStackTrace(System.err);
                }
                this.error("Command \"" + args[i] + (i + 1 < args.length && !args[i + 1].startsWith("-") ? " " + args[i + 1] : "") + "\" failed, " + e.getMessage());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                this.error("Command \"" + args[i] + (i + 1 < args.length && !args[i + 1].startsWith("-") ? " " + args[i + 1] : "") + "\" failed, " + e.getMessage());
            }
        }
        this.assertFramework();
        if (!bLaunched) {
            try {
                this.framework.start();
                this.closeSplash();
                this.println("Framework launched", 0);
            }
            catch (Throwable t) {
                BundleException be;
                Throwable ne;
                if (t instanceof BundleException && (ne = (be = (BundleException)t).getNestedException()) != null) {
                    t = ne;
                }
                this.error("Framework launch failed, " + t.getMessage(), t);
            }
        }
        FrameworkEvent stopEvent = null;
        while (true) {
            try {
                while (true) {
                    stopEvent = this.framework.waitForStop(0L);
                    switch (stopEvent.getType()) {
                        case 64: {
                            this.println("Framework terminated", 0);
                            return;
                        }
                        case 128: {
                            break;
                        }
                        case 256: {
                            return;
                        }
                        case 2: {
                            this.error("Fatal framework error, terminating.", stopEvent.getThrowable());
                            return;
                        }
                        case 512: {
                            this.error("Framework waitForStop(0) timed out!", stopEvent.getThrowable());
                        }
                    }
                }
            }
            catch (InterruptedException ie) {
                continue;
            }
            break;
        }
    }

    private long getBundleID(Framework fw, String idLocation) {
        try {
            return Long.parseLong(idLocation);
        }
        catch (NumberFormatException nfe) {
            Bundle[] bl = fw.getBundleContext().getBundles();
            String loc = this.completeLocation(idLocation);
            for (int i = 0; bl != null && i < bl.length; ++i) {
                if (!loc.equals(bl[i].getLocation())) continue;
                return bl[i].getBundleId();
            }
            throw new IllegalArgumentException("Invalid bundle id/location: " + idLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String completeLocation(String location) {
        int ic;
        String[] base = this.getJarBase();
        if (location.startsWith("file:jars/") && !this.topDir.equals("")) {
            location = (JARDIR_DEFAULT + this.topDir + location.substring(5)).replace('\\', '/');
            this.println("mangled bundle location to " + location, 2);
        }
        if ((ic = location.indexOf(":")) < 2 || ic > location.indexOf("/")) {
            this.println("location=" + location, 2);
            for (int i = 0; i < base.length; ++i) {
                this.println("base[" + i + "]=" + base[i], 2);
                try {
                    URL url = new URL(new URL(base[i]), location);
                    this.println("check " + url, 2);
                    if ("file".equals(url.getProtocol())) {
                        File f = new File(url.getFile()).getAbsoluteFile();
                        if (!f.exists() || !f.canRead()) {
                            continue;
                        }
                    } else if ("http".equals(url.getProtocol())) {
                        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
                        uc.connect();
                        int rc = uc.getResponseCode();
                        uc.disconnect();
                        if (rc != 200) {
                            this.println("Can't access HTTP bundle: " + url + ", response code=" + rc, 0);
                            continue;
                        }
                    } else {
                        InputStream is = null;
                        try {
                            is = url.openStream();
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                        }
                    }
                    location = url.toString();
                    this.println("found location=" + location, 5);
                    break;
                }
                catch (Exception _e) {
                    // empty catch block
                }
            }
        }
        return location;
    }

    String[] expandArgs(String[] argv) {
        ArrayList<String> v = new ArrayList<String>();
        for (int i = 0; i < argv.length; ++i) {
            if ("-xargs".equals(argv[i]) || "--xargs".equals(argv[i])) {
                boolean bIgnoreException = argv[i].equals("--xargs");
                if (i + 1 < argv.length) {
                    String xargsPath = argv[i + 1];
                    ++i;
                    try {
                        String[] moreArgs = this.loadArgs(xargsPath, argv);
                        String[] r = this.expandArgs(moreArgs);
                        for (int j = 0; j < r.length; ++j) {
                            v.add(r[j]);
                        }
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (bIgnoreException) {
                            this.println("Failed to load -xargs " + xargsPath, 1, e);
                            continue;
                        }
                        throw e;
                    }
                }
                throw new IllegalArgumentException("-xargs without argument");
            }
            v.add(argv[i]);
        }
        String[] r = new String[v.size()];
        v.toArray(r);
        return r;
    }

    void printResource(String name) {
        try {
            System.out.println(new String(Util.readResource(name)));
        }
        catch (Exception e) {
            System.out.println("No resource '" + name + "' available");
        }
    }

    void printJVMInfo(Framework framework) {
        try {
            Properties props = System.getProperties();
            System.out.println("--- System properties ---");
            Enumeration e = ((Hashtable)props).keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                System.out.println(key + ": " + ((Hashtable)props).get(key));
            }
            System.out.println("\n");
            System.out.println("--- Framework properties ---");
            String keyStr = framework.getBundleContext().getProperty("org.knopflerfish.framework.bundleprops.keys");
            String[] keys = Util.splitwords(keyStr != null ? keyStr : "", ",");
            for (int i = 0; i < keys.length; ++i) {
                System.out.println(keys[i] + ": " + framework.getBundleContext().getProperty(keys[i]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static String readVersion() {
        return Main.readResource("/version", "<no version found>", "UTF-8");
    }

    static String readRelease() {
        return Main.readResource("/release", "0.0.0.snapshot", "UTF-8");
    }

    static String readResource(String file, String defaultValue, String encoding) {
        try {
            return new String(Util.readResource(file), encoding).trim();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    String getDefaultXArgs() {
        String[] stringArray;
        File[] fileArray;
        boolean bInit = "onFirstInit".equals((String)this.fwProps.get("org.osgi.framework.storage.clean"));
        String fwDirStr = Util.getFrameworkDir(this.fwProps);
        File fwDir = new File(new File(fwDirStr).getAbsolutePath());
        this.println("fwdir is " + fwDir, 1);
        if (!bInit) {
            boolean bl = bInit = !fwDir.exists() || !fwDir.isDirectory();
            if (bInit) {
                this.println("Implicit -init since fwdir does not exist.", 2);
            }
        }
        this.println("init is " + bInit, 2);
        String defDirStr = fwDir.getParent();
        File defDir = defDirStr != null ? new File(defDirStr) : null;
        File cwDir = new File(new File("").getAbsolutePath());
        this.println("defDir=" + defDir, 5);
        this.println("cwDir=" + cwDir, 5);
        if (null != defDir) {
            File[] fileArray2 = new File[3];
            fileArray2[0] = fwDir;
            fileArray2[1] = defDir;
            fileArray = fileArray2;
            fileArray2[2] = cwDir;
        } else {
            File[] fileArray3 = new File[2];
            fileArray3[0] = fwDir;
            fileArray = fileArray3;
            fileArray3[1] = cwDir;
        }
        File[] dirs = fileArray;
        for (int i = 0; i < dirs.length; ++i) {
            File jarsDir = new File(dirs[i], "jars");
            if (!jarsDir.exists() || !jarsDir.isDirectory()) continue;
            this.topDir = dirs[i].getAbsolutePath();
            break;
        }
        this.println("Knopflerfish root directory is " + this.topDir, 2);
        String osName = Alias.unifyOsName(System.getProperty("os.name"));
        if (bInit) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "init_" + osName + ".xargs";
            stringArray2[1] = XARGS_INIT;
            stringArray = stringArray2;
            stringArray2[2] = "remote-init.xargs";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = XARGS_RESTART;
        }
        String[] xargNames = stringArray;
        String xargsFound = null;
        this.println("Searching for default xargs file:", 5);
        block1: for (int i = 0; i < dirs.length; ++i) {
            for (int k = 0; k < xargNames.length; ++k) {
                File xargsFile = new File(dirs[i], xargNames[k]);
                this.println("  trying " + xargsFile.getAbsolutePath(), 5);
                if (!xargsFile.exists()) continue;
                xargsFound = xargsFile.getAbsolutePath();
                break block1;
            }
        }
        this.println("default xargs file is " + xargsFound, 2);
        return xargsFound;
    }

    protected void addDefaultProps() {
        String jars;
        Iterator it = this.defaultFwProps.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            if (!this.fwProps.containsKey(key)) {
                String val = (String)entry.getValue();
                this.println("Using default " + key + "=" + val, 1);
                this.fwProps.put(key, val);
                continue;
            }
            this.println("framework prop " + key + "=" + this.fwProps.get(key), 1);
        }
        if (null == this.fwProps.get(PRODVERSION_PROP)) {
            this.fwProps.put(PRODVERSION_PROP, this.version);
        }
        if ((jars = (String)this.sysProps.get(JARDIR_PROP)) != null && !"".equals(jars)) {
            this.println("old jars=" + jars, 1);
        } else {
            String jarBaseDir = this.topDir + "jars";
            this.println("jarBaseDir=" + jarBaseDir, 2);
            File jarDir = new File(new File(jarBaseDir).getAbsolutePath());
            if (jarDir.exists() && jarDir.isDirectory()) {
                String[] names = jarDir.list();
                ArrayList<String> v = new ArrayList<String>();
                for (int i = 0; i < names.length; ++i) {
                    File f = new File(jarDir, names[i]);
                    if (!f.isDirectory()) continue;
                    v.add(names[i]);
                }
                String[] subdirs = new String[v.size()];
                v.toArray(subdirs);
                StringBuffer sb = new StringBuffer();
                sb.append(JARDIR_DEFAULT + jarBaseDir + "/");
                for (int i = 0; i < subdirs.length; ++i) {
                    sb.append(";file:" + jarBaseDir + "/" + subdirs[i] + "/");
                }
                jars = sb.toString().replace('\\', '/');
                this.sysProps.put(JARDIR_PROP, jars);
                this.println("scanned org.knopflerfish.gosg.jars=" + jars, 2);
            }
        }
    }

    void populateSysProps() {
        Properties systemProperties = System.getProperties();
        Enumeration<?> systemPropertiesNames = systemProperties.propertyNames();
        while (systemPropertiesNames.hasMoreElements()) {
            try {
                String name = (String)systemPropertiesNames.nextElement();
                String value = systemProperties.getProperty(name);
                this.sysProps.put(name, value);
                this.println("Initial system property: " + name + "=" + value, 3);
            }
            catch (Exception e) {
                this.println("Failed to process system property: " + e, 1, e);
            }
        }
    }

    void mergeSystemProperties(Map props) {
        Properties p = System.getProperties();
        ((Hashtable)p).putAll(props);
        System.setProperties(p);
    }

    void finalizeProperties() {
        this.expandPropValues(this.sysProps, null);
        this.expandPropValues(this.fwProps, this.sysProps);
        this.addDefaultProps();
        this.mergeSystemProperties(this.sysProps);
        if (this.writeSysProps()) {
            this.mergeSystemProperties(this.fwProps);
        }
    }

    void expandPropValues(Map toExpand, Map fallback) {
        HashMap all = null;
        Iterator eit = toExpand.entrySet().iterator();
        while (eit.hasNext()) {
            Map.Entry entry = eit.next();
            String value = (String)entry.getValue();
            if (-1 == value.indexOf("${")) continue;
            if (null == all) {
                all = new HashMap();
                if (null != fallback) {
                    all.putAll(fallback);
                }
                all.putAll(toExpand);
            }
            Iterator it = all.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry allEntry = it.next();
                String rk = "${" + (String)allEntry.getKey() + "}";
                String rv = (String)allEntry.getValue();
                value = Util.replace(value, rk, rv);
            }
            entry.setValue(value);
            this.println("Expanded property: " + entry.getKey() + "=" + value, 1);
        }
    }

    private void addArg(List args, String arg) {
        if (0 == args.size()) {
            args.add(arg);
        } else {
            String lastArg = (String)args.get(args.size() - 1);
            if ("-xargs".equals(lastArg) || "--xargs".equals(lastArg)) {
                String[] exArgs = this.expandArgs(new String[]{lastArg, arg});
                args.remove(args.size() - 1);
                for (int i = 0; i < exArgs.length; ++i) {
                    args.add(exArgs[i]);
                }
            } else {
                args.add(arg);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String[] loadArgs(String xargsPath, String[] oldArgs) {
        ArrayList v;
        block25: {
            if (XARGS_DEFAULT.equals(xargsPath)) {
                this.processProperties(oldArgs);
                xargsPath = this.getDefaultXArgs();
            }
            v = new ArrayList();
            BufferedReader in = null;
            try {
                try {
                    File f;
                    File defDir;
                    this.println("Searching for xargs file with '" + xargsPath + "'.", 2);
                    String fwDirStr = Util.getFrameworkDir(this.fwProps);
                    File fwDir = new File(new File(fwDirStr).getAbsolutePath());
                    String defDirStr = fwDir.getParent();
                    File file = defDir = defDirStr != null ? new File(defDirStr) : null;
                    if (null != defDir) {
                        f = new File(new File(defDir, xargsPath).getAbsolutePath());
                        this.println(" trying " + f, 5);
                        if (f.exists()) {
                            this.println("Loading xargs file " + f, 1);
                            in = new BufferedReader(new FileReader(f));
                        }
                    }
                    if (null == in) {
                        f = new File(new File(xargsPath).getAbsolutePath());
                        this.println(" trying " + f, 5);
                        if (f.exists()) {
                            this.println("Loading xargs file " + f, 1);
                            in = new BufferedReader(new FileReader(f));
                        }
                    }
                    if (in == null) {
                        try {
                            this.println(" trying URL " + xargsPath, 5);
                            URL url = new URL(xargsPath);
                            this.println("Loading xargs url " + url, 0);
                            in = new BufferedReader(new InputStreamReader(url.openStream()));
                        }
                        catch (MalformedURLException e) {
                            throw new IllegalArgumentException("Bad xargs URL " + xargsPath + ": " + e);
                        }
                    }
                    StringBuffer contLine = new StringBuffer();
                    String line = null;
                    String tmpline = null;
                    int lineno = 0;
                    tmpline = in.readLine();
                    while (tmpline != null) {
                        block24: {
                            block30: {
                                block29: {
                                    block28: {
                                        block27: {
                                            ++lineno;
                                            if (!(tmpline = tmpline.trim()).endsWith("\\")) break block27;
                                            tmpline = tmpline.substring(0, tmpline.length() - 1);
                                            if (contLine == null) {
                                                contLine = new StringBuffer(tmpline);
                                                break block24;
                                            } else {
                                                contLine.append(tmpline);
                                            }
                                            break block24;
                                        }
                                        if (contLine != null) {
                                            contLine.append(tmpline);
                                            line = contLine.toString();
                                            contLine = null;
                                        } else {
                                            line = tmpline;
                                        }
                                        if (!line.startsWith("-D")) break block28;
                                        this.addArg(v, line);
                                        break block24;
                                    }
                                    if (!line.startsWith("-F")) break block29;
                                    this.addArg(v, line);
                                    break block24;
                                }
                                if (line.startsWith("#")) break block24;
                                if (!line.startsWith("-")) break block30;
                                int i = line.indexOf(32);
                                if (i != -1) {
                                    this.addArg(v, line.substring(0, i));
                                    line = line.substring(i).trim();
                                    if (line.length() > 0) {
                                        this.addArg(v, line);
                                    }
                                    break block24;
                                } else {
                                    this.addArg(v, line);
                                }
                                break block24;
                            }
                            if (line.length() > 0) {
                                this.addArg(v, line);
                            }
                        }
                        tmpline = in.readLine();
                    }
                    Object var15_16 = null;
                    if (null == in) break block25;
                }
                catch (Exception e) {
                    if (!(e instanceof RuntimeException)) throw new IllegalArgumentException("xargs loading failed: " + e);
                    throw (RuntimeException)e;
                }
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                if (null == in) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ignore) {}
            in.close();
        }
        String[] args2 = new String[v.size()];
        v.toArray(args2);
        return args2;
    }

    void closeSplash() {
        try {
            Class<?> splashScreenCls = Class.forName("java.awt.SplashScreen");
            Method getSplashScreenMethod = splashScreenCls.getMethod("getSplashScreen", null);
            Object splashScreen = getSplashScreenMethod.invoke(null, null);
            if (null != splashScreen) {
                Method closeMethod = splashScreenCls.getMethod("close", null);
                closeMethod.invoke(splashScreen, null);
            }
        }
        catch (Exception e) {
            this.println("close splash screen: ", 6, e);
        }
    }

    void println(String s, int level) {
        this.println(s, level, null);
    }

    void println(String s, Bundle b) {
        this.println(s + b.getLocation() + " (id#" + b.getBundleId() + ")", 1);
    }

    void println(String s, int level, Exception e) {
        if (this.verbosity >= level) {
            System.out.println((level > 0 ? "#" + level + ": " : "") + s);
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    void error(String s) {
        this.error(s, null);
    }

    void error(String s, Throwable t) {
        System.err.println("Error: " + s);
        if (t != null) {
            t.printStackTrace();
        }
        System.exit(1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

