/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.knopflerfish.framework.BundleContextImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.ServiceListenerEntry;
import org.knopflerfish.framework.ServiceReferenceImpl;
import org.knopflerfish.framework.ServiceRegistrationImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

class Hooks {
    private final FrameworkContext fwCtx;
    ServiceTracker listenerHookTracker;
    boolean bOpen;
    static /* synthetic */ Class class$org$osgi$framework$hooks$service$ListenerHook;
    static /* synthetic */ Class class$org$osgi$framework$hooks$service$FindHook;
    static /* synthetic */ Class class$org$osgi$framework$hooks$service$EventHook;

    Hooks(FrameworkContext fwCtx) {
        this.fwCtx = fwCtx;
    }

    synchronized void open() {
        if (this.fwCtx.debug.hooks) {
            this.fwCtx.debug.println("opening hooks");
        }
        this.listenerHookTracker = new ServiceTracker((BundleContext)this.fwCtx.systemBundle.bundleContext, (class$org$osgi$framework$hooks$service$ListenerHook == null ? (class$org$osgi$framework$hooks$service$ListenerHook = Hooks.class$("org.osgi.framework.hooks.service.ListenerHook")) : class$org$osgi$framework$hooks$service$ListenerHook).getName(), new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                ListenerHook lh = (ListenerHook)((Hooks)Hooks.this).fwCtx.systemBundle.bundleContext.getService(reference);
                try {
                    lh.added(Hooks.this.getServiceCollection());
                }
                catch (Exception e) {
                    ((Hooks)Hooks.this).fwCtx.debug.printStackTrace("Failed to call listener hook  #" + reference.getProperty("service.id"), e);
                }
                return lh;
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
                ((Hooks)Hooks.this).fwCtx.systemBundle.bundleContext.ungetService(reference);
            }
        });
        this.listenerHookTracker.open();
        this.bOpen = true;
    }

    synchronized void close() {
        this.listenerHookTracker.close();
        this.listenerHookTracker = null;
        this.bOpen = false;
    }

    public synchronized boolean isOpen() {
        return this.bOpen;
    }

    void filterServiceReferences(BundleContextImpl bc, String service, String filter, boolean allServices, Collection refs) {
        ArrayList srl = this.fwCtx.services.get((class$org$osgi$framework$hooks$service$FindHook == null ? (class$org$osgi$framework$hooks$service$FindHook = Hooks.class$("org.osgi.framework.hooks.service.FindHook")) : class$org$osgi$framework$hooks$service$FindHook).getName());
        if (srl != null) {
            RemoveOnlyCollection filtered = new RemoveOnlyCollection(refs);
            Iterator i = ((AbstractList)srl).iterator();
            while (i.hasNext()) {
                ServiceReferenceImpl sr = ((ServiceRegistrationImpl)i.next()).reference;
                FindHook fh = (FindHook)sr.getService(this.fwCtx.systemBundle);
                if (fh == null) continue;
                try {
                    fh.find(bc, service, filter, allServices, filtered);
                }
                catch (Exception e) {
                    this.fwCtx.listeners.frameworkError(bc, (Throwable)new BundleException("Failed to call find hook  #" + sr.getProperty("service.id"), e));
                }
            }
        }
    }

    void filterServiceEventReceivers(ServiceEvent evt, Collection receivers) {
        ArrayList srl = this.fwCtx.services.get((class$org$osgi$framework$hooks$service$EventHook == null ? (class$org$osgi$framework$hooks$service$EventHook = Hooks.class$("org.osgi.framework.hooks.service.EventHook")) : class$org$osgi$framework$hooks$service$EventHook).getName());
        if (srl != null) {
            HashSet<BundleContext> ctxs = new HashSet<BundleContext>();
            Iterator ir = receivers.iterator();
            while (ir.hasNext()) {
                ctxs.add(((ServiceListenerEntry)ir.next()).getBundleContext());
            }
            int start_size = ctxs.size();
            RemoveOnlyCollection filtered = new RemoveOnlyCollection(ctxs);
            Iterator i = ((AbstractList)srl).iterator();
            while (i.hasNext()) {
                ServiceReferenceImpl sr = ((ServiceRegistrationImpl)i.next()).reference;
                EventHook eh = (EventHook)sr.getService(this.fwCtx.systemBundle);
                if (eh == null) continue;
                try {
                    eh.event(evt, filtered);
                }
                catch (Exception e) {
                    this.fwCtx.debug.printStackTrace("Failed to call event hook  #" + sr.getProperty("service.id"), e);
                }
            }
            if (start_size != ctxs.size()) {
                Iterator ir2 = receivers.iterator();
                while (ir2.hasNext()) {
                    if (ctxs.contains(((ServiceListenerEntry)ir2.next()).getBundleContext())) continue;
                    ir2.remove();
                }
            }
        }
    }

    Collection getServiceCollection() {
        return Collections.unmodifiableSet(this.fwCtx.listeners.serviceListeners.serviceSet);
    }

    void handleServiceListenerReg(ServiceListenerEntry sle) {
        if (!this.isOpen() || this.listenerHookTracker.size() == 0) {
            return;
        }
        ServiceReference[] srl = this.listenerHookTracker.getServiceReferences();
        Set set = Hooks.toImmutableSet(sle);
        for (int i = 0; srl != null && i < srl.length; ++i) {
            ListenerHook lh = (ListenerHook)this.listenerHookTracker.getService(srl[i]);
            try {
                lh.added(set);
                continue;
            }
            catch (Exception e) {
                this.fwCtx.debug.printStackTrace("Failed to call listener hook #" + srl[i].getProperty("service.id"), e);
            }
        }
    }

    void handleServiceListenerUnreg(ServiceListenerEntry sle) {
        if (this.isOpen()) {
            this.handleServiceListenerUnreg(Hooks.toImmutableSet(sle));
        }
    }

    void handleServiceListenerUnreg(Collection set) {
        if (!this.isOpen() || this.listenerHookTracker.size() == 0) {
            return;
        }
        ServiceReference[] srl = this.listenerHookTracker.getServiceReferences();
        for (int i = 0; srl != null && i < srl.length; ++i) {
            ListenerHook lh = (ListenerHook)this.listenerHookTracker.getService(srl[i]);
            try {
                lh.removed(set);
                continue;
            }
            catch (Exception e) {
                this.fwCtx.debug.printStackTrace("Failed to call listener hook #" + srl[i].getProperty("service.id"), e);
            }
        }
    }

    static Set toImmutableSet(Object obj) {
        Set<Object> set = new HashSet<Object>();
        set.add(obj);
        set = Collections.unmodifiableSet(set);
        return set;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class RemoveOnlyCollection
    extends AbstractCollection {
        final Collection org;

        public RemoveOnlyCollection(Collection values) {
            this.org = values;
        }

        public boolean add(Object obj) {
            throw new UnsupportedOperationException("objects can only be removed");
        }

        public boolean addAll(Collection objs) {
            throw new UnsupportedOperationException("objects can only be removed");
        }

        public Iterator iterator() {
            return this.org.iterator();
        }

        public boolean remove(Object o) {
            return this.org.remove(o);
        }

        public int size() {
            return this.org.size();
        }
    }
}

