/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.knopflerfish.framework.FWProps;
import org.osgi.framework.BundleException;

public class Debug {
    private ThreadLocal insideDebug;
    public static String AUTOMANIFEST_PROP = "org.knopflerfish.framework.debug.automanifest";
    boolean automanifest;
    public static String BUNDLE_RESOURCE_PROP = "org.knopflerfish.framework.debug.bundle_resource";
    boolean bundle_resource;
    public static String CERTIFICATES_PROP = "org.knopflerfish.framework.debug.certificates";
    public boolean certificates;
    public static String CLASSLOADER_PROP = "org.knopflerfish.framework.debug.classloader";
    boolean classLoader;
    public static String ERRORS_PROP = "org.knopflerfish.framework.debug.errors";
    boolean errors;
    public static String FRAMEWORK_PROP = "org.knopflerfish.framework.debug.framework";
    boolean framework;
    public static String HOOKS_PROP = "org.knopflerfish.framework.debug.hooks";
    boolean hooks;
    public static String LAZY_ACTIVATION_PROP = "org.knopflerfish.framework.debug.lazy_activation";
    boolean lazy_activation;
    public static String LDAP_PROP = "org.knopflerfish.framework.debug.ldap";
    boolean ldap;
    public static String PACKAGES_PROP = "org.knopflerfish.framework.debug.packages";
    boolean packages;
    public static String PATCH_PROP = "org.knopflerfish.framework.debug.patch";
    boolean patch;
    public static String PERMISSIONS_PROP = "org.knopflerfish.framework.debug.permissions";
    public boolean permissions;
    public static String SERVICE_REFERENCE_PROP = "org.knopflerfish.framework.debug.service_reference";
    boolean service_reference;
    public static String STARTLEVEL_PROP = "org.knopflerfish.framework.debug.startlevel";
    boolean startlevel;
    public static String URL_PROP = "org.knopflerfish.framework.debug.url";
    boolean url;

    public Debug(FWProps props) {
        props.setPropertyDefault(AUTOMANIFEST_PROP, "false");
        props.setPropertyDefault(BUNDLE_RESOURCE_PROP, "false");
        props.setPropertyDefault(CERTIFICATES_PROP, "false");
        props.setPropertyDefault(CLASSLOADER_PROP, "false");
        props.setPropertyDefault(ERRORS_PROP, "false");
        props.setPropertyDefault(FRAMEWORK_PROP, "false");
        props.setPropertyDefault(HOOKS_PROP, "false");
        props.setPropertyDefault(LAZY_ACTIVATION_PROP, "false");
        props.setPropertyDefault(PACKAGES_PROP, "false");
        props.setPropertyDefault(PATCH_PROP, "false");
        props.setPropertyDefault(PERMISSIONS_PROP, "false");
        props.setPropertyDefault(SERVICE_REFERENCE_PROP, "false");
        props.setPropertyDefault(STARTLEVEL_PROP, "false");
        props.setPropertyDefault(URL_PROP, "false");
        this.automanifest = props.getBooleanProperty(AUTOMANIFEST_PROP);
        this.bundle_resource = props.getBooleanProperty(BUNDLE_RESOURCE_PROP);
        this.certificates = props.getBooleanProperty(CERTIFICATES_PROP);
        this.classLoader = props.getBooleanProperty(CLASSLOADER_PROP);
        this.errors = props.getBooleanProperty(ERRORS_PROP);
        this.framework = props.getBooleanProperty(FRAMEWORK_PROP);
        this.hooks = props.getBooleanProperty(HOOKS_PROP);
        this.lazy_activation = props.getBooleanProperty(LAZY_ACTIVATION_PROP);
        this.packages = props.getBooleanProperty(PACKAGES_PROP);
        this.patch = props.getBooleanProperty(PATCH_PROP);
        this.permissions = props.getBooleanProperty(PERMISSIONS_PROP);
        this.service_reference = props.getBooleanProperty(SERVICE_REFERENCE_PROP);
        this.startlevel = props.getBooleanProperty(STARTLEVEL_PROP);
        this.url = props.getBooleanProperty(URL_PROP);
    }

    private boolean useDoPrivileged() {
        if (System.getSecurityManager() != null) {
            if (this.insideDebug == null) {
                this.insideDebug = new ThreadLocal(){

                    protected synchronized Object initialValue() {
                        return new Boolean(false);
                    }
                };
            }
            return true;
        }
        return false;
    }

    private void inside(boolean b) {
        this.insideDebug.set(new Boolean(b));
    }

    private boolean isInside() {
        return (Boolean)this.insideDebug.get();
    }

    private void println0(String str) {
        System.err.println("## DEBUG: " + str);
    }

    public void println(final String str) {
        if (this.useDoPrivileged()) {
            if (!this.isInside()) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Debug.this.inside(true);
                        Debug.this.println0(str);
                        Debug.this.inside(false);
                        return null;
                    }
                });
            }
        } else {
            this.println0(str);
        }
    }

    private void printStackTrace0(String str, Throwable t) {
        Throwable n;
        System.err.println("## DEBUG: " + str);
        t.printStackTrace();
        if (t instanceof BundleException && (n = ((BundleException)t).getNestedException()) != null) {
            System.err.println("Nested bundle exception:");
            n.printStackTrace();
        }
    }

    public void printStackTrace(final String str, final Throwable t) {
        if (this.useDoPrivileged()) {
            if (!this.isInside()) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Debug.this.inside(true);
                        Debug.this.printStackTrace0(str, t);
                        Debug.this.inside(false);
                        return null;
                    }
                });
            }
        } else {
            this.printStackTrace0(str, t);
        }
    }
}

