/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.knopflerfish.framework.BundleClassLoader;
import org.knopflerfish.framework.BundleClassWriter;
import org.knopflerfish.framework.ClassAdapterPatcher;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.LDAPExpr;
import org.knopflerfish.framework.MethodInfo;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class ClassPatcher {
    protected static Map patchers = new HashMap();
    protected BundleClassLoader classLoader;
    protected Hashtable matchProps = null;
    public static final String PROP_CLASSNAME = "classname";
    public static final String PROP_BID = "bid";
    public static final String PROP_LOCATION = "location";
    public static final String PROP_METHODNAME = "methodname";
    public static final String PROP_METHODACCESS = "methodaccess";
    public static final String PROP_METHODDESC = "methoddesc";
    protected LDAPExpr patchesFilter = null;
    protected boolean bDumpClasses = false;
    protected Map wrappers = new HashMap();
    FrameworkContext framework;
    static String PRE = "patch.";
    static /* synthetic */ Class class$org$knopflerfish$framework$ClassPatcher;

    protected ClassPatcher(BundleClassLoader classLoader) {
        this.classLoader = classLoader;
        this.framework = classLoader.bpkgs.bundle.fwCtx;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassPatcher getInstance(BundleClassLoader classLoader) {
        Map map = patchers;
        synchronized (map) {
            ClassPatcher cp = (ClassPatcher)patchers.get(classLoader);
            if (cp == null) {
                cp = new ClassPatcher(classLoader);
                patchers.put(classLoader, cp);
            }
            return cp;
        }
    }

    protected void init() {
        this.bDumpClasses = this.framework.props.getBooleanProperty("org.knopflerfish.framework.patch.dumpclasses");
        String urlS = this.classLoader.archive.getAttribute("Bundle-ClassPatcher-Config");
        if (urlS == null || "".equals(urlS)) {
            urlS = this.framework.props.getProperty("org.knopflerfish.framework.patch.configurl");
        } else if ("none".equals(urlS)) {
            urlS = null;
        }
        this.makeMatchProps();
        if (urlS != null) {
            this.loadWrappers(urlS);
        }
    }

    public byte[] patch(String className, byte[] classBytes) {
        boolean b;
        if (this.wrappers.size() == 0) {
            return classBytes;
        }
        this.matchProps.put(PROP_CLASSNAME, className);
        if (this.patchesFilter != null && !(b = this.patchesFilter.evaluate(this.matchProps, false))) {
            return classBytes;
        }
        try {
            ClassReader cr = new ClassReader(classBytes);
            BundleClassWriter cw = new BundleClassWriter(1, this.classLoader);
            ClassAdapterPatcher trans = new ClassAdapterPatcher((ClassVisitor)cw, className.replace('.', '/'), this.classLoader, this.classLoader.archive.getBundleId(), this);
            cr.accept((ClassVisitor)trans, 0);
            byte[] newBytes = cw.toByteArray();
            if (this.bDumpClasses) {
                this.dumpClassBytes(className, newBytes);
            }
            classBytes = newBytes;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to patch " + className + "/" + this.classLoader + ": " + e);
        }
        return classBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadWrappers(String urlS) {
        URL url = null;
        InputStream is = null;
        try {
            url = urlS.startsWith("!!") ? (class$org$knopflerfish$framework$ClassPatcher == null ? (class$org$knopflerfish$framework$ClassPatcher = ClassPatcher.class$("org.knopflerfish.framework.ClassPatcher")) : class$org$knopflerfish$framework$ClassPatcher).getResource(urlS.substring(2)) : (urlS.startsWith("!") ? this.classLoader.getResource(urlS.substring(1)) : new URL(urlS));
            is = url.openStream();
            this.loadWrappersFromInputStream(is);
        }
        catch (Exception e) {
            this.framework.debug.printStackTrace("Failed to load patches conf from " + url, e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception ignored) {}
        }
    }

    protected void loadWrappersFromInputStream(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        String f = (String)((Hashtable)props).get("patches.filter");
        if (f != null) {
            try {
                this.patchesFilter = new LDAPExpr(f);
            }
            catch (Exception e) {
                this.framework.debug.printStackTrace("Failed to set patches filter", e);
            }
        }
        Iterator it = ((Hashtable)props).keySet().iterator();
        while (it.hasNext()) {
            int ix;
            String key = (String)it.next();
            if (!key.startsWith(PRE) || (ix = key.lastIndexOf(".from")) == -1) continue;
            String id = key.substring(PRE.length(), ix);
            String from = (String)((Hashtable)props).get(PRE + id + ".from");
            String to = (String)((Hashtable)props).get(PRE + id + ".to");
            if (to == null) {
                if (!this.framework.debug.patch) continue;
                this.framework.debug.println("No key=" + PRE + id + ".to");
                continue;
            }
            this.addPatch(from, to, "true".equals(((Hashtable)props).get(PRE + id + ".active")), "true".equals(((Hashtable)props).get(PRE + id + ".static")), (String)((Hashtable)props).get(PRE + id + ".filter"));
        }
    }

    protected static void parseSignature(String sig, String[] r) {
        int dotIx = sig.indexOf(".");
        if (dotIx == -1) {
            throw new IllegalArgumentException("No . in sig=" + sig);
        }
        int descIx = sig.indexOf("(");
        if (descIx == -1) {
            descIx = sig.length();
        }
        r[0] = sig.substring(0, dotIx).trim();
        r[1] = sig.substring(dotIx + 1, descIx).trim();
        r[2] = descIx < sig.length() ? sig.substring(descIx).trim() : null;
    }

    protected void addPatch(String from, String to, boolean defActive, boolean bStatic, String filter) {
        String[] r = new String[3];
        ClassPatcher.parseSignature(from, r);
        String owner = r[0];
        String name = r[1];
        String desc = r[2];
        ClassPatcher.parseSignature(to, r);
        String targetOwner = r[0];
        String targetName = r[1];
        if (!this.classLoader.isBundlePatch()) {
            return;
        }
        String kpt = this.framework.props.getProperty("kf.patch." + targetName);
        if (kpt != null ? "false".equalsIgnoreCase(kpt) : !defActive) {
            return;
        }
        MethodInfo mi = new MethodInfo(owner, name, desc, bStatic);
        if (filter != null) {
            try {
                mi.filter = new LDAPExpr(filter);
            }
            catch (Exception e) {
                this.framework.debug.printStackTrace("Bad filter for " + mi, e);
            }
        }
        int ix0 = desc.lastIndexOf("(");
        int ix1 = desc.lastIndexOf(")");
        String origArgs = desc.substring(ix0 + 1, ix1);
        String retType = desc.substring(ix1 + 1);
        String targetDesc = bStatic ? origArgs + "JLjava/lang/Object;" : "Ljava/lang/Object;" + origArgs + "JLjava/lang/Object;";
        targetDesc = "(" + targetDesc + ")" + retType;
        MethodInfo target = new MethodInfo(targetOwner, targetName, targetDesc, false);
        target.key = mi;
        this.wrappers.put(mi, target);
    }

    protected void dumpInfo() {
        boolean bFirst = true;
        Iterator it = this.wrappers.keySet().iterator();
        while (it.hasNext()) {
            MethodInfo from = (MethodInfo)it.next();
            MethodInfo mi = (MethodInfo)this.wrappers.get(from);
            if (mi.nPatches > 0) {
                if (bFirst) {
                    this.framework.debug.println("Patches in " + mi.className);
                    bFirst = false;
                }
                this.framework.debug.println(" " + mi.nPatches + " " + (mi.nPatches == 1 ? "occurance " : "occurances") + " of " + from.owner + "." + from.name);
            }
            mi.nPatches = 0;
            mi.className = "";
        }
    }

    MethodInfo findMethodInfo(MethodInfo from) {
        MethodInfo mi = (MethodInfo)this.wrappers.get(from);
        return mi;
    }

    protected void makeMatchProps() {
        this.matchProps = new Hashtable();
        Dictionary d = this.classLoader.bpkgs.bundle.getHeaders();
        Enumeration e = d.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object val = d.get(key);
            this.matchProps.put(key, val);
        }
        this.matchProps.put(PROP_LOCATION, this.classLoader.archive.getBundleLocation());
        this.matchProps.put(PROP_BID, new Long(this.classLoader.archive.getBundleId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpClassBytes(String className, byte[] classBytes) {
        OutputStream os = null;
        try {
            String dirName = this.framework.props.getProperty("org.knopflerfish.framework.patch.dumpclasses.dir");
            File dir = new File(dirName);
            String classFileName = className.replace('.', '/');
            int ix = classFileName.lastIndexOf("/");
            if (ix != -1) {
                String classDir = classFileName.substring(0, ix);
                classFileName = classFileName.substring(ix + 1) + ".class";
                dir = new File(dir, classDir);
            }
            dir.mkdirs();
            File file = new File(dir, classFileName);
            if (this.framework.debug.patch) {
                this.framework.debug.println("dump " + className + " to " + file.getAbsolutePath());
            }
            os = new FileOutputStream(file);
            os.write(classBytes);
            os.flush();
        }
        catch (Exception e) {
            this.framework.debug.printStackTrace("Failed to dump class=" + className, e);
        }
        finally {
            try {
                os.close();
            }
            catch (Exception ignored) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

