/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class Bundles {
    private final Hashtable bundles = new Hashtable();
    private FrameworkContext fwCtx;

    Bundles(FrameworkContext fw) {
        this.fwCtx = fw;
        this.bundles.put(fw.systemBundle.location, fw.systemBundle);
    }

    void clear() {
        this.bundles.clear();
        this.fwCtx = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BundleImpl install(String location, InputStream in) throws BundleException {
        BundleImpl b;
        if (null == this.fwCtx) {
            throw new IllegalStateException("Bundles.getBundle(id) called on closed bundles object.");
        }
        Bundles bundles = this;
        synchronized (bundles) {
            b = (BundleImpl)this.bundles.get(location);
            if (b != null) {
                return b;
            }
            b = this.fwCtx.perm.callInstall0(this, location, in);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BundleImpl install0(String location, InputStream in, Object checkContext) throws BundleException {
        BundleArchive ba = null;
        try {
            InputStream bin;
            if (in == null) {
                String basicAuth;
                URL url = new URL(location);
                URLConnection conn = url.openConnection();
                String auth = this.fwCtx.props.getProperty("http.proxyAuth");
                if (auth != null && !"".equals(auth) && ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol()))) {
                    String base64 = Util.base64Encode(auth);
                    conn.setRequestProperty("Proxy-Authorization", "Basic " + base64);
                }
                if ((basicAuth = this.fwCtx.props.getProperty("http.basicAuth")) != null && !"".equals(basicAuth) && ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol()))) {
                    String base64 = Util.base64Encode(basicAuth);
                    conn.setRequestProperty("Authorization", "Basic " + base64);
                }
                bin = conn.getInputStream();
            } else {
                bin = in;
            }
            try {
                ba = this.fwCtx.storage.insertBundleJar(location, bin);
            }
            finally {
                bin.close();
            }
            BundleImpl res = new BundleImpl(this.fwCtx, ba, checkContext);
            this.bundles.put(location, res);
            this.fwCtx.listeners.bundleChanged(new BundleEvent(1, res));
            return res;
        }
        catch (Exception e) {
            if (ba != null) {
                ba.purge();
            }
            if (e instanceof SecurityException) {
                throw (SecurityException)e;
            }
            throw new BundleException("Failed to install bundle: " + e, 0, e);
        }
    }

    void remove(String location) {
        this.bundles.remove(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle getBundle(long id) {
        if (null == this.fwCtx) {
            throw new IllegalStateException("Bundles.getBundle(id) called on closed bundles object.");
        }
        Hashtable hashtable = this.bundles;
        synchronized (hashtable) {
            Enumeration e = this.bundles.elements();
            while (e.hasMoreElements()) {
                BundleImpl b = (BundleImpl)e.nextElement();
                if (b.id != id) continue;
                return b;
            }
        }
        return null;
    }

    public Bundle getBundle(String location) {
        if (null == this.fwCtx) {
            throw new IllegalStateException("Bundles.getBundle(id) called on closed bundles object.");
        }
        return (Bundle)this.bundles.get(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BundleImpl getBundle(String name, Version version) {
        if (null == this.fwCtx) {
            throw new IllegalStateException("Bundles.getBundle(id) called on closed bundles object.");
        }
        Hashtable hashtable = this.bundles;
        synchronized (hashtable) {
            Enumeration e = this.bundles.elements();
            while (e.hasMoreElements()) {
                BundleImpl b = (BundleImpl)e.nextElement();
                if (!name.equals(b.symbolicName) || !version.equals(b.version)) continue;
                return b;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getBundles() {
        if (null == this.fwCtx) {
            throw new IllegalStateException("Bundles.getBundle(id) called on closed bundles object.");
        }
        ArrayList res = new ArrayList(this.bundles.size());
        Hashtable hashtable = this.bundles;
        synchronized (hashtable) {
            res.addAll(this.bundles.values());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getBundles(String name) {
        ArrayList<BundleImpl> res = new ArrayList<BundleImpl>();
        Hashtable hashtable = this.bundles;
        synchronized (hashtable) {
            Enumeration e = this.bundles.elements();
            while (e.hasMoreElements()) {
                BundleImpl b = (BundleImpl)e.nextElement();
                if (!name.equals(b.symbolicName)) continue;
                res.add(b);
            }
        }
        return res;
    }

    List getBundles(String name, VersionRange range) {
        if (null == this.fwCtx) {
            throw new IllegalStateException("Bundles.getBundle(id) called on closed bundles object.");
        }
        List res = this.getBundles(name);
        int i = 0;
        while (i < res.size()) {
            BundleImpl b = (BundleImpl)res.remove(i);
            if (!range.withinRange(b.version)) continue;
            int j = i;
            while (--j >= 0 && b.version.compareTo(((BundleImpl)res.get((int)j)).version) > 0) {
            }
            res.add(j + 1, b);
            ++i;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getActiveBundles() {
        if (null == this.fwCtx) {
            throw new IllegalStateException("Bundles.getBundle(id) called on closed bundles object.");
        }
        ArrayList<BundleImpl> slist = new ArrayList<BundleImpl>();
        Hashtable hashtable = this.bundles;
        synchronized (hashtable) {
            Enumeration e = this.bundles.elements();
            while (e.hasMoreElements()) {
                BundleImpl b = (BundleImpl)e.nextElement();
                int s = b.getState();
                if (s != 32 && s != 8) continue;
                slist.add(b);
            }
        }
        return slist;
    }

    synchronized void load() {
        BundleArchive[] bas = this.fwCtx.storage.getAllBundleArchives();
        for (int i = 0; i < bas.length; ++i) {
            try {
                BundleImpl b = new BundleImpl(this.fwCtx, bas[i], null);
                this.bundles.put(b.location, b);
                continue;
            }
            catch (Exception e) {
                try {
                    bas[i].setAutostartSetting(-1);
                    bas[i].setStartLevel(-2);
                }
                catch (IOException _ioe) {
                    // empty catch block
                }
                System.err.println("Error: Failed to load bundle " + bas[i].getBundleId() + " (" + bas[i].getBundleLocation() + ")" + " uninstalled it!");
                e.printStackTrace();
            }
        }
    }

    void startBundles(List slist) {
        BundleImpl rb;
        Iterator i = slist.iterator();
        while (i.hasNext()) {
            rb = (BundleImpl)i.next();
            rb.getUpdatedState();
        }
        i = slist.iterator();
        while (i.hasNext()) {
            rb = (BundleImpl)i.next();
            if (rb.getUpdatedState() != 4) continue;
            try {
                rb.start();
            }
            catch (BundleException be) {
                rb.fwCtx.listeners.frameworkError(rb, (Throwable)be);
            }
        }
    }

    List getFragmentBundles(BundleImpl target) {
        ArrayList<BundleImpl> retval = new ArrayList<BundleImpl>();
        Enumeration e = this.bundles.elements();
        while (e.hasMoreElements()) {
            BundleImpl b = (BundleImpl)e.nextElement();
            if (!b.isFragment() || b.state == 1 || !b.fragment.isTarget(target)) continue;
            retval.add(b);
        }
        return retval;
    }
}

