/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.LinkedList;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;

class BundleThread
extends Thread {
    private static final int OP_IDLE = 0;
    private static final int OP_BUNDLE_EVENT = 1;
    private static final int OP_START = 2;
    private static final int OP_STOP = 3;
    private static final int KEEP_ALIVE = 1000;
    private final FrameworkContext fwCtx;
    private volatile BundleEvent be;
    private volatile BundleImpl bundle;
    private volatile int operation = 0;
    private volatile Object res;
    private volatile Object lock = new Object();

    BundleThread(FrameworkContext fc) {
        super(fc.threadGroup, "BundleThread waiting");
        this.setDaemon(false);
        this.fwCtx = fc;
        this.start();
    }

    void quit() {
        this.lock = null;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                while (this.lock != null && this.operation == 0) {
                    try {
                        this.lock.wait(1000L);
                        if (this.operation == 0) {
                            LinkedList linkedList = this.fwCtx.bundleThreads;
                            synchronized (linkedList) {
                                if (this.fwCtx.bundleThreads.remove(this)) {
                                    return;
                                }
                                continue;
                            }
                        }
                        break;
                    }
                    catch (InterruptedException ie) {
                    }
                }
                if (this.lock == null) {
                    break;
                }
                Exception tmpres = null;
                try {
                    switch (this.operation) {
                        case 1: {
                            this.setName("BundleChanged #" + this.be.getBundle().getBundleId());
                            this.fwCtx.listeners.bundleChanged(this.be);
                            break;
                        }
                        case 2: {
                            this.setName("BundleStart #" + this.bundle.getBundleId());
                            tmpres = this.bundle.start0();
                            break;
                        }
                        case 3: {
                            this.setName("BundleStop #" + this.bundle.getBundleId());
                            tmpres = this.bundle.stop1();
                        }
                    }
                }
                catch (Throwable t) {
                    this.fwCtx.listeners.frameworkError(this.bundle, t);
                }
                this.operation = 0;
                this.res = tmpres;
            }
            object = this.fwCtx.packages;
            synchronized (object) {
                this.fwCtx.packages.notifyAll();
            }
        }
    }

    void bundleChanged(BundleEvent be) {
        this.be = be;
        this.startAndWait((BundleImpl)be.getBundle(), 1);
    }

    BundleException callStart0(BundleImpl b) {
        return (BundleException)this.startAndWait(b, 2);
    }

    BundleException callStop1(BundleImpl b) {
        return (BundleException)this.startAndWait(b, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object startAndWait(BundleImpl b, int op) {
        Object object = this.lock;
        synchronized (object) {
            this.res = Boolean.FALSE;
            this.bundle = b;
            this.operation = op;
            this.lock.notifyAll();
        }
        do {
            try {
                this.fwCtx.packages.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.res == Boolean.FALSE);
        object = this.fwCtx.bundleThreads;
        synchronized (object) {
            this.fwCtx.bundleThreads.addFirst(this);
            if (op != this.operation) {
                // empty if block
            }
            return this.res;
        }
    }
}

