/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleClassLoader;
import org.knopflerfish.framework.BundleContextImpl;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.BundleResourceStream;
import org.knopflerfish.framework.BundleThread;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.HeaderDictionary;
import org.knopflerfish.framework.MainClassBundleActivator;
import org.knopflerfish.framework.Packages;
import org.knopflerfish.framework.PermissionOps;
import org.knopflerfish.framework.ServiceReferenceImpl;
import org.knopflerfish.framework.ServiceRegistrationImpl;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.Validator;
import org.knopflerfish.framework.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;

public class BundleImpl
implements Bundle {
    static final int RESOLVED_FLAGS = 60;
    final FrameworkContext fwCtx;
    final long id;
    final String location;
    PermissionOps secure;
    boolean v2Manifest;
    String symbolicName;
    boolean singleton;
    Version version;
    volatile int state;
    BundlePackages bpkgs;
    volatile BundleArchive archive;
    int generation = 0;
    private ProtectionDomain protectionDomain;
    private volatile ClassLoader classLoader = null;
    private HashMap oldClassLoaders = null;
    protected FileTree bundleDir = null;
    protected BundleContextImpl bundleContext = null;
    protected BundleActivator bactivator = null;
    protected long lastModified;
    ArrayList fragments = null;
    String attachPolicy;
    Fragment fragment = null;
    private volatile HeaderDictionary cachedHeaders = null;
    private volatile HeaderDictionary cachedRawHeaders = null;
    boolean lazyActivation = false;
    private HashSet lazyIncludes;
    private HashSet lazyExcludes;
    protected volatile int operation;
    static final int IDLE = 0;
    static final int ACTIVATING = 1;
    static final int DEACTIVATING = 2;
    static final int RESOLVING = 3;
    static final int UNINSTALLING = 4;
    static final int UNRESOLVING = 5;
    static final int UPDATING = 6;
    private BundleException resolveFailException;
    private boolean wasStarted;

    BundleImpl(FrameworkContext fw, long id, String loc, String sym, Version ver) {
        this.fwCtx = fw;
        this.secure = this.fwCtx.perm;
        this.id = id;
        this.location = loc;
        this.protectionDomain = null;
        this.symbolicName = sym;
        this.singleton = false;
        this.version = ver;
        this.v2Manifest = true;
        this.state = 2;
        this.attachPolicy = "always";
        this.modified();
    }

    BundleImpl(FrameworkContext fw, BundleArchive ba, Object checkContext) {
        this.fwCtx = fw;
        this.secure = this.fwCtx.perm;
        this.id = ba.getBundleId();
        this.location = ba.getBundleLocation();
        this.archive = ba;
        this.state = 2;
        this.checkCertificates(ba);
        this.protectionDomain = this.secure.getProtectionDomain(this);
        try {
            this.secure.checkLifecycleAdminPerm(this, checkContext);
            this.checkManifestHeaders(checkContext);
            this.bpkgs = new BundlePackages(this, this.generation++, this.archive.getAttribute("Export-Package"), this.archive.getAttribute("Import-Package"), this.archive.getAttribute("DynamicImport-Package"), this.archive.getAttribute("Require-Bundle"));
        }
        catch (RuntimeException re) {
            this.secure.purge(this, this.protectionDomain);
            throw re;
        }
        this.doExportImport();
        this.bundleDir = this.fwCtx.getDataStorage(this.id);
        int oldStartLevel = this.archive.getStartLevel();
        try {
            if (this.fwCtx.startLevelController == null) {
                this.archive.setStartLevel(0);
            } else if (oldStartLevel == -1) {
                this.archive.setStartLevel(this.fwCtx.startLevelController.getInitialBundleStartLevel());
            }
        }
        catch (Exception e) {
            this.fwCtx.debug.println("Failed to set start level on #" + this.id + ": " + e);
        }
        this.lastModified = this.archive.getLastModified();
        if (this.lastModified == 0L) {
            this.modified();
        }
        if (this.isExtension() && this.resolveFragment(this.fwCtx.systemBundle)) {
            this.state = 4;
        }
    }

    public int getState() {
        return this.state;
    }

    public void start() throws BundleException {
        this.start(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int options) throws BundleException {
        this.secure.checkExecuteAdminPerm(this);
        Packages packages = this.fwCtx.packages;
        synchronized (packages) {
            if (this.isFragment()) {
                throw new BundleException("Cannot start a fragment bundle", 2);
            }
            if (this.state == 1) {
                throw new IllegalStateException("Bundle is uninstalled");
            }
            options &= 0xFF;
            if (this.fwCtx.startLevelController != null && this.getStartLevel() > this.fwCtx.startLevelController.getStartLevel()) {
                if ((options & 1) != 0) {
                    throw new BundleException("Can not transiently activate bundle with start level " + this.getStartLevel() + " when running on start level " + this.fwCtx.startLevelController.getStartLevel(), 10);
                }
                this.setAutostartSetting(options);
                return;
            }
            this.waitOnOperation(this.fwCtx.packages, "Bundle.start", false);
            if (this.state == 32) {
                return;
            }
            if ((options & 1) == 0) {
                this.setAutostartSetting(options);
            }
            if ((options & 2) != 0 && this.lazyActivation) {
                if (2 == this.getUpdatedState()) {
                    throw this.resolveFailException;
                }
                if (8 == this.state) {
                    return;
                }
            } else {
                this.secure.callFinalizeActivation(this);
                return;
            }
            this.state = 8;
            this.bundleContext = new BundleContextImpl(this);
            this.operation = 1;
        }
        this.secure.callBundleChanged(this.fwCtx, new BundleEvent(512, this));
        packages = this.fwCtx.packages;
        synchronized (packages) {
            this.operation = 0;
            this.fwCtx.packages.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finalizeActivation() throws BundleException {
        Packages packages = this.fwCtx.packages;
        synchronized (packages) {
            switch (this.getUpdatedState()) {
                case 2: {
                    throw this.resolveFailException;
                }
                case 8: {
                    if (this.operation == 1) {
                        return;
                    }
                }
                case 4: {
                    this.state = 8;
                    this.operation = 1;
                    if (this.fwCtx.debug.lazy_activation) {
                        this.fwCtx.debug.println("activating #" + this.getBundleId());
                    }
                    if (null == this.bundleContext) {
                        this.bundleContext = new BundleContextImpl(this);
                    }
                    BundleException e = this.bundleThread().callStart0(this);
                    this.operation = 0;
                    this.fwCtx.packages.notifyAll();
                    if (e == null) break;
                    throw e;
                }
                case 32: {
                    break;
                }
                case 16: {
                    throw new BundleException("start called from BundleActivator.stop", 5);
                }
                case 1: {
                    throw new IllegalStateException("Bundle is in UNINSTALLED state");
                }
            }
        }
    }

    BundleException start0() {
        String ba = this.archive.getAttribute("Bundle-Activator");
        boolean bStarted = false;
        BundleException res = null;
        this.fwCtx.listeners.bundleChanged(new BundleEvent(128, this));
        ClassLoader oldLoader = null;
        if (this.fwCtx.props.SETCONTEXTCLASSLOADER) {
            oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
        }
        int error_type = 3;
        try {
            if (ba != null) {
                Class<?> c = this.classLoader.loadClass(ba.trim());
                error_type = 5;
                this.bactivator = (BundleActivator)c.newInstance();
                this.bactivator.start(this.bundleContext);
                bStarted = true;
            } else {
                String mc;
                String locations = this.fwCtx.props.getProperty("org.knopflerfish.framework.main.class.activation");
                if (locations.length() > 0 && (mc = this.archive.getAttribute("Main-Class")) != null) {
                    String[] locs = Util.splitwords(locations, ",");
                    for (int i = 0; i < locs.length; ++i) {
                        if (!locs[i].equals(this.location)) continue;
                        if (this.fwCtx.debug.packages) {
                            this.fwCtx.debug.println("starting main class " + mc);
                        }
                        error_type = 5;
                        Class<?> mainClass = this.classLoader.loadClass(mc.trim());
                        this.bactivator = new MainClassBundleActivator(mainClass);
                        this.bactivator.start(this.bundleContext);
                        bStarted = true;
                        break;
                    }
                }
            }
            if (!bStarted) {
                // empty if block
            }
            if (8 != this.state) {
                error_type = 7;
                if (1 == this.state) {
                    throw new Exception("Bundle uninstalled during start()");
                }
                throw new Exception("Bundle changed state because of refresh during start()");
            }
            this.state = 32;
        }
        catch (Throwable t) {
            res = new BundleException("Bundle start failed", error_type, t);
        }
        if (this.fwCtx.debug.lazy_activation) {
            this.fwCtx.debug.println("activating #" + this.getBundleId() + " completed.");
        }
        if (this.fwCtx.props.SETCONTEXTCLASSLOADER) {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        if (res == null) {
            this.fwCtx.listeners.bundleChanged(new BundleEvent(2, this));
        } else if (this.operation == 1) {
            this.state = 16;
            this.fwCtx.listeners.bundleChanged(new BundleEvent(256, this));
            this.removeBundleResources();
            this.bundleContext.invalidate();
            this.bundleContext = null;
            this.state = 4;
            this.fwCtx.listeners.bundleChanged(new BundleEvent(4, this));
        }
        return res;
    }

    public void stop() throws BundleException {
        this.stop(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int options) throws BundleException {
        Exception savedException = null;
        this.secure.checkExecuteAdminPerm(this);
        Packages packages = this.fwCtx.packages;
        synchronized (packages) {
            if (this.isFragment()) {
                throw new BundleException("Cannot stop a fragment bundle", 2);
            }
            if (this.state == 1) {
                throw new IllegalStateException("Bundle is uninstalled");
            }
            this.waitOnOperation(this.fwCtx.packages, "Bundle.stop", false);
            if ((options & 1) == 0) {
                this.setAutostartSetting(-1);
            }
            switch (this.state) {
                case 1: 
                case 2: 
                case 4: 
                case 16: {
                    return;
                }
                case 8: 
                case 32: {
                    savedException = this.stop0();
                }
            }
        }
        if (savedException != null) {
            if (savedException instanceof BundleException) {
                throw (BundleException)savedException;
            }
            throw (RuntimeException)savedException;
        }
    }

    Exception stop0() {
        this.wasStarted = this.state == 32;
        this.state = 16;
        this.operation = 2;
        BundleException savedException = this.bundleThread().callStop1(this);
        if (this.state != 1) {
            this.state = 4;
            this.bundleThread().bundleChanged(new BundleEvent(4, this));
            this.fwCtx.packages.notifyAll();
            this.operation = 0;
        }
        return savedException;
    }

    Exception stop1() {
        BundleException res = null;
        this.fwCtx.listeners.bundleChanged(new BundleEvent(256, this));
        if (this.wasStarted && this.bactivator != null) {
            try {
                this.bactivator.stop(this.bundleContext);
                if (this.state != 16) {
                    if (this.state == 1) {
                        return new IllegalStateException("Bundle is uninstalled");
                    }
                    return new IllegalStateException("Bundle changed state because of refresh during stop");
                }
            }
            catch (Throwable e) {
                res = new BundleException("Bundle.stop: BundleActivator stop failed", 5, e);
            }
            this.bactivator = null;
        }
        if (this.operation == 2 && null != this.bundleContext) {
            this.fwCtx.listeners.serviceListeners.hooksBundleStopped(this.bundleContext);
            this.removeBundleResources();
            this.bundleContext.invalidate();
            this.bundleContext = null;
        }
        return res;
    }

    void waitOnOperation(Object lock, String src, boolean longWait) throws BundleException {
        if (this.operation != 0) {
            String op;
            long left = longWait ? 20000L : 500L;
            long waitUntil = System.currentTimeMillis() + left;
            do {
                try {
                    lock.wait(left);
                    if (this.operation == 0) {
                        return;
                    }
                }
                catch (InterruptedException _ie) {
                    // empty catch block
                }
            } while ((left = waitUntil - System.currentTimeMillis()) > 0L);
            switch (this.operation) {
                case 0: {
                    return;
                }
                case 1: {
                    op = "start";
                    break;
                }
                case 2: {
                    op = "stop";
                    break;
                }
                case 3: {
                    op = "resolve";
                    break;
                }
                case 4: {
                    op = "uninstall";
                    break;
                }
                case 5: {
                    op = "unresolve";
                    break;
                }
                case 6: {
                    op = "update";
                    break;
                }
                default: {
                    op = "unknown operation";
                }
            }
            throw new BundleException(src + " called during " + op + " of Bundle", 7);
        }
    }

    public void update() throws BundleException {
        this.update(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(InputStream in) throws BundleException {
        try {
            this.secure.checkLifecycleAdminPerm(this);
            if (this.isExtension()) {
                this.secure.checkExtensionLifecycleAdminPerm(this);
            }
            Packages packages = this.fwCtx.packages;
            synchronized (packages) {
                boolean wasActive = this.state == 32;
                switch (this.getUpdatedState()) {
                    case 32: {
                        this.stop(1);
                    }
                    case 2: 
                    case 4: {
                        this.secure.callUpdate0(this, in, wasActive);
                        break;
                    }
                    case 8: {
                        throw new IllegalStateException("Bundle is in STARTING state");
                    }
                    case 16: {
                        throw new IllegalStateException("Bundle is in STOPPING state");
                    }
                    case 1: {
                        throw new IllegalStateException("Bundle is in UNINSTALLED state");
                    }
                }
            }
            Object var6_5 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
            return;
        }
        catch (IOException ignore) {}
    }

    void update0(InputStream in, boolean wasActive, Object checkContext) throws BundleException {
        boolean purgeOld;
        boolean wasResolved = this.state == 4;
        Fragment oldFragment = this.fragment;
        int oldStartLevel = this.getStartLevel();
        BundleArchive newArchive = null;
        BundlePackages newBpkgs = null;
        this.operation = 6;
        try {
            InputStream bin;
            if (in == null) {
                File file;
                URL url;
                String fname;
                String update;
                String string = update = this.archive != null ? this.archive.getAttribute("Bundle-UpdateLocation") : null;
                if (update == null) {
                    update = this.location;
                }
                if ((fname = (url = new URL(update)).getFile()).startsWith("file:")) {
                    fname = fname.substring(5);
                }
                bin = (file = new File(fname)).isDirectory() ? null : url.openStream();
            } else {
                bin = in;
            }
            newArchive = this.fwCtx.storage.updateBundleArchive(this.archive, bin);
            this.checkCertificates(newArchive);
            this.checkManifestHeaders(checkContext);
            newBpkgs = new BundlePackages(this, this.generation, newArchive.getAttribute("Export-Package"), newArchive.getAttribute("Import-Package"), newArchive.getAttribute("DynamicImport-Package"), newArchive.getAttribute("Require-Bundle"));
            newArchive.setStartLevel(oldStartLevel);
            this.fwCtx.storage.replaceBundleArchive(this.archive, newArchive);
        }
        catch (Exception e) {
            if (newArchive != null) {
                newArchive.purge();
            }
            this.operation = 0;
            if (wasActive) {
                try {
                    this.start();
                }
                catch (BundleException be) {
                    this.fwCtx.listeners.frameworkError(this, (Throwable)be);
                }
            }
            if (e instanceof BundleException) {
                throw (BundleException)e;
            }
            throw new BundleException("Failed to get update bundle", 0, e);
        }
        if (oldFragment != null) {
            if (oldFragment.hasHosts()) {
                if (oldFragment.extension != null) {
                    if (oldFragment.extension.equals("bootclasspath")) {
                        this.fwCtx.systemBundle.bootClassPathHasChanged = true;
                    }
                } else {
                    Iterator i = oldFragment.getHosts();
                    while (i.hasNext()) {
                        ((BundleImpl)i.next()).bpkgs.fragmentIsZombie(this);
                    }
                }
                oldFragment.removeHost(null);
                purgeOld = false;
            } else {
                purgeOld = true;
            }
        } else {
            boolean allRemoved = this.bpkgs.unregisterPackages(false);
            if (allRemoved) {
                if (this.classLoader != null) {
                    if (this.classLoader instanceof BundleClassLoader) {
                        ((BundleClassLoader)this.classLoader).close();
                    }
                    this.classLoader = null;
                }
                purgeOld = true;
            } else {
                this.saveZombiePackages();
                purgeOld = false;
            }
            if (this.isFragmentHost()) {
                this.detachFragments();
            }
        }
        BundleArchive oldArchive = this.archive;
        this.archive = newArchive;
        this.cachedRawHeaders = null;
        this.state = 2;
        ProtectionDomain oldProtectionDomain = this.protectionDomain;
        this.protectionDomain = this.secure.getProtectionDomain(this);
        ++this.generation;
        this.bpkgs = newBpkgs;
        this.doExportImport();
        if (purgeOld) {
            this.secure.purge(this, oldProtectionDomain);
            if (null != oldArchive) {
                oldArchive.purge();
            }
        }
        if (wasResolved) {
            this.bundleThread().bundleChanged(new BundleEvent(64, this));
        }
        this.bundleThread().bundleChanged(new BundleEvent(8, this));
        this.operation = 0;
        this.modified();
        if (wasActive) {
            try {
                this.start();
            }
            catch (BundleException be) {
                this.fwCtx.listeners.frameworkError(this, (Throwable)be);
            }
        }
    }

    public void uninstall() throws BundleException {
        this.secure.checkLifecycleAdminPerm(this);
        if (this.isExtension()) {
            this.secure.checkExtensionLifecycleAdminPerm(this);
        }
        this.secure.callUninstall0(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uninstall0() {
        Packages packages = this.fwCtx.packages;
        synchronized (packages) {
            if (null != this.archive) {
                try {
                    this.archive.setStartLevel(-2);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            boolean doPurge = false;
            switch (this.state) {
                case 1: {
                    throw new IllegalStateException("Bundle is in UNINSTALLED state");
                }
                case 8: 
                case 16: 
                case 32: {
                    Exception exception;
                    try {
                        this.waitOnOperation(this.fwCtx.packages, "Bundle.uninstall", true);
                        exception = (this.state & 0x28) != 0 ? this.stop0() : null;
                    }
                    catch (Exception se) {
                        this.setStateInstalled(false);
                        this.fwCtx.packages.notifyAll();
                        exception = se;
                    }
                    this.operation = 4;
                    if (exception != null) {
                        this.fwCtx.listeners.frameworkError(this, (Throwable)exception);
                    }
                }
                case 2: 
                case 4: {
                    this.fwCtx.bundles.remove(this.location);
                    if (this.operation != 4) {
                        try {
                            this.waitOnOperation(this.fwCtx.packages, "Bundle.uninstall", true);
                            this.operation = 4;
                        }
                        catch (BundleException be) {
                            if (this.bundleContext != null) {
                                this.bundleContext.invalidate();
                                this.bundleContext = null;
                            }
                            this.operation = 4;
                            this.fwCtx.listeners.frameworkError(this, (Throwable)be);
                        }
                    }
                    if (this.isFragment()) {
                        if (this.isAttached()) {
                            if (this.isExtension()) {
                                if (this.isBootClassPathExtension()) {
                                    this.fwCtx.systemBundle.bootClassPathHasChanged = true;
                                }
                            } else {
                                Iterator i = this.fragment.getHosts();
                                while (i.hasNext()) {
                                    BundleImpl hb = (BundleImpl)i.next();
                                    if (hb.bpkgs == null) continue;
                                    hb.bpkgs.fragmentIsZombie(this);
                                }
                            }
                            this.fragment.removeHost(null);
                        } else {
                            this.secure.purge(this, this.protectionDomain);
                            doPurge = true;
                        }
                    } else {
                        boolean pkgsUnregistered = this.bpkgs.unregisterPackages(false);
                        if (pkgsUnregistered) {
                            if (this.classLoader != null) {
                                if (this.classLoader instanceof BundleClassLoader) {
                                    ((BundleClassLoader)this.classLoader).purge(false);
                                }
                                this.classLoader = null;
                            } else {
                                this.secure.purge(this, this.protectionDomain);
                            }
                            doPurge = true;
                        } else {
                            this.saveZombiePackages();
                        }
                        if (this.isFragmentHost()) {
                            this.detachFragments();
                        }
                    }
                    this.state = 2;
                    this.bundleThread().bundleChanged(new BundleEvent(64, this));
                    this.cachedHeaders = this.getHeaders0(null);
                    this.bpkgs = null;
                    this.bactivator = null;
                    if (doPurge) {
                        this.archive.purge();
                        this.archive = null;
                    }
                    if (this.bundleDir != null) {
                        if (this.bundleDir.exists() && !this.bundleDir.delete()) {
                            this.fwCtx.listeners.frameworkError(this, (Throwable)new IOException("Failed to delete bundle data"));
                        }
                        this.bundleDir = null;
                    }
                    this.modified();
                    this.state = 1;
                    this.operation = 0;
                }
            }
        }
        this.fwCtx.listeners.bundleChanged(new BundleEvent(16, this));
    }

    public Dictionary getHeaders() {
        return this.getHeaders(null);
    }

    public long getBundleId() {
        return this.id;
    }

    public String getLocation() {
        this.secure.checkMetadataAdminPerm(this);
        return this.location;
    }

    public ServiceReference[] getRegisteredServices() {
        this.checkUninstalled();
        Set sr = this.fwCtx.services.getRegisteredByBundle(this);
        this.secure.filterGetServicePermission(sr);
        if (sr.size() > 0) {
            ServiceReference[] res = new ServiceReference[sr.size()];
            int pos = 0;
            Iterator i = sr.iterator();
            while (i.hasNext()) {
                res[pos++] = ((ServiceRegistration)i.next()).getReference();
            }
            return res;
        }
        return null;
    }

    public ServiceReference[] getServicesInUse() {
        this.checkUninstalled();
        Set sr = this.fwCtx.services.getUsedByBundle(this);
        this.secure.filterGetServicePermission(sr);
        if (sr.size() > 0) {
            ServiceReference[] res = new ServiceReference[sr.size()];
            int pos = 0;
            Iterator i = sr.iterator();
            while (i.hasNext()) {
                res[pos++] = ((ServiceRegistration)i.next()).getReference();
            }
            return res;
        }
        return null;
    }

    public boolean hasPermission(Object permission) {
        this.checkUninstalled();
        if (permission instanceof Permission) {
            if (this.secure.checkPermissions()) {
                PermissionCollection pc = this.protectionDomain.getPermissions();
                return pc != null ? pc.implies((Permission)permission) : false;
            }
            return true;
        }
        return false;
    }

    public BundleContext getBundleContext() {
        this.secure.checkContextAdminPerm(this);
        return this.bundleContext;
    }

    public URL getResource(String name) {
        ClassLoader cl0;
        this.checkUninstalled();
        if (this.secure.okResourceAdminPerm(this) && !this.isFragment() && this.getUpdatedState() != 2 && (cl0 = this.classLoader) != null) {
            return cl0.getResource(name);
        }
        return null;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    /*
     * WARNING - void declaration
     */
    public Map getSignerCertificates(int signersType) {
        void var2_2;
        ArrayList cs;
        boolean onlyTrusted;
        if (signersType == 1) {
            onlyTrusted = false;
        } else if (signersType == 2) {
            onlyTrusted = true;
        } else {
            throw new IllegalArgumentException("signersType not SIGNER_ALL or SIGNERS_TRUSTED");
        }
        if (this.archive != null && (cs = this.archive.getCertificateChains((boolean)var2_2)) != null) {
            HashMap res = new HashMap();
            Iterator i = cs.iterator();
            while (i.hasNext()) {
                ArrayList chain = (ArrayList)i.next();
                res.put(chain.get(0), chain.clone());
            }
            return res;
        }
        return Collections.EMPTY_MAP;
    }

    public Version getVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getUpdatedState() {
        if (this.state == 2) {
            try {
                Packages packages = this.fwCtx.packages;
                synchronized (packages) {
                    if (this.state == 2) {
                        String ee = this.archive.getAttribute("Bundle-RequiredExecutionEnvironment");
                        if (ee != null) {
                            if (this.fwCtx.debug.packages) {
                                this.fwCtx.debug.println("bundle #" + this.archive.getBundleId() + " has EE=" + ee);
                            }
                            if (!this.fwCtx.isValidEE(ee)) {
                                throw new BundleException("Unable to resolve bundle: Execution environment '" + ee + "' is not supported", 4);
                            }
                        }
                        if (this.isFragment()) {
                            List hosts = this.fragment.targets();
                            if (hosts != null) {
                                Iterator i = hosts.iterator();
                                while (i.hasNext()) {
                                    BundleImpl host = (BundleImpl)i.next();
                                    if (host.state == 2) {
                                        host.getUpdatedState();
                                        continue;
                                    }
                                    if (this.fragment.isHost(host)) continue;
                                }
                                if (this.state == 2 && this.fragment.hasHosts()) {
                                    this.state = 4;
                                    this.operation = 3;
                                    this.bundleThread().bundleChanged(new BundleEvent(32, this));
                                    this.operation = 0;
                                }
                            }
                        } else {
                            this.attachFragments();
                            if (this.bpkgs.resolvePackages()) {
                                this.classLoader = this.secure.newBundleClassLoader(this.bpkgs, this.archive, this.fragments, this.protectionDomain);
                                this.resolveFailException = null;
                                this.state = 4;
                                this.operation = 3;
                                if (this.fragments != null) {
                                    Iterator i = ((AbstractList)this.fragments).iterator();
                                    while (i.hasNext()) {
                                        BundleImpl fb = (BundleImpl)i.next();
                                        fb.getUpdatedState();
                                    }
                                }
                                this.bundleThread().bundleChanged(new BundleEvent(32, this));
                                this.operation = 0;
                            } else {
                                throw new BundleException("Unable to resolve bundle: " + this.bpkgs.getResolveFailReason(), 4);
                            }
                        }
                    }
                }
            }
            catch (BundleException be) {
                this.resolveFailException = be;
                this.detachFragments();
                this.fwCtx.listeners.frameworkError(this, (Throwable)be);
            }
        }
        return this.state;
    }

    boolean resolveFragment(BundleImpl host) {
        if (this.isFragment() && this.secure.okFragmentBundlePerm(this)) {
            try {
                host.attachFragment(this);
                this.fragment.addHost(host);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    File getDataRoot() {
        return this.bundleDir;
    }

    ClassLoader getClassLoader() {
        return this.classLoader;
    }

    void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStateInstalled(boolean sendEvent) {
        Packages packages = this.fwCtx.packages;
        synchronized (packages) {
            if (this.bundleContext != null) {
                this.bundleContext.invalidate();
                this.bundleContext = null;
            }
            if (this.isFragment()) {
                this.classLoader = null;
                this.fragment.removeHost(null);
            } else {
                if (this.classLoader != null) {
                    if (this.classLoader instanceof BundleClassLoader) {
                        ((BundleClassLoader)this.classLoader).close();
                    }
                    this.classLoader = null;
                }
                this.bpkgs.unregisterPackages(true);
                if (this.isFragmentHost()) {
                    this.detachFragments();
                }
                this.bpkgs.registerPackages();
            }
            this.state = 2;
            if (sendEvent) {
                this.operation = 5;
                this.bundleThread().bundleChanged(new BundleEvent(64, this));
            }
            this.operation = 0;
        }
    }

    ClassLoader getClassLoader(BundlePackages ebpkgs) {
        if (this.bpkgs == ebpkgs) {
            return this.classLoader;
        }
        if (this.oldClassLoaders != null) {
            return (ClassLoader)this.oldClassLoaders.get(ebpkgs);
        }
        return null;
    }

    void purge() {
        if (this.state == 1) {
            this.fwCtx.bundles.remove(this.location);
        }
        if (this.oldClassLoaders != null) {
            Iterator i = this.oldClassLoaders.values().iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (!(obj instanceof BundleClassLoader)) continue;
                ((BundleClassLoader)obj).purge(true);
            }
            this.oldClassLoaders = null;
        }
    }

    BundleArchive getBundleArchive(long gen, long frag) {
        if (gen == -1L || this.bpkgs != null && (long)this.bpkgs.generation == gen) {
            if (frag == -1L) {
                return this.archive;
            }
            return ((BundleClassLoader)this.classLoader).getBundleArchive(frag);
        }
        Iterator i = this.oldClassLoaders.values().iterator();
        while (i.hasNext()) {
            BundleClassLoader cl = (BundleClassLoader)i.next();
            if ((long)cl.getBpkgs().generation != gen) continue;
            return cl.getBundleArchive(frag);
        }
        return null;
    }

    Iterator getExports() {
        if (this.oldClassLoaders != null) {
            HashSet res = new HashSet();
            Iterator i = this.oldClassLoaders.values().iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (!(obj instanceof BundleClassLoader)) continue;
                Iterator j = ((BundleClassLoader)obj).getBpkgs().getExports();
                while (j.hasNext()) {
                    res.add(j.next());
                }
            }
            if (this.bpkgs != null) {
                i = this.bpkgs.getExports();
                while (i.hasNext()) {
                    res.add(i.next());
                }
            }
            return res.iterator();
        }
        if (this.bpkgs != null) {
            return this.bpkgs.getExports();
        }
        return ((AbstractList)new ArrayList(0)).iterator();
    }

    Iterator getImports() {
        if (this.oldClassLoaders != null) {
            HashSet res = new HashSet();
            Iterator i = this.oldClassLoaders.values().iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (!(obj instanceof BundleClassLoader)) continue;
                Iterator j = ((BundleClassLoader)obj).getBpkgs().getImports();
                while (j.hasNext()) {
                    res.add(j.next());
                }
            }
            if (this.bpkgs != null) {
                i = this.bpkgs.getImports();
                while (i.hasNext()) {
                    res.add(i.next());
                }
            }
            return res.iterator();
        }
        if (this.bpkgs != null) {
            return this.bpkgs.getImports();
        }
        return ((AbstractList)new ArrayList(0)).iterator();
    }

    List getRequiredBy() {
        if (this.oldClassLoaders != null) {
            ArrayList res = new ArrayList();
            Iterator i = this.oldClassLoaders.values().iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (!(obj instanceof BundleClassLoader)) continue;
                res.addAll(((BundleClassLoader)obj).getBpkgs().getRequiredBy());
            }
            if (this.bpkgs != null) {
                res.addAll(this.bpkgs.getRequiredBy());
            }
            return res;
        }
        if (this.bpkgs != null) {
            return this.bpkgs.getRequiredBy();
        }
        return new ArrayList(0);
    }

    URL getURL(long gen, long fragId, int subId, String path) {
        try {
            StringBuffer u = new StringBuffer("bundle");
            u.append("://");
            u.append(this.id);
            if (gen != -1L) {
                u.append('.').append(gen);
            }
            if (fragId != -1L && fragId != this.id) {
                u.append('_').append(fragId);
            }
            if (subId >= 0) {
                u.append(':').append(subId);
            }
            if (!path.startsWith("/")) {
                u.append('/');
            }
            u.append(path);
            return this.secure.getBundleURL(this.fwCtx, u.toString());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private void checkCertificates(BundleArchive ba) {
        ArrayList cs = ba.getCertificateChains(false);
        if (cs != null && this.fwCtx.validator != null) {
            if (this.fwCtx.debug.certificates) {
                this.fwCtx.debug.println("Validate certs for bundle #" + ba.getBundleId());
            }
            cs = (ArrayList)cs.clone();
            Iterator vi = this.fwCtx.validator.iterator();
            while (!cs.isEmpty() && vi.hasNext()) {
                Validator v = (Validator)vi.next();
                Iterator ci = ((AbstractList)cs).iterator();
                while (ci.hasNext()) {
                    List c = (List)ci.next();
                    if (v.validateCertificateChain(c)) {
                        ba.trustCertificateChain(c);
                        ci.remove();
                        if (!this.fwCtx.debug.certificates) continue;
                        this.fwCtx.debug.println("Validated cert: " + c.get(0));
                        continue;
                    }
                    if (!this.fwCtx.debug.certificates) continue;
                    this.fwCtx.debug.println("Failed to validate cert: " + c.get(0));
                }
            }
            if (cs.isEmpty()) {
                return;
            }
        }
        if (this.fwCtx.props.getBooleanProperty("org.knopflerfish.framework.all_signed")) {
            throw new IllegalArgumentException("All installed bundles must be signed!");
        }
    }

    private void checkManifestHeaders(Object checkContext) {
        boolean newLazyActivation;
        Fragment newFragment;
        boolean newSingleton;
        Version newVersion;
        String newSymbolicName;
        String mv = this.archive.getAttribute("Bundle-ManifestVersion");
        boolean newV2Manifest = mv != null && mv.trim().equals("2");
        Iterator i = Util.parseEntries("Bundle-SymbolicName", this.archive.getAttribute("Bundle-SymbolicName"), true, true, true);
        Map e = null;
        if (i.hasNext()) {
            e = (Map)i.next();
            newSymbolicName = (String)e.get("$key");
        } else {
            if (newV2Manifest) {
                throw new IllegalArgumentException("Bundle has no symbolic name, location=" + this.location);
            }
            newSymbolicName = null;
        }
        String mbv = this.archive.getAttribute("Bundle-Version");
        if (mbv != null) {
            try {
                newVersion = new Version(mbv);
            }
            catch (Throwable ee) {
                if (newV2Manifest) {
                    throw new IllegalArgumentException("Bundle does not specify a valid Bundle-Version header. Got exception: " + ee.getMessage());
                }
                newVersion = Version.emptyVersion;
            }
        } else {
            newVersion = Version.emptyVersion;
        }
        String newAttachPolicy = "always";
        if (e != null) {
            newSingleton = "true".equals((String)e.get("singleton"));
            BundleImpl snb = this.fwCtx.bundles.getBundle(newSymbolicName, newVersion);
            String tmp = (String)e.get("fragment-attachment");
            String string = newAttachPolicy = tmp == null ? "always" : tmp;
            if (snb != null && snb != this) {
                throw new IllegalArgumentException("Bundle with same symbolic name and version is already installed (" + newSymbolicName + ", " + newVersion);
            }
        } else {
            newSingleton = false;
        }
        if ((i = Util.parseEntries("Fragment-Host", this.archive.getAttribute("Fragment-Host"), true, true, true)).hasNext()) {
            if (this.archive.getAttribute("Bundle-Activator") != null) {
                throw new IllegalArgumentException("A fragment bundle can not have a Bundle-Activator.");
            }
            e = (Map)i.next();
            String extension = (String)e.get("extension");
            String key = (String)e.get("$key");
            if ("framework".equals(extension) || "bootclasspath".equals(extension)) {
                if (!"system.bundle".equals(key) && !"org.knopflerfish.framework".equals(key)) {
                    throw new IllegalArgumentException("An extension bundle must target the system bundle(=system.bundle)");
                }
                if (this.archive.getAttribute("Import-Package") != null || this.archive.getAttribute("Require-Bundle") != null || this.archive.getAttribute("Bundle-NativeCode") != null || this.archive.getAttribute("DynamicImport-Package") != null || this.archive.getAttribute("Bundle-Activator") != null) {
                    throw new IllegalArgumentException("An extension bundle cannot specify: Import-Package, Require-Bundle, Bundle-NativeCode, DynamicImport-Package or Bundle-Activator");
                }
                this.secure.checkExtensionLifecycleAdminPerm(this, checkContext);
                if (!this.secure.okAllPerm(this)) {
                    throw new IllegalArgumentException("An extension bundle must have AllPermission");
                }
                if (!this.fwCtx.props.getBooleanProperty("org.osgi.supports.framework.extension") && "framework".equals(extension)) {
                    throw new UnsupportedOperationException("Framework extension bundles are not supported by this framework. Consult the documentation");
                }
                if (!this.fwCtx.props.getBooleanProperty("org.osgi.supports.bootclasspath.extension") && "bootclasspath".equals(extension)) {
                    throw new UnsupportedOperationException("Bootclasspath extension bundles are not supported by this framework. Consult the documentation");
                }
            } else if (extension != null) {
                throw new IllegalArgumentException("Did not recognize directive extension:=" + extension + ".");
            }
            newFragment = new Fragment(key, extension, (String)e.get("bundle-version"));
        } else {
            newFragment = null;
        }
        i = Util.parseEntries("Bundle-ActivationPolicy", this.archive.getAttribute("Bundle-ActivationPolicy"), true, true, true);
        HashSet newLazyIncludes = null;
        HashSet newLazyExcludes = null;
        if (i.hasNext()) {
            e = (Map)i.next();
            newLazyActivation = "lazy".equals(e.get("$key"));
            if (newLazyActivation) {
                if (e.containsKey("include")) {
                    newLazyIncludes = Util.parseEnumeration("include", (String)e.get("include"));
                }
                if (e.containsKey("exclude")) {
                    newLazyExcludes = Util.parseEnumeration("exclude", (String)e.get("exclude"));
                    if (newLazyIncludes != null) {
                        Iterator excsIter = newLazyExcludes.iterator();
                        while (excsIter.hasNext()) {
                            String entry = (String)excsIter.next();
                            if (!newLazyIncludes.contains(entry)) continue;
                            throw new IllegalArgumentException("Conflicting include/exclude entries in Bundle-ActivationPolicy: '" + entry + "' both included and excluded");
                        }
                    }
                }
            }
        } else {
            newLazyActivation = false;
        }
        this.v2Manifest = newV2Manifest;
        this.symbolicName = newSymbolicName;
        this.version = newVersion;
        this.attachPolicy = newAttachPolicy;
        this.singleton = newSingleton;
        this.fragment = newFragment;
        this.lazyActivation = newLazyActivation;
        this.lazyIncludes = newLazyIncludes;
        this.lazyExcludes = newLazyExcludes;
    }

    void setAutostartSetting(int setting) {
        this.secure.callSetAutostartSetting(this, setting);
    }

    void setAutostartSetting0(int setting) {
        try {
            if (null != this.archive) {
                this.archive.setAutostartSetting(setting);
            }
        }
        catch (IOException e) {
            this.fwCtx.listeners.frameworkError(this, (Throwable)e);
        }
    }

    int getAutostartSetting() {
        return this.archive != null ? this.archive.getAutostartSetting() : -1;
    }

    private void doExportImport() {
        if (!this.isFragment()) {
            this.bpkgs.registerPackages();
        }
    }

    private void removeBundleResources() {
        this.fwCtx.listeners.removeAllListeners(this.bundleContext);
        Set srs = this.fwCtx.services.getRegisteredByBundle(this);
        Iterator i = srs.iterator();
        while (i.hasNext()) {
            try {
                ((ServiceRegistration)i.next()).unregister();
            }
            catch (IllegalStateException ignore) {}
        }
        Set s = this.fwCtx.services.getUsedByBundle(this);
        Iterator i2 = s.iterator();
        while (i2.hasNext()) {
            ServiceReferenceImpl sri = ((ServiceRegistrationImpl)i2.next()).reference;
            if (sri == null) continue;
            sri.ungetService(this, false);
        }
    }

    private void saveZombiePackages() {
        if (this.oldClassLoaders == null) {
            this.oldClassLoaders = new HashMap();
        }
        this.oldClassLoaders.put(this.bpkgs, this.classLoader);
        this.classLoader = null;
    }

    int getStartLevel() {
        if (this.archive != null) {
            return this.archive.getStartLevel();
        }
        return 0;
    }

    void setStartLevel(int n) {
        if (this.archive != null) {
            try {
                this.archive.setStartLevel(n);
            }
            catch (Exception e) {
                this.fwCtx.listeners.frameworkError(this, (Throwable)new BundleException("Failed to set start level on #" + this.id, e));
            }
        }
    }

    public String toString() {
        return this.toString(0);
    }

    String toString(int detail) {
        StringBuffer sb = new StringBuffer();
        sb.append("BundleImpl[");
        sb.append("id=" + this.getBundleId());
        if (detail > 0) {
            sb.append(", state=" + this.getState());
        }
        if (detail > 1) {
            sb.append(", startlevel=" + this.getStartLevel());
        }
        if (detail > 3) {
            try {
                sb.append(", autostart setting=");
                sb.append(this.getAutostartSetting());
            }
            catch (Exception e) {
                sb.append(e.toString());
            }
        }
        if (detail > 4) {
            sb.append(", loc=" + this.location);
        }
        if (detail > 4) {
            sb.append(", symName=" + this.symbolicName);
        }
        sb.append("]");
        return sb.toString();
    }

    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        if (this.secure.okResourceAdminPerm(this)) {
            if (this.state == 2 && !this.fwCtx.bundles.getFragmentBundles(this).isEmpty()) {
                this.getUpdatedState();
            }
            return this.secure.callFindEntries0(this, path, filePattern, recurse);
        }
        return null;
    }

    Enumeration findEntries0(String path, String filePattern, boolean recurse) {
        Vector res = new Vector();
        this.addResourceEntries(res, path, filePattern, recurse);
        if (this.isFragmentHost()) {
            Iterator i = ((AbstractList)this.fragments).iterator();
            while (i.hasNext()) {
                BundleImpl fb = (BundleImpl)i.next();
                fb.addResourceEntries(res, path, filePattern, recurse);
            }
        }
        return res.size() != 0 ? res.elements() : null;
    }

    void addResourceEntries(Vector res, String path, String pattern, boolean recurse) {
        Enumeration e = this.archive.findResourcesPath(path);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL url;
                String fp = (String)e.nextElement();
                boolean isDirectory = fp.endsWith("/");
                int searchBackwardFrom = fp.length() - 1;
                if (isDirectory) {
                    --searchBackwardFrom;
                }
                int l = fp.lastIndexOf(47, searchBackwardFrom);
                String lastComponentOfPath = fp.substring(l + 1, searchBackwardFrom + 1);
                if ((pattern == null || Util.filterMatch(pattern, lastComponentOfPath)) && (url = this.getURL(-1L, -1L, -1, fp)) != null) {
                    res.add(url);
                }
                if (!isDirectory || !recurse) continue;
                this.addResourceEntries(res, fp, pattern, recurse);
            }
        }
    }

    public URL getEntry(String name) {
        if (this.secure.okResourceAdminPerm(this)) {
            this.checkUninstalled();
            try {
                if ("/".equals(name)) {
                    return this.getURL(-1L, -1L, -1, "/");
                }
                BundleResourceStream is = this.secure.callGetBundleResourceStream(this.archive, name, 0);
                if (is != null) {
                    ((InputStream)is).close();
                    return this.getURL(-1L, -1L, -1, name);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public Enumeration getEntryPaths(String path) {
        if (this.secure.okResourceAdminPerm(this)) {
            this.checkUninstalled();
            return this.secure.callFindResourcesPath(this.archive, path);
        }
        return null;
    }

    private Dictionary getLocaleDictionary(String locale, String baseName) {
        String defaultLocale = Locale.getDefault().toString();
        if (locale == null) {
            locale = defaultLocale;
        } else if (locale.equals("")) {
            return null;
        }
        Hashtable localization_entries = new Hashtable();
        this.readLocalization("", localization_entries, baseName);
        this.readLocalization(Locale.getDefault().toString(), localization_entries, baseName);
        if (!locale.equals(defaultLocale)) {
            this.readLocalization(locale, localization_entries, baseName);
        }
        return localization_entries;
    }

    private HeaderDictionary localize(HeaderDictionary localized, Dictionary localization_entries) {
        if (localization_entries != null) {
            Enumeration e = localized.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String unlocalizedEntry = (String)localized.get(key);
                if (!unlocalizedEntry.startsWith("%")) continue;
                String k = unlocalizedEntry.substring(1);
                String val = (String)localization_entries.get(k);
                if (val == null) {
                    localized.put(key, k);
                    continue;
                }
                localized.put(key, val);
            }
        }
        return localized;
    }

    protected void readLocalization(String locale, Hashtable localization_entries, String baseName) {
        if (baseName == null) {
            baseName = "OSGI-INF/l10n/bundle";
        }
        if (!locale.equals("")) {
            locale = "_" + locale;
        }
        BundleClassLoader cl = null;
        if ((this.state & 0x3C) != 0) {
            if (this.isFragment()) {
                Iterator i = this.fragment.getHosts();
                BundleImpl best = null;
                while (i.hasNext()) {
                    BundleImpl b = (BundleImpl)i.next();
                    if (best != null && b.version.compareTo(best.version) <= 0) continue;
                    best = b;
                }
                if (best == this.fwCtx.systemBundle) {
                    best.readLocalization(locale, localization_entries, baseName);
                    return;
                }
                cl = (BundleClassLoader)best.getClassLoader();
            } else {
                cl = (BundleClassLoader)this.classLoader;
            }
        }
        while (true) {
            String l = baseName + locale + ".properties";
            Hashtable res = cl != null ? cl.getLocalizationEntries(l) : this.archive.getLocalizationEntries(l);
            if (res != null) {
                localization_entries.putAll(res);
                break;
            }
            int pos = locale.lastIndexOf(95);
            if (pos == -1) break;
            locale = locale.substring(0, pos);
        }
    }

    public Dictionary getHeaders(String locale) {
        this.secure.checkMetadataAdminPerm(this);
        return this.secure.callGetHeaders0(this, locale);
    }

    HeaderDictionary getHeaders0(String locale) {
        BundleArchive tmpArchive = this.archive;
        HeaderDictionary tmp = this.cachedRawHeaders;
        if (tmp == null) {
            this.cachedRawHeaders = tmp = tmpArchive.getUnlocalizedAttributes();
        }
        if ("".equals(locale)) {
            return (HeaderDictionary)tmp.clone();
        }
        if (this.cachedHeaders == null) {
            block7: {
                String base = (String)tmp.get("Bundle-Localization");
                try {
                    HeaderDictionary res = this.localize((HeaderDictionary)tmp.clone(), this.getLocaleDictionary(locale, base));
                    if (tmpArchive == this.archive) {
                        return res;
                    }
                }
                catch (Exception e) {
                    if (tmpArchive != this.archive) break block7;
                    throw (RuntimeException)e;
                }
            }
            if (this.cachedHeaders == null) {
                return this.getHeaders0(locale);
            }
        }
        return (HeaderDictionary)this.cachedHeaders.clone();
    }

    private void modified() {
        this.lastModified = System.currentTimeMillis();
        if (this.archive != null) {
            try {
                this.archive.setLastModified(this.lastModified);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Enumeration getResources(String name) throws IOException {
        ClassLoader cl0;
        this.checkUninstalled();
        if (this.secure.okResourceAdminPerm(this) && !this.isFragment() && this.getUpdatedState() != 2 && (cl0 = this.classLoader) != null) {
            Enumeration e = cl0 instanceof BundleClassLoader ? ((BundleClassLoader)cl0).getResourcesOSGi(name) : cl0.getResources(name);
            return e != null && e.hasMoreElements() ? e : null;
        }
        return null;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (this.secure.okClassAdminPerm(this)) {
            this.checkUninstalled();
            if (this.isFragment()) {
                throw new ClassNotFoundException("Can not load classes from fragment/extension bundles");
            }
            if (this.getUpdatedState() == 2) {
                throw new ClassNotFoundException(this.resolveFailException.getMessage());
            }
            ClassLoader cl = this.classLoader;
            if (cl == null) {
                throw new IllegalStateException("state is uninstalled?");
            }
            return cl.loadClass(name);
        }
        throw new ClassNotFoundException("No AdminPermission to get class: " + name);
    }

    boolean isFragment() {
        return this.fragment != null;
    }

    boolean isExtension() {
        return this.isFragment() && this.fragment.extension != null;
    }

    boolean extensionNeedsRestart() {
        return this.isExtension() && (this.state & 3) != 0;
    }

    boolean isBootClassPathExtension() {
        return this.isExtension() && this.fragment.extension.equals("bootclasspath");
    }

    boolean isAttached() {
        return this.isFragment() && this.fragment.hasHosts();
    }

    String getFragmentHostName() {
        if (this.isFragment()) {
            return this.fragment.hostName;
        }
        return null;
    }

    boolean isFragmentHost() {
        return this.fragments != null && this.fragments.size() > 0;
    }

    void attachFragments() {
        List hosting;
        if (!this.attachPolicy.equals("never") && (hosting = this.fwCtx.bundles.getFragmentBundles(this)).size() > 0 && this.secure.okHostBundlePerm(this)) {
            Iterator iter = hosting.iterator();
            while (iter.hasNext()) {
                BundleImpl fb = (BundleImpl)iter.next();
                fb.resolveFragment(this);
            }
        }
    }

    void attachFragment(BundleImpl fragmentBundle) {
        int i;
        this.checkUninstalled();
        if (this.attachPolicy.equals("never")) {
            throw new IllegalStateException("Bundle does not allow fragments to attach");
        }
        if (this.attachPolicy.equals("resolve-time") && (this.state & 0x3C) != 0) {
            throw new IllegalStateException("Bundle does not allow fragments to attach dynamicly");
        }
        String failReason = this.bpkgs.attachFragment(fragmentBundle.bpkgs);
        if (failReason != null) {
            throw new IllegalStateException(failReason);
        }
        if (this.fwCtx.debug.packages) {
            this.fwCtx.debug.println("Fragment(id=" + fragmentBundle.getBundleId() + ") attached to host(id=" + this.bpkgs.bundle.id + ",gen=" + this.bpkgs.generation + ")");
        }
        if (this.fragments == null) {
            this.fragments = new ArrayList();
        }
        for (i = 0; i < this.fragments.size(); ++i) {
            BundleImpl b = (BundleImpl)this.fragments.get(i);
            if (b.id > fragmentBundle.id) break;
        }
        this.fragments.add(i, fragmentBundle);
    }

    Iterator getFragments() {
        return this.fragments == null ? ((AbstractList)new ArrayList(0)).iterator() : ((AbstractList)this.fragments).iterator();
    }

    private void detachFragments() {
        if (this.fragments != null) {
            while (this.fragments.size() > 0) {
                this.detachFragment((BundleImpl)this.fragments.get(0));
            }
        }
    }

    private void detachFragment(BundleImpl fb) {
        if (((AbstractCollection)this.fragments).remove(fb)) {
            this.bpkgs.detachFragment(fb);
            if (this.fwCtx.debug.packages) {
                this.fwCtx.debug.println("Fragment(id=" + fb.getBundleId() + ") detached from host(id=" + this.bpkgs.bundle.id + ",gen=" + this.bpkgs.generation + ")");
            }
            if (fb.state != 1) {
                fb.fragment.removeHost(this);
                if (!fb.fragment.hasHosts()) {
                    fb.setStateInstalled(true);
                }
            }
        }
    }

    private void checkUninstalled() {
        if (this.state == 1) {
            throw new IllegalStateException("Bundle is in UNINSTALLED state");
        }
    }

    private boolean isPkgActivationTrigger(String packageName) {
        return this.lazyIncludes == null && this.lazyExcludes == null || this.lazyIncludes != null && this.lazyIncludes.contains(packageName) || this.lazyExcludes != null && !this.lazyExcludes.contains(packageName);
    }

    boolean triggersActivationPkg(String pkg) {
        return 16 != this.fwCtx.systemBundle.getState() && this.state == 8 && this.operation != 1 && this.lazyActivation && this.isPkgActivationTrigger(pkg);
    }

    boolean triggersActivationCls(String name) {
        if (16 != this.fwCtx.systemBundle.getState() && this.state == 8 && this.operation != 1 && this.lazyActivation) {
            String pkg = "";
            int pos = name.lastIndexOf(46);
            if (pos != -1) {
                pkg = name.substring(0, pos);
            }
            return this.isPkgActivationTrigger(pkg);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BundleThread bundleThread() {
        LinkedList linkedList = this.fwCtx.bundleThreads;
        synchronized (linkedList) {
            if (this.fwCtx.bundleThreads.isEmpty()) {
                return this.secure.createBundleThread(this.fwCtx);
            }
            return (BundleThread)this.fwCtx.bundleThreads.removeFirst();
        }
    }

    class Fragment {
        final String hostName;
        final String extension;
        final VersionRange versionRange;
        private List hosts = new ArrayList(2);

        Fragment(String hostName, String extension, String range) {
            this.hostName = hostName;
            this.extension = extension;
            this.versionRange = range == null ? VersionRange.defaultVersionRange : new VersionRange(range);
        }

        void addHost(BundleImpl host) {
            this.hosts.add(host);
        }

        void removeHost(BundleImpl host) {
            if (host == null) {
                this.hosts.clear();
            } else {
                this.hosts.remove(host);
            }
        }

        boolean isHost(BundleImpl host) {
            return this.hosts.contains(host);
        }

        Iterator getHosts() {
            return this.hosts.iterator();
        }

        boolean hasHosts() {
            return !this.hosts.isEmpty();
        }

        Bundle[] hostsArray() {
            return this.hosts.toArray(new Bundle[this.hosts.size()]);
        }

        boolean isTarget(BundleImpl b) {
            return this.hostName.equals(b.symbolicName) && this.versionRange.withinRange(b.version);
        }

        List targets() {
            List bundles = BundleImpl.this.fwCtx.bundles.getBundles(this.hostName, this.versionRange);
            Iterator iter = bundles.iterator();
            while (iter.hasNext()) {
                BundleImpl t = (BundleImpl)iter.next();
                if (t.state != 1 && !t.attachPolicy.equals("never")) continue;
                iter.remove();
            }
            if (bundles.isEmpty()) {
                return null;
            }
            return bundles;
        }
    }
}

