/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.List;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.ServiceReferenceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class BundleContextImpl
implements BundleContext {
    final BundleImpl bundle;
    private boolean valid = true;

    public BundleContextImpl(BundleImpl bundle) {
        this.bundle = bundle;
    }

    public String getProperty(String key) {
        this.checkValid();
        return this.bundle.fwCtx.props.getProperty(key);
    }

    public Bundle installBundle(String location) throws BundleException {
        this.checkValid();
        return this.bundle.fwCtx.bundles.install(location, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle installBundle(String location, InputStream in) throws BundleException {
        BundleImpl bundleImpl;
        block5: {
            try {
                this.checkValid();
                bundleImpl = this.bundle.fwCtx.bundles.install(location, in);
                Object var5_4 = null;
                if (in == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_5 = null;
                    if (in == null) break block6;
                    try {
                        in.close();
                    }
                    catch (IOException ignore) {}
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return bundleImpl;
    }

    public Bundle getBundle() {
        this.checkValid();
        return this.bundle;
    }

    public Bundle getBundle(long id) {
        return this.bundle.fwCtx.bundles.getBundle(id);
    }

    public Bundle[] getBundles() {
        List bl = this.bundle.fwCtx.bundles.getBundles();
        return bl.toArray(new Bundle[bl.size()]);
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.checkValid();
        this.bundle.fwCtx.listeners.addServiceListener(this, listener, filter);
    }

    public void addServiceListener(ServiceListener listener) {
        this.checkValid();
        try {
            this.bundle.fwCtx.listeners.addServiceListener(this, listener, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    public void removeServiceListener(ServiceListener listener) {
        this.checkValid();
        this.bundle.fwCtx.listeners.removeServiceListener(this, listener);
    }

    public void addBundleListener(BundleListener listener) {
        this.checkValid();
        this.bundle.fwCtx.listeners.addBundleListener(this, listener);
    }

    public void removeBundleListener(BundleListener listener) {
        this.checkValid();
        this.bundle.fwCtx.listeners.removeBundleListener(this, listener);
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.checkValid();
        this.bundle.fwCtx.listeners.addFrameworkListener(this, listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.checkValid();
        this.bundle.fwCtx.listeners.removeFrameworkListener(this, listener);
    }

    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        this.checkValid();
        String[] classes = (String[])clazzes.clone();
        return this.bundle.fwCtx.services.register(this.bundle, classes, service, properties);
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        this.checkValid();
        String[] classes = new String[]{clazz};
        return this.bundle.fwCtx.services.register(this.bundle, classes, service, properties);
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValid();
        return this.bundle.fwCtx.services.get(clazz, filter, this.bundle);
    }

    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValid();
        return this.bundle.fwCtx.services.get(clazz, filter, null);
    }

    public ServiceReference getServiceReference(String clazz) {
        this.checkValid();
        return this.bundle.fwCtx.services.get(this.bundle, clazz);
    }

    public Object getService(ServiceReference reference) {
        this.checkValid();
        if (reference == null) {
            throw new NullPointerException("null ServiceReference is not valid input to getService()");
        }
        return ((ServiceReferenceImpl)reference).getService(this.bundle);
    }

    public boolean ungetService(ServiceReference reference) {
        this.checkValid();
        if (reference == null) {
            throw new NullPointerException("null ServiceReference is not valid input to ungetService()");
        }
        return ((ServiceReferenceImpl)reference).ungetService(this.bundle, true);
    }

    public File getDataFile(String filename) {
        this.checkValid();
        File dataRoot = this.bundle.getDataRoot();
        if (dataRoot != null) {
            if (!dataRoot.exists()) {
                dataRoot.mkdirs();
            }
            return new File(dataRoot, filename);
        }
        return null;
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        this.checkValid();
        return FrameworkUtil.createFilter(filter);
    }

    void invalidate() {
        this.valid = false;
    }

    boolean isValid() {
        return this.valid;
    }

    private void checkValid() {
        if (!this.valid) {
            throw new IllegalStateException("This bundle context is no longer valid");
        }
    }
}

