/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.knopflerfish.framework.Alias;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundleResourceStream;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.FWProps;
import org.knopflerfish.framework.FileArchive;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.VersionRange;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class BundleClassPath {
    private final FWProps props;
    private ArrayList archives = new ArrayList(4);
    private Map nativeLibs;
    private Debug debug;
    private long bid;

    BundleClassPath(BundleArchive ba, List frags, FrameworkContext fwCtx) throws BundleException {
        Iterator i;
        this.props = fwCtx.props;
        this.debug = fwCtx.debug;
        this.bid = ba.getBundleId();
        this.checkBundleArchive(ba, frags);
        if (frags != null) {
            i = frags.iterator();
            while (i.hasNext()) {
                this.checkBundleArchive(((BundleImpl)i.next()).archive, null);
            }
        }
        this.resolveNativeCode(ba, false);
        if (frags != null) {
            i = frags.iterator();
            while (i.hasNext()) {
                this.resolveNativeCode(((BundleImpl)i.next()).archive, true);
            }
        }
    }

    Vector componentExists(String component, boolean onlyFirst) {
        Vector v;
        block9: {
            block7: {
                block8: {
                    v = null;
                    if (component.startsWith("/")) {
                        component = component.substring(1);
                    }
                    if (this.debug.classLoader) {
                        this.debug.println(this + "compentExists: " + component);
                    }
                    if (0 != component.length()) break block7;
                    if (!onlyFirst) break block8;
                    v = new Vector(1);
                    v.addElement(this.archives.get(0));
                    if (!this.debug.classLoader) break block9;
                    this.debug.println(this + "compentExists added first top in classpath.");
                    break block9;
                }
                v = new Vector(this.archives);
                if (!this.debug.classLoader) break block9;
                this.debug.println(this + "compentExists added all tops in classpath.");
                break block9;
            }
            Iterator i = ((AbstractList)this.archives).iterator();
            while (i.hasNext()) {
                FileArchive fa = (FileArchive)i.next();
                BundleResourceStream ai = fa.getBundleResourceStream(component);
                if (ai == null) continue;
                if (v == null) {
                    v = new Vector();
                }
                v.addElement(fa);
                if (this.debug.classLoader) {
                    this.debug.println(this + "compentExists added: " + fa);
                }
                try {
                    ((InputStream)ai).close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                if (!onlyFirst) continue;
                break;
            }
        }
        return v;
    }

    InputStream getInputStream(String component, int ix) {
        if (component.startsWith("/")) {
            component = component.substring(1);
        }
        return ((FileArchive)this.archives.get(ix)).getBundleResourceStream(component);
    }

    String getNativeLibrary(String libName) {
        if (this.debug.classLoader) {
            this.debug.println(this + "getNativeLibrary: lib=" + libName);
        }
        if (this.nativeLibs != null) {
            FileArchive fa;
            String key = System.mapLibraryName(libName);
            if (this.debug.classLoader) {
                this.debug.println(this + "getNativeLibrary: try, " + key);
            }
            if ((fa = (FileArchive)this.nativeLibs.get(key)) == null) {
                String libExtensions = this.props.getProperty("org.osgi.framework.library.extensions");
                int pos = key.lastIndexOf(".");
                if (libExtensions.length() > 0 && pos > -1) {
                    String baseKey = key.substring(0, pos + 1);
                    String[] exts = Util.splitwords(libExtensions, ", \t");
                    for (int i = 0; i < exts.length; ++i) {
                        key = baseKey + exts[i];
                        if (this.debug.classLoader) {
                            this.debug.println(this + "getNativeLibrary: try, " + key);
                        }
                        if ((fa = (FileArchive)this.nativeLibs.get(key)) != null) break;
                    }
                }
                if (fa == null) {
                    return null;
                }
            }
            if (this.debug.classLoader) {
                this.debug.println(this + "getNativeLibrary: got, " + fa);
            }
            return fa.getNativeLibrary(key);
        }
        return null;
    }

    public String toString() {
        return "BundleClassPath(#" + this.bid + ").";
    }

    private void checkBundleArchive(BundleArchive ba, List frags) {
        String bcp = ba.getAttribute("Bundle-ClassPath");
        if (bcp != null) {
            StringTokenizer st = new StringTokenizer(bcp, ",");
            while (st.hasMoreTokens()) {
                String path = st.nextToken().trim();
                FileArchive a = ba.getFileArchive(path);
                if (a == null && frags != null) {
                    Iterator i = frags.iterator();
                    while (i.hasNext() && (a = ((BundleImpl)i.next()).archive.getFileArchive(path)) == null) {
                    }
                }
                if (a != null) {
                    this.archives.add(a);
                    if (!this.debug.classLoader) continue;
                    this.debug.println(this + "- Added path entry: " + a);
                    continue;
                }
                if (!this.debug.classLoader) continue;
                this.debug.println(this + "- Failed to find class path entry: " + path);
            }
        } else {
            this.archives.add(ba.getFileArchive("."));
        }
    }

    private void resolveNativeCode(BundleArchive ba, boolean isFrag) throws BundleException {
        String bnc = ba.getAttribute("Bundle-NativeCode");
        if (bnc != null) {
            ArrayList<String> proc = new ArrayList<String>(3);
            String procP = this.props.getProperty("org.osgi.framework.processor");
            proc.add(this.props.getProperty("org.osgi.framework.processor").toLowerCase());
            String procS = System.getProperty("os.arch").toLowerCase();
            if (procP.equals(procS)) {
                proc.add(procS);
            }
            if (procP.startsWith("arm_")) {
                proc.add("arm");
            }
            ArrayList<String> os = new ArrayList<String>();
            String osP = this.props.getProperty("org.osgi.framework.os.name").toLowerCase();
            os.add(osP);
            String osS = System.getProperty("os.name").toLowerCase();
            if (!osS.equals(osP)) {
                os.add(osS);
            } else {
                osS = null;
            }
            for (int i = 0; i < Alias.osNameAliases.length; ++i) {
                if (!osP.equalsIgnoreCase(Alias.osNameAliases[i][0])) continue;
                for (int j = 1; j < Alias.osNameAliases[i].length; ++j) {
                    if (osS == null || !osS.equals(Alias.osNameAliases[i][j])) {
                        os.add(Alias.osNameAliases[i][j]);
                        continue;
                    }
                    osS = null;
                }
                break;
            }
            Version osVer = new Version(this.props.getProperty("org.osgi.framework.os.version"));
            String osLang = this.props.getProperty("org.osgi.framework.language");
            boolean optional = false;
            List best = null;
            VersionRange bestVer = null;
            boolean bestLang = false;
            Iterator i = Util.parseEntries("Bundle-NativeCode", bnc, false, false, false);
            while (i.hasNext()) {
                List keys;
                boolean matchLang;
                VersionRange matchVer;
                block31: {
                    List sf;
                    List lang;
                    List ol;
                    matchVer = null;
                    matchLang = false;
                    Map params = (Map)i.next();
                    keys = (List)params.get("$keys");
                    if (keys.size() == 1 && "*".equals(keys.get(0)) && !i.hasNext()) {
                        optional = true;
                        break;
                    }
                    List pl = (List)params.get("processor");
                    if (pl == null || !this.containsIgnoreCase(proc, pl) || (ol = (List)params.get("osname")) == null || !this.containsIgnoreCase(os, ol)) continue;
                    List ver = (List)params.get("osversion");
                    if (ver != null) {
                        boolean okVer = false;
                        Iterator v = ver.iterator();
                        while (v.hasNext()) {
                            matchVer = new VersionRange((String)v.next());
                            if (!matchVer.withinRange(osVer)) continue;
                            okVer = true;
                            break;
                        }
                        if (!okVer) continue;
                    }
                    if ((lang = (List)params.get("language")) != null) {
                        Iterator l = lang.iterator();
                        while (l.hasNext()) {
                            if (!osLang.equalsIgnoreCase((String)l.next())) continue;
                            matchLang = true;
                            break;
                        }
                        if (!matchLang) continue;
                    }
                    if ((sf = (List)params.get("selection-filter")) != null) {
                        String sfs = (String)sf.get(0);
                        if (sf.size() == 1) {
                            try {
                                if (!FrameworkUtil.createFilter(sfs).match(this.props.getProperties())) {
                                    continue;
                                }
                                break block31;
                            }
                            catch (InvalidSyntaxException ise) {
                                throw new BundleException("Invalid syntax for native code selection filter: " + sfs, 8, ise);
                            }
                        }
                        throw new BundleException("Invalid character after native code selection filter: " + sfs, 8);
                    }
                }
                if (best != null) {
                    boolean verEqual = false;
                    if (bestVer != null) {
                        if (matchVer == null) continue;
                        int d = bestVer.compareTo(matchVer);
                        if (d == 0) {
                            verEqual = true;
                        } else if (d > 0) {
                            continue;
                        }
                    } else if (matchVer == null) {
                        verEqual = true;
                    }
                    if (verEqual && (!matchLang || bestLang)) continue;
                }
                best = keys;
                bestVer = matchVer;
                bestLang = matchLang;
            }
            if (best == null) {
                if (optional) {
                    return;
                }
                throw new BundleException("No matching native code libraries found.", 8);
            }
            this.nativeLibs = new HashMap();
            Iterator p = best.iterator();
            block7: while (p.hasNext()) {
                String name = (String)p.next();
                Iterator i2 = ((AbstractList)this.archives).iterator();
                while (i2.hasNext()) {
                    String key;
                    FileArchive fa = (FileArchive)i2.next();
                    if (isFrag && fa.getBundleId() != ba.getBundleId() || (key = fa.checkNativeLibrary(name)) == null) continue;
                    this.nativeLibs.put(key, fa);
                    if (!this.debug.classLoader) continue block7;
                    this.debug.println(this + "- Registered native library: " + key + " -> " + fa);
                    continue block7;
                }
                throw new BundleException("Failed to resolve native code: " + name, 8);
            }
        } else {
            this.nativeLibs = null;
        }
    }

    private boolean containsIgnoreCase(List fl, List l) {
        Iterator i = l.iterator();
        while (i.hasNext()) {
            String s = ((String)i.next()).toLowerCase();
            Iterator j = fl.iterator();
            while (j.hasNext()) {
                if (!Util.filterMatch((String)j.next(), s)) continue;
                return true;
            }
        }
        return false;
    }
}

