/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleClassPath;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.ClassPatcher;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.FileArchive;
import org.knopflerfish.framework.PermissionOps;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;

public final class BundleClassLoader
extends ClassLoader
implements BundleReference {
    private final ClassLoader parent;
    final PermissionOps secure;
    final ProtectionDomain protectionDomain;
    BundleArchive archive;
    BundlePackages bpkgs;
    private BundleClassPath classPath;
    private ArrayList fragments;
    private static ThreadLocal tlBundlesToActivate = new ThreadLocal();
    private static Constructor dexFileClassCons;
    private static Method dexFileClassLoadClassMethod;
    static boolean bDalvik;
    private Object dexFile = null;
    Debug debug;
    static boolean bHasASM;
    static boolean bHasCheckedASM;
    protected static SecurityManagerExposer smex;
    static final SearchAction classSearch;
    static final SearchAction resourceSearch;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$reflect$Proxy;
    static /* synthetic */ Class class$org$knopflerfish$framework$BundleClassLoader;
    static /* synthetic */ Class class$org$osgi$framework$Bundle;

    BundleClassLoader(BundlePackages bpkgs, BundleArchive ba, ArrayList frags, ProtectionDomain pd, PermissionOps secure) throws BundleException {
        super(bpkgs.bundle.fwCtx.parentClassLoader);
        this.debug = bpkgs.bundle.fwCtx.debug;
        this.parent = bpkgs.bundle.fwCtx.parentClassLoader;
        this.secure = secure;
        this.protectionDomain = pd;
        this.bpkgs = bpkgs;
        this.archive = ba;
        this.fragments = frags;
        this.classPath = new BundleClassPath(ba, frags, bpkgs.bundle.fwCtx);
        if (this.debug.classLoader) {
            this.debug.println(this + " Created new classloader");
        }
    }

    boolean isBundlePatch() {
        if (!bHasCheckedASM) {
            try {
                Class.forName("org.objectweb.asm.ClassReader");
                bHasASM = true;
            }
            catch (Exception no_asm_class) {
                bHasASM = false;
            }
            bHasCheckedASM = true;
            if (this.debug.patch) {
                this.debug.println("ASM library: " + bHasASM);
            }
        }
        return bHasASM && this.bpkgs.bundle.fwCtx.props.getBooleanProperty("org.knopflerfish.framework.patch");
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String pkg;
        String path;
        int pos;
        if (name.startsWith("java.")) {
            return this.parent.loadClass(name);
        }
        if (this.bpkgs.bundle.fwCtx.isBootDelegated(name)) {
            try {
                Class<?> bootDelegationCls = this.parent.loadClass(name);
                if (this.debug.classLoader && bootDelegationCls != null) {
                    this.debug.println(this + " findClass: " + name + " boot delegation: " + bootDelegationCls);
                }
                return bootDelegationCls;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if ((pos = name.lastIndexOf(46)) != -1) {
            path = name.replace('.', '/');
            pkg = name.substring(0, pos);
        } else {
            path = name;
            pkg = null;
        }
        Class<?> res = (Class<?>)this.secure.callSearchFor(this, name, pkg, path + ".class", classSearch, true, this, null);
        if (res != null) {
            return res;
        }
        if (!this.bpkgs.bundle.fwCtx.props.STRICTBOOTCLASSLOADING && this.isBootClassContext(name)) {
            if (this.debug.classLoader) {
                this.debug.println(this + " trying parent loader for class=" + name + ", since it was loaded on the system loader itself");
            }
            if ((res = this.parent.loadClass(name)) != null && this.debug.classLoader) {
                this.debug.println(this + " loaded " + name + " from " + this.parent);
            }
            return res;
        }
        throw new ClassNotFoundException(name);
    }

    protected String findLibrary(String name) {
        String res = this.secure.callFindLibrary0(this, name);
        if (this.debug.classLoader) {
            this.debug.println(this + " Find library: " + name + (res != null ? " OK" : " FAIL"));
        }
        return res;
    }

    protected Enumeration findResources(String name) {
        return this.getBundleResources(name, false);
    }

    protected URL findResource(String name) {
        Enumeration res = this.getBundleResources(name, true);
        if (res != null) {
            return (URL)res.nextElement();
        }
        return null;
    }

    private boolean isNonBundleClass(Class cls) {
        return this.getClass().getClassLoader() != cls.getClassLoader() && !(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = BundleClassLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).isAssignableFrom(cls) && !(class$java$lang$Class == null ? (class$java$lang$Class = BundleClassLoader.class$("java.lang.Class")) : class$java$lang$Class).equals(cls) && !(class$java$lang$reflect$Proxy == null ? (class$java$lang$reflect$Proxy = BundleClassLoader.class$("java.lang.reflect.Proxy")) : class$java$lang$reflect$Proxy).equals(cls);
    }

    public boolean isBootClassContext(String name) {
        Class[] classStack = smex.getClassContext();
        for (int i = 1; i < classStack.length; ++i) {
            ClassLoader currentCL;
            Class currentCls = classStack[i];
            if (!this.isNonBundleClass(currentCls)) continue;
            ClassLoader cl = currentCL = currentCls.getClassLoader();
            while (cl != null && cl != cl.getClass().getClassLoader()) {
                if ((class$org$knopflerfish$framework$BundleClassLoader == null ? BundleClassLoader.class$("org.knopflerfish.framework.BundleClassLoader") : class$org$knopflerfish$framework$BundleClassLoader).isInstance(cl)) {
                    return false;
                }
                cl = cl.getClass().getClassLoader();
            }
            return !(class$org$osgi$framework$Bundle == null ? (class$org$osgi$framework$Bundle = BundleClassLoader.class$("org.osgi.framework.Bundle")) : class$org$osgi$framework$Bundle).isInstance(classStack[i - 1]);
        }
        return false;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        BundleImpl b;
        Class c = this.findLoadedClass(name);
        if (c == null) {
            c = this.findClass(name);
        } else if (this.secure.getClassLoaderOf(c) == this && (b = (BundleImpl)this.getBundle()).triggersActivationCls(name)) {
            ArrayList bundlesToActivate;
            if (this.debug.lazy_activation) {
                this.debug.println(this + " lazy activation of #" + b.id + " triggered by loadClass(" + name + ")");
            }
            if (null == (bundlesToActivate = (ArrayList)tlBundlesToActivate.get())) {
                if (this.debug.lazy_activation) {
                    this.debug.println(this + " requesting lazy activation of #" + b.id);
                }
                try {
                    this.secure.callFinalizeActivation(b);
                }
                catch (BundleException e) {
                    b.fwCtx.listeners.frameworkError(b, (Throwable)e);
                }
            } else {
                boolean bundlePresent = false;
                int size = bundlesToActivate.size();
                for (int i = 0; i < size; ++i) {
                    BundleImpl tmp = (BundleImpl)bundlesToActivate.get(i);
                    if (tmp.id != b.id) continue;
                    bundlePresent = true;
                    break;
                }
                if (!bundlePresent) {
                    bundlesToActivate.add(b);
                    if (this.debug.lazy_activation) {
                        this.debug.println(this + " added #" + b.id + " to list of bundles to be activated.");
                    }
                }
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public URL getResource(String name) {
        if (this.debug.classLoader) {
            this.debug.println(this + " getResource: " + name);
        }
        URL res = null;
        if (name.startsWith("java/")) {
            res = this.parent.getResource(name);
            if (this.debug.classLoader) {
                this.debug.println(this + " getResource: " + name + " file in java pkg: " + res);
            }
            return res;
        }
        if (this.bpkgs.bundle.fwCtx.isBootDelegatedResource(name) && (res = this.parent.getResource(name)) != null) {
            if (this.debug.classLoader) {
                this.debug.println(this + " getResource: " + name + " boot delegation: " + res);
            }
            return res;
        }
        res = this.findResource(name);
        if (this.debug.classLoader) {
            this.debug.println(this + " getResource: " + name + " bundle space: " + res);
        }
        return res;
    }

    public Enumeration getResourcesOSGi(String name) throws IOException {
        int start;
        if (this.debug.classLoader) {
            this.debug.println(this + " getResources: " + name);
        }
        int n = start = name.startsWith("/") ? 1 : 0;
        if (name.substring(start).startsWith("java/")) {
            return this.parent.getResources(name);
        }
        Enumeration res = null;
        if (this.bpkgs.bundle.fwCtx.isBootDelegatedResource(name)) {
            res = this.parent.getResources(name);
        }
        if (res == null || !res.hasMoreElements()) {
            res = this.findResources(name);
        }
        return res;
    }

    public InputStream getResourceAsStream(String name) {
        try {
            URL url = this.getResource(name);
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return "BundleClassLoader(id=" + this.bpkgs.bundle.id + ",gen=" + this.bpkgs.generation + ")";
    }

    public Bundle getBundle() {
        return this.bpkgs.bundle;
    }

    BundleArchive getBundleArchive(long frag) {
        if (frag >= 0L) {
            if (this.fragments != null) {
                Iterator i = ((AbstractList)this.fragments).iterator();
                while (i.hasNext()) {
                    BundleImpl b = (BundleImpl)i.next();
                    if (b.getBundleId() != frag) continue;
                    return b.archive;
                }
            }
            return null;
        }
        return this.archive;
    }

    void close() {
        this.archive = null;
        this.bpkgs.invalidateClassLoader();
        if (this.fragments != null) {
            this.fragments.clear();
            this.fragments = null;
        }
        if (this.debug.classLoader) {
            this.debug.println(this + " Cleared archives");
        }
    }

    void purge(boolean purgeArchive) {
        this.bpkgs.unregisterPackages(true);
        if (this.protectionDomain != null) {
            this.bpkgs.bundle.fwCtx.perm.purge(this.bpkgs.bundle, this.protectionDomain);
        }
        if (purgeArchive && this.archive != null) {
            this.archive.purge();
        }
        if (this.fragments != null) {
            // empty if block
        }
        this.close();
    }

    Enumeration getBundleResources(String name, boolean onlyFirst) {
        if (this.debug.classLoader) {
            this.debug.println(this + " Find bundle resource" + (onlyFirst ? "" : "s") + ": " + name);
        }
        String pkg = null;
        int pos = name.lastIndexOf(47);
        if (pos > 0) {
            int start = name.startsWith("/") ? 1 : 0;
            pkg = name.substring(start, pos).replace('/', '.');
        } else {
            pkg = null;
        }
        return (Enumeration)this.secure.callSearchFor(this, null, pkg, name, resourceSearch, onlyFirst, this, null);
    }

    Hashtable getLocalizationEntries(String name) {
        Hashtable res;
        block1: {
            BundleArchive ba;
            res = this.archive.getLocalizationEntries(name);
            if (res != null || this.fragments == null) break block1;
            Iterator i = ((AbstractList)this.fragments).iterator();
            while (i.hasNext() && (res = (ba = ((BundleImpl)i.next()).archive).getLocalizationEntries(name)) == null) {
            }
        }
        return res;
    }

    BundlePackages getBpkgs() {
        return this.bpkgs;
    }

    Object searchFor(String name, String pkg, String path, SearchAction action, boolean onlyFirst, BundleClassLoader requestor, HashSet visited) {
        try {
            BundleImpl b = (BundleImpl)this.getBundle();
            boolean initiator = false;
            ArrayList<BundleImpl> bundlesToActivate = null;
            if (action == classSearch) {
                boolean bundlePresent = false;
                bundlesToActivate = (ArrayList<BundleImpl>)tlBundlesToActivate.get();
                boolean bl = initiator = bundlesToActivate == null;
                if (initiator) {
                    bundlesToActivate = new ArrayList<BundleImpl>();
                    tlBundlesToActivate.set(bundlesToActivate);
                } else {
                    bundlePresent = bundlesToActivate.contains(b);
                }
                if (!bundlePresent && b.triggersActivationPkg(pkg)) {
                    bundlesToActivate.add(b);
                    if (this.debug.lazy_activation) {
                        this.debug.println(this + " lazy activation of #" + b.id + " triggered by searchFor(" + name + ")");
                    }
                }
            }
            Object res = this.searchFor0(name, pkg, path, action, onlyFirst, requestor, visited);
            if (initiator) {
                tlBundlesToActivate.set(null);
                for (int i = bundlesToActivate.size() - 1; i >= 0; --i) {
                    BundleImpl tmp = (BundleImpl)bundlesToActivate.get(i);
                    if (this.debug.lazy_activation) {
                        this.debug.println(this + " requesting lazy activation of #" + tmp.id);
                    }
                    try {
                        tmp.finalizeActivation();
                        continue;
                    }
                    catch (BundleException e) {
                        b.fwCtx.listeners.frameworkError(tmp, (Throwable)e);
                    }
                }
            }
            return res;
        }
        catch (Error te) {
            tlBundlesToActivate.set(null);
            throw te;
        }
    }

    Object searchFor0(String name, String pkg, String path, SearchAction action, boolean onlyFirst, BundleClassLoader requestor, HashSet visited) {
        ExportPkg ep;
        BundlePackages pbp;
        Class<?> c;
        if (action == classSearch && requestor != this && (c = this.findLoadedClass(name)) != null) {
            return c;
        }
        if (this.debug.classLoader) {
            this.debug.println(this + " Search for: " + path);
        }
        if (pkg != null) {
            pbp = this.bpkgs.getProviderBundlePackages(pkg);
            if (pbp != null) {
                if (BundleClassLoader.isSystemBundle(pbp.bundle)) {
                    try {
                        return pbp.bundle.fwCtx.systemBundle.getClassLoader().loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                    }
                } else {
                    BundleClassLoader cl = (BundleClassLoader)pbp.getClassLoader();
                    if (cl != this && (visited == null || cl != null && !visited.contains(cl))) {
                        if (cl != null) {
                            if (this.debug.classLoader) {
                                this.debug.println(this + " Import search: " + path + " from #" + pbp.bundle.id);
                            }
                            return this.secure.callSearchFor(cl, name, pkg, path, action, onlyFirst, requestor, visited);
                        }
                        if (this.debug.classLoader) {
                            this.debug.println(this + " No import found: " + path);
                        }
                        return null;
                    }
                }
            } else {
                ArrayList pl = this.bpkgs.getRequiredBundlePackages(pkg);
                if (pl != null) {
                    if (visited == null) {
                        visited = new HashSet<BundleClassLoader>();
                    }
                    visited.add(this);
                    Iterator pi = ((AbstractList)pl).iterator();
                    while (pi.hasNext()) {
                        Object res;
                        BundleClassLoader cl;
                        pbp = (BundlePackages)pi.next();
                        if (pbp == null || (cl = (BundleClassLoader)pbp.getClassLoader()) == null || visited.contains(cl)) continue;
                        if (this.debug.classLoader) {
                            this.debug.println(this + " Required bundle search: " + path + " from #" + pbp.bundle.id);
                        }
                        if ((res = this.secure.callSearchFor(cl, name, pkg, path, action, onlyFirst, requestor, visited)) == null) continue;
                        return res;
                    }
                    if (this.debug.classLoader) {
                        this.debug.println(this + " Required bundle search: " + "Not found, continuing with local search.");
                    }
                }
            }
            ep = this.bpkgs.getExport(pkg);
        } else {
            ep = null;
        }
        if (this != requestor && ep != null && !ep.checkFilter(name)) {
            return null;
        }
        Vector av = this.classPath.componentExists(path, onlyFirst);
        if (av != null) {
            try {
                return action.get(av, path, name, pkg, this);
            }
            catch (IOException ioe) {
                this.bpkgs.bundle.fwCtx.listeners.frameworkError(this.bpkgs.bundle, (Throwable)ioe);
                return null;
            }
        }
        if (ep != null) {
            return null;
        }
        if (pkg != null) {
            pbp = this.bpkgs.getDynamicProviderBundlePackages(pkg);
            if (pbp != null) {
                if (BundleClassLoader.isSystemBundle(pbp.bundle)) {
                    try {
                        return pbp.bundle.fwCtx.systemBundle.getClassLoader().loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                    }
                } else {
                    BundleClassLoader cl = (BundleClassLoader)pbp.getClassLoader();
                    if (cl != null) {
                        if (this.debug.classLoader) {
                            this.debug.println(this + " Dynamic import search: " + path + " from #" + pbp.bundle.id);
                        }
                        return this.secure.callSearchFor(cl, name, pkg, path, action, onlyFirst, requestor, visited);
                    }
                }
            }
            if (this.debug.classLoader) {
                this.debug.println(this + " No dynamic import: " + path);
            }
        }
        return null;
    }

    private static boolean isSystemBundle(BundleImpl bundle) {
        return bundle == bundle.fwCtx.systemBundle;
    }

    private Class getDexFileClass(String name) throws Exception {
        if (this.debug.classLoader) {
            this.debug.println("loading dex class " + name);
        }
        if (this.dexFile == null) {
            File f = new File(this.archive.getJarLocation());
            this.dexFile = dexFileClassCons.newInstance(f);
            if (this.debug.classLoader) {
                this.debug.println("created DexFile from " + f);
            }
        }
        String path = name.replace('.', '/');
        return (Class)dexFileClassLoadClassMethod.invoke(this.dexFile, path, this);
    }

    String findLibrary0(String name) {
        return this.classPath.getNativeLibrary(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        bDalvik = false;
        try {
            Class<?> dexFileClass;
            try {
                dexFileClass = Class.forName("android.dalvik.DexFile");
            }
            catch (Exception ex) {
                dexFileClass = Class.forName("dalvik.system.DexFile");
            }
            dexFileClassCons = dexFileClass.getConstructor(class$java$io$File == null ? (class$java$io$File = BundleClassLoader.class$("java.io.File")) : class$java$io$File);
            dexFileClassLoadClassMethod = dexFileClass.getMethod("loadClass", class$java$lang$String == null ? (class$java$lang$String = BundleClassLoader.class$("java.lang.String")) : class$java$lang$String, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = BundleClassLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            bDalvik = true;
        }
        catch (Exception e) {
            dexFileClassCons = null;
            dexFileClassLoadClassMethod = null;
        }
        bHasASM = false;
        bHasCheckedASM = false;
        smex = new SecurityManagerExposer();
        classSearch = new SearchAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object get(Vector items, String path, String name, String pkg, BundleClassLoader cl) throws IOException {
                byte[] bytes = ((FileArchive)items.get(0)).getClassBytes(path);
                if (bytes != null) {
                    if (cl.isBundlePatch()) {
                        bytes = ClassPatcher.getInstance(cl).patch(name, bytes);
                    }
                    if (cl.debug.classLoader) {
                        cl.debug.println("classLoader(#" + cl.bpkgs.bundle.id + ") - load class: " + name);
                    }
                    BundleClassLoader bundleClassLoader = cl;
                    synchronized (bundleClassLoader) {
                        Class c = cl.findLoadedClass(name);
                        if (c == null) {
                            if (pkg != null && cl.getPackage(pkg) == null) {
                                cl.definePackage(pkg, null, null, null, null, null, null, null);
                            }
                            if (bDalvik) {
                                try {
                                    c = cl.getDexFileClass(name);
                                }
                                catch (Exception e) {
                                    throw new IOException("Failed to load dex class '" + name + "', " + e);
                                }
                            }
                            if (c == null) {
                                c = cl.protectionDomain == null ? cl.defineClass(name, bytes, 0, bytes.length) : cl.defineClass(name, bytes, 0, bytes.length, cl.protectionDomain);
                            }
                        }
                        return c;
                    }
                }
                return null;
            }
        };
        resourceSearch = new SearchAction(){

            public Object get(Vector items, String path, String name, String pkg, BundleClassLoader cl) throws IOException {
                Vector<URL> answer = new Vector<URL>();
                for (int i = 0; i < items.size(); ++i) {
                    FileArchive fa = (FileArchive)items.elementAt(i);
                    URL url = cl.bpkgs.bundle.getURL(cl.bpkgs.generation, fa.getBundleId(), fa.getSubId(), path);
                    if (url != null) {
                        if (cl.debug.classLoader) {
                            cl.debug.println("classLoader(#" + cl.bpkgs.bundle.id + ") - found: " + path + " -> " + url);
                        }
                    } else {
                        return null;
                    }
                    answer.addElement(url);
                }
                return answer.elements();
            }
        };
    }

    static interface SearchAction {
        public Object get(Vector var1, String var2, String var3, String var4, BundleClassLoader var5) throws IOException;
    }

    static class SecurityManagerExposer
    extends SecurityManager {
        SecurityManagerExposer() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

