/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.service.um.useradmin.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.knopflerfish.service.um.useradmin.impl.Activator;
import org.knopflerfish.service.um.useradmin.impl.AuthorizationImpl;
import org.knopflerfish.service.um.useradmin.impl.ConditionImpl;
import org.knopflerfish.service.um.useradmin.impl.EventQueue;
import org.knopflerfish.service.um.useradmin.impl.GroupImpl;
import org.knopflerfish.service.um.useradmin.impl.LDAPQuery;
import org.knopflerfish.service.um.useradmin.impl.RoleImpl;
import org.knopflerfish.service.um.useradmin.impl.SendUserAdminEventJob;
import org.knopflerfish.service.um.useradmin.impl.UserImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.useradmin.Authorization;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;
import org.osgi.service.useradmin.UserAdmin;
import org.osgi.service.useradmin.UserAdminEvent;
import org.osgi.service.useradmin.UserAdminPermission;
import org.osgi.util.tracker.ServiceTracker;

public class UserAdminImpl
implements ServiceFactory,
UserAdmin,
ServiceListener {
    static final UserAdminPermission adminPermission = new UserAdminPermission("admin", null);
    protected ServiceReference uasr;
    protected Hashtable roles;
    protected Vector listeners;
    RoleImpl anyone;
    EventQueue eventQueue;
    ServiceTracker eventAdminTracker;
    static /* synthetic */ Class class$org$osgi$service$event$EventAdmin;
    static /* synthetic */ Class class$org$osgi$service$useradmin$UserAdminListener;

    UserAdminImpl() {
        this.revert();
        if (this.roles == null) {
            this.zap();
        }
        this.listeners = new Vector();
        this.eventAdminTracker = new ServiceTracker(Activator.bc, (class$org$osgi$service$event$EventAdmin == null ? (class$org$osgi$service$event$EventAdmin = UserAdminImpl.class$("org.osgi.service.event.EventAdmin")) : class$org$osgi$service$event$EventAdmin).getName(), null);
        this.eventQueue = new EventQueue(Activator.bc);
    }

    private void init(ServiceReference sr) {
        this.uasr = sr;
        try {
            String clazz = (class$org$osgi$service$useradmin$UserAdminListener == null ? (class$org$osgi$service$useradmin$UserAdminListener = UserAdminImpl.class$("org.osgi.service.useradmin.UserAdminListener")) : class$org$osgi$service$useradmin$UserAdminListener).getName();
            Activator.bc.addServiceListener((ServiceListener)this, "(objectClass=" + clazz + ")");
            ServiceReference[] srs = Activator.bc.getServiceReferences(clazz, null);
            if (srs != null) {
                for (int i = 0; i < srs.length; ++i) {
                    this.listeners.addElement(srs[i]);
                    if (!Activator.log.doDebug()) continue;
                    Activator.log.debug("UserAdminListener found: " + srs[i]);
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        this.eventAdminTracker.open();
        if (Activator.log.doInfo()) {
            Activator.log.info("Service initialized", this.uasr);
        }
    }

    void stop() {
        this.save();
    }

    void sendEvent(int type, Role role) {
        if (type != 2 || this.roles.get(role.getName()) != null) {
            UserAdminEvent event = new UserAdminEvent(this.uasr, type, role);
            this.eventQueue.enqueue(new SendUserAdminEventJob(Activator.bc, this.eventAdminTracker, event, this.listeners));
            if (Activator.log.doDebug()) {
                Activator.log.debug(event.toString(), this.uasr);
            }
        } else if (Activator.log.doDebug()) {
            Activator.log.debug("Event not sent, " + role.getName() + " has been removed.", this.uasr);
        }
    }

    public synchronized Object getService(Bundle bundle, ServiceRegistration registration) {
        if (this.uasr == null) {
            this.init(registration.getReference());
        }
        return this;
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    /*
     * WARNING - void declaration
     */
    public Role createRole(String name, int type) {
        void var4_4;
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(adminPermission);
        }
        if (this.roles.get(name) != null) {
            return null;
        }
        switch (type) {
            case 1: {
                RoleImpl role = new UserImpl(name);
                break;
            }
            case 2: {
                RoleImpl role = new GroupImpl(name);
                break;
            }
            case -1: {
                RoleImpl role = new ConditionImpl(name);
                break;
            }
            default: {
                throw new IllegalArgumentException("UserAdminImpl: Unknown type '" + type + "'.");
            }
        }
        this.roles.put(name, var4_4);
        this.sendEvent(1, (Role)var4_4);
        return var4_4;
    }

    public boolean removeRole(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(adminPermission);
        }
        if ("user.anyone".equals(name)) {
            return false;
        }
        RoleImpl role = (RoleImpl)this.roles.remove(name);
        if (role != null) {
            role.remove();
            this.sendEvent(4, role);
            return true;
        }
        return false;
    }

    public Role getRole(String name) {
        return (Role)this.roles.get(name);
    }

    public Role[] getRoles(String filter) throws InvalidSyntaxException {
        Vector<RoleImpl> v = new Vector<RoleImpl>();
        Enumeration en = this.roles.elements();
        while (en.hasMoreElements()) {
            RoleImpl role = (RoleImpl)en.nextElement();
            if (filter != null && !LDAPQuery.query(filter, role.getProperties())) continue;
            v.addElement(role);
        }
        Object[] result = new Role[v.size()];
        v.copyInto(result);
        return result;
    }

    public User getUser(String key, String value) {
        User[] users = this.getUsers(key, value);
        return users.length == 1 ? users[0] : null;
    }

    private User[] getUsers(String key, String value) {
        Vector<UserImpl> found = new Vector<UserImpl>();
        Enumeration en = this.roles.elements();
        while (en.hasMoreElements()) {
            UserImpl user;
            Object val;
            Object o = en.nextElement();
            if (!(o instanceof UserImpl) || !((val = (user = (UserImpl)o).getProperties().get(key)) instanceof String) || !value.equals(val)) continue;
            found.addElement(user);
        }
        Object[] result = new User[found.size()];
        found.copyInto(result);
        return result;
    }

    public Authorization getAuthorization(User user) {
        RoleImpl role = user != null ? (UserImpl)user : this.anyone;
        return new AuthorizationImpl(role);
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference sr = event.getServiceReference();
        switch (event.getType()) {
            case 1: {
                this.listeners.addElement(sr);
                if (!Activator.log.doDebug()) break;
                Activator.log.debug("UserAdminListener found: " + sr);
                break;
            }
            case 4: {
                if (!this.listeners.removeElement(sr) || !Activator.log.doDebug()) break;
                Activator.log.debug("UserAdminListener gone: " + sr);
            }
        }
    }

    protected void zap() {
        this.roles = new Hashtable();
        this.anyone = new RoleImpl("user.anyone");
        this.roles.put("user.anyone", this.anyone);
    }

    protected void revert() {
        File file;
        if (Boolean.getBoolean("org.knopflerfish.useradmin.dontsave")) {
            if (Activator.log.doDebug()) {
                Activator.log.debug("read skipped");
            }
            return;
        }
        String path = Activator.bc.getProperty("org.knopflerfish.useradmin.store");
        String oldPath = Activator.bc.getProperty("org.knopflerfish.useradmin.oldstore");
        if (path == null) {
            file = Activator.bc.getDataFile("ua_store");
        } else {
            file = new File(path);
            if (file == null || !file.exists()) {
                file = new File(oldPath);
            }
        }
        try {
            if (file != null && file.exists()) {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
                Object obj = ois.readObject();
                ois.close();
                if (obj instanceof Hashtable) {
                    this.roles = (Hashtable)obj;
                    if (null != this.roles) {
                        this.anyone = (RoleImpl)this.roles.get("user.anyone");
                        if (null == this.anyone) {
                            this.anyone = new RoleImpl("user.anyone");
                            this.roles.put("user.anyone", this.anyone);
                        }
                    }
                    if (Activator.log.doDebug()) {
                        Activator.log.debug("roles reverted");
                    }
                } else {
                    Activator.log.error("ua_store corrupted");
                }
            } else if (Activator.log.doDebug()) {
                Activator.log.debug("ua_store not found");
            }
        }
        catch (ClassNotFoundException e) {
            Activator.log.error("Failed to instantiate saved roles", (Throwable)e);
        }
        catch (IOException e) {
            Activator.log.error("Failed to read saved roles", (Throwable)e);
        }
    }

    protected void save() {
        File file;
        if (Boolean.getBoolean("org.knopflerfish.useradmin.dontsave")) {
            if (Activator.log.doDebug()) {
                Activator.log.debug("save skipped");
            }
            return;
        }
        String path = Activator.bc.getProperty("org.knopflerfish.useradmin.store");
        if (path == null) {
            file = Activator.bc.getDataFile("ua_store");
            if (file == null) {
                Activator.log.info("The platform cannot provide a data file. Cannot save roles.");
                return;
            }
        } else {
            file = new File(path);
        }
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
            oos.writeObject(this.roles);
            oos.close();
        }
        catch (IOException e) {
            Activator.log.error("Failed to save roles", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

