/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.service.um.useradmin.impl;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;
import org.knopflerfish.service.um.useradmin.impl.RoleImpl;
import org.knopflerfish.service.um.useradmin.impl.UserAdminImpl;
import org.knopflerfish.service.um.useradmin.impl.UserImpl;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;

public class GroupImpl
extends UserImpl
implements Group {
    protected Vector basicMembers = new Vector();
    protected Vector reqMembers = new Vector();

    GroupImpl(String name) {
        super(name);
    }

    boolean hasRole(String roleName, String user, Dictionary context, Vector visited) {
        if (visited.contains(this)) {
            return false;
        }
        visited.addElement(this);
        Enumeration en = this.reqMembers.elements();
        while (en.hasMoreElements()) {
            RoleImpl member = (RoleImpl)en.nextElement();
            if (member.hasMember(user, context, new Vector())) continue;
            return false;
        }
        return super.hasRole(roleName, user, context, visited);
    }

    boolean hasMember(String user, Dictionary context, Vector visited) {
        RoleImpl member;
        if (this.name.equals(user)) {
            return true;
        }
        if (visited.contains(this)) {
            return false;
        }
        visited.addElement(this);
        Enumeration en = this.reqMembers.elements();
        while (en.hasMoreElements()) {
            member = (RoleImpl)en.nextElement();
            if (member.hasMember(user, context, visited)) continue;
            return false;
        }
        en = this.basicMembers.elements();
        while (en.hasMoreElements()) {
            member = (RoleImpl)en.nextElement();
            if (!member.hasMember(user, context, visited)) continue;
            return true;
        }
        return false;
    }

    void remove() {
        RoleImpl role;
        super.remove();
        Enumeration en = this.basicMembers.elements();
        while (en.hasMoreElements()) {
            role = (RoleImpl)en.nextElement();
            role.basicMemberOf.removeElement(this);
        }
        en = this.reqMembers.elements();
        while (en.hasMoreElements()) {
            role = (RoleImpl)en.nextElement();
            role.reqMemberOf.removeElement(this);
        }
    }

    public int getType() {
        return 2;
    }

    public boolean addMember(Role role) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(UserAdminImpl.adminPermission);
        }
        if (this.basicMembers.contains(role)) {
            return false;
        }
        this.basicMembers.addElement(role);
        ((RoleImpl)role).basicMemberOf.addElement(this);
        return true;
    }

    public boolean addRequiredMember(Role role) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(UserAdminImpl.adminPermission);
        }
        if (this.reqMembers.contains(role)) {
            return false;
        }
        this.reqMembers.addElement(role);
        ((RoleImpl)role).reqMemberOf.addElement(this);
        return true;
    }

    public boolean removeMember(Role role) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(UserAdminImpl.adminPermission);
        }
        if (this.basicMembers.removeElement(role)) {
            ((RoleImpl)role).basicMemberOf.removeElement(this);
            return true;
        }
        if (this.reqMembers.removeElement(role)) {
            ((RoleImpl)role).reqMemberOf.removeElement(this);
            return true;
        }
        return false;
    }

    public Role[] getMembers() {
        Vector v = new Vector();
        Enumeration en = this.basicMembers.elements();
        while (en.hasMoreElements()) {
            v.addElement(en.nextElement());
        }
        if (v.size() == 0) {
            return null;
        }
        Object[] result = new Role[v.size()];
        v.copyInto(result);
        return result;
    }

    public Role[] getRequiredMembers() {
        Vector v = new Vector();
        Enumeration en = this.reqMembers.elements();
        while (en.hasMoreElements()) {
            v.addElement(en.nextElement());
        }
        if (v.size() == 0) {
            return null;
        }
        Object[] result = new Role[v.size()];
        v.copyInto(result);
        return result;
    }
}

