/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.service.console;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final String BLANKS = "                                                                  ";

    public static void selectBundles(Bundle[] bundles, String[] selection) {
        Util.selectBundles(bundles, selection, null);
    }

    public static void selectBundles(Bundle[] bundles, String[] selection, Set<String> selectionMatches) {
        if (selection != null) {
            for (int i = 0; i < bundles.length; ++i) {
                int j;
                String bn = Util.shortName(bundles[i]);
                String sn = Util.symbolicName(bundles[i]);
                String l = bundles[i].getLocation();
                for (j = 0; j < selection.length; ++j) {
                    try {
                        long id = Long.parseLong(selection[j]);
                        if (bundles[i].getBundleId() == id) {
                            if (null == selectionMatches) break;
                            selectionMatches.add(selection[j]);
                            break;
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (bn.equals(selection[j]) || l.equals(selection[j]) || null != sn && sn.equals(selection[j])) {
                        if (null == selectionMatches) break;
                        selectionMatches.add(selection[j]);
                        break;
                    }
                    if (selection[j].startsWith("*")) {
                        String s = selection[j].substring(1);
                        if (!bn.endsWith(s) && !l.endsWith(s) && (null == sn || !sn.endsWith(s))) continue;
                        if (null == selectionMatches) break;
                        selectionMatches.add(selection[j]);
                        break;
                    }
                    if (selection[j].endsWith("*")) {
                        String s = selection[j].substring(0, selection[j].length() - 1);
                        if (bn.startsWith(s) || null != sn && sn.startsWith(s)) {
                            if (null == selectionMatches) break;
                            selectionMatches.add(selection[j]);
                            break;
                        }
                        if (s.indexOf(58) == -1 || !l.startsWith(s)) continue;
                        if (null == selectionMatches) break;
                        selectionMatches.add(selection[j]);
                        break;
                    }
                    if (!l.endsWith(((Object)new StringBuffer().append("/").append(selection[j]).append(".jar")).toString()) && !l.endsWith(((Object)new StringBuffer().append("\\").append(selection[j]).append(".jar")).toString())) continue;
                    if (null == selectionMatches) break;
                    selectionMatches.add(selection[j]);
                    break;
                }
                if (j != selection.length) continue;
                bundles[i] = null;
            }
        }
    }

    public static void sortBundles(Bundle[] b, boolean longName) {
        int x;
        int l = x = b.length;
        while (x > 0) {
            x = 0;
            String p = null;
            if (b[0] != null) {
                p = longName ? b[0].getLocation() : Util.shortName(b[0]);
            }
            for (int i = 1; i < l; ++i) {
                String n = null;
                if (b[i] != null) {
                    String string = n = longName ? b[i].getLocation() : Util.shortName(b[i]);
                }
                if (n != null && (p == null || p.compareTo(n) > 0)) {
                    x = i - 1;
                    Bundle t = b[x];
                    b[x] = b[i];
                    b[i] = t;
                    continue;
                }
                p = n;
            }
        }
    }

    public static void sortBundlesId(Bundle[] b) {
        int x;
        int l = x = b.length;
        while (x > 0) {
            x = 0;
            long p = b[0] != null ? b[0].getBundleId() : Long.MAX_VALUE;
            for (int i = 1; i < l; ++i) {
                long n;
                long l2 = n = b[i] != null ? b[i].getBundleId() : Long.MAX_VALUE;
                if (p > n) {
                    x = i - 1;
                    Bundle t = b[x];
                    b[x] = b[i];
                    b[i] = t;
                    continue;
                }
                p = n;
            }
        }
    }

    public static void sortBundlesTime(Bundle[] b) {
        int x;
        int l = x = b.length;
        while (x > 0) {
            x = 0;
            long p = b[0] != null ? b[0].getLastModified() : Long.MAX_VALUE;
            for (int i = 1; i < l; ++i) {
                long n;
                long l2 = n = b[i] != null ? b[i].getLastModified() : Long.MAX_VALUE;
                if (p > n) {
                    x = i - 1;
                    Bundle t = b[x];
                    b[x] = b[i];
                    b[i] = t;
                    continue;
                }
                p = n;
            }
        }
    }

    public static String shortName(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        String n = (String)bundle.getHeaders().get("Bundle-Name");
        if (n == null) {
            n = bundle.getLocation();
            int x = n.lastIndexOf(47);
            int y = n.lastIndexOf(92);
            if (y > x) {
                x = y;
            }
            if (x != -1) {
                n = n.substring(x + 1);
            }
            if (n.endsWith(".jar")) {
                n = n.substring(0, n.length() - 4);
            }
        }
        return n;
    }

    public static String symbolicName(Bundle bundle) {
        int semiPos;
        if (bundle == null) {
            return null;
        }
        Dictionary d = bundle.getHeaders("");
        String bsn = (String)d.get("Bundle-SymbolicName");
        if (bsn != null && bsn.length() > 0 && -1 < (semiPos = bsn.indexOf(59))) {
            bsn = bsn.substring(0, semiPos).trim();
        }
        return bsn;
    }

    public static String showState(Bundle bundle) {
        switch (bundle.getState()) {
            case 2: {
                return "installed   ";
            }
            case 4: {
                return "resolved    ";
            }
            case 8: {
                return "starting    ";
            }
            case 32: {
                return "active      ";
            }
            case 16: {
                return "stopping    ";
            }
            case 1: {
                return "uninstalled ";
            }
        }
        return ((Object)new StringBuffer().append("ILLEGAL <").append(bundle.getState()).append("> ")).toString();
    }

    public static String showId(Bundle bundle) {
        return ((Object)new StringBuffer().append(Util.showRight(5, String.valueOf(bundle.getBundleId()))).append(" ")).toString();
    }

    public static String showServiceClasses(ServiceReference<?> sr) {
        StringBuffer sb = new StringBuffer();
        String[] c = (String[])sr.getProperty("objectClass");
        if (c.length >= 2) {
            sb.append("[");
        }
        for (int i = 0; i < c.length; ++i) {
            int x;
            if (i > 0) {
                sb.append(",");
            }
            sb.append((x = c[i].lastIndexOf(46)) != -1 ? c[i].substring(x + 1) : c[i]);
        }
        if (c.length >= 2) {
            sb.append("]");
        }
        return ((Object)sb).toString();
    }

    public static String showObject(Object o) {
        if (o == null) {
            return "null";
        }
        if (o.getClass().isArray()) {
            StringBuffer sb = new StringBuffer();
            int len = Array.getLength(o);
            sb.append("[");
            if (len > 0) {
                sb.append(Util.showObject(Array.get(o, 0)));
            }
            for (int i = 1; i < len; ++i) {
                sb.append(((Object)new StringBuffer().append(", ").append(Util.showObject(Array.get(o, i)))).toString());
            }
            sb.append("]");
            o = sb;
        } else if (o instanceof Enumeration) {
            StringBuffer sb = new StringBuffer();
            Enumeration e = (Enumeration)o;
            sb.append("[");
            if (e.hasMoreElements()) {
                sb.append(Util.showObject(e.nextElement()));
            }
            while (e.hasMoreElements()) {
                sb.append(((Object)new StringBuffer().append(", ").append(Util.showObject(e.nextElement()))).toString());
            }
            sb.append("]");
            o = sb;
        } else if (o instanceof Collection) {
            StringBuffer sb = new StringBuffer();
            Iterator it = ((Collection)o).iterator();
            sb.append("[");
            if (it.hasNext()) {
                sb.append(Util.showObject(it.next()));
            }
            while (it.hasNext()) {
                sb.append(", ");
                sb.append(Util.showObject(it.next()));
            }
            sb.append("]");
            o = sb;
        }
        return o.toString();
    }

    public static String showLeft(int width, String str) {
        if (str.length() < width) {
            return ((Object)new StringBuffer().append(str).append(BLANKS.substring(0, width - str.length()))).toString();
        }
        return str.substring(0, width);
    }

    public static String showRight(int width, String str) {
        if (str.length() < width) {
            return ((Object)new StringBuffer().append(BLANKS.substring(0, width - str.length())).append(str)).toString();
        }
        return str.substring(0, width);
    }
}

