/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.service.console;

import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import org.knopflerfish.service.console.CommandGroup;
import org.knopflerfish.service.console.Session;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandGroupAdapter
implements CommandGroup {
    public static final String COMMAND_GROUP = (class$org$knopflerfish$service$console$CommandGroup == null ? (class$org$knopflerfish$service$console$CommandGroup = CommandGroupAdapter.class$("org.knopflerfish.service.console.CommandGroup")) : class$org$knopflerfish$service$console$CommandGroup).getName();
    String groupName;
    String shortHelp;
    private static final String DOING_ARGS = "_D_";
    private static final String LAST = "_L_";
    static /* synthetic */ Class class$org$knopflerfish$service$console$CommandGroup;
    static /* synthetic */ Class class$java$util$Dictionary;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$io$PrintWriter;
    static /* synthetic */ Class class$org$knopflerfish$service$console$Session;

    public CommandGroupAdapter(String groupName, String shortHelp) {
        this.groupName = groupName;
        this.shortHelp = shortHelp;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public String getShortHelp() {
        return this.shortHelp;
    }

    @Override
    public String getLongHelp() {
        StringBuffer res = new StringBuffer();
        res.append(((Object)new StringBuffer().append("Available ").append(this.groupName).append(" commands:\n")).toString());
        TreeSet<String> helpLines = new TreeSet<String>();
        Field[] f = this.getClass().getFields();
        for (int i = 0; i < f.length; ++i) {
            String name = f[i].getName();
            if (!name.startsWith("HELP_")) continue;
            try {
                name = name.substring(5).toLowerCase();
                DynamicCmd cmd = new DynamicCmd(this, name);
                String hl = ((Object)new StringBuffer().append("  ").append(name).append(" [-help] ").append(cmd.usage).append(" - ").append(cmd.help[0]).append("\n")).toString();
                helpLines.add(hl);
                continue;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        for (String line : helpLines) {
            res.append(line);
        }
        return ((Object)res).toString();
    }

    @Override
    public int execute(String[] args, Reader in, PrintWriter out, Session session) {
        DynamicCmd cmd;
        if (args.length == 0 || args[0] == null || args[0].length() == 0) {
            return -1;
        }
        try {
            cmd = new DynamicCmd(this, args[0]);
        }
        catch (Exception e) {
            out.println(e.getMessage());
            return -2;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!"-help".equals(args[i])) continue;
            out.println(((Object)new StringBuffer().append("Usage: ").append(args[0]).append(" [-help] ").append(cmd.usage)).toString());
            for (int j = 0; j < cmd.help.length; ++j) {
                out.println(((Object)new StringBuffer().append("  ").append(cmd.help[j])).toString());
            }
            return 0;
        }
        try {
            Integer res = (Integer)cmd.cmd.invoke((Object)this, this.getOpt(args, cmd.usage), in, out, session);
            return res;
        }
        catch (IllegalAccessException e) {
            out.println(((Object)new StringBuffer().append("Command failed: ").append(e.getMessage())).toString());
            return -1;
        }
        catch (InvocationTargetException e) {
            out.println("Command execution failed, stack trace follows:");
            e.getTargetException().printStackTrace(out);
            return -1;
        }
        catch (Exception e) {
            out.println(e.getMessage());
            return -1;
        }
    }

    public Dictionary<String, Object> getOpt(String[] args, String usage) throws Exception {
        Hashtable<String, Object> res = new Hashtable<String, Object>();
        res.put("command", args[0]);
        args[0] = null;
        this.parseUsage(usage.trim(), 0, args, res, 0);
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            throw new Exception(((Object)new StringBuffer().append("Unknown argument: ").append(args[i])).toString());
        }
        return res;
    }

    public Map<String, String> getCommandNames() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Field[] f = this.getClass().getFields();
        for (int i = 0; i < f.length; ++i) {
            String name = f[i].getName();
            if (!name.startsWith("HELP_")) continue;
            try {
                name = name.substring(5).toLowerCase();
                DynamicCmd cmd = new DynamicCmd(this, name);
                StringBuffer help = new StringBuffer();
                help.append(cmd.usage);
                if (cmd.help != null) {
                    for (int j = 0; j < cmd.help.length; ++j) {
                        help.append("\n");
                        help.append(cmd.help[j]);
                    }
                }
                map.put(name, ((Object)help).toString());
                continue;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return map;
    }

    private int parseUsage(String usage, int pos, String[] args, Hashtable<String, Object> res, int level) throws Exception {
        int ulen = usage.length();
        block8: while (pos < ulen) {
            switch (usage.charAt(pos)) {
                case '-': {
                    boolean alt;
                    if (res.containsKey(DOING_ARGS)) {
                        throw new Exception(((Object)new StringBuffer().append("Can not mix flags and args: ").append(usage.substring(pos))).toString());
                    }
                    boolean found = false;
                    String flag = "";
                    do {
                        alt = false;
                        int start = pos++;
                        while (pos < ulen && usage.charAt(pos) != ' ' && usage.charAt(pos) != ']') {
                            ++pos;
                        }
                        flag = usage.substring(start, pos);
                        Object val = new Integer(1);
                        int fpos = -1;
                        for (int i = 0; i < args.length; ++i) {
                            if (!flag.equals(args[i])) continue;
                            fpos = i;
                            break;
                        }
                        while (pos < ulen && usage.charAt(pos) == ' ') {
                            ++pos;
                        }
                        if (pos < ulen) {
                            if (usage.charAt(pos) == '#') {
                                while (pos < ulen && usage.charAt(pos) != ' ' && usage.charAt(pos) != ']') {
                                    ++pos;
                                }
                                if (fpos >= 0) {
                                    if (fpos + 1 < args.length) {
                                        val = args[fpos + 1];
                                        args[fpos + 1] = null;
                                    } else {
                                        throw new Exception(((Object)new StringBuffer().append("No value for: ").append(flag)).toString());
                                    }
                                }
                                while (pos < ulen && usage.charAt(pos) == ' ') {
                                    ++pos;
                                }
                            }
                            if (pos < ulen && usage.charAt(pos) == '|') {
                                ++pos;
                                while (pos < ulen && usage.charAt(pos) == ' ') {
                                    ++pos;
                                }
                                if (usage.charAt(pos) == '-') {
                                    alt = true;
                                } else {
                                    throw new Exception(((Object)new StringBuffer().append("Missing flag in OR-expression: ").append(usage.substring(pos))).toString());
                                }
                            }
                        }
                        if (fpos < 0) continue;
                        Object old = res.put(args[fpos], val);
                        if (old != null) {
                            if (old instanceof Integer) {
                                res.put(args[fpos], new Integer((Integer)old + 1));
                            } else {
                                throw new Exception(((Object)new StringBuffer().append("Duplicate flagname with value in usage: ").append(args[fpos])).toString());
                            }
                        }
                        args[fpos] = null;
                        found = true;
                    } while (alt);
                    if (found || level != 0) continue block8;
                    throw new Exception(((Object)new StringBuffer().append("Mandatory flag not set, flags: ").append(usage)).toString());
                }
                case '<': {
                    int i;
                    res.put(DOING_ARGS, "");
                    int wstart = ++pos;
                    ++pos;
                    pos = usage.indexOf(62, pos);
                    if (pos == -1) {
                        throw new Exception(((Object)new StringBuffer().append("Unmatched: ").append(usage.substring(wstart - 1))).toString());
                    }
                    String key = usage.substring(wstart, pos++);
                    for (i = 0; i < args.length; ++i) {
                        if (args[i] == null) continue;
                        if (args[i].startsWith("-")) {
                            if (args[i].startsWith("--")) {
                                args[i] = args[i].substring(1);
                            } else {
                                throw new Exception(((Object)new StringBuffer().append("Unknown flag: ").append(args[i])).toString());
                            }
                        }
                        if (res.put(key, args[i]) != null) {
                            throw new Exception(((Object)new StringBuffer().append("Duplicate argname in usage: ").append(key)).toString());
                        }
                        args[i] = null;
                        break;
                    }
                    if (i == args.length && level == 0) {
                        throw new Exception(((Object)new StringBuffer().append("Mandatory argument not set: ").append(key)).toString());
                    }
                    res.put(LAST, key);
                    continue block8;
                }
                case '[': {
                    pos = this.parseUsage(usage, pos + 1, args, res, level + 1);
                    continue block8;
                }
                case ']': {
                    if (level == 0) {
                        throw new Exception(((Object)new StringBuffer().append("Unmatched: ").append(usage.substring(pos))).toString());
                    }
                    return pos + 1;
                }
                case '.': {
                    if (usage.substring(pos).equals("...")) {
                        String repeat = (String)res.get(LAST);
                        if (repeat != null && res.containsKey(repeat)) {
                            ArrayList<Object> v = new ArrayList<Object>();
                            do {
                                v.add(res.remove(repeat));
                                this.parseUsage(((Object)new StringBuffer().append("<").append(repeat).append(">]")).toString(), 0, args, res, 1);
                            } while (res.containsKey(repeat));
                            String[] vres = new String[v.size()];
                            res.put(repeat, v.toArray(vres));
                        }
                        pos = ulen;
                        continue block8;
                    }
                    throw new Exception(((Object)new StringBuffer().append("Unexpected usage end: ").append(usage.substring(pos))).toString());
                }
                case ' ': {
                    ++pos;
                    continue block8;
                }
            }
            throw new Exception(((Object)new StringBuffer().append("Unexpected character: ").append(usage.charAt(pos))).toString());
        }
        if (level > 0) {
            throw new Exception(((Object)new StringBuffer().append("Missing ").append(level).append(" closing ']'")).toString());
        }
        res.remove(DOING_ARGS);
        res.remove(LAST);
        return pos;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    public static class DynamicCmd {
        public Method cmd;
        public String usage;
        public String[] help;

        public String toString() {
            return "DynamicCmd[cmd=" + this.cmd + ", usage=" + this.usage + "]";
        }

        public DynamicCmd(CommandGroup cg, String name) throws Exception {
            try {
                Class<?> cls = cg.getClass();
                String hname = "HELP_" + name.toUpperCase();
                Field[] f = cls.getFields();
                int match = -1;
                boolean multiple = false;
                for (int i = 0; i < f.length; ++i) {
                    String fname = f[i].getName();
                    if (fname.equals(hname)) {
                        match = i;
                        name = fname.substring(5);
                        multiple = false;
                        break;
                    }
                    if (!fname.startsWith(hname)) continue;
                    if (match != -1) {
                        multiple = true;
                        continue;
                    }
                    match = i;
                    name = fname.substring(5);
                }
                if (match == -1) {
                    throw new Exception("No such command: " + name);
                }
                if (multiple) {
                    throw new Exception("Multiple matching commands for: " + hname.substring(5));
                }
                this.help = (String[])f[match].get(cg);
                this.usage = (String)cls.getField("USAGE_" + name.toUpperCase()).get(cg);
                this.cmd = cls.getMethod("cmd" + name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase(), class$java$util$Dictionary == null ? (class$java$util$Dictionary = CommandGroupAdapter.class$("java.util.Dictionary")) : class$java$util$Dictionary, class$java$io$Reader == null ? (class$java$io$Reader = CommandGroupAdapter.class$("java.io.Reader")) : class$java$io$Reader, class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = CommandGroupAdapter.class$("java.io.PrintWriter")) : class$java$io$PrintWriter, class$org$knopflerfish$service$console$Session == null ? (class$org$knopflerfish$service$console$Session = CommandGroupAdapter.class$("org.knopflerfish.service.console.Session")) : class$org$knopflerfish$service$console$Session);
                if (!this.cmd.getReturnType().getName().equals("int")) {
                    throw new Exception("No such command: " + name);
                }
            }
            catch (ClassNotFoundException e) {
                throw new Exception("Internal error");
            }
            catch (NoSuchFieldException e) {
                throw new Exception("Command implementation incomplete (USAGE string missing): " + name);
            }
            catch (NoSuchMethodException e) {
                throw new Exception("Command implementation incomplete (cmd method missing): " + name);
            }
        }
    }
}

