/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.hive;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.compat.DynConstructors;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.DatasetOperationException;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.DefaultConfiguration;
import org.kitesdk.data.spi.Loadable;
import org.kitesdk.data.spi.OptionBuilder;
import org.kitesdk.data.spi.Registration;
import org.kitesdk.data.spi.URIPattern;
import org.kitesdk.data.spi.hive.HiveManagedDatasetRepository;
import org.kitesdk.data.spi.hive.HiveUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Loader
implements Loadable {
    private static final Logger LOG = LoggerFactory.getLogger(Loader.class);
    public static final String HIVE_METASTORE_URI_PROP = "hive.metastore.uris";
    private static final int UNSPECIFIED_PORT = -1;
    private static final String NOT_SET = "not-set";
    private static final String HDFS_HOST = "hdfs:host";
    private static final String HDFS_PORT = "hdfs:port";
    private static final String OLD_HDFS_HOST = "hdfs-host";
    private static final String OLD_HDFS_PORT = "hdfs-port";
    private static DynConstructors.Ctor<Configuration> HIVE_CONF;

    public void load() {
        Loader.checkHiveDependencies();
        ManagedBuilder managedBuilder = new ManagedBuilder();
        ExternalBuilder externalBuilder = new ExternalBuilder();
        Registration.register((URIPattern)new URIPattern("hive"), (URIPattern)new URIPattern("hive::namespace/:dataset"), (OptionBuilder)managedBuilder);
        Registration.register((URIPattern)new URIPattern("hive"), (URIPattern)new URIPattern("hive::dataset?namespace=default"), (OptionBuilder)managedBuilder);
        Registration.register((URIPattern)new URIPattern("hive"), (URIPattern)new URIPattern("hive?namespace=default"), (OptionBuilder)managedBuilder);
        Registration.register((URIPattern)new URIPattern("hive://not-set"), (URIPattern)new URIPattern("hive:/:namespace/:dataset"), (OptionBuilder)managedBuilder);
        Registration.register((URIPattern)new URIPattern("hive://not-set"), (URIPattern)new URIPattern("hive:/:dataset?namespace=default"), (OptionBuilder)managedBuilder);
        Registration.register((URIPattern)new URIPattern("hive://not-set"), (URIPattern)new URIPattern("hive://not-set?namespace=default"), (OptionBuilder)managedBuilder);
        Registration.register((URIPattern)new URIPattern("hive:/*path?absolute=true"), (URIPattern)new URIPattern("hive:/*path/:namespace/:dataset?absolute=true"), (OptionBuilder)externalBuilder);
        Registration.register((URIPattern)new URIPattern("hive:*path"), (URIPattern)new URIPattern("hive:*path/:namespace/:dataset"), (OptionBuilder)externalBuilder);
    }

    private static Configuration newHiveConf(Configuration base) {
        Loader.checkHiveDependencies();
        Configuration conf = (Configuration)HIVE_CONF.newInstance(new Object[]{base, HIVE_CONF.getConstructedClass()});
        HiveUtils.addResource(conf, base);
        return conf;
    }

    private static synchronized void checkHiveDependencies() {
        if (HIVE_CONF == null) {
            HIVE_CONF = new DynConstructors.Builder().impl("org.apache.hadoop.hive.conf.HiveConf", new Class[]{Configuration.class, Class.class}).build();
        }
    }

    private static URI fileSystemURI(Map<String, String> match, Configuration conf) {
        String userInfo = match.containsKey("auth:username") ? (match.containsKey("auth:password") ? match.get("auth:username") + ":" + match.get("auth:password") : match.get("auth:username")) : null;
        try {
            String defaultScheme;
            if (match.containsKey(HDFS_HOST) || match.containsKey(OLD_HDFS_HOST)) {
                int port = -1;
                if (match.containsKey(HDFS_PORT) || match.containsKey(OLD_HDFS_PORT)) {
                    try {
                        port = Integer.parseInt(Loader.first(match, HDFS_PORT, OLD_HDFS_PORT));
                    }
                    catch (NumberFormatException e) {
                        port = -1;
                    }
                }
                return new URI("hdfs", userInfo, Loader.first(match, HDFS_HOST, OLD_HDFS_HOST), port, "/", null, null);
            }
            try {
                defaultScheme = FileSystem.get((Configuration)conf).getUri().getScheme();
            }
            catch (IOException e) {
                throw new DatasetIOException("Cannot determine the default FS", e);
            }
            return new URI(defaultScheme, userInfo, "", -1, "/", null, null);
        }
        catch (URISyntaxException ex) {
            throw new DatasetOperationException("Could not build FS URI", (Throwable)ex);
        }
    }

    private static void setMetaStoreURI(Configuration conf, Map<String, String> match) {
        block4: {
            try {
                int port;
                String host = match.get("auth:host");
                if (host == null || NOT_SET.equals(host)) break block4;
                try {
                    port = Integer.parseInt(match.get("auth:port"));
                }
                catch (NumberFormatException e) {
                    port = -1;
                }
                conf.set(HIVE_METASTORE_URI_PROP, new URI("thrift", null, host, port, null, null, null).toString());
            }
            catch (URISyntaxException ex) {
                throw new DatasetOperationException("Could not build metastore URI", (Throwable)ex);
            }
        }
    }

    private static String first(Map<String, String> data, String ... keys) {
        for (String key : keys) {
            if (!data.containsKey(key)) continue;
            return data.get(key);
        }
        return null;
    }

    private static class ManagedBuilder
    implements OptionBuilder<DatasetRepository> {
        private ManagedBuilder() {
        }

        public DatasetRepository getFromOptions(Map<String, String> match) {
            LOG.debug("Managed URI options: {}", match);
            Configuration conf = Loader.newHiveConf(DefaultConfiguration.get());
            Loader.setMetaStoreURI(conf, match);
            return new HiveManagedDatasetRepository.Builder().configuration(conf).build();
        }
    }

    private static class ExternalBuilder
    implements OptionBuilder<DatasetRepository> {
        private ExternalBuilder() {
        }

        public DatasetRepository getFromOptions(Map<String, String> match) {
            FileSystem fs;
            LOG.debug("External URI options: {}", match);
            String path = match.get("path");
            Path root = match.containsKey("absolute") && Boolean.valueOf(match.get("absolute")) != false ? (path == null || path.isEmpty() ? new Path("/") : new Path("/", path)) : (path == null || path.isEmpty() ? new Path(".") : new Path(path));
            Configuration conf = Loader.newHiveConf(DefaultConfiguration.get());
            try {
                fs = FileSystem.get((URI)Loader.fileSystemURI(match, conf), (Configuration)conf);
            }
            catch (IOException e) {
                if (e.getMessage().startsWith("Incomplete")) {
                    throw new DatasetIOException("Could not get a FileSystem: make sure the default " + match.get("uri:scheme") + " URI is configured.", e);
                }
                throw new DatasetIOException("Could not get a FileSystem", e);
            }
            Loader.setMetaStoreURI(conf, match);
            return new HiveManagedDatasetRepository.Builder().configuration(conf).rootDirectory(fs.makeQualified(root)).build();
        }
    }
}

