/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.avro;

import java.lang.reflect.Constructor;
import org.apache.avro.specific.SpecificRecord;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.hbase.avro.AvroRecordBuilder;
import org.kitesdk.data.hbase.avro.AvroRecordBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificAvroRecordBuilderFactory<T extends SpecificRecord>
implements AvroRecordBuilderFactory<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SpecificAvroRecordBuilderFactory.class);
    private final Class<T> recordClass;
    private final Constructor<T> recordClassConstructor;

    public SpecificAvroRecordBuilderFactory(Class<T> recordClass) {
        this.recordClass = recordClass;
        try {
            this.recordClassConstructor = recordClass.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            String msg = "Could not get a default constructor for class: " + recordClass.toString();
            LOG.error(msg, (Throwable)e);
            throw new DatasetException(msg, (Throwable)e);
        }
    }

    @Override
    public AvroRecordBuilder<T> getBuilder() {
        try {
            return new SpecificAvroRecordBuilder<T>(this.recordClassConstructor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Class<T> getRecordClass() {
        return this.recordClass;
    }

    private static class SpecificAvroRecordBuilder<T extends SpecificRecord>
    implements AvroRecordBuilder<T> {
        private T specificRecord;

        public SpecificAvroRecordBuilder(Constructor<T> recordConstructor) {
            try {
                this.specificRecord = (SpecificRecord)recordConstructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                LOG.error("Could not create a SpecificRecord instance.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        @Override
        public void put(String field, Object value) {
            int fieldPos = this.specificRecord.getSchema().getField(field).pos();
            this.specificRecord.put(fieldPos, value);
        }

        @Override
        public T build() {
            return this.specificRecord;
        }
    }
}

