/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.IncompatibleSchemaException;
import org.kitesdk.data.spi.SchemaValidationUtil;
import org.kitesdk.shaded.com.google.common.base.Charsets;
import org.kitesdk.shaded.com.google.common.io.Closeables;

public class SchemaManager {
    private final Path schemaDirectory;
    private final FileSystem rootFileSystem;

    public static SchemaManager create(Configuration conf, Path schemaDirectory) {
        try {
            FileSystem rootFileSystem = schemaDirectory.getFileSystem(conf);
            rootFileSystem.mkdirs(schemaDirectory);
            return new SchemaManager(schemaDirectory, rootFileSystem);
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to create schema manager directory: " + schemaDirectory, e);
        }
    }

    public static SchemaManager load(Configuration conf, Path schemaDirectory) {
        try {
            FileSystem rootFileSystem = schemaDirectory.getFileSystem(conf);
            if (rootFileSystem.exists(schemaDirectory)) {
                return new SchemaManager(schemaDirectory, rootFileSystem);
            }
            return null;
        }
        catch (IOException e) {
            throw new DatasetIOException("Cannot load schema manager at:" + schemaDirectory, e);
        }
    }

    private SchemaManager(Path schemaDirectory, FileSystem rootFileSystem) throws IOException {
        this.schemaDirectory = schemaDirectory;
        this.rootFileSystem = rootFileSystem;
    }

    private static int getFileNumber(FileStatus fileStatus) {
        try {
            String fileName = fileStatus.getPath().getName();
            return Integer.parseInt(fileName.substring(0, fileName.indexOf(46)));
        }
        catch (NumberFormatException e) {
            throw new DatasetException("Unexpected file in schema manager folder " + fileStatus.getPath(), e);
        }
    }

    private Path newestFile() {
        try {
            FileStatus[] statuses = this.rootFileSystem.listStatus(this.schemaDirectory);
            if (statuses.length == 0) {
                return null;
            }
            Arrays.sort(statuses, new FileNameComparator());
            return statuses[statuses.length - 1].getPath();
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to list schema files.", e);
        }
    }

    public URI getNewestSchemaURI() {
        Path path = this.newestFile();
        return path == null ? null : this.rootFileSystem.makeQualified(path).toUri();
    }

    private Schema loadSchema(Path schemaPath) {
        Schema schema = null;
        FSDataInputStream inputStream = null;
        boolean threw = true;
        try {
            inputStream = this.rootFileSystem.open(schemaPath);
            schema = new Schema.Parser().parse((InputStream)inputStream);
            threw = false;
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to load schema file:" + schemaPath, e);
        }
        finally {
            try {
                Closeables.close((Closeable)inputStream, threw);
            }
            catch (IOException e) {
                throw new DatasetIOException("Cannot close", e);
            }
        }
        return schema;
    }

    public Schema getNewestSchema() {
        Path schemaPath = this.newestFile();
        return schemaPath == null ? null : this.loadSchema(schemaPath);
    }

    public URI importSchema(Path schemaPath) {
        Schema schema = this.loadSchema(schemaPath);
        return this.writeSchema(schema);
    }

    public URI writeSchema(Schema schema) {
        Schema previousSchema;
        Path previousPath = this.newestFile();
        if (previousPath != null && schema.equals((Object)(previousSchema = this.loadSchema(previousPath)))) {
            return this.rootFileSystem.makeQualified(previousPath).toUri();
        }
        Map<Integer, Schema> schemas = this.getSchemas();
        for (Schema oldSchema : schemas.values()) {
            if (SchemaValidationUtil.canRead(oldSchema, schema)) continue;
            throw new IncompatibleSchemaException("Schema cannot read data written using existing schema. Schema: " + schema.toString(true) + "\nPrevious schema: " + oldSchema.toString(true));
        }
        Path schemaPath = null;
        if (previousPath == null) {
            schemaPath = new Path(this.schemaDirectory, "1.avsc");
        } else {
            String previousName = previousPath.getName().substring(0, previousPath.getName().indexOf(46));
            int i = Integer.parseInt(previousName) + 1;
            schemaPath = new Path(this.schemaDirectory, Integer.toString(i) + ".avsc");
        }
        FSDataOutputStream outputStream = null;
        boolean threw = true;
        try {
            outputStream = this.rootFileSystem.create(schemaPath, false);
            outputStream.write(schema.toString(true).getBytes(Charsets.UTF_8));
            outputStream.flush();
            threw = false;
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to save schema file: " + schemaPath, e);
        }
        finally {
            try {
                Closeables.close((Closeable)outputStream, threw);
            }
            catch (IOException e) {
                throw new DatasetIOException("Cannot close", e);
            }
        }
        return this.rootFileSystem.makeQualified(schemaPath).toUri();
    }

    public Map<Integer, Schema> getSchemas() {
        TreeMap<Integer, Schema> schemas = new TreeMap<Integer, Schema>();
        try {
            FileStatus[] statuses;
            for (FileStatus fileStatus : statuses = this.rootFileSystem.listStatus(this.schemaDirectory)) {
                int schemaNumber = SchemaManager.getFileNumber(fileStatus);
                Schema schema = this.loadSchema(fileStatus.getPath());
                schemas.put(schemaNumber, schema);
            }
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to list schema files.", e);
        }
        return schemas;
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="Implement if we intend to use in Serializable objects  (e.g., TreeMaps) and use java serialization.")
    private static final class FileNameComparator
    implements Comparator<FileStatus> {
        private FileNameComparator() {
        }

        @Override
        public int compare(FileStatus file1, FileStatus file2) {
            return SchemaManager.getFileNumber(file1) - SchemaManager.getFileNumber(file2);
        }
    }
}

