/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.Conversions;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.SchemaUtil;
import org.kitesdk.data.spi.StorageKey;
import org.kitesdk.data.spi.partition.DayOfMonthFieldPartitioner;
import org.kitesdk.data.spi.partition.HourFieldPartitioner;
import org.kitesdk.data.spi.partition.MinuteFieldPartitioner;
import org.kitesdk.data.spi.partition.MonthFieldPartitioner;
import org.kitesdk.shaded.com.google.common.base.Joiner;
import org.kitesdk.shaded.com.google.common.base.Splitter;
import org.kitesdk.shaded.com.google.common.collect.ImmutableMap;
import org.kitesdk.shaded.com.google.common.collect.Iterables;
import org.kitesdk.shaded.com.google.common.collect.Lists;

public class PathConversion {
    private final Schema schema;
    private static final Splitter PART_SEP = Splitter.on('=');
    private static final Joiner PART_JOIN = Joiner.on('=');
    private static final Map<Class<?>, Integer> WIDTHS = ImmutableMap.builder().put(MinuteFieldPartitioner.class, 2).put(HourFieldPartitioner.class, 2).put(DayOfMonthFieldPartitioner.class, 2).put(MonthFieldPartitioner.class, 2).build();

    public PathConversion(Schema schema) {
        this.schema = schema;
    }

    public StorageKey toKey(Path fromPath, StorageKey storage) {
        List<FieldPartitioner> partitioners = Accessor.getDefault().getFieldPartitioners(storage.getPartitionStrategy());
        ArrayList<Object> values = Lists.newArrayList(new Object[partitioners.size()]);
        Path currentPath = fromPath;
        for (int index = partitioners.size() - 1; currentPath != null && index >= 0; currentPath = currentPath.getParent(), --index) {
            values.set(index, this.valueForDirname(partitioners.get(index), currentPath.getName()));
        }
        storage.replaceValues(values);
        return storage;
    }

    public Path fromKey(StorageKey key) {
        StringBuilder pathBuilder = new StringBuilder();
        List<FieldPartitioner> partitioners = Accessor.getDefault().getFieldPartitioners(key.getPartitionStrategy());
        for (int i = 0; i < partitioners.size(); ++i) {
            FieldPartitioner fp = partitioners.get(i);
            if (i != 0) {
                pathBuilder.append('/');
            }
            String dirname = PathConversion.dirnameForValue(fp, key.get(i));
            pathBuilder.append(dirname);
        }
        return new Path(pathBuilder.toString());
    }

    public <T> T valueForDirname(FieldPartitioner<?, T> field, String name) {
        return PathConversion.valueForDirname(field, this.schema, name);
    }

    public static <T> String dirnameForValue(FieldPartitioner<?, T> field, T value) {
        return PART_JOIN.join(field.getName(), PathConversion.valueToString(field, value), new Object[0]);
    }

    public static <T> String valueToString(FieldPartitioner<?, T> field, T value) {
        try {
            return URLEncoder.encode(Conversions.makeString(value, WIDTHS.get(field.getClass())), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"Unable to find UTF-8 encoding.");
        }
    }

    public static <T> T valueForDirname(FieldPartitioner<?, T> field, Schema schema, String name) {
        return Conversions.convert((Object)PathConversion.dirnameToValueString(name), SchemaUtil.getPartitionType(field, schema));
    }

    public static String dirnameToValueString(String name) {
        try {
            return URLDecoder.decode(Iterables.getLast(PART_SEP.split(name)), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"Unable to find UTF-8 encoding.");
        }
    }
}

