/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.kitesdk.compat.DynConstructors;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.spi.filesystem.KeyReaderWrapper;
import org.kitesdk.data.spi.filesystem.ValueReaderWrapper;

public class InputFormatUtil {
    public static final String INPUT_FORMAT_CLASS_PROP = "kite.inputformat.class";
    public static final String INPUT_FORMAT_RECORD_PROP = "kite.inputformat.record-type";

    public static <K, V> FileInputFormat<K, V> newInputFormatInstance(DatasetDescriptor descriptor) {
        DynConstructors.Ctor ctor = new DynConstructors.Builder().impl(descriptor.getProperty(INPUT_FORMAT_CLASS_PROP), new Class[0]).build();
        return (FileInputFormat)ctor.newInstance(new Object[0]);
    }

    @SuppressWarnings(value={"DM_CONVERT_CASE"}, justification="For record types only")
    public static <E> RecordReader<E, Void> newRecordReader(DatasetDescriptor descriptor) {
        String typeString = descriptor.getProperty(INPUT_FORMAT_RECORD_PROP);
        RecordType type = RecordType.VALUE;
        if (typeString != null) {
            type = RecordType.valueOf(typeString.trim().toUpperCase());
        }
        if (type == RecordType.KEY) {
            FileInputFormat format = InputFormatUtil.newInputFormatInstance(descriptor);
            return new KeyReaderWrapper(format);
        }
        if (type == RecordType.VALUE) {
            FileInputFormat format = InputFormatUtil.newInputFormatInstance(descriptor);
            return new ValueReaderWrapper(format);
        }
        throw new DatasetException("[BUG] Invalid record type: " + (Object)((Object)type));
    }

    public static enum RecordType {
        KEY,
        VALUE;

    }
}

