/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.predicates;

import org.junit.Assert;
import org.junit.Test;
import org.kitesdk.data.spi.predicates.Range;
import org.kitesdk.data.spi.predicates.Ranges;

public class TestRangeComparable {
    @Test
    public void testSingletonRangeComparable() {
        Range range = Ranges.singleton((Object)3);
        Assert.assertEquals((Object)range.toString(), (Object)"[3, 3]");
        Assert.assertTrue((String)"Should contain inner point", (boolean)range.contains((Object)3));
        Assert.assertFalse((String)"Should not contain outside point", (boolean)range.contains((Object)2));
    }

    @Test
    public void testOpenRangeComparable() {
        Range range = Ranges.open((Object)3, (Object)5);
        Assert.assertEquals((Object)range.toString(), (Object)"(3, 5)");
        Assert.assertTrue((String)"Should contain inner point", (boolean)range.contains((Object)4));
        Assert.assertFalse((String)"Should not contain outside point", (boolean)range.contains((Object)2));
        Assert.assertFalse((String)"Should not contain lower endpoint", (boolean)range.contains((Object)3));
        Assert.assertFalse((String)"Should not contain upper endpoint", (boolean)range.contains((Object)5));
    }

    @Test
    public void testClosedRangeComparable() {
        Range range = Ranges.closed((Object)3, (Object)5);
        Assert.assertEquals((Object)range.toString(), (Object)"[3, 5]");
        Assert.assertTrue((String)"Should contain inner point", (boolean)range.contains((Object)4));
        Assert.assertFalse((String)"Should not contain outside point", (boolean)range.contains((Object)2));
        Assert.assertTrue((String)"Should contain lower endpoint", (boolean)range.contains((Object)3));
        Assert.assertTrue((String)"Should contain upper endpoint", (boolean)range.contains((Object)5));
    }

    @Test
    public void testOpenClosedRangeComparable() {
        Range range = Ranges.openClosed((Object)3, (Object)5);
        Assert.assertEquals((Object)range.toString(), (Object)"(3, 5]");
        Assert.assertTrue((String)"Should contain inner point", (boolean)range.contains((Object)4));
        Assert.assertFalse((String)"Should not contain outside point", (boolean)range.contains((Object)2));
        Assert.assertFalse((String)"Should not contain lower endpoint", (boolean)range.contains((Object)3));
        Assert.assertTrue((String)"Should contain upper endpoint", (boolean)range.contains((Object)5));
    }

    @Test
    public void testClosedOpenRangeComparable() {
        Range range = Ranges.closedOpen((Object)3, (Object)5);
        Assert.assertEquals((Object)range.toString(), (Object)"[3, 5)");
        Assert.assertTrue((String)"Should contain inner point", (boolean)range.contains((Object)4));
        Assert.assertFalse((String)"Should not contain outside point", (boolean)range.contains((Object)2));
        Assert.assertTrue((String)"Should contain lower endpoint", (boolean)range.contains((Object)3));
        Assert.assertFalse((String)"Should not contain upper endpoint", (boolean)range.contains((Object)5));
    }

    @Test
    public void testAtLeastRangeComparable() {
        Range range = Ranges.atLeast((Object)3);
        Assert.assertEquals((Object)range.toString(), (Object)"[3, inf)");
        Assert.assertTrue((String)"Should contain inner point", (boolean)range.contains((Object)4));
        Assert.assertFalse((String)"Should not contain outside point", (boolean)range.contains((Object)2));
        Assert.assertTrue((String)"Should contain lower endpoint", (boolean)range.contains((Object)3));
        Assert.assertTrue((String)"Should contain max", (boolean)range.contains((Object)Integer.MAX_VALUE));
    }

    @Test
    public void testGreaterThanRangeComparable() {
        Range range = Ranges.greaterThan((Object)3);
        Assert.assertEquals((Object)range.toString(), (Object)"(3, inf)");
        Assert.assertTrue((String)"Should contain inner point", (boolean)range.contains((Object)4));
        Assert.assertFalse((String)"Should not contain outside point", (boolean)range.contains((Object)2));
        Assert.assertFalse((String)"Should not contain lower endpoint", (boolean)range.contains((Object)3));
        Assert.assertTrue((String)"Should contain max", (boolean)range.contains((Object)Integer.MAX_VALUE));
    }

    @Test
    public void testAtMostRangeComparable() {
        Range range = Ranges.atMost((Object)5);
        Assert.assertEquals((Object)range.toString(), (Object)"(inf, 5]");
        Assert.assertTrue((String)"Should contain inner point", (boolean)range.contains((Object)4));
        Assert.assertFalse((String)"Should not contain outside point", (boolean)range.contains((Object)6));
        Assert.assertTrue((String)"Should contain min", (boolean)range.contains((Object)Integer.MIN_VALUE));
        Assert.assertTrue((String)"Should contain upper endpoint", (boolean)range.contains((Object)5));
    }

    @Test
    public void testLessThanRangeComparable() {
        Range range = Ranges.lessThan((Object)5);
        Assert.assertEquals((Object)range.toString(), (Object)"(inf, 5)");
        Assert.assertTrue((String)"Should contain inner point", (boolean)range.contains((Object)4));
        Assert.assertFalse((String)"Should not contain outside point", (boolean)range.contains((Object)6));
        Assert.assertTrue((String)"Should contain min", (boolean)range.contains((Object)Integer.MIN_VALUE));
        Assert.assertFalse((String)"Should not contain upper endpoint", (boolean)range.contains((Object)5));
    }

    @Test
    public void testAsGuavaRange() {
        Assert.assertEquals((String)"Should convert to guava singleton", (Object)com.google.common.collect.Ranges.singleton((Comparable)Integer.valueOf(3)), (Object)Ranges.asGuavaRange((Range)Ranges.singleton((Object)3)));
        Assert.assertEquals((String)"Should convert to guava open", (Object)com.google.common.collect.Ranges.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)), (Object)Ranges.asGuavaRange((Range)Ranges.open((Object)3, (Object)5)));
        Assert.assertEquals((String)"Should convert to guava closed", (Object)com.google.common.collect.Ranges.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)), (Object)Ranges.asGuavaRange((Range)Ranges.closed((Object)3, (Object)5)));
        Assert.assertEquals((String)"Should convert to guava openClosed", (Object)com.google.common.collect.Ranges.openClosed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)), (Object)Ranges.asGuavaRange((Range)Ranges.openClosed((Object)3, (Object)5)));
        Assert.assertEquals((String)"Should convert to guava closedOpen", (Object)com.google.common.collect.Ranges.closedOpen((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)), (Object)Ranges.asGuavaRange((Range)Ranges.closedOpen((Object)3, (Object)5)));
        Assert.assertEquals((String)"Should convert to guava atLeast", (Object)com.google.common.collect.Ranges.atLeast((Comparable)Integer.valueOf(3)), (Object)Ranges.asGuavaRange((Range)Ranges.atLeast((Object)3)));
        Assert.assertEquals((String)"Should convert to guava greaterThan", (Object)com.google.common.collect.Ranges.greaterThan((Comparable)Integer.valueOf(3)), (Object)Ranges.asGuavaRange((Range)Ranges.greaterThan((Object)3)));
        Assert.assertEquals((String)"Should convert to guava atMost", (Object)com.google.common.collect.Ranges.atMost((Comparable)Integer.valueOf(5)), (Object)Ranges.asGuavaRange((Range)Ranges.atMost((Object)5)));
        Assert.assertEquals((String)"Should convert to guava lessThan", (Object)com.google.common.collect.Ranges.lessThan((Comparable)Integer.valueOf(5)), (Object)Ranges.asGuavaRange((Range)Ranges.lessThan((Object)5)));
    }

    @Test
    public void testIntersectionOverlap() {
        Assert.assertEquals((String)"Open inner endpoints remain open", (Object)Ranges.open((Object)10, (Object)15), (Object)Ranges.closedOpen((Object)5, (Object)15).intersection(Ranges.openClosed((Object)10, (Object)20)));
        Assert.assertEquals((String)"Open inner endpoints remain open", (Object)Ranges.open((Object)10, (Object)15), (Object)Ranges.openClosed((Object)10, (Object)20).intersection(Ranges.closedOpen((Object)5, (Object)15)));
        Assert.assertEquals((String)"Closed inner endpoints remain closed", (Object)Ranges.closed((Object)10, (Object)15), (Object)Ranges.openClosed((Object)5, (Object)15).intersection(Ranges.closedOpen((Object)10, (Object)20)));
        Assert.assertEquals((String)"Closed inner endpoints remain closed", (Object)Ranges.closed((Object)10, (Object)15), (Object)Ranges.closedOpen((Object)10, (Object)20).intersection(Ranges.openClosed((Object)5, (Object)15)));
        Assert.assertEquals((String)"Start endpoints equal, one open", (Object)Ranges.openClosed((Object)5, (Object)15), (Object)Ranges.openClosed((Object)5, (Object)15).intersection(Ranges.closedOpen((Object)5, (Object)20)));
        Assert.assertEquals((String)"Start endpoints equal, one open", (Object)Ranges.openClosed((Object)5, (Object)15), (Object)Ranges.closedOpen((Object)5, (Object)20).intersection(Ranges.openClosed((Object)5, (Object)15)));
        Assert.assertEquals((String)"Start endpoints equal, both closed", (Object)Ranges.closedOpen((Object)5, (Object)15), (Object)Ranges.closedOpen((Object)5, (Object)15).intersection(Ranges.closedOpen((Object)5, (Object)20)));
        Assert.assertEquals((String)"Start endpoints equal, both closed", (Object)Ranges.closedOpen((Object)5, (Object)15), (Object)Ranges.closedOpen((Object)5, (Object)20).intersection(Ranges.closedOpen((Object)5, (Object)15)));
        Assert.assertEquals((String)"Stop endpoints equal, one open", (Object)Ranges.open((Object)10, (Object)20), (Object)Ranges.openClosed((Object)10, (Object)20).intersection(Ranges.closedOpen((Object)5, (Object)20)));
        Assert.assertEquals((String)"Stop endpoints equal, one open", (Object)Ranges.open((Object)10, (Object)20), (Object)Ranges.closedOpen((Object)5, (Object)20).intersection(Ranges.openClosed((Object)10, (Object)20)));
        Assert.assertEquals((String)"Stop endpoints equal, both closed", (Object)Ranges.openClosed((Object)10, (Object)20), (Object)Ranges.openClosed((Object)10, (Object)20).intersection(Ranges.openClosed((Object)5, (Object)20)));
        Assert.assertEquals((String)"Stop endpoints equal, both closed", (Object)Ranges.openClosed((Object)10, (Object)20), (Object)Ranges.openClosed((Object)5, (Object)20).intersection(Ranges.openClosed((Object)10, (Object)20)));
    }

    @Test
    public void testIntersectionPositiveInfinity() {
        Assert.assertEquals((String)"Defined endpoint is used", (Object)Ranges.closed((Object)10, (Object)20), (Object)Ranges.openClosed((Object)5, (Object)20).intersection(Ranges.atLeast((Object)10)));
        Assert.assertEquals((String)"Defined endpoint is used", (Object)Ranges.closed((Object)10, (Object)20), (Object)Ranges.atLeast((Object)10).intersection(Ranges.openClosed((Object)5, (Object)20)));
        Assert.assertEquals((String)"Defined endpoint is used", (Object)Ranges.open((Object)10, (Object)20), (Object)Ranges.closedOpen((Object)5, (Object)20).intersection(Ranges.greaterThan((Object)10)));
        Assert.assertEquals((String)"Defined endpoint is used", (Object)Ranges.open((Object)10, (Object)20), (Object)Ranges.greaterThan((Object)10).intersection(Ranges.closedOpen((Object)5, (Object)20)));
    }

    @Test
    public void testIntersectionNegativeInfinity() {
        Assert.assertEquals((String)"Defined endpoint is used", (Object)Ranges.openClosed((Object)5, (Object)10), (Object)Ranges.openClosed((Object)5, (Object)20).intersection(Ranges.atMost((Object)10)));
        Assert.assertEquals((String)"Defined endpoint is used", (Object)Ranges.openClosed((Object)5, (Object)10), (Object)Ranges.atMost((Object)10).intersection(Ranges.openClosed((Object)5, (Object)20)));
        Assert.assertEquals((String)"Defined endpoint is used", (Object)Ranges.closedOpen((Object)5, (Object)10), (Object)Ranges.closedOpen((Object)5, (Object)20).intersection(Ranges.lessThan((Object)10)));
        Assert.assertEquals((String)"Defined endpoint is used", (Object)Ranges.closedOpen((Object)5, (Object)10), (Object)Ranges.lessThan((Object)10).intersection(Ranges.closedOpen((Object)5, (Object)20)));
    }
}

