/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.predicates;

import org.apache.avro.util.Utf8;
import org.junit.Assert;
import org.junit.Test;
import org.kitesdk.data.spi.predicates.Range;
import org.kitesdk.data.spi.predicates.Ranges;

public class TestRangeCharSequence {
    @Test
    public void testStringRangeAcceptsUtf8() {
        Range range = Ranges.openClosed((Object)"ab", (Object)"cd");
        Assert.assertEquals((Object)range.toString(), (Object)"(ab, cd]");
        Assert.assertTrue((String)"Should contain inner Utf8", (boolean)range.contains((Object)new Utf8("ac")));
        Assert.assertFalse((String)"Should not contain outside Utf8", (boolean)range.contains((Object)new Utf8("ab")));
    }

    @Test
    public void testUtf8RangeAcceptsString() {
        Range range = Ranges.openClosed((Object)new Utf8("ab"), (Object)new Utf8("cd"));
        Assert.assertEquals((Object)range.toString(), (Object)"(ab, cd]");
        Assert.assertTrue((String)"Should contain inner Utf8", (boolean)range.contains((Object)"ac"));
        Assert.assertFalse((String)"Should not contain outside Utf8", (boolean)range.contains((Object)"ab"));
    }

    @Test
    public void testSingletonRangeComparable() {
        Range range = Ranges.singleton((Object)"ab");
        Assert.assertEquals((Object)range.toString(), (Object)"[ab, ab]");
        Assert.assertTrue((String)"Should contain inner point", (boolean)range.contains((Object)"ab"));
        Assert.assertFalse((String)"Should not contain outside point", (boolean)range.contains((Object)"aa"));
    }

    @Test
    public void testOpenRangeComparable() {
        Range range = Ranges.open((Object)"ab", (Object)"cd");
        Assert.assertEquals((Object)range.toString(), (Object)"(ab, cd)");
        Assert.assertTrue((String)"Should contain inner point", (boolean)range.contains((Object)"b"));
        Assert.assertFalse((String)"Should not contain outside point", (boolean)range.contains((Object)"aa"));
        Assert.assertFalse((String)"Should not contain lower endpoint", (boolean)range.contains((Object)"ab"));
        Assert.assertFalse((String)"Should not contain upper endpoint", (boolean)range.contains((Object)"cd"));
    }

    @Test
    public void testClosedRangeComparable() {
        Range range = Ranges.closed((Object)"ab", (Object)"cd");
        Assert.assertEquals((Object)range.toString(), (Object)"[ab, cd]");
        Assert.assertTrue((String)"Should contain inner point", (boolean)range.contains((Object)"b"));
        Assert.assertFalse((String)"Should not contain outside point", (boolean)range.contains((Object)"aa"));
        Assert.assertTrue((String)"Should contain lower endpoint", (boolean)range.contains((Object)"ab"));
        Assert.assertTrue((String)"Should contain upper endpoint", (boolean)range.contains((Object)"cd"));
    }

    @Test
    public void testOpenClosedRangeComparable() {
        Range range = Ranges.openClosed((Object)"ab", (Object)"cd");
        Assert.assertEquals((Object)range.toString(), (Object)"(ab, cd]");
        Assert.assertTrue((String)"Should contain inner point", (boolean)range.contains((Object)"b"));
        Assert.assertFalse((String)"Should not contain outside point", (boolean)range.contains((Object)"aa"));
        Assert.assertFalse((String)"Should not contain lower endpoint", (boolean)range.contains((Object)"ab"));
        Assert.assertTrue((String)"Should contain upper endpoint", (boolean)range.contains((Object)"cd"));
    }

    @Test
    public void testClosedOpenRangeComparable() {
        Range range = Ranges.closedOpen((Object)"ab", (Object)"cd");
        Assert.assertEquals((Object)range.toString(), (Object)"[ab, cd)");
        Assert.assertTrue((String)"Should contain inner point", (boolean)range.contains((Object)"b"));
        Assert.assertFalse((String)"Should not contain outside point", (boolean)range.contains((Object)"aa"));
        Assert.assertTrue((String)"Should contain lower endpoint", (boolean)range.contains((Object)"ab"));
        Assert.assertFalse((String)"Should not contain upper endpoint", (boolean)range.contains((Object)"cd"));
    }

    @Test
    public void testAtLeastRangeComparable() {
        Range range = Ranges.atLeast((Object)"ab");
        Assert.assertEquals((Object)range.toString(), (Object)"[ab, inf)");
        Assert.assertTrue((String)"Should contain inner point", (boolean)range.contains((Object)"b"));
        Assert.assertFalse((String)"Should not contain outside point", (boolean)range.contains((Object)"aa"));
        Assert.assertTrue((String)"Should contain lower endpoint", (boolean)range.contains((Object)"ab"));
        Assert.assertTrue((String)"Should contain max", (boolean)range.contains((Object)"zzzzzzz"));
    }

    @Test
    public void testGreaterThanRangeComparable() {
        Range range = Ranges.greaterThan((Object)"ab");
        Assert.assertEquals((Object)range.toString(), (Object)"(ab, inf)");
        Assert.assertTrue((String)"Should contain inner point", (boolean)range.contains((Object)"b"));
        Assert.assertFalse((String)"Should not contain outside point", (boolean)range.contains((Object)"aa"));
        Assert.assertFalse((String)"Should not contain lower endpoint", (boolean)range.contains((Object)"ab"));
        Assert.assertTrue((String)"Should contain max", (boolean)range.contains((Object)"zzzzzzz"));
    }

    @Test
    public void testAtMostRangeComparable() {
        Range range = Ranges.atMost((Object)"cd");
        Assert.assertEquals((Object)range.toString(), (Object)"(inf, cd]");
        Assert.assertTrue((String)"Should contain inner point", (boolean)range.contains((Object)"b"));
        Assert.assertFalse((String)"Should not contain outside point", (boolean)range.contains((Object)"d"));
        Assert.assertTrue((String)"Should contain min", (boolean)range.contains((Object)""));
        Assert.assertTrue((String)"Should contain upper endpoint", (boolean)range.contains((Object)"cd"));
    }

    @Test
    public void testLessThanRangeComparable() {
        Range range = Ranges.lessThan((Object)"cd");
        Assert.assertEquals((Object)range.toString(), (Object)"(inf, cd)");
        Assert.assertTrue((String)"Should contain inner point", (boolean)range.contains((Object)"b"));
        Assert.assertFalse((String)"Should not contain outside point", (boolean)range.contains((Object)"d"));
        Assert.assertTrue((String)"Should contain min", (boolean)range.contains((Object)""));
        Assert.assertFalse((String)"Should not contain upper endpoint", (boolean)range.contains((Object)"cd"));
    }

    @Test
    public void testAsGuavaRange() {
        Assert.assertEquals((String)"Should convert to guava singleton", (Object)com.google.common.collect.Ranges.singleton((Comparable)((Object)"ab")), (Object)Ranges.asGuavaRange((Range)Ranges.singleton((Object)"ab")));
        Assert.assertEquals((String)"Should convert to guava open", (Object)com.google.common.collect.Ranges.open((Comparable)((Object)"ab"), (Comparable)((Object)"cd")), (Object)Ranges.asGuavaRange((Range)Ranges.open((Object)"ab", (Object)"cd")));
        Assert.assertEquals((String)"Should convert to guava closed", (Object)com.google.common.collect.Ranges.closed((Comparable)((Object)"ab"), (Comparable)((Object)"cd")), (Object)Ranges.asGuavaRange((Range)Ranges.closed((Object)"ab", (Object)"cd")));
        Assert.assertEquals((String)"Should convert to guava openClosed", (Object)com.google.common.collect.Ranges.openClosed((Comparable)((Object)"ab"), (Comparable)((Object)"cd")), (Object)Ranges.asGuavaRange((Range)Ranges.openClosed((Object)"ab", (Object)"cd")));
        Assert.assertEquals((String)"Should convert to guava closedOpen", (Object)com.google.common.collect.Ranges.closedOpen((Comparable)((Object)"ab"), (Comparable)((Object)"cd")), (Object)Ranges.asGuavaRange((Range)Ranges.closedOpen((Object)"ab", (Object)"cd")));
        Assert.assertEquals((String)"Should convert to guava atLeast", (Object)com.google.common.collect.Ranges.atLeast((Comparable)((Object)"ab")), (Object)Ranges.asGuavaRange((Range)Ranges.atLeast((Object)"ab")));
        Assert.assertEquals((String)"Should convert to guava greaterThan", (Object)com.google.common.collect.Ranges.greaterThan((Comparable)((Object)"ab")), (Object)Ranges.asGuavaRange((Range)Ranges.greaterThan((Object)"ab")));
        Assert.assertEquals((String)"Should convert to guava atMost", (Object)com.google.common.collect.Ranges.atMost((Comparable)((Object)"cd")), (Object)Ranges.asGuavaRange((Range)Ranges.atMost((Object)"cd")));
        Assert.assertEquals((String)"Should convert to guava lessThan", (Object)com.google.common.collect.Ranges.lessThan((Comparable)((Object)"cd")), (Object)Ranges.asGuavaRange((Range)Ranges.lessThan((Object)"cd")));
    }

    @Test
    public void testIntersectionOverlap() {
        Assert.assertEquals((String)"Open inner endpoints remain open", (Object)Ranges.open((Object)"d", (Object)"dz"), (Object)Ranges.closedOpen((Object)"cd", (Object)"dz").intersection(Ranges.openClosed((Object)"d", (Object)"ee")));
        Assert.assertEquals((String)"Open inner endpoints remain open", (Object)Ranges.open((Object)"d", (Object)"dz"), (Object)Ranges.openClosed((Object)"d", (Object)"ee").intersection(Ranges.closedOpen((Object)"cd", (Object)"dz")));
        Assert.assertEquals((String)"Closed inner endpoints remain closed", (Object)Ranges.closed((Object)"d", (Object)"dz"), (Object)Ranges.openClosed((Object)"cd", (Object)"dz").intersection(Ranges.closedOpen((Object)"d", (Object)"ee")));
        Assert.assertEquals((String)"Closed inner endpoints remain closed", (Object)Ranges.closed((Object)"d", (Object)"dz"), (Object)Ranges.closedOpen((Object)"d", (Object)"ee").intersection(Ranges.openClosed((Object)"cd", (Object)"dz")));
        Assert.assertEquals((String)"Start endpoints equal, one open", (Object)Ranges.openClosed((Object)"cd", (Object)"dz"), (Object)Ranges.openClosed((Object)"cd", (Object)"dz").intersection(Ranges.closedOpen((Object)"cd", (Object)"ee")));
        Assert.assertEquals((String)"Start endpoints equal, one open", (Object)Ranges.openClosed((Object)"cd", (Object)"dz"), (Object)Ranges.closedOpen((Object)"cd", (Object)"ee").intersection(Ranges.openClosed((Object)"cd", (Object)"dz")));
        Assert.assertEquals((String)"Start endpoints equal, both closed", (Object)Ranges.closedOpen((Object)"cd", (Object)"dz"), (Object)Ranges.closedOpen((Object)"cd", (Object)"dz").intersection(Ranges.closedOpen((Object)"cd", (Object)"ee")));
        Assert.assertEquals((String)"Start endpoints equal, both closed", (Object)Ranges.closedOpen((Object)"cd", (Object)"dz"), (Object)Ranges.closedOpen((Object)"cd", (Object)"ee").intersection(Ranges.closedOpen((Object)"cd", (Object)"dz")));
        Assert.assertEquals((String)"Stop endpoints equal, one open", (Object)Ranges.open((Object)"d", (Object)"ee"), (Object)Ranges.openClosed((Object)"d", (Object)"ee").intersection(Ranges.closedOpen((Object)"cd", (Object)"ee")));
        Assert.assertEquals((String)"Stop endpoints equal, one open", (Object)Ranges.open((Object)"d", (Object)"ee"), (Object)Ranges.closedOpen((Object)"cd", (Object)"ee").intersection(Ranges.openClosed((Object)"d", (Object)"ee")));
        Assert.assertEquals((String)"Stop endpoints equal, both closed", (Object)Ranges.openClosed((Object)"d", (Object)"ee"), (Object)Ranges.openClosed((Object)"d", (Object)"ee").intersection(Ranges.openClosed((Object)"cd", (Object)"ee")));
        Assert.assertEquals((String)"Stop endpoints equal, both closed", (Object)Ranges.openClosed((Object)"d", (Object)"ee"), (Object)Ranges.openClosed((Object)"cd", (Object)"ee").intersection(Ranges.openClosed((Object)"d", (Object)"ee")));
    }

    @Test
    public void testIntersectionPositiveInfinity() {
        Assert.assertEquals((String)"Defined endpoint is used", (Object)Ranges.closed((Object)"d", (Object)"ee"), (Object)Ranges.openClosed((Object)"cd", (Object)"ee").intersection(Ranges.atLeast((Object)"d")));
        Assert.assertEquals((String)"Defined endpoint is used", (Object)Ranges.closed((Object)"d", (Object)"ee"), (Object)Ranges.atLeast((Object)"d").intersection(Ranges.openClosed((Object)"cd", (Object)"ee")));
        Assert.assertEquals((String)"Defined endpoint is used", (Object)Ranges.open((Object)"d", (Object)"ee"), (Object)Ranges.closedOpen((Object)"cd", (Object)"ee").intersection(Ranges.greaterThan((Object)"d")));
        Assert.assertEquals((String)"Defined endpoint is used", (Object)Ranges.open((Object)"d", (Object)"ee"), (Object)Ranges.greaterThan((Object)"d").intersection(Ranges.closedOpen((Object)"cd", (Object)"ee")));
    }

    @Test
    public void testIntersectionNegativeInfinity() {
        Assert.assertEquals((String)"Defined endpoint is used", (Object)Ranges.openClosed((Object)"cd", (Object)"d"), (Object)Ranges.openClosed((Object)"cd", (Object)"ee").intersection(Ranges.atMost((Object)"d")));
        Assert.assertEquals((String)"Defined endpoint is used", (Object)Ranges.openClosed((Object)"cd", (Object)"d"), (Object)Ranges.atMost((Object)"d").intersection(Ranges.openClosed((Object)"cd", (Object)"ee")));
        Assert.assertEquals((String)"Defined endpoint is used", (Object)Ranges.closedOpen((Object)"cd", (Object)"d"), (Object)Ranges.closedOpen((Object)"cd", (Object)"ee").intersection(Ranges.lessThan((Object)"d")));
        Assert.assertEquals((String)"Defined endpoint is used", (Object)Ranges.closedOpen((Object)"cd", (Object)"d"), (Object)Ranges.lessThan((Object)"d").intersection(Ranges.closedOpen((Object)"cd", (Object)"ee")));
    }
}

