/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.io.Files;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kitesdk.data.MiniDFSTest;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.filesystem.DatasetTestUtilities;
import org.kitesdk.data.spi.filesystem.SignalManager;

@RunWith(value=Parameterized.class)
public class TestSignalManager
extends MiniDFSTest {
    Path testDirectory;
    Configuration conf;
    FileSystem fileSystem;
    boolean distributed;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public TestSignalManager(boolean distributed) {
        this.distributed = distributed;
    }

    @Before
    public void setup() throws IOException {
        this.conf = this.distributed ? MiniDFSTest.getConfiguration() : new Configuration();
        this.fileSystem = FileSystem.get((Configuration)this.conf);
        Path baseDirectory = this.fileSystem.makeQualified(new Path(Files.createTempDir().getAbsolutePath()));
        this.testDirectory = new Path(baseDirectory, ".signals");
    }

    @Test
    public void testNormalizeConstraints() throws IOException {
        Constraints constraints = new Constraints(DatasetTestUtilities.USER_SCHEMA).with("email", new Object[]{"user@domain.com"});
        String normalizedConstraints = SignalManager.getNormalizedConstraints((Constraints)constraints);
        Assert.assertEquals((Object)"email=user%40domain.com", (Object)normalizedConstraints);
    }

    @Test
    public void testNormalizeConstraintsUnbounded() throws IOException {
        Constraints constraints = new Constraints(DatasetTestUtilities.USER_SCHEMA);
        String normalizedConstraints = SignalManager.getNormalizedConstraints((Constraints)constraints);
        Assert.assertEquals((Object)"unbounded", (Object)normalizedConstraints);
    }

    @Test
    public void testNormalizeConstraintsValueExists() throws IOException {
        Constraints constraints = new Constraints(DatasetTestUtilities.USER_SCHEMA).with("email", new Object[]{""});
        String normalizedConstraints = SignalManager.getNormalizedConstraints((Constraints)constraints);
        Assert.assertEquals((Object)"email=in()", (Object)normalizedConstraints);
    }

    @Test
    public void testNormalizeConstraintsOrderedSets() throws IOException {
        Constraints constraints = new Constraints(DatasetTestUtilities.OLD_VALUE_SCHEMA).with("value", new Object[]{7L, 2L, 3L});
        String normalizedConstraints = SignalManager.getNormalizedConstraints((Constraints)constraints);
        Assert.assertEquals((Object)"value=2,3,7", (Object)normalizedConstraints);
    }

    @Test
    public void testNormalizeConstraintsIntervals() throws IOException {
        Constraints constraints = new Constraints(DatasetTestUtilities.OLD_VALUE_SCHEMA).toBefore("value", (Comparable)Long.valueOf(12L));
        String normalizedConstraints = SignalManager.getNormalizedConstraints((Constraints)constraints);
        Assert.assertEquals((Object)"value=(,12)", (Object)normalizedConstraints);
    }

    @Test
    public void testNormalizeConstraintsOrderedKeys() throws IOException {
        Constraints constraints = new Constraints(DatasetTestUtilities.USER_SCHEMA).with("username", new Object[]{"kite"}).with("email", new Object[]{"kite@domain.com"});
        String normalizedConstraints = SignalManager.getNormalizedConstraints((Constraints)constraints);
        Assert.assertEquals((Object)"email=kite%40domain.com&username=kite", (Object)normalizedConstraints);
    }

    @Test
    public void testSignalDirectoryCreatedOnSignal() throws IOException {
        SignalManager manager = new SignalManager(this.fileSystem, this.testDirectory);
        Assert.assertFalse((String)"Signal directory shouldn't exist before signals", (boolean)this.fileSystem.exists(this.testDirectory));
        Constraints constraints = new Constraints(DatasetTestUtilities.USER_SCHEMA).with("email", new Object[]{"signalCreatesDir@domain.com"});
        manager.signalReady(constraints);
        Assert.assertTrue((String)"Signal directory created on signals", (boolean)this.fileSystem.exists(this.testDirectory));
    }

    @Test
    public void testConstraintsSignaledReady() throws IOException {
        SignalManager manager = new SignalManager(this.fileSystem, this.testDirectory);
        Constraints constraints = new Constraints(DatasetTestUtilities.USER_SCHEMA).with("email", new Object[]{"testConstraintsSignaledReady@domain.com"});
        manager.signalReady(constraints);
        String normalizedConstraints = SignalManager.getNormalizedConstraints((Constraints)constraints);
        Assert.assertTrue((boolean)this.fileSystem.exists(new Path(this.testDirectory, normalizedConstraints)));
    }

    @Test
    public void testMultiConstraintsSignaledReady() throws IOException {
        SignalManager manager = new SignalManager(this.fileSystem, this.testDirectory);
        Constraints constraints = new Constraints(DatasetTestUtilities.USER_SCHEMA).with("email", new Object[]{"kiteuser@domain.com"}).with("username", new Object[]{"kiteuser"});
        manager.signalReady(constraints);
        String normalizedConstraints = SignalManager.getNormalizedConstraints((Constraints)constraints);
        Assert.assertTrue((boolean)this.fileSystem.exists(new Path(this.testDirectory, normalizedConstraints)));
    }

    @Test
    public void testConstraintsSignaledReadyPreviouslySignaled() throws IOException, InterruptedException {
        SignalManager manager = new SignalManager(this.fileSystem, this.testDirectory);
        Constraints constraints = new Constraints(DatasetTestUtilities.USER_SCHEMA).with("email", new Object[]{"testConstraintsSignaledReadyPreviouslySignaled@domain.com"});
        String normalizedConstraints = SignalManager.getNormalizedConstraints((Constraints)constraints);
        Path signalFilePath = new Path(this.testDirectory, normalizedConstraints);
        manager.signalReady(constraints);
        Assert.assertTrue((boolean)this.fileSystem.exists(signalFilePath));
        long firstSignalContents = this.fileSystem.getFileStatus(signalFilePath).getModificationTime();
        long spinStart = System.currentTimeMillis();
        long signaledTime = 0L;
        while (firstSignalContents >= signaledTime && System.currentTimeMillis() - spinStart <= 2000L) {
            manager.signalReady(constraints);
            signaledTime = manager.getReadyTimestamp(constraints);
        }
        Assert.assertFalse((String)"Second signal should not match the first", (signaledTime == firstSignalContents ? 1 : 0) != 0);
    }

    @Test
    public void testConstraintsGetReadyTimestamp() throws IOException {
        SignalManager manager = new SignalManager(this.fileSystem, this.testDirectory);
        Constraints constraints = new Constraints(DatasetTestUtilities.USER_SCHEMA).with("email", new Object[]{"testConstraintsReady@domain.com"});
        Path signalFilePath = new Path(this.testDirectory, "email=testConstraintsReady%40domain.com");
        FSDataOutputStream stream = this.fileSystem.create(signalFilePath, true);
        stream.writeUTF(String.valueOf(System.currentTimeMillis()));
        stream.close();
        Assert.assertTrue((manager.getReadyTimestamp(constraints) != -1L ? 1 : 0) != 0);
    }

    @Test
    public void testConstraintsGetReadyTimestampNotYetSignaled() throws IOException {
        SignalManager manager = new SignalManager(this.fileSystem, this.testDirectory);
        Constraints constraints = new Constraints(DatasetTestUtilities.USER_SCHEMA).with("email", new Object[]{"testConstraintsGetReadyTimestampNotYetSignaled@domain.com"});
        Assert.assertEquals((String)"A constraint that is not signaled should show -1", (long)-1L, (long)manager.getReadyTimestamp(constraints));
    }
}

