/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.io.Files;
import java.io.IOException;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.Formats;
import org.kitesdk.data.LocalFileSystem;
import org.kitesdk.data.TestDatasetReaders;
import org.kitesdk.data.event.Value;
import org.kitesdk.data.spi.filesystem.DatasetTestUtilities;
import org.kitesdk.data.spi.filesystem.FileSystemDatasetRepository;

public class TestReadParquetAfterSchemaEvolution
extends TestDatasetReaders<GenericRecord> {
    private static final int totalRecords = 100;
    protected static FileSystem fs = null;
    protected static Path testDirectory = null;
    protected static Dataset<GenericRecord> readerDataset;

    @BeforeClass
    public static void setup() throws IOException {
        fs = LocalFileSystem.getInstance();
        testDirectory = new Path(Files.createTempDir().getAbsolutePath());
        FileSystemDatasetRepository repo = new FileSystemDatasetRepository(fs.getConf(), testDirectory);
        Dataset writerDataset = repo.create("ns", "test", new DatasetDescriptor.Builder().schema(DatasetTestUtilities.OLD_VALUE_SCHEMA).format(Formats.PARQUET).build(), GenericRecord.class);
        DatasetWriter writer = writerDataset.newWriter();
        GenericData.Record record = new GenericData.Record(DatasetTestUtilities.OLD_VALUE_SCHEMA);
        for (long i = 0L; i < 100L; ++i) {
            record.put("value", (Object)i);
            writer.write((Object)record);
        }
        writer.close();
        repo.update("ns", "test", new DatasetDescriptor.Builder(writerDataset.getDescriptor()).schema(Value.class).build());
        readerDataset = repo.load("ns", "test", GenericRecord.class);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        fs.delete(testDirectory, true);
    }

    @Override
    public DatasetReader<GenericRecord> newReader() throws IOException {
        return readerDataset.newReader();
    }

    @Override
    public int getTotalRecords() {
        return 100;
    }

    @Override
    public DatasetTestUtilities.RecordValidator<GenericRecord> getValidator() {
        return new DatasetTestUtilities.RecordValidator<GenericRecord>(){

            @Override
            public void validate(GenericRecord record, int recordNum) {
                Assert.assertEquals(null, (Object)record.get("id"));
                Assert.assertEquals((Object)recordNum, (Object)record.get("value"));
            }
        };
    }
}

