/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Test;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.IncompatibleSchemaException;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.View;
import org.kitesdk.data.event.IncompatibleEvent;
import org.kitesdk.data.event.ReflectSmallEvent;
import org.kitesdk.data.event.ReflectStandardEvent;
import org.kitesdk.data.event.SmallEvent;
import org.kitesdk.data.event.StandardEvent;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.Schemas;
import org.kitesdk.data.spi.TestRefinableViews;
import org.kitesdk.data.spi.filesystem.FileSystemDatasetRepository;

public class TestProjection
extends TestRefinableViews {
    public TestProjection(boolean distributed) {
        super(distributed);
    }

    @Override
    public DatasetRepository newRepo() {
        return new FileSystemDatasetRepository.Builder().configuration(this.conf).rootDirectory(URI.create("target/data")).build();
    }

    @After
    public void removeDataPath() throws IOException {
        this.fs.delete(new Path("target/data"), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGenericProjectionAsSchema() throws IOException {
        Dataset original = (Dataset)Datasets.load((URI)this.unbounded.getUri(), StandardEvent.class);
        Schema standardEvent = Schemas.fromAvsc((Configuration)this.conf, (URI)URI.create("resource:standard_event.avsc"));
        Schema smallEvent = Schemas.fromAvsc((Configuration)this.conf, (URI)URI.create("resource:small_event.avsc"));
        DatasetWriter writer = null;
        try {
            writer = original.asSchema(standardEvent).newWriter();
            writer.write((Object)TestProjection.toGeneric((GenericRecord)sepEvent, standardEvent));
            writer.write((Object)TestProjection.toGeneric((GenericRecord)octEvent, standardEvent));
            writer.write((Object)TestProjection.toGeneric((GenericRecord)novEvent, standardEvent));
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
        final View smallEvents = original.asSchema(smallEvent);
        HashSet expected = Sets.newHashSet((Object[])new GenericRecord[]{TestProjection.toGeneric((GenericRecord)TestProjection.toSmallEvent(sepEvent), smallEvent), TestProjection.toGeneric((GenericRecord)TestProjection.toSmallEvent(octEvent), smallEvent), TestProjection.toGeneric((GenericRecord)TestProjection.toSmallEvent(novEvent), smallEvent)});
        TestProjection.assertContentEquals(expected, smallEvents);
        TestHelpers.assertThrows("Should not be able to write small events", IncompatibleSchemaException.class, new Runnable(){

            @Override
            public void run() {
                smallEvents.newWriter();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSpecificProjectionAsType() throws IOException {
        Dataset original = (Dataset)Datasets.load((URI)this.unbounded.getUri());
        DatasetWriter writer = null;
        try {
            writer = original.asType(StandardEvent.class).newWriter();
            writer.write((Object)sepEvent);
            writer.write((Object)octEvent);
            writer.write((Object)novEvent);
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
        final View smallEvents = original.asType(SmallEvent.class);
        HashSet expected = Sets.newHashSet((Object[])new SmallEvent[]{TestProjection.toSmallEvent(sepEvent), TestProjection.toSmallEvent(octEvent), TestProjection.toSmallEvent(novEvent)});
        TestProjection.assertContentEquals(expected, smallEvents);
        TestHelpers.assertThrows("Should not be able to write small events", IncompatibleSchemaException.class, new Runnable(){

            @Override
            public void run() {
                smallEvents.newWriter();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSpecificProjectionLoad() throws IOException {
        DatasetWriter writer = null;
        try {
            writer = this.unbounded.newWriter();
            writer.write((Object)sepEvent);
            writer.write((Object)octEvent);
            writer.write((Object)novEvent);
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
        Dataset dataset = this.repo.load("ns", this.unbounded.getDataset().getName(), SmallEvent.class);
        HashSet expected = Sets.newHashSet((Object[])new SmallEvent[]{TestProjection.toSmallEvent(sepEvent), TestProjection.toSmallEvent(octEvent), TestProjection.toSmallEvent(novEvent)});
        TestProjection.assertContentEquals(expected, dataset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReflectProjectionAsType() throws IOException {
        Dataset original = this.repo.create("ns", "reflectProjection", new DatasetDescriptor.Builder().schema(StandardEvent.class).build(), StandardEvent.class);
        DatasetWriter writer = null;
        try {
            writer = original.asType(ReflectStandardEvent.class).newWriter();
            writer.write((Object)new ReflectStandardEvent(sepEvent));
            writer.write((Object)new ReflectStandardEvent(octEvent));
            writer.write((Object)new ReflectStandardEvent(novEvent));
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
        final View smallEvents = original.asType(ReflectSmallEvent.class);
        HashSet expected = Sets.newHashSet((Object[])new ReflectSmallEvent[]{new ReflectSmallEvent(sepEvent), new ReflectSmallEvent(octEvent), new ReflectSmallEvent(novEvent)});
        TestProjection.assertContentEquals(expected, smallEvents);
        TestHelpers.assertThrows("Should not be able to write small events", IncompatibleSchemaException.class, new Runnable(){

            @Override
            public void run() {
                smallEvents.newWriter();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReflectProjectionLoad() throws IOException {
        Dataset original = this.repo.create("ns", "reflectProjection", new DatasetDescriptor.Builder().schema(ReflectStandardEvent.class).build(), ReflectStandardEvent.class);
        DatasetWriter writer = null;
        try {
            writer = original.newWriter();
            writer.write((Object)new ReflectStandardEvent(sepEvent));
            writer.write((Object)new ReflectStandardEvent(octEvent));
            writer.write((Object)new ReflectStandardEvent(novEvent));
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
        Dataset dataset = this.repo.load("ns", original.getName(), ReflectSmallEvent.class);
        HashSet expected = Sets.newHashSet((Object[])new ReflectSmallEvent[]{new ReflectSmallEvent(sepEvent), new ReflectSmallEvent(octEvent), new ReflectSmallEvent(novEvent)});
        TestProjection.assertContentEquals(expected, dataset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMixedProjection() throws IOException {
        Dataset original = this.repo.create("ns", "mixedProjection", new DatasetDescriptor.Builder().schema(StandardEvent.class).build(), StandardEvent.class);
        DatasetWriter writer = null;
        try {
            writer = original.newWriter();
            writer.write((Object)sepEvent);
            writer.write((Object)octEvent);
            writer.write((Object)novEvent);
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
        Dataset dataset = this.repo.load("ns", original.getName(), ReflectSmallEvent.class);
        HashSet expected = Sets.newHashSet((Object[])new ReflectSmallEvent[]{new ReflectSmallEvent(sepEvent), new ReflectSmallEvent(octEvent), new ReflectSmallEvent(novEvent)});
        TestProjection.assertContentEquals(expected, dataset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncompatibleProjection() throws IOException {
        DatasetWriter writer = null;
        try {
            writer = this.unbounded.newWriter();
            writer.write((Object)sepEvent);
            writer.write((Object)octEvent);
            writer.write((Object)novEvent);
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
        TestHelpers.assertThrows("Should not load a dataset with an incompatible class", IncompatibleSchemaException.class, new Runnable(){

            @Override
            public void run() {
                TestProjection.this.repo.load("ns", TestProjection.this.unbounded.getDataset().getName(), IncompatibleEvent.class);
            }
        });
        TestHelpers.assertThrows("Should reject a schema that can't read or write", IncompatibleSchemaException.class, new Runnable(){

            @Override
            public void run() {
                TestProjection.this.unbounded.asType(IncompatibleEvent.class);
            }
        });
        TestHelpers.assertThrows("Should reject a schema that can't read or write", IncompatibleSchemaException.class, new Runnable(){

            @Override
            public void run() {
                TestProjection.this.unbounded.getDataset().asType(IncompatibleEvent.class);
            }
        });
    }

    private static SmallEvent toSmallEvent(StandardEvent event) {
        return SmallEvent.newBuilder().setUserId(event.getUserId()).setSessionId(event.getSessionId()).build();
    }

    private static GenericRecord toGeneric(GenericRecord rec, Schema schema) {
        GenericRecordBuilder builder = new GenericRecordBuilder(schema);
        for (Schema.Field field : schema.getFields()) {
            builder.set(field, rec.get(field.name()));
        }
        return builder.build();
    }
}

