/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.View;
import org.kitesdk.data.spi.filesystem.DatasetTestUtilities;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.kitesdk.data.spi.filesystem.FileSystemDatasetRepository;
import org.kitesdk.data.spi.filesystem.FileSystemView;
import org.kitesdk.data.spi.filesystem.PartitionedDatasetWriter;

public class TestPartitionedDatasetWriter {
    private Configuration conf;
    private FileSystem fileSystem;
    private Path testDirectory;
    private FileSystemDatasetRepository repo;
    private PartitionedDatasetWriter<Object, ?> writer;

    @Before
    public void setUp() throws IOException {
        this.conf = new Configuration();
        this.fileSystem = FileSystem.get((Configuration)this.conf);
        this.testDirectory = new Path(Files.createTempDir().getAbsolutePath());
        this.repo = new FileSystemDatasetRepository(this.conf, this.testDirectory);
        PartitionStrategy partitionStrategy = new PartitionStrategy.Builder().hash("username", 2).build();
        FileSystemDataset users = (FileSystemDataset)this.repo.create("ns", "users", new DatasetDescriptor.Builder().schema(DatasetTestUtilities.USER_SCHEMA).partitionStrategy(partitionStrategy).build());
        this.writer = PartitionedDatasetWriter.newWriter((FileSystemView)new FileSystemView(users, null, null, Object.class));
    }

    @After
    public void tearDown() throws IOException {
        this.fileSystem.delete(this.testDirectory, true);
    }

    @Test
    public void testBasicInitClose() throws IOException {
        this.writer.initialize();
        this.writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriter() throws IOException {
        GenericData.Record record = new GenericRecordBuilder(DatasetTestUtilities.USER_SCHEMA).set("username", (Object)"test1").set("email", (Object)"a@example.com").build();
        try {
            this.writer.initialize();
            this.writer.write((Object)record);
            this.writer.close();
        }
        finally {
            Closeables.close(this.writer, (boolean)true);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testWriteToClosedWriterFails() throws IOException {
        GenericData.Record record = new GenericRecordBuilder(DatasetTestUtilities.USER_SCHEMA).set("username", (Object)"test1").set("email", (Object)"a@example.com").build();
        this.writer.initialize();
        this.writer.close();
        this.writer.write((Object)record);
    }

    @Test
    public void testProvidedPartitioner() throws IOException {
        Schema user = (Schema)SchemaBuilder.record((String)"User").fields().requiredString("username").requiredString("email").endRecord();
        PartitionStrategy strategy = new PartitionStrategy.Builder().provided("version", "int").build();
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schema(user).partitionStrategy(strategy).build();
        Path datasetPath = new Path("file:" + this.testDirectory + "/provided/users");
        final Dataset users = (Dataset)Datasets.create((String)("dataset:" + datasetPath), (DatasetDescriptor)descriptor);
        GenericData.Record u1 = new GenericRecordBuilder(user).set("username", (Object)"test1").set("email", (Object)"a@example.com").build();
        GenericData.Record u2 = new GenericRecordBuilder(user).set("username", (Object)"test2").set("email", (Object)"b@example.com").build();
        TestHelpers.assertThrows("Should reject write with unknown version", IllegalArgumentException.class, new Runnable((GenericRecord)u1){
            final /* synthetic */ GenericRecord val$u1;
            {
                this.val$u1 = genericRecord;
            }

            @Override
            public void run() {
                TestPartitionedDatasetWriter.writeToView((View)users, new GenericRecord[]{this.val$u1});
            }
        });
        Assert.assertFalse((boolean)this.fileSystem.exists(new Path(datasetPath, "version=6")));
        TestPartitionedDatasetWriter.writeToView(users.with("version", new Object[]{6}), new GenericRecord[]{u1});
        Assert.assertTrue((boolean)this.fileSystem.exists(new Path(datasetPath, "version=6")));
        Assert.assertFalse((boolean)this.fileSystem.exists(new Path(datasetPath, "version=7")));
        TestPartitionedDatasetWriter.writeToView(Datasets.load((String)("view:" + datasetPath + "?version=7")), u2);
        Assert.assertTrue((boolean)this.fileSystem.exists(new Path(datasetPath, "version=7")));
        Assert.assertEquals((String)"Should read from provided partitions without view", (Object)Sets.newHashSet((Object[])new GenericRecord[]{u1, u2}), DatasetTestUtilities.materialize(users));
        Assert.assertEquals((String)"Should read from provided partition", (Object)Sets.newHashSet((Object[])new GenericRecord[]{u1}), DatasetTestUtilities.materialize(users.with("version", new Object[]{6})));
        Assert.assertEquals((String)"Should read from provided partition", (Object)Sets.newHashSet((Object[])new GenericRecord[]{u2}), DatasetTestUtilities.materialize(users.with("version", new Object[]{7})));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <E> void writeToView(View<E> view, E ... entities) {
        DatasetWriter writer = null;
        try {
            writer = view.newWriter();
            for (E entity : entities) {
                writer.write(entity);
            }
            writer.close();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

