/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.data.spi.filesystem.MultiLevelIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMultiLevelIterator {
    public static final Logger LOG = LoggerFactory.getLogger(TestMultiLevelIterator.class);
    private static Map<String, Map<String, Map<String, String>>> l1;

    @BeforeClass
    public static void setup() {
        HashMap l3_1 = Maps.newHashMap();
        l3_1.put("l3_1_1", "one");
        l3_1.put("l3_1_2", "two");
        HashMap l3_2 = Maps.newHashMap();
        HashMap l2_1 = Maps.newHashMap();
        l2_1.put("l2_1_1", l3_1);
        l2_1.put("l2_1_2", l3_2);
        HashMap l2_2 = Maps.newHashMap();
        HashMap l3_3 = Maps.newHashMap();
        l3_3.put("l3_3_1", "1");
        l3_3.put("l3_3_2", "2");
        HashMap l2_3 = Maps.newHashMap();
        l2_3.put("l2_3_1", l3_3);
        l1 = Maps.newHashMap();
        l1.put("l1_1", l2_1);
        l1.put("l1_2", l2_2);
        l1.put("l1_3", l2_3);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDepth0() {
        RecursiveMapIterator d0 = new RecursiveMapIterator(0, l1);
    }

    @Test
    public void testDepth1() {
        RecursiveMapIterator d1 = new RecursiveMapIterator(1, l1);
        HashSet expected = Sets.newHashSet((Object[])new List[]{Lists.newArrayList((Object[])new String[]{"l1_1"}), Lists.newArrayList((Object[])new String[]{"l1_2"}), Lists.newArrayList((Object[])new String[]{"l1_3"})});
        Assert.assertEquals((Object)expected, (Object)Sets.newHashSet((Iterator)((Object)d1)));
    }

    @Test
    public void testDepth2() {
        RecursiveMapIterator d2 = new RecursiveMapIterator(2, l1);
        HashSet expected = Sets.newHashSet((Object[])new List[]{Lists.newArrayList((Object[])new String[]{"l1_1", "l2_1_1"}), Lists.newArrayList((Object[])new String[]{"l1_1", "l2_1_2"}), Lists.newArrayList((Object[])new String[]{"l1_3", "l2_3_1"})});
        Assert.assertEquals((Object)expected, (Object)Sets.newHashSet((Iterator)((Object)d2)));
    }

    @Test
    public void testDepth3() {
        RecursiveMapIterator d3 = new RecursiveMapIterator(3, l1);
        HashSet expected = Sets.newHashSet((Object[])new List[]{Lists.newArrayList((Object[])new String[]{"l1_1", "l2_1_1", "l3_1_1"}), Lists.newArrayList((Object[])new String[]{"l1_1", "l2_1_1", "l3_1_2"}), Lists.newArrayList((Object[])new String[]{"l1_3", "l2_3_1", "l3_3_1"}), Lists.newArrayList((Object[])new String[]{"l1_3", "l2_3_1", "l3_3_2"})});
        Assert.assertEquals((Object)expected, (Object)Sets.newHashSet((Iterator)((Object)d3)));
    }

    @Test
    public void testDepth4() {
        RecursiveMapIterator d4 = new RecursiveMapIterator(4, l1);
        HashSet expected = Sets.newHashSet();
        Assert.assertEquals((Object)expected, (Object)Sets.newHashSet((Iterator)((Object)d4)));
    }

    @Test
    public void testDepth5() {
        RecursiveMapIterator d5 = new RecursiveMapIterator(5, l1);
        HashSet expected = Sets.newHashSet();
        Assert.assertEquals((Object)expected, (Object)Sets.newHashSet((Iterator)((Object)d5)));
    }

    public static class RecursiveMapIterator
    extends MultiLevelIterator<String> {
        private final Map<String, Map> map;

        public RecursiveMapIterator(int level, Map<String, Map> map) {
            super(level);
            this.map = map;
        }

        public Iterable<String> getLevel(List<String> current) {
            Map currentLevel = this.map;
            try {
                for (String key : current) {
                    currentLevel = currentLevel.get(key);
                }
            }
            catch (Exception ex) {
                LOG.debug("Returning empty set for {}", current);
                return Sets.newHashSet();
            }
            LOG.debug("Returning {} for {}", currentLevel.keySet(), current);
            return currentLevel.keySet();
        }
    }
}

