/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.TestDatasetReaders;
import org.kitesdk.data.UnknownFormatException;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.DataModelUtil;
import org.kitesdk.data.spi.EntityAccessor;
import org.kitesdk.data.spi.filesystem.DatasetTestUtilities;
import org.kitesdk.data.spi.filesystem.MultiFileDatasetReader;

public class TestMultiFileDatasetReader
extends TestDatasetReaders {
    public static final Path TEST_FILE = new Path(Resources.getResource((String)"data/strings-100.avro").getFile());
    public static final Constraints CONSTRAINTS = new Constraints(DatasetTestUtilities.STRING_SCHEMA);
    public static final DatasetTestUtilities.RecordValidator<GenericData.Record> VALIDATOR = new DatasetTestUtilities.RecordValidator<GenericData.Record>(){

        @Override
        public void validate(GenericData.Record record, int recordNum) {
            Assert.assertNotNull((Object)record);
            Assert.assertEquals((Object)String.valueOf(recordNum % 100), (Object)record.get("text").toString());
        }
    };
    public static final DatasetDescriptor DESCRIPTOR = new DatasetDescriptor.Builder().schema(DatasetTestUtilities.STRING_SCHEMA).build();
    private static final EntityAccessor<GenericData.Record> ACCESSOR = DataModelUtil.accessor(GenericData.Record.class, (Schema)DatasetTestUtilities.STRING_SCHEMA);
    private FileSystem fileSystem;

    public DatasetReader newReader() throws IOException {
        return new MultiFileDatasetReader(FileSystem.get((Configuration)new Configuration()), (Iterable)Lists.newArrayList((Object[])new Path[]{TEST_FILE, TEST_FILE}), DESCRIPTOR, CONSTRAINTS, ACCESSOR);
    }

    @Override
    public int getTotalRecords() {
        return 200;
    }

    public DatasetTestUtilities.RecordValidator getValidator() {
        return VALIDATOR;
    }

    @Before
    public void setUp() throws IOException {
        this.fileSystem = FileSystem.get((Configuration)new Configuration());
    }

    @Test
    public void testEmptyPathList() throws IOException {
        MultiFileDatasetReader reader = new MultiFileDatasetReader(this.fileSystem, (Iterable)Lists.newArrayList(), DESCRIPTOR, CONSTRAINTS, ACCESSOR);
        DatasetTestUtilities.checkReaderBehavior(reader, 0, VALIDATOR);
    }

    @Test
    public void testSingleFile() throws IOException {
        MultiFileDatasetReader reader = new MultiFileDatasetReader(this.fileSystem, (Iterable)Lists.newArrayList((Object[])new Path[]{TEST_FILE}), DESCRIPTOR, CONSTRAINTS, ACCESSOR);
        DatasetTestUtilities.checkReaderBehavior(reader, 100, VALIDATOR);
    }

    @Test(expected=NullPointerException.class)
    public void testRequriesFileSystem() throws IOException {
        new MultiFileDatasetReader(null, (Iterable)Lists.newArrayList((Object[])new Path[]{TEST_FILE, TEST_FILE}), DESCRIPTOR, CONSTRAINTS, ACCESSOR);
    }

    @Test(expected=NullPointerException.class)
    public void testRequriesFiles() throws IOException {
        new MultiFileDatasetReader(this.fileSystem, null, DESCRIPTOR, CONSTRAINTS, ACCESSOR);
    }

    @Test(expected=NullPointerException.class)
    public void testRequriesDescriptor() throws IOException {
        new MultiFileDatasetReader(this.fileSystem, (Iterable)Lists.newArrayList((Object[])new Path[]{TEST_FILE, TEST_FILE}), null, CONSTRAINTS, ACCESSOR);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRejectsNullPaths() throws IOException {
        MultiFileDatasetReader reader = new MultiFileDatasetReader(this.fileSystem, (Iterable)Lists.newArrayList((Object[])new Path[]{null, TEST_FILE}), DESCRIPTOR, CONSTRAINTS, ACCESSOR);
        reader.initialize();
        reader.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=UnknownFormatException.class)
    public void testUnknownFormat() throws IOException {
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schema(DatasetTestUtilities.STRING_SCHEMA).format(Accessor.getDefault().newFormat("explode!")).build();
        MultiFileDatasetReader reader = new MultiFileDatasetReader(this.fileSystem, (Iterable)Lists.newArrayList((Object[])new Path[]{TEST_FILE}), descriptor, CONSTRAINTS, ACCESSOR);
        try {
            reader.initialize();
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=DatasetIOException.class)
    public void testMissingPath() throws IOException {
        Path missingFile = new Path("data/no-such-file.avro");
        MultiFileDatasetReader reader = new MultiFileDatasetReader(this.fileSystem, (Iterable)Lists.newArrayList((Object[])new Path[]{missingFile, TEST_FILE}), DESCRIPTOR, CONSTRAINTS, ACCESSOR);
        try {
            try {
                reader.initialize();
            }
            catch (Throwable t) {
                Assert.fail((String)("Reader failed in open: " + t.getClass().getName()));
            }
            Assert.assertTrue((String)"Reader is not open after open()", (boolean)reader.isOpen());
            DatasetTestUtilities.checkReaderIteration(reader, 200, VALIDATOR);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=DatasetIOException.class)
    public void testEmptyFile() throws IOException {
        Path emptyFile = new Path("/tmp/empty-file.avro");
        Assert.assertTrue((String)"Failed to create a new empty file", (boolean)this.fileSystem.createNewFile(emptyFile));
        try {
            MultiFileDatasetReader reader = new MultiFileDatasetReader(this.fileSystem, (Iterable)Lists.newArrayList((Object[])new Path[]{emptyFile, TEST_FILE}), DESCRIPTOR, CONSTRAINTS, ACCESSOR);
            try {
                try {
                    reader.initialize();
                }
                catch (Throwable t) {
                    Assert.fail((String)("Reader failed in open: " + t.getClass().getName()));
                }
                Assert.assertTrue((String)"Reader is not open after open()", (boolean)reader.isOpen());
                DatasetTestUtilities.checkReaderIteration(reader, 200, VALIDATOR);
            }
            finally {
                reader.close();
            }
        }
        finally {
            Assert.assertTrue((String)"Failed to clean up empty file", (boolean)this.fileSystem.delete(emptyFile, true));
        }
    }
}

