/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.LocalFileSystem;
import org.kitesdk.data.TestDatasetReaders;
import org.kitesdk.data.spi.filesystem.DatasetTestUtilities;
import org.kitesdk.data.spi.filesystem.InputFormatReader;

public class TestInputFormatValueReader
extends TestDatasetReaders<Text> {
    private static FileSystem localfs = null;
    private static Path userFile = new Path("target/test.text");
    private static List<String> lines = Lists.newArrayList((Object[])new String[]{"line1", "line2", "line3"});

    @Override
    public DatasetReader<Text> newReader() throws IOException {
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().property("kite.inputformat.class", "org.apache.hadoop.mapreduce.lib.input.TextInputFormat").property("kite.inputformat.record-type", "value").schema(Schema.create((Schema.Type)Schema.Type.STRING)).build();
        return new InputFormatReader(localfs, userFile, descriptor);
    }

    @Override
    public int getTotalRecords() {
        return lines.size();
    }

    @Override
    public DatasetTestUtilities.RecordValidator<Text> getValidator() {
        return new DatasetTestUtilities.RecordValidator<Text>(){

            @Override
            public void validate(Text record, int recordNum) {
                System.err.println(record.toString());
                Assert.assertEquals(lines.get(recordNum), (Object)record.toString());
            }
        };
    }

    @BeforeClass
    public static void setup() throws IOException {
        localfs = LocalFileSystem.getInstance();
        BufferedWriter writer = Files.newWriter((File)new File(userFile.toString()), (Charset)Charset.forName("UTF-8"));
        for (String line : lines) {
            writer.write(line);
            writer.newLine();
        }
        writer.flush();
        writer.close();
    }
}

