/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.LocalFileSystem;
import org.kitesdk.data.TestDatasetReaders;
import org.kitesdk.data.spi.filesystem.DatasetTestUtilities;
import org.kitesdk.data.spi.filesystem.InputFormatReader;

public class TestInputFormatKeyReader
extends TestDatasetReaders<LongWritable> {
    private static FileSystem localfs = null;
    private static Path userFile = new Path("target/test.text");
    private static List<String> lines = Lists.newArrayList((Object[])new String[]{"line1", "line2", "line3"});
    private static List<Long> positions = Lists.newArrayList((Object[])new Long[]{0L, 6L, 12L});

    @Override
    public DatasetReader<LongWritable> newReader() throws IOException {
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().property("kite.inputformat.class", "org.apache.hadoop.mapreduce.lib.input.TextInputFormat").property("kite.inputformat.record-type", "key").schema(Schema.create((Schema.Type)Schema.Type.LONG)).build();
        return new InputFormatReader(localfs, userFile, descriptor);
    }

    @Override
    public int getTotalRecords() {
        return lines.size();
    }

    @Override
    public DatasetTestUtilities.RecordValidator<LongWritable> getValidator() {
        return new DatasetTestUtilities.RecordValidator<LongWritable>(){

            @Override
            public void validate(LongWritable record, int recordNum) {
                System.err.println(record.toString());
                Assert.assertEquals((long)((Long)positions.get(recordNum)), (long)record.get());
            }
        };
    }

    @BeforeClass
    public static void setup() throws IOException {
        localfs = LocalFileSystem.getInstance();
        BufferedWriter writer = Files.newWriter((File)new File(userFile.toString()), (Charset)Charset.forName("UTF-8"));
        for (String line : lines) {
            writer.write(line);
            writer.newLine();
        }
        writer.flush();
        writer.close();
    }
}

