/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.net.URI;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.compat.Hadoop;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.DatasetNotFoundException;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.MiniDFSTest;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.spi.DatasetRepositories;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;

public class TestHDFSDatasetURIs
extends MiniDFSTest {
    private static String hdfsAuth;
    private static DatasetDescriptor descriptor;

    @BeforeClass
    public static void createRepositoryAndTestDatasets() throws Exception {
        hdfsAuth = TestHDFSDatasetURIs.getDFS().getUri().getAuthority();
        descriptor = new DatasetDescriptor.Builder().schemaUri("resource:schema/user.avsc").build();
    }

    @Test
    public void testMissingHDFSAuthority() {
        try {
            Datasets.load((String)"dataset:hdfs:/tmp/data/ns/test", Object.class);
            Assert.fail((String)"Shouldn't be able to connect to HDFS");
        }
        catch (DatasetIOException e) {
            Assert.assertTrue((String)"Should have helpful error message", (boolean)e.getMessage().contains("make sure the default hdfs URI is configured"));
        }
    }

    @Test
    public void testAbsolute() {
        DatasetRepository repo = DatasetRepositories.repositoryFor((String)("repo:hdfs://" + hdfsAuth + "/tmp/data"));
        repo.delete("ns", "test");
        repo.create("ns", "test", descriptor);
        Dataset ds = (Dataset)Datasets.load((String)("dataset:hdfs://" + hdfsAuth + "/tmp/data/ns/test"), Object.class);
        Assert.assertNotNull((String)"Should load dataset", (Object)ds);
        Assert.assertTrue((boolean)(ds instanceof FileSystemDataset));
        Assert.assertEquals((String)"Locations should match", (Object)URI.create("hdfs://" + hdfsAuth + "/tmp/data/ns/test"), (Object)ds.getDescriptor().getLocation());
        Assert.assertEquals((String)"Descriptors should match", (Object)repo.load("ns", "test").getDescriptor(), (Object)ds.getDescriptor());
        Assert.assertEquals((String)"Should report correct namespace", (Object)"ns", (Object)ds.getNamespace());
        Assert.assertEquals((String)"Should report correct name", (Object)"test", (Object)ds.getName());
        repo.delete("ns", "test");
    }

    @Test
    public void testAbsoluteTrailingSlash() {
        DatasetRepository repo = DatasetRepositories.repositoryFor((String)("repo:hdfs://" + hdfsAuth + "/tmp/data/"));
        repo.delete("ns", "test");
        repo.create("ns", "test", descriptor);
        Dataset ds = (Dataset)Datasets.load((String)("dataset:hdfs://" + hdfsAuth + "/tmp/data/ns/test/"), Object.class);
        Assert.assertNotNull((String)"Should load dataset", (Object)ds);
        Assert.assertTrue((boolean)(ds instanceof FileSystemDataset));
        Assert.assertEquals((String)"Locations should match", (Object)URI.create("hdfs://" + hdfsAuth + "/tmp/data/ns/test"), (Object)ds.getDescriptor().getLocation());
        Assert.assertEquals((String)"Descriptors should match", (Object)repo.load("ns", "test").getDescriptor(), (Object)ds.getDescriptor());
        Assert.assertEquals((String)"Should report correct namespace", (Object)"ns", (Object)ds.getNamespace());
        Assert.assertEquals((String)"Should report correct name", (Object)"test", (Object)ds.getName());
        repo.delete("ns", "test");
    }

    @Test
    public void testAbsoluteRoot() {
        DatasetRepository repo = DatasetRepositories.repositoryFor((String)("repo:hdfs://" + hdfsAuth + "/"));
        repo.delete("ns", "test");
        repo.create("ns", "test", descriptor);
        Dataset ds = (Dataset)Datasets.load((String)("dataset:hdfs://" + hdfsAuth + "/ns/test"), Object.class);
        Assert.assertNotNull((String)"Should load dataset", (Object)ds);
        Assert.assertTrue((boolean)(ds instanceof FileSystemDataset));
        Assert.assertEquals((String)"Locations should match", (Object)URI.create("hdfs://" + hdfsAuth + "/ns/test"), (Object)ds.getDescriptor().getLocation());
        Assert.assertEquals((String)"Descriptors should match", (Object)repo.load("ns", "test").getDescriptor(), (Object)ds.getDescriptor());
        Assert.assertEquals((String)"Should report correct namespace", (Object)"ns", (Object)ds.getNamespace());
        Assert.assertEquals((String)"Should report correct name", (Object)"test", (Object)ds.getName());
        repo.delete("ns", "test");
    }

    @Test
    public void testRelative() {
        DatasetRepository repo = DatasetRepositories.repositoryFor((String)("repo:hdfs://" + hdfsAuth + "/data?absolute=false"));
        repo.delete("ns", "test");
        repo.create("ns", "test", descriptor);
        Dataset ds = (Dataset)Datasets.load((String)("dataset:hdfs://" + hdfsAuth + "/data/ns/test?absolute=false"), Object.class);
        Assert.assertNotNull((String)"Should load dataset", (Object)ds);
        Assert.assertTrue((boolean)(ds instanceof FileSystemDataset));
        Path cwd = TestHDFSDatasetURIs.getDFS().makeQualified(new Path("."));
        Assert.assertEquals((String)"Locations should match", (Object)new Path(cwd, "data/ns/test").toUri(), (Object)ds.getDescriptor().getLocation());
        Assert.assertEquals((String)"Descriptors should match", (Object)repo.load("ns", "test").getDescriptor(), (Object)ds.getDescriptor());
        Assert.assertEquals((String)"Should report correct namespace", (Object)"ns", (Object)ds.getNamespace());
        Assert.assertEquals((String)"Should report correct name", (Object)"test", (Object)ds.getName());
        repo.delete("ns", "test");
    }

    @Test
    public void testMissingNamespace() {
        TestHelpers.assertThrows("Should not find dataset: no such dataset", DatasetNotFoundException.class, new Runnable(){

            @Override
            public void run() {
                Dataset ds = (Dataset)Datasets.load((String)("dataset:hdfs://" + hdfsAuth + "/tmp/data/nosuchnamespace/test"), Object.class);
            }
        });
    }

    @Test
    public void testMissingDataset() {
        TestHelpers.assertThrows("Should not find dataset: no such dataset", DatasetNotFoundException.class, new Runnable(){

            @Override
            public void run() {
                Dataset ds = (Dataset)Datasets.load((String)("dataset:hdfs://" + hdfsAuth + "/tmp/data/ns/nosuchdataset"), Object.class);
            }
        });
    }

    @Test
    public void testNotEnoughPathComponents() {
        TestHelpers.assertThrows("Should not match URI pattern", DatasetNotFoundException.class, new Runnable(){

            @Override
            public void run() {
                Dataset ds = (Dataset)Datasets.load((String)("dataset:hdfs://" + hdfsAuth + "/test"), Object.class);
            }
        });
    }

    @Test
    public void testMissingRepository() {
        TestHelpers.assertThrows("Should not find dataset: unknown storage scheme", DatasetNotFoundException.class, new Runnable(){

            @Override
            public void run() {
                Dataset ds = (Dataset)Datasets.load((String)("dataset:unknown://" + hdfsAuth + "/tmp/data/test"), Object.class);
            }
        });
    }

    @Test
    public void testAbsoluteWebHdfs() {
        Assume.assumeTrue((!Hadoop.isHadoop1() ? 1 : 0) != 0);
        String webhdfsAuth = TestHDFSDatasetURIs.getConfiguration().get("dfs.namenode.http-address");
        DatasetRepository repo = DatasetRepositories.repositoryFor((String)("repo:webhdfs://" + webhdfsAuth + "/tmp/data"));
        repo.delete("ns", "test");
        repo.create("ns", "test", descriptor);
        Dataset ds = (Dataset)Datasets.load((String)("dataset:webhdfs://" + webhdfsAuth + "/tmp/data/ns/test"), Object.class);
        Assert.assertNotNull((String)"Should load dataset", (Object)ds);
        Assert.assertTrue((boolean)(ds instanceof FileSystemDataset));
        Assert.assertEquals((String)"Locations should match", (Object)URI.create("webhdfs://" + webhdfsAuth + "/tmp/data/ns/test"), (Object)ds.getDescriptor().getLocation());
        Assert.assertEquals((String)"Descriptors should match", (Object)repo.load("ns", "test").getDescriptor(), (Object)ds.getDescriptor());
        Assert.assertEquals((String)"Should report correct namespace", (Object)"ns", (Object)ds.getNamespace());
        Assert.assertEquals((String)"Should report correct name", (Object)"test", (Object)ds.getName());
        repo.delete("ns", "test");
    }
}

