/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.MiniDFSTest;
import org.kitesdk.data.spi.InitializeAccessor;
import org.kitesdk.data.spi.ReaderWriterState;
import org.kitesdk.data.spi.filesystem.FileSystemWriter;
import org.kitesdk.data.spi.filesystem.PathFilters;

public abstract class TestFileSystemWriters
extends MiniDFSTest {
    public static final Schema TEST_SCHEMA = (Schema)SchemaBuilder.record((String)"Message").fields().requiredLong("id").requiredString("message").endRecord();
    protected FileSystem fs = null;
    protected Path testDirectory = null;
    protected FileSystemWriter<GenericData.Record> fsWriter = null;

    public abstract FileSystemWriter<GenericData.Record> newWriter(Path var1, Schema var2);

    public abstract DatasetReader<GenericData.Record> newReader(Path var1, Schema var2);

    @Before
    public void setup() throws IOException {
        this.fs = TestFileSystemWriters.getDFS();
        this.testDirectory = new Path(Files.createTempDir().getAbsolutePath());
        this.fsWriter = this.newWriter(this.testDirectory, TEST_SCHEMA);
    }

    @After
    public void tearDown() throws IOException {
        this.fs.delete(this.testDirectory, true);
    }

    @Test
    public void testBasicWrite() throws IOException {
        TestFileSystemWriters.init(this.fsWriter);
        FileStatus[] stats = this.fs.listStatus(this.testDirectory, PathFilters.notHidden());
        Assert.assertEquals((String)"Should contain no visible files", (long)0L, (long)stats.length);
        stats = this.fs.listStatus(this.testDirectory);
        Assert.assertEquals((String)"Should contain a hidden file", (long)1L, (long)stats.length);
        ArrayList written = Lists.newArrayList();
        for (long i = 0L; i < 10000L; ++i) {
            GenericData.Record record = TestFileSystemWriters.record(i, "test-" + i);
            this.fsWriter.write((Object)record);
            written.add(record);
        }
        stats = this.fs.listStatus(this.testDirectory, PathFilters.notHidden());
        Assert.assertEquals((String)"Should contain no visible files", (long)0L, (long)stats.length);
        stats = this.fs.listStatus(this.testDirectory);
        Assert.assertEquals((String)"Should contain a hidden file", (long)1L, (long)stats.length);
        this.fsWriter.close();
        stats = this.fs.listStatus(this.testDirectory, PathFilters.notHidden());
        Assert.assertEquals((String)"Should contain a visible data file", (long)1L, (long)stats.length);
        DatasetReader<GenericData.Record> reader = this.newReader(stats[0].getPath(), TEST_SCHEMA);
        Assert.assertEquals((String)"Should match written records", (Object)written, (Object)Lists.newArrayList((Iterator)((Iterator)TestFileSystemWriters.init(reader))));
    }

    @Test
    public void testDiscardEmptyFiles() throws IOException {
        TestFileSystemWriters.init(this.fsWriter);
        this.fsWriter.close();
        FileStatus[] stats = this.fs.listStatus(this.testDirectory, PathFilters.notHidden());
        Assert.assertEquals((String)"Should not contain any files", (long)0L, (long)stats.length);
    }

    @Test
    public void testDiscardErrorFiles() throws IOException {
        TestFileSystemWriters.init(this.fsWriter);
        for (long i = 0L; i < 10000L; ++i) {
            this.fsWriter.write((Object)TestFileSystemWriters.record(i, "test-" + i));
        }
        this.fsWriter.state = ReaderWriterState.ERROR;
        this.fsWriter.close();
        FileStatus[] stats = this.fs.listStatus(this.testDirectory, PathFilters.notHidden());
        Assert.assertEquals((String)"Should not contain any files", (long)0L, (long)stats.length);
    }

    protected static GenericData.Record record(long id, String message) {
        GenericData.Record record = new GenericData.Record(TEST_SCHEMA);
        record.put("id", (Object)id);
        record.put("message", (Object)message);
        return record;
    }

    protected static <C> C init(C obj) {
        if (obj instanceof InitializeAccessor) {
            ((InitializeAccessor)obj).initialize();
        }
        return obj;
    }
}

