/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.PartitionView;
import org.kitesdk.data.Signalable;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.View;
import org.kitesdk.data.event.StandardEvent;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.LastModifiedAccessor;
import org.kitesdk.data.spi.TestRefinableViews;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.kitesdk.data.spi.filesystem.FileSystemDatasetRepository;
import org.kitesdk.data.spi.filesystem.FileSystemView;

public class TestFileSystemView
extends TestRefinableViews {
    public TestFileSystemView(boolean distributed) {
        super(distributed);
    }

    @Override
    public DatasetRepository newRepo() {
        return new FileSystemDatasetRepository.Builder().configuration(this.conf).rootDirectory(URI.create("target/data")).build();
    }

    @After
    public void removeDataPath() throws IOException {
        this.fs.delete(new Path("target/data"), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoveringPartitions() throws IOException {
        DatasetWriter writer = null;
        try {
            writer = this.unbounded.newWriter();
            writer.write((Object)sepEvent);
            writer.write((Object)octEvent);
            writer.write((Object)novEvent);
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
        TreeMap partitions = Maps.newTreeMap();
        for (PartitionView view : this.unbounded.getCoveringPartitions()) {
            partitions.put(view.getLocation().toString(), view);
        }
        Iterator iter = partitions.values().iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        View v1 = (View)iter.next();
        Assert.assertTrue((boolean)v1.includes((Object)this.standardEvent(sepEvent.getTimestamp())));
        Assert.assertFalse((boolean)v1.includes((Object)this.standardEvent(octEvent.getTimestamp())));
        Assert.assertFalse((boolean)v1.includes((Object)this.standardEvent(novEvent.getTimestamp())));
        Assert.assertTrue((boolean)iter.hasNext());
        View v2 = (View)iter.next();
        Assert.assertFalse((boolean)v2.includes((Object)this.standardEvent(sepEvent.getTimestamp())));
        Assert.assertTrue((boolean)v2.includes((Object)this.standardEvent(octEvent.getTimestamp())));
        Assert.assertFalse((boolean)v2.includes((Object)this.standardEvent(novEvent.getTimestamp())));
        Assert.assertTrue((boolean)iter.hasNext());
        View v3 = (View)iter.next();
        Assert.assertFalse((boolean)v3.includes((Object)this.standardEvent(sepEvent.getTimestamp())));
        Assert.assertFalse((boolean)v3.includes((Object)this.standardEvent(octEvent.getTimestamp())));
        Assert.assertTrue((boolean)v3.includes((Object)this.standardEvent(novEvent.getTimestamp())));
        Assert.assertFalse((boolean)iter.hasNext());
    }

    private StandardEvent standardEvent(long timestamp) {
        return StandardEvent.newBuilder(event).setTimestamp(timestamp).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelete() throws Exception {
        DatasetWriter writer = null;
        try {
            writer = this.unbounded.newWriter();
            writer.write((Object)sepEvent);
            writer.write((Object)octEvent);
            writer.write((Object)novEvent);
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
        Path root = new Path("target/data/ns/test");
        Path y2013 = new Path("target/data/ns/test/year=2013");
        Path sep = new Path("target/data/ns/test/year=2013/month=09");
        Path sep12 = new Path("target/data/ns/test/year=2013/month=09/day=12");
        Path oct = new Path("target/data/ns/test/year=2013/month=10");
        Path oct12 = new Path("target/data/ns/test/year=2013/month=10/day=12");
        Path nov = new Path("target/data/ns/test/year=2013/month=11");
        Path nov11 = new Path("target/data/ns/test/year=2013/month=11/day=11");
        TestFileSystemView.assertDirectoriesExist(this.fs, root, y2013, sep, sep12, oct, oct12, nov, nov11);
        long julStart = new DateTime(2013, 6, 1, 0, 0, DateTimeZone.UTC).getMillis();
        long sepStart = new DateTime(2013, 9, 1, 0, 0, DateTimeZone.UTC).getMillis();
        final long nov11Start = new DateTime(2013, 11, 11, 0, 0, DateTimeZone.UTC).getMillis();
        final long nov12Start = new DateTime(2013, 11, 12, 0, 0, DateTimeZone.UTC).getMillis();
        long decStart = new DateTime(2013, 12, 1, 0, 0, DateTimeZone.UTC).getMillis();
        final long sepInstant = sepEvent.getTimestamp();
        final long sep12End = new DateTime(2013, 9, 13, 0, 0, DateTimeZone.UTC).getMillis() - 1L;
        final long octInstant = octEvent.getTimestamp();
        final long oct12Start = new DateTime(2013, 10, 12, 0, 0, 0, DateTimeZone.UTC).getMillis();
        final long oct12BadStart = new DateTime(2013, 10, 12, 0, 1, 0, DateTimeZone.UTC).getMillis();
        final long oct12End = new DateTime(2013, 10, 12, 23, 59, 59, 999, DateTimeZone.UTC).getMillis();
        final long oct12BadEnd = new DateTime(2013, 10, 12, 23, 59, 57, 999, DateTimeZone.UTC).getMillis();
        Assert.assertFalse((String)"Delete should return false to indicate no changes", (boolean)this.unbounded.from("timestamp", (Comparable)Long.valueOf(decStart)).deleteAll());
        Assert.assertFalse((String)"Delete should return false to indicate no changes", (boolean)this.unbounded.from("timestamp", (Comparable)Long.valueOf(julStart)).toBefore("timestamp", (Comparable)Long.valueOf(sepStart)).deleteAll());
        TestHelpers.assertThrows("Delete should fail if not aligned with partition boundary", UnsupportedOperationException.class, new Runnable(){

            @Override
            public void run() {
                TestFileSystemView.this.unbounded.to("timestamp", (Comparable)Long.valueOf(sepInstant)).deleteAll();
            }
        });
        TestHelpers.assertThrows("Delete should fail if not aligned with partition boundary", UnsupportedOperationException.class, new Runnable(){

            @Override
            public void run() {
                TestFileSystemView.this.unbounded.toBefore("timestamp", (Comparable)Long.valueOf(sep12End)).deleteAll();
            }
        });
        Assert.assertTrue((String)"Delete should return true to indicate FS changed", (boolean)this.unbounded.to("timestamp", (Comparable)Long.valueOf(sep12End)).deleteAll());
        TestFileSystemView.assertDirectoriesDoNotExist(this.fs, sep12, sep);
        TestFileSystemView.assertDirectoriesExist(this.fs, root, y2013, oct, oct12, nov, nov11);
        Assert.assertFalse((String)"Delete should return false to indicate no changes", (boolean)this.unbounded.to("timestamp", (Comparable)Long.valueOf(sep12End)).deleteAll());
        TestFileSystemView.assertDirectoriesDoNotExist(this.fs, sep12, sep);
        TestFileSystemView.assertDirectoriesExist(this.fs, root, y2013, oct, oct12, nov, nov11);
        TestHelpers.assertThrows("Delete should fail if not aligned with partition boundary", UnsupportedOperationException.class, new Runnable(){

            @Override
            public void run() {
                TestFileSystemView.this.unbounded.from("timestamp", (Comparable)Long.valueOf(nov11Start)).to("timestamp", (Comparable)Long.valueOf(nov12Start)).deleteAll();
            }
        });
        TestHelpers.assertThrows("Delete should fail if not aligned with partition boundary", UnsupportedOperationException.class, new Runnable(){

            @Override
            public void run() {
                TestFileSystemView.this.unbounded.fromAfter("timestamp", (Comparable)Long.valueOf(nov11Start)).toBefore("timestamp", (Comparable)Long.valueOf(nov12Start)).deleteAll();
            }
        });
        Assert.assertTrue((String)"Delete should return true to indicate FS changed", (boolean)this.unbounded.from("timestamp", (Comparable)Long.valueOf(nov11Start)).toBefore("timestamp", (Comparable)Long.valueOf(nov12Start)).deleteAll());
        TestFileSystemView.assertDirectoriesDoNotExist(this.fs, sep12, sep, nov11, nov);
        TestFileSystemView.assertDirectoriesExist(this.fs, root, y2013, oct, oct12);
        Assert.assertFalse((String)"Delete should return false to indicate no changes", (boolean)this.unbounded.from("timestamp", (Comparable)Long.valueOf(nov11Start)).toBefore("timestamp", (Comparable)Long.valueOf(nov12Start)).deleteAll());
        TestFileSystemView.assertDirectoriesDoNotExist(this.fs, sep12, sep, nov11, nov);
        TestFileSystemView.assertDirectoriesExist(this.fs, root, y2013, oct, oct12);
        TestHelpers.assertThrows("Delete should fail if not aligned with partition boundary", UnsupportedOperationException.class, new Runnable(){

            @Override
            public void run() {
                TestFileSystemView.this.unbounded.from("timestamp", (Comparable)Long.valueOf(octInstant)).to("timestamp", (Comparable)Long.valueOf(octInstant)).deleteAll();
            }
        });
        TestHelpers.assertThrows("Delete should fail if not aligned with partition boundary", UnsupportedOperationException.class, new Runnable(){

            @Override
            public void run() {
                TestFileSystemView.this.unbounded.from("timestamp", (Comparable)Long.valueOf(oct12BadStart)).to("timestamp", (Comparable)Long.valueOf(oct12End)).deleteAll();
            }
        });
        TestHelpers.assertThrows("Delete should fail if not aligned with partition boundary", UnsupportedOperationException.class, new Runnable(){

            @Override
            public void run() {
                TestFileSystemView.this.unbounded.from("timestamp", (Comparable)Long.valueOf(oct12Start)).to("timestamp", (Comparable)Long.valueOf(oct12BadEnd)).deleteAll();
            }
        });
        Assert.assertTrue((String)"Delete should return true to indicate FS changed", (boolean)this.unbounded.from("timestamp", (Comparable)Long.valueOf(oct12Start)).to("timestamp", (Comparable)Long.valueOf(oct12End)).deleteAll());
        TestFileSystemView.assertDirectoriesDoNotExist(this.fs, y2013, sep12, sep, oct12, oct, nov11, nov);
        TestFileSystemView.assertDirectoriesExist(this.fs, root);
        Assert.assertFalse((String)"Delete should return false to indicate no changes", (boolean)this.unbounded.from("timestamp", (Comparable)Long.valueOf(oct12Start)).to("timestamp", (Comparable)Long.valueOf(oct12End)).deleteAll());
        TestFileSystemView.assertDirectoriesDoNotExist(this.fs, y2013, sep12, sep, oct12, oct, nov11, nov);
        TestFileSystemView.assertDirectoriesExist(this.fs, root);
        Assert.assertFalse((String)"Delete should return false to indicate no changes", (boolean)this.unbounded.deleteAll());
        TestFileSystemView.assertDirectoriesDoNotExist(this.fs, y2013, sep12, sep, oct12, oct, nov11, nov);
        TestFileSystemView.assertDirectoriesExist(this.fs, root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnboundedDelete() throws Exception {
        DatasetWriter writer = null;
        try {
            writer = this.unbounded.newWriter();
            writer.write((Object)sepEvent);
            writer.write((Object)octEvent);
            writer.write((Object)novEvent);
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
        Path root = new Path("target/data/ns/test");
        Path y2013 = new Path("target/data/ns/test/year=2013");
        Path sep = new Path("target/data/ns/test/year=2013/month=09");
        Path sep12 = new Path("target/data/ns/test/year=2013/month=09/day=12");
        Path oct = new Path("target/data/ns/test/year=2013/month=10");
        Path oct12 = new Path("target/data/ns/test/year=2013/month=10/day=12");
        Path nov = new Path("target/data/ns/test/year=2013/month=11");
        Path nov11 = new Path("target/data/ns/test/year=2013/month=11/day=11");
        TestFileSystemView.assertDirectoriesExist(this.fs, root, y2013, sep, sep12, oct, oct12, nov, nov11);
        Assert.assertTrue((String)"Delete should return true to indicate data was deleted.", (boolean)this.unbounded.deleteAll());
        TestFileSystemView.assertDirectoriesDoNotExist(this.fs, y2013, sep12, sep, oct12, oct, nov11, nov);
        TestFileSystemView.assertDirectoriesExist(this.fs, root);
    }

    @Test
    public void testSignalUpdatesLastModified() {
        long lastModified = ((LastModifiedAccessor)this.unbounded).getLastModified();
        long signaledTime = -1L;
        long spinStart = System.currentTimeMillis();
        while (lastModified >= signaledTime && System.currentTimeMillis() - spinStart <= 2000L) {
            ((Signalable)this.unbounded).signalReady();
            signaledTime = ((LastModifiedAccessor)this.unbounded).getLastModified();
        }
        Assert.assertTrue((String)"Signaling should update last modified time", (signaledTime > lastModified ? 1 : 0) != 0);
    }

    @Test
    public void testNullSignalManager() {
        FileSystemDataset ds = (FileSystemDataset)this.unbounded.getDataset();
        FileSystemView view = new FileSystemView(ds, null, null, StandardEvent.class);
        Assert.assertTrue((String)"Last modified does not require access to signal manager", (view.getLastModified() >= -1L ? 1 : 0) != 0);
        view.signalReady();
        Assert.assertFalse((String)"View should not be signaled without manager", (boolean)view.isReady());
    }

    public static void assertDirectoriesExist(FileSystem fs, Path ... dirs) throws IOException {
        for (Path path : dirs) {
            Assert.assertTrue((String)("Directory should exist: " + path), (fs.exists(path) && fs.isDirectory(path) ? 1 : 0) != 0);
        }
    }

    public static void assertDirectoriesDoNotExist(FileSystem fs, Path ... dirs) throws IOException {
        for (Path path : dirs) {
            Assert.assertTrue((String)("Directory should not exist: " + path), (!fs.exists(path) ? 1 : 0) != 0);
        }
    }
}

