/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.data.LocalFileSystem;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.StorageKey;
import org.kitesdk.data.spi.filesystem.FileSystemPartitionIterator;

public class TestFileSystemPartitionIteratorProvidedPartitioners {
    public static final PartitionStrategy strategy = new PartitionStrategy.Builder().provided("year").provided("month", "int").provided("day", "long").build();
    private static final Schema schema = (Schema)SchemaBuilder.record((String)"Event").fields().requiredLong("id").requiredLong("timestamp").endRecord();
    public static final Constraints emptyConstraints = new Constraints(schema, strategy);
    public static FileSystem fileSystem;
    public static List<StorageKey> keys;
    public Path testDirectory;

    @BeforeClass
    public static void createExpectedKeys() throws IOException {
        fileSystem = LocalFileSystem.getInstance();
        keys = Lists.newArrayList();
        for (Integer year : Arrays.asList(2012, 2013)) {
            for (Integer month : Arrays.asList(9, 10, 11, 12)) {
                for (Integer day : Arrays.asList(22, 24, 25)) {
                    StorageKey k = new StorageKey.Builder(strategy).add("year", (Object)year).add("month", (Object)month).add("day", (Object)day).build();
                    keys.add(k);
                }
            }
        }
    }

    @Before
    public void createDirectoryLayout() throws Exception {
        this.testDirectory = fileSystem.makeQualified(new Path(Files.createTempDir().getAbsolutePath()));
        for (String year : Arrays.asList("year=2012", "year=2013")) {
            Path yearPath = new Path(this.testDirectory, year);
            for (String month : Arrays.asList("month=09", "month=10", "month=11", "month=12")) {
                Path monthPath = new Path(yearPath, month);
                for (String day : Arrays.asList("day=22", "day=24", "day=25")) {
                    Path dayPath = new Path(monthPath, day);
                    fileSystem.mkdirs(dayPath);
                }
            }
        }
    }

    @After
    public void cleanDirectoryLayout() throws Exception {
        fileSystem.delete(this.testDirectory, true);
    }

    @Test
    public void testUnbounded() throws Exception {
        FileSystemPartitionIterator partitions = new FileSystemPartitionIterator(fileSystem, this.testDirectory, strategy, schema, (Predicate)emptyConstraints.toKeyPredicate());
        TestFileSystemPartitionIteratorProvidedPartitioners.assertIterableEquals(keys, partitions);
    }

    @Test
    public void testStringConstraint() throws IOException {
        FileSystemPartitionIterator partitions = new FileSystemPartitionIterator(fileSystem, this.testDirectory, strategy, schema, (Predicate)emptyConstraints.with("year", new Object[]{"2012"}).toKeyPredicate());
        TestFileSystemPartitionIteratorProvidedPartitioners.assertIterableEquals(keys.subList(0, 12), partitions);
        TestHelpers.assertThrows("Should reject constraint with integer type", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                emptyConstraints.with("year", new Object[]{2013});
            }
        });
        TestHelpers.assertThrows("Should reject constraint with long type", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                emptyConstraints.with("year", new Object[]{2013L});
            }
        });
    }

    @Test
    public void testIntConstraint() throws IOException {
        FileSystemPartitionIterator partitions = new FileSystemPartitionIterator(fileSystem, this.testDirectory, strategy, schema, (Predicate)emptyConstraints.with("month", new Object[]{9}).toKeyPredicate());
        ArrayList expected = Lists.newArrayList();
        expected.addAll(keys.subList(0, 3));
        expected.addAll(keys.subList(12, 15));
        TestFileSystemPartitionIteratorProvidedPartitioners.assertIterableEquals(expected, partitions);
        TestHelpers.assertThrows("Should reject constraint with string type", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                emptyConstraints.with("month", new Object[]{"10"});
            }
        });
        TestHelpers.assertThrows("Should reject constraint with long type", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                emptyConstraints.with("month", new Object[]{11L});
            }
        });
    }

    @Test
    public void testLongConstraint() throws IOException {
        FileSystemPartitionIterator partitions = new FileSystemPartitionIterator(fileSystem, this.testDirectory, strategy, schema, (Predicate)emptyConstraints.with("day", new Object[]{22L}).toKeyPredicate());
        ArrayList expected = Lists.newArrayList((Object[])new StorageKey[]{keys.get(0), keys.get(3), keys.get(6), keys.get(9), keys.get(12), keys.get(15), keys.get(18), keys.get(21)});
        TestFileSystemPartitionIteratorProvidedPartitioners.assertIterableEquals(expected, partitions);
        TestHelpers.assertThrows("Should reject constraint with string type", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                emptyConstraints.with("day", new Object[]{"24"});
            }
        });
        TestHelpers.assertThrows("Should reject constraint with long type", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                emptyConstraints.with("day", new Object[]{25});
            }
        });
    }

    public static <T> void assertIterableEquals(Iterable<T> expected, Iterable<T> actualIterable) {
        HashSet expectedSet = Sets.newHashSet(expected);
        for (T actual : actualIterable) {
            Assert.assertTrue((String)("Unexpected record: " + actual), (boolean)expectedSet.remove(actual));
        }
        Assert.assertEquals((String)("Not all expected records were present: " + expectedSet), (long)0L, (long)expectedSet.size());
    }
}

